/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.problemsView.notifications;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.jetbrains.rider.model.RdProjectDescriptor;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.model.RdProjectState;
import com.jetbrains.rider.model.RdSolutionDescriptor;
import com.jetbrains.rider.model.RdSolutionState;
import com.jetbrains.rider.model.RdUnloadProjectDescriptor;
import com.jetbrains.rider.model.RdUnloadProjectState;
import com.jetbrains.rider.problemsView.RiderProblemsViewBundle;
import com.jetbrains.rider.problemsView.fus.RiderProblemsViewStatisticsCollector;
import com.jetbrains.rider.problemsView.views.RiderProblemsViewIndicationService;
import com.jetbrains.rider.problemsView.views.RiderProblemsViewToolwindowUtils;
import com.jetbrains.rider.projectView.notifications.SolutionLoadNotification;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityVisitor;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/problemsView/notifications/ProblemsViewToolWindowNotification;", "Lcom/jetbrains/rider/projectView/notifications/SolutionLoadNotification;", "project", "Lcom/intellij/openapi/project/Project;", "ProblemsViewToolWindowNotification", "(Lcom/intellij/openapi/project/Project;)V", "settingName", "", "getSettingName", "()Ljava/lang/String;", "createNotification", "Lcom/intellij/notification/Notification;", "Companion", "intellij.rider"})
public final class ProblemsViewToolWindowNotification
extends SolutionLoadNotification {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String OPEN_ACTION = "open";
    @NotNull
    public static final String DISABLE_ACTION = "disable";
    @NotNull
    public static final String GROUP_NAME = "ProblemsView Notification";

    public ProblemsViewToolWindowNotification(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @NotNull
    public String getSettingName() {
        return "do_not_show_solution_notification";
    }

    @Nullable
    public Notification createNotification() {
        String string;
        Object[] objectArray;
        String string2;
        Object[] objectArray2;
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.getProject()).getToolWindow("Problems View");
        if (toolWindow == null) {
            return null;
        }
        ToolWindow toolWindow2 = toolWindow;
        if (toolWindow2.isVisible()) {
            return null;
        }
        var var2_2 = new ProjectModelEntityVisitor(){
            private int projectsWithErrors;

            public final int getProjectsWithErrors() {
                return this.projectsWithErrors;
            }

            public final void setProjectsWithErrors(int n) {
                this.projectsWithErrors = n;
            }

            protected ProjectModelEntityVisitor.Result visitProject(ProjectModelEntity entity) {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                RdProjectModelItemDescriptor rdProjectModelItemDescriptor = entity.getDescriptor();
                Intrinsics.checkNotNull((Object)rdProjectModelItemDescriptor, (String)"null cannot be cast to non-null type com.jetbrains.rider.model.RdProjectDescriptor");
                RdProjectState rdProjectState = ((RdProjectDescriptor)rdProjectModelItemDescriptor).getState();
                if (rdProjectState == RdProjectState.WithErrors) {
                    int n = this.projectsWithErrors;
                    this.projectsWithErrors = n + 1;
                }
                return ProjectModelEntityVisitor.Result.Stop;
            }

            protected ProjectModelEntityVisitor.Result visitUnloadedProject(ProjectModelEntity entity) {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                RdProjectModelItemDescriptor rdProjectModelItemDescriptor = entity.getDescriptor();
                Intrinsics.checkNotNull((Object)rdProjectModelItemDescriptor, (String)"null cannot be cast to non-null type com.jetbrains.rider.model.RdUnloadProjectDescriptor");
                RdUnloadProjectState rdUnloadProjectState = ((RdUnloadProjectDescriptor)rdProjectModelItemDescriptor).getState();
                if (rdUnloadProjectState == RdUnloadProjectState.LoadFailed) {
                    int n = this.projectsWithErrors;
                    this.projectsWithErrors = n + 1;
                }
                return ProjectModelEntityVisitor.Result.Stop;
            }
        };
        ProjectModelEntity projectModelEntity = WorkspaceModelExtensionsKt.getSolutionEntity((WorkspaceModel)WorkspaceModel.Companion.getInstance(this.getProject()));
        if (projectModelEntity == null) {
            return null;
        }
        ProjectModelEntity projectModelEntity2 = projectModelEntity;
        var2_2.visit(projectModelEntity2);
        int n = var2_2.getProjectsWithErrors();
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = projectModelEntity2.getDescriptor();
        Intrinsics.checkNotNull((Object)rdProjectModelItemDescriptor, (String)"null cannot be cast to non-null type com.jetbrains.rider.model.RdSolutionDescriptor");
        RdSolutionState rdSolutionState = ((RdSolutionDescriptor)rdProjectModelItemDescriptor).getState();
        if (rdSolutionState == RdSolutionState.WithErrors) {
            ++n;
        }
        if (n == 0) {
            return null;
        }
        NotificationSettings notificationSettings = NotificationsConfigurationImpl.getSettings((String)GROUP_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)notificationSettings, (String)"getSettings(...)");
        NotificationSettings notificationSettings2 = notificationSettings;
        if (notificationSettings2.getDisplayType() == NotificationDisplayType.TOOL_WINDOW) {
            objectArray2 = new Object[]{OPEN_ACTION, n, n == 1 ? 0 : 1};
            string2 = RiderProblemsViewBundle.Companion.message("notification.on.tool.window.title", objectArray2);
        } else {
            objectArray2 = new Object[]{n, n == 1 ? 0 : 1};
            string2 = RiderProblemsViewBundle.Companion.message("notification.on.balloon.title", objectArray2);
        }
        String string3 = string2;
        Object[] objectArray3 = objectArray2 = n > 0 ? NotificationType.ERROR : NotificationType.WARNING;
        if (notificationSettings2.getDisplayType() == NotificationDisplayType.TOOL_WINDOW) {
            objectArray = new Object[]{DISABLE_ACTION};
            string = RiderProblemsViewBundle.Companion.message("notification.on.tool.window.do.not.show", objectArray);
        } else {
            objectArray = new Object[]{OPEN_ACTION, DISABLE_ACTION};
            string = RiderProblemsViewBundle.Companion.message("notification.on.balloon.links", objectArray);
        }
        String string4 = string;
        objectArray = new Notification(GROUP_NAME, string3, string4, (NotificationType)objectArray2);
        objectArray.setListener((arg_0, arg_1) -> ProblemsViewToolWindowNotification.x(this, arg_0, arg_1));
        RiderProblemsViewIndicationService.Companion.getInstance(this.getProject());
        return objectArray;
    }

    private static final void x(ProblemsViewToolWindowNotification problemsViewToolWindowNotification, Notification notification2, HyperlinkEvent hyperlinkEvent) {
        Intrinsics.checkNotNullParameter((Object)notification2, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)hyperlinkEvent, (String)"hyperlinkEvent");
        if (!Intrinsics.areEqual((Object)hyperlinkEvent.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            return;
        }
        if (Intrinsics.areEqual((Object)hyperlinkEvent.getDescription(), (Object)OPEN_ACTION)) {
            RiderProblemsViewToolwindowUtils.INSTANCE.selectToolsetFileTab(problemsViewToolWindowNotification.getProject());
            String string = hyperlinkEvent.getDescription();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescription(...)");
            RiderProblemsViewStatisticsCollector.INSTANCE.balloonOpenActionPressed(string, problemsViewToolWindowNotification.getProject());
        }
        if (Intrinsics.areEqual((Object)hyperlinkEvent.getDescription(), (Object)DISABLE_ACTION)) {
            problemsViewToolWindowNotification.disableNotification();
            String string = hyperlinkEvent.getDescription();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescription(...)");
            RiderProblemsViewStatisticsCollector.INSTANCE.balloonOpenActionPressed(string, problemsViewToolWindowNotification.getProject());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/problemsView/notifications/ProblemsViewToolWindowNotification$Companion;", "", "ProblemsViewToolWindowNotification$Companion", "()V", "OPEN_ACTION", "", "DISABLE_ACTION", "GROUP_NAME", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

