/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.problemsView;

import com.intellij.analysis.problemsView.toolWindow.HighlightingPanel;
import com.intellij.analysis.problemsView.toolWindow.Root;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ToggleOptionAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.rider.problemsView.fus.RiderProblemsViewStatisticsCollector;
import com.jetbrains.rider.problemsView.views.panels.RiderProblemsViewTabPanelWithStats;
import java.awt.Component;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\b\u0010\u0013\u001a\u00020\u0001H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/problemsView/ProblemsViewToolWindowListener;", "Lcom/intellij/openapi/wm/ex/ToolWindowManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "ProblemsViewToolWindowListener", "(Lcom/intellij/openapi/project/Project;)V", "initialized", "", "selectedTime", "", "deselectedTime", "toolWindowShown", "", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "x", "component", "Ljava/awt/Component;", "selected", "x", "intellij.rider"})
public final class ProblemsViewToolWindowListener
implements ToolWindowManagerListener {
    @NotNull
    private final Project project;
    private boolean initialized;
    private long selectedTime;
    private long deselectedTime;

    public ProblemsViewToolWindowListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public void toolWindowShown(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        if (this.initialized) {
            return;
        }
        if (Intrinsics.areEqual((Object)toolWindow.getId(), (Object)"Problems View")) {
            this.initialized = true;
            Component[] componentArray = toolWindow.getComponent().getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            Component component2 = (Component)ArraysKt.firstOrNull((Object[])componentArray);
            if (component2 != null) {
                this.x(component2, true);
            }
            toolWindow.getContentManager().addContentManagerListener(new ContentManagerListener(this){
                final /* synthetic */ ProblemsViewToolWindowListener this$0;
                {
                    this.this$0 = $receiver;
                }

                public void selectionChanged(ContentManagerEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    JComponent jComponent = event.getContent().getComponent();
                    Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
                    ProblemsViewToolWindowListener.access$reportStats(this.this$0, jComponent, ContentManagerEvent.ContentOperation.add == event.getOperation());
                }
            });
            MessageBus messageBus = this.project.getMessageBus();
            ContentManager contentManager = toolWindow.getContentManager();
            Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
            MessageBusConnection messageBusConnection = messageBus.connect((Disposable)contentManager);
            Topic topic = ToolWindowManagerListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, (Object)this.x());
        }
    }

    private final void x(Component component2, boolean bl) {
        HighlightingPanel highlightingPanel;
        RiderProblemsViewTabPanelWithStats riderProblemsViewTabPanelWithStats;
        RiderProblemsViewTabPanelWithStats riderProblemsViewTabPanelWithStats2 = riderProblemsViewTabPanelWithStats = component2 instanceof RiderProblemsViewTabPanelWithStats ? (RiderProblemsViewTabPanelWithStats)((Object)component2) : null;
        if (riderProblemsViewTabPanelWithStats != null) {
            riderProblemsViewTabPanelWithStats.logTabSelection(bl);
            return;
        }
        HighlightingPanel highlightingPanel2 = highlightingPanel = component2 instanceof HighlightingPanel ? (HighlightingPanel)component2 : null;
        if (highlightingPanel != null) {
            if (highlightingPanel.isVisible()) {
                this.selectedTime = System.nanoTime();
            } else {
                this.deselectedTime = System.nanoTime();
            }
            Root root2 = highlightingPanel.getTreeModel().getRoot();
            int n = root2 != null ? root2.getProblemCount() : 0;
            Project project = highlightingPanel.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ToggleOptionAction.Option option2 = highlightingPanel.getShowPreview();
            RiderProblemsViewStatisticsCollector.INSTANCE.logTabSelection(project, "CurrentFile", bl, n, option2 != null ? option2.isEnabled() : false, this.deselectedTime - this.selectedTime);
        }
    }

    private final ToolWindowManagerListener x() {
        return new ToolWindowManagerListener(this){
            private final AtomicBoolean visibility;
            final /* synthetic */ ProblemsViewToolWindowListener this$0;
            {
                this.this$0 = $receiver;
                this.visibility = new AtomicBoolean(true);
            }

            public void stateChanged(ToolWindowManager manager) {
                Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
                ToolWindow toolWindow = manager.getToolWindow("Problems View");
                if (toolWindow == null || toolWindow.isDisposed()) {
                    return;
                }
                boolean bl = toolWindow.isVisible();
                if (bl != this.visibility.getAndSet(bl)) {
                    JComponent jComponent;
                    Content content = toolWindow.getContentManager().getSelectedContent();
                    JComponent jComponent2 = jComponent = content != null ? content.getComponent() : null;
                    if (jComponent != null) {
                        ProblemsViewToolWindowListener.access$reportStats(this.this$0, jComponent, bl);
                    }
                }
            }
        };
    }

    public static final /* synthetic */ void access$reportStats(ProblemsViewToolWindowListener $this, Component component2, boolean selected) {
        $this.x(component2, selected);
    }
}

