/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins;

import com.intellij.idea.AppMode;
import com.intellij.openapi.application.ArchivedCompilationContextUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rider.RiderEnvironment;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/plugins/RiderBundledPluginHelpers;", "", "RiderBundledPluginHelpers", "()V", "Companion", "intellij.rider"})
public final class RiderBundledPluginHelpers {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ,\u0010\r\u001a\u0004\u0018\u00010\u000e\"\u0004\b\u0000\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\b2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/plugins/RiderBundledPluginHelpers$Companion;", "", "RiderBundledPluginHelpers$Companion", "()V", "isAvailable", "", "T", "serviceClass", "Ljava/lang/Class;", "productCoreDllFileName", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getBundledPluginDotFile", "Ljava/io/File;", "dllOrExeName", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nRiderBundledPluginHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderBundledPluginHelpers.kt\ncom/jetbrains/rider/plugins/RiderBundledPluginHelpers$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final <T> boolean isAvailable(@NotNull Class<T> serviceClass, @NotNull String productCoreDllFileName, @NotNull Logger logger) {
            Intrinsics.checkNotNullParameter(serviceClass, (String)"serviceClass");
            Intrinsics.checkNotNullParameter((Object)productCoreDllFileName, (String)"productCoreDllFileName");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            return this.getBundledPluginDotFile(serviceClass, productCoreDllFileName, logger) != null;
        }

        @Nullable
        public final <T> File getBundledPluginDotFile(@NotNull Class<T> serviceClass, @NotNull String dllOrExeName, @NotNull Logger logger) {
            File file2;
            Intrinsics.checkNotNullParameter(serviceClass, (String)"serviceClass");
            Intrinsics.checkNotNullParameter((Object)dllOrExeName, (String)"dllOrExeName");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            String string = PathManager.getJarPathForClass(serviceClass);
            if (string == null) {
                logger.error("No JAR file found for " + dllOrExeName);
                return null;
            }
            File file3 = new File(string);
            if (ArchivedCompilationContextUtil.getArchivedCompiledClassesLocation() != null && AppMode.isRunningFromDevBuild()) {
                File file4 = new File(PathManager.getHomePath()).getParentFile().getParentFile().getParentFile();
                Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"getParentFile(...)");
                var9_7 = var8_6 = FilesKt.resolve((File)FilesKt.resolve((File)FilesKt.resolve((File)FilesKt.resolve((File)file4, (String)"out"), (String)"rider"), (String)"plugins-backend-parts"), (String)("intellij.rider.plugins." + FilesKt.getNameWithoutExtension((File)file3)));
                var10_8 = false;
                file2 = var9_7.isDirectory() ? var8_6 : null;
                if (file2 == null) {
                    file2 = file3;
                }
            } else if (ArchivedCompilationContextUtil.getArchivedCompiledClassesLocation() != null) {
                File file5 = FilesKt.resolve((File)FilesKt.resolve((File)FilesKt.resolve((File)new File(PathManager.getHomePath()), (String)"out"), (String)"rider"), (String)"plugins-backend-parts");
                String string2 = file3.getParentFile().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                var9_7 = var8_6 = FilesKt.resolve((File)file5, (String)string2);
                var10_8 = false;
                file2 = var9_7.isDirectory() ? var8_6 : null;
                if (file2 == null) {
                    file2 = file3;
                }
            } else if (AppMode.isRunningFromDevBuild()) {
                File file6 = new File(PathManager.getHomePath()).getParentFile().getParentFile().getParentFile();
                Intrinsics.checkNotNullExpressionValue((Object)file6, (String)"getParentFile(...)");
                var9_7 = var8_6 = FilesKt.resolve((File)FilesKt.resolve((File)FilesKt.resolve((File)FilesKt.resolve((File)FilesKt.resolve((File)file6, (String)"out"), (String)"rider"), (String)"classes"), (String)"production"), (String)("intellij.rider.plugins." + FilesKt.getNameWithoutExtension((File)file3)));
                var10_8 = false;
                file2 = var9_7.isDirectory() ? var8_6 : null;
                if (file2 == null) {
                    file2 = file3;
                }
            } else {
                file2 = Intrinsics.areEqual((Object)FilesKt.getExtension((File)file3), (Object)"jar") ? file3.getParentFile().getParentFile() : file3;
            }
            File file7 = file2;
            Intrinsics.checkNotNull((Object)file7);
            File file8 = FilesKt.resolve((File)FilesKt.resolve((File)file7, (String)"DotFiles"), (String)dllOrExeName);
            if (file8.exists()) {
                logger.info("Plugin backend file " + dllOrExeName + " found in DotFiles: " + file8);
                return file8;
            }
            file7 = FilesKt.resolve((File)RiderEnvironment.INSTANCE.getRiderBackendDirectory(), (String)dllOrExeName);
            if (file7.exists()) {
                logger.info("Plugin backend file " + dllOrExeName + " found in BinDir: " + file8);
                return file7;
            }
            logger.info("Plugin backend file " + dllOrExeName + " not found");
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

