/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.pasteSpecial;

import com.google.gson.JsonSyntaxException;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.BasePasteHandler;
import com.intellij.openapi.editor.impl.EditorCopyPasteHelperImpl;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.ui.messages.MessagesService;
import com.jetbrains.rider.RiderBundle;
import com.jetbrains.rider.pasteSpecial.JsonToCSharp;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H&J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0016\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/pasteSpecial/PasteAsCSharpHandler;", "Lcom/intellij/openapi/editor/actions/BasePasteHandler;", "PasteAsCSharpHandler", "()V", "format", "Lcom/jetbrains/rider/pasteSpecial/JsonToCSharp$OutputFormat;", "doExecute", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "pasteJson", "content", "", "intellij.rider"})
public abstract class PasteAsCSharpHandler
extends BasePasteHandler {
    @NotNull
    public abstract JsonToCSharp.OutputFormat format();

    public void doExecute(@NotNull Editor editor2, @Nullable Caret caret, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Transferable transferable = CopyPasteManager.getInstance().getContents();
        Object object = transferable != null ? transferable.getTransferData(DataFlavor.stringFlavor) : null;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        String string = (String)object;
        this.pasteJson(editor2, string);
    }

    public final void pasteJson(@NotNull Editor editor2, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        String string = null;
        try {
            string = JsonToCSharp.INSTANCE.convert(content, this.format());
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            String string2 = RiderBundle.message("paste.special.unable.to.parse.json", new Object[0]);
            String string3 = RiderBundle.message("paste.special.invalid.json.message", new Object[0]);
            MessagesService.Companion.getInstance().showErrorDialog(null, string3, string2);
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> PasteAsCSharpHandler.x(editor2, string));
    }

    private static final void x(Editor editor2, String string) {
        EditorCopyPasteHelperImpl.insertStringAtCaret((Editor)editor2, (String)string);
    }
}

