/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.nuget.panels;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ConsoleHighlighter;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.actions.RiderActionsBundle;
import com.jetbrains.rider.model.RdNuGetLogLevel;
import com.jetbrains.rider.model.RdNuGetLogMessage;
import com.jetbrains.rider.nuget.RiderNuGetExtensionsKt;
import com.jetbrains.rider.nuget.RiderNuGetFacade;
import com.jetbrains.rider.nuget.RiderNuGetLogHost;
import com.jetbrains.rider.nuget.RiderNuGetViewSettings;
import com.jetbrains.rider.nuget.RiderNugetBundle;
import com.jetbrains.rider.nuget.actions.NuGetRefreshLogsAction;
import com.jetbrains.rider.nuget.actions.RiderNuGetShowSettingsAction;
import com.jetbrains.rider.nuget.actions.RiderNuGetToolbarRestoreAction;
import com.jetbrains.rider.nuget.credentials.MicrosoftDeviceFlowUtil;
import com.jetbrains.rider.nuget.helpers.RiderNuGetActionHelper;
import com.jetbrains.rider.nuget.helpers.RiderNuGetConsoleHelper;
import com.jetbrains.rider.nuget.panels.RiderNuGetPanelBase;
import com.jetbrains.rider.nuget.panels.components.NuGetLogSeverityComboBox;
import icons.ReSharperIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001'B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\nH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0014J\b\u0010 \u001a\u00020!H\u0014J\b\u0010\"\u001a\u00020!H\u0014J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/jetbrains/rider/nuget/panels/RiderNuGetLogPanel;", "Lcom/jetbrains/rider/nuget/panels/RiderNuGetPanelBase;", "facade", "Lcom/jetbrains/rider/nuget/RiderNuGetFacade;", "RiderNuGetLogPanel", "(Lcom/jetbrains/rider/nuget/RiderNuGetFacade;)V", "console", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "fullLog", "", "Lcom/jetbrains/rider/model/RdNuGetLogMessage;", "x", "()Ljava/util/List;", "viewSettings", "Lcom/jetbrains/rider/nuget/RiderNuGetViewSettings;", "x", "()Lcom/jetbrains/rider/nuget/RiderNuGetViewSettings;", "rehighlightQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "rehighlightQueueAction", "Lcom/intellij/util/ui/update/Update;", "dateFormat", "Ljava/text/SimpleDateFormat;", "G", "", "x", "refreshAction", "Lcom/jetbrains/rider/nuget/actions/NuGetRefreshLogsAction;", "x", "message", "build", "Ljavax/swing/JPanel;", "buildToolbar", "Ljavax/swing/JComponent;", "buildTopToolbar", "x", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "level", "Lcom/jetbrains/rider/model/RdNuGetLogLevel;", "ConsoleType", "intellij.rider"})
public final class RiderNuGetLogPanel
extends RiderNuGetPanelBase {
    @NotNull
    private final RiderNuGetFacade facade;
    @NotNull
    private final ConsoleViewImpl console;
    @NotNull
    private final MergingUpdateQueue rehighlightQueue;
    @NotNull
    private final Update rehighlightQueueAction;
    @NotNull
    private final SimpleDateFormat dateFormat;
    @NotNull
    private final NuGetRefreshLogsAction refreshAction;

    public RiderNuGetLogPanel(@NotNull RiderNuGetFacade facade) {
        Intrinsics.checkNotNullParameter((Object)facade, (String)"facade");
        super(RiderNugetBundle.Companion.message("tab.title.log", new Object[0]));
        this.facade = facade;
        this.console = RiderNuGetConsoleHelper.Companion.createConsole(this.facade.getProject());
        this.rehighlightQueue = new MergingUpdateQueue("RiderNuGetLog->ReHighlight", 2000, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this.facade.getProject(), null, true).setRestartTimerOnAdd(true);
        this.rehighlightQueueAction = new Update(this){
            final /* synthetic */ RiderNuGetLogPanel this$0;
            {
                this.this$0 = $receiver;
                super((Object)"RiderNuGetLog->ReHighlightAction", false, 0, 6, null);
            }

            public void run() {
                RiderNuGetLogPanel.access$getConsole$p(this.this$0).rehighlightHyperlinksAndFoldings();
            }
        };
        this.dateFormat = new SimpleDateFormat("HH:mm:ss");
        this.refreshAction = new NuGetRefreshLogsAction((Function0<Unit>)((Function0)() -> RiderNuGetLogPanel.x(this)));
        Disposer.register((Disposable)((Disposable)this.facade.getProject()), (Disposable)((Disposable)this.console));
        this.x();
        this.facade.getHost().getLog().advise((Lifetime)this.facade.getLifetime(), arg_0 -> RiderNuGetLogPanel.x(this, arg_0));
        this.x().getShowTime().advise((Lifetime)this.facade.getLifetime(), (Function1<? super Boolean, Unit>)((Function1)arg_0 -> RiderNuGetLogPanel.G(this, arg_0)));
        this.x().getShowContext().advise((Lifetime)this.facade.getLifetime(), (Function1<? super Boolean, Unit>)((Function1)arg_0 -> RiderNuGetLogPanel.k(this, arg_0)));
        this.x().getShowLevel().advise((Lifetime)this.facade.getLifetime(), (Function1<? super Boolean, Unit>)((Function1)arg_0 -> RiderNuGetLogPanel.x(this, arg_0)));
        this.x().getVerbosity().advise((Lifetime)this.facade.getLifetime(), (Function1<? super RdNuGetLogLevel, Unit>)((Function1)arg_0 -> RiderNuGetLogPanel.x(this, arg_0)));
    }

    private final List<RdNuGetLogMessage> x() {
        return RiderNuGetLogHost.Companion.getInstance(this.facade.getProject()).getFullLog();
    }

    private final RiderNuGetViewSettings x() {
        return this.facade.getViewSettings();
    }

    private final void G() {
        this.rehighlightQueue.queue(this.rehighlightQueueAction);
    }

    private final void x() {
        this.console.clear();
        for (RdNuGetLogMessage rdNuGetLogMessage : this.x()) {
            this.x(rdNuGetLogMessage);
        }
        this.G();
    }

    private final void x(RdNuGetLogMessage rdNuGetLogMessage) {
        if (!RiderNuGetExtensionsKt.isEmpty((RdNuGetLogMessage)rdNuGetLogMessage)) {
            MicrosoftDeviceFlowUtil.Companion.interceptAndNotifyFromLogMessage(this.facade.getProject(), rdNuGetLogMessage.getText());
        }
        if (!RiderNuGetExtensionsKt.isEmpty((RdNuGetLogMessage)rdNuGetLogMessage) && this.x().getVerbosity().shouldBeVisible(rdNuGetLogMessage.getLevel())) {
            ConsoleViewContentType consoleViewContentType = this.x(rdNuGetLogMessage.getLevel());
            boolean bl = true;
            if (this.x().getShowTime().getValue()) {
                String string = this.dateFormat.format(rdNuGetLogMessage.getTimestamp());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
                RiderNuGetLogPanel.x(this, consoleViewContentType, string);
                bl = false;
            }
            if (this.x().getShowContext().getValue()) {
                if (!bl) {
                    RiderNuGetLogPanel.x(this, consoleViewContentType, "|");
                }
                String string = rdNuGetLogMessage.getContext().toString().toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                RiderNuGetLogPanel.x(this, consoleViewContentType, string);
                bl = false;
            }
            if (this.x().getShowLevel().getValue()) {
                if (!bl) {
                    RiderNuGetLogPanel.x(this, consoleViewContentType, "|");
                }
                String string = rdNuGetLogMessage.getLevel().toString().toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                String string2 = StringsKt.padEnd((String)string, (int)5, (char)' ').substring(0, 5);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                RiderNuGetLogPanel.x(this, consoleViewContentType, string2);
                bl = false;
            }
            if (!bl) {
                RiderNuGetLogPanel.x(this, consoleViewContentType, "| ");
            }
            RiderNuGetLogPanel.x(this, consoleViewContentType, rdNuGetLogMessage.getText());
            RiderNuGetLogPanel.x(this, consoleViewContentType, "\n");
        }
    }

    @Override
    @NotNull
    protected JPanel build() {
        JPanel jPanel;
        JPanel jPanel2 = jPanel = new JPanel(new BorderLayout());
        boolean bl = false;
        jPanel2.add((Component)this.console.getComponent(), "Center");
        Editor editor2 = this.console.getEditor();
        Intrinsics.checkNotNull((Object)editor2);
        editor2.getSettings().setCaretRowShown(true);
        RiderNuGetActionHelper.INSTANCE.applyRefreshActionShortcut(this.refreshAction, jPanel2);
        return jPanel;
    }

    @Override
    @NotNull
    protected JComponent buildToolbar() {
        List list2 = new ArrayList();
        list2.add(new RiderNuGetToolbarRestoreAction((Lifetime)this.facade.getLifetime(), this.facade));
        list2.add(this.refreshAction);
        list2.add(new RiderNuGetShowSettingsAction(this.facade.getProject()));
        list2.add(this.facade.getHelpAction());
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup(list2);
        JComponent jComponent = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)defaultActionGroup, false).getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    @Override
    @NotNull
    protected JComponent buildTopToolbar() {
        List list2 = new ArrayList();
        list2.add(RiderNuGetViewSettings.BooleanViewProperty.toToggleDumbAwareAction$default(this.x().getShowTime(), RiderActionsBundle.Companion.message("action.hide.time.text", new Object[0]), RiderActionsBundle.Companion.message("action.show.time.text", new Object[0]), RiderActionsBundle.Companion.message("action.toggle.time.show.hide.description", new Object[0]), ReSharperIcons.UnitTesting.Time, null, 16, null));
        list2.add(RiderNuGetViewSettings.BooleanViewProperty.toToggleDumbAwareAction$default(this.x().getShowContext(), RiderActionsBundle.Companion.message("action.hide.context.text", new Object[0]), RiderActionsBundle.Companion.message("action.show.context.text", new Object[0]), RiderActionsBundle.Companion.message("action.toggle.context.show.hide.description", new Object[0]), AllIcons.Actions.MoveTo2, null, 16, null));
        list2.add(RiderNuGetViewSettings.BooleanViewProperty.toToggleDumbAwareAction$default(this.x().getShowLevel(), RiderActionsBundle.Companion.message("action.hide.level.text", new Object[0]), RiderActionsBundle.Companion.message("action.show.level.text", new Object[0]), RiderActionsBundle.Companion.message("action.toggle.level.description", new Object[0]), AllIcons.Actions.ListFiles, null, 16, null));
        list2.add(new Separator());
        AnAction[] anActionArray = this.console.createConsoleActions();
        list2.add(anActionArray[2]);
        list2.add(anActionArray[3]);
        list2.add(anActionArray[5]);
        list2.add(new Separator());
        list2.add(new NuGetLogSeverityComboBox(this.x()));
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup(list2);
        JComponent jComponent = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)defaultActionGroup, true).getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    private final ConsoleViewContentType x(RdNuGetLogLevel rdNuGetLogLevel) {
        return switch (WhenMappings.$EnumSwitchMapping$0[rdNuGetLogLevel.ordinal()]) {
            case 1 -> ConsoleType.INSTANCE.getDebug();
            case 2 -> ConsoleType.INSTANCE.getVerbose();
            case 3 -> ConsoleType.INSTANCE.getInformation();
            case 4 -> ConsoleType.INSTANCE.getMinimal();
            case 5 -> ConsoleType.INSTANCE.getWarning();
            case 6 -> ConsoleType.INSTANCE.getError();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final Unit x(RiderNuGetLogPanel riderNuGetLogPanel) {
        riderNuGetLogPanel.x();
        return Unit.INSTANCE;
    }

    private static final void x(RiderNuGetLogPanel riderNuGetLogPanel, ConsoleViewContentType consoleViewContentType, String string) {
        riderNuGetLogPanel.console.print(string, consoleViewContentType);
    }

    private static final Unit x(RiderNuGetLogPanel riderNuGetLogPanel, List list2) {
        Intrinsics.checkNotNullParameter((Object)list2, (String)"messages");
        for (RdNuGetLogMessage rdNuGetLogMessage : list2) {
            riderNuGetLogPanel.x(rdNuGetLogMessage);
        }
        riderNuGetLogPanel.G();
        return Unit.INSTANCE;
    }

    private static final Unit G(RiderNuGetLogPanel riderNuGetLogPanel, boolean bl) {
        riderNuGetLogPanel.x();
        return Unit.INSTANCE;
    }

    private static final Unit k(RiderNuGetLogPanel riderNuGetLogPanel, boolean bl) {
        riderNuGetLogPanel.x();
        return Unit.INSTANCE;
    }

    private static final Unit x(RiderNuGetLogPanel riderNuGetLogPanel, boolean bl) {
        riderNuGetLogPanel.x();
        return Unit.INSTANCE;
    }

    private static final Unit x(RiderNuGetLogPanel riderNuGetLogPanel, RdNuGetLogLevel rdNuGetLogLevel) {
        Intrinsics.checkNotNullParameter((Object)rdNuGetLogLevel, (String)"it");
        riderNuGetLogPanel.x();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ ConsoleViewImpl access$getConsole$p(RiderNuGetLogPanel $this) {
        return $this.console;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/nuget/panels/RiderNuGetLogPanel$ConsoleType;", "", "RiderNuGetLogPanel$ConsoleType", "()V", "debug", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "getDebug", "()Lcom/intellij/execution/ui/ConsoleViewContentType;", "verbose", "getVerbose", "information", "getInformation", "minimal", "getMinimal", "warning", "getWarning", "error", "getError", "intellij.rider"})
    private static final class ConsoleType {
        @NotNull
        public static final ConsoleType INSTANCE = new ConsoleType();
        @NotNull
        private static final ConsoleViewContentType debug = new ConsoleViewContentType("NUGET_DEBUG", ConsoleHighlighter.GRAY);
        @NotNull
        private static final ConsoleViewContentType verbose = new ConsoleViewContentType("NUGET_VERBOSE", ConsoleHighlighter.BLUE);
        @NotNull
        private static final ConsoleViewContentType information = new ConsoleViewContentType("NUGET_INFORMATION", ConsoleHighlighter.CYAN);
        @NotNull
        private static final ConsoleViewContentType minimal = new ConsoleViewContentType("NUGET_MINIMAL", ConsoleHighlighter.MAGENTA);
        @NotNull
        private static final ConsoleViewContentType warning = new ConsoleViewContentType("NUGET_WARNING", ConsoleHighlighter.YELLOW);
        @NotNull
        private static final ConsoleViewContentType error = new ConsoleViewContentType("NUGET_ERROR", ConsoleHighlighter.RED);

        private ConsoleType() {
        }

        @NotNull
        public final ConsoleViewContentType getDebug() {
            return debug;
        }

        @NotNull
        public final ConsoleViewContentType getVerbose() {
            return verbose;
        }

        @NotNull
        public final ConsoleViewContentType getInformation() {
            return information;
        }

        @NotNull
        public final ConsoleViewContentType getMinimal() {
            return minimal;
        }

        @NotNull
        public final ConsoleViewContentType getWarning() {
            return warning;
        }

        @NotNull
        public final ConsoleViewContentType getError() {
            return error;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RdNuGetLogLevel.values().length];
            try {
                nArray[RdNuGetLogLevel.Debug.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdNuGetLogLevel.Verbose.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdNuGetLogLevel.Information.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdNuGetLogLevel.Minimal.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdNuGetLogLevel.Warning.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdNuGetLogLevel.Error.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

