/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.nuget.management.smart;

import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rider.RiderBundle;
import com.jetbrains.rider.model.RdNuGetFeed;
import com.jetbrains.rider.model.RdNuGetImplicitVersion;
import com.jetbrains.rider.model.RdNuGetRemoteVersion;
import com.jetbrains.rider.model.RdNuGetSmartMetadata;
import com.jetbrains.rider.nuget.RiderNuGetExtensionsKt;
import com.jetbrains.rider.nuget.RiderNuGetViewSettings;
import com.jetbrains.rider.nuget.RiderNugetBundle;
import com.jetbrains.rider.nuget.actions.RiderNuGetContextPopupAction;
import com.jetbrains.rider.nuget.actions.RiderNuGetQuickDocAction;
import com.jetbrains.rider.nuget.configs.RiderNuGetFeedColorManager;
import com.jetbrains.rider.nuget.configs.RiderNuGetFeedManager;
import com.jetbrains.rider.nuget.helpers.RiderNuGetColors;
import com.jetbrains.rider.nuget.helpers.RiderNuGetIconLoader;
import com.jetbrains.rider.nuget.helpers.RiderNuGetPrereleaseHelper;
import com.jetbrains.rider.nuget.management.RiderNuGetManagementPanel;
import com.jetbrains.rider.nuget.management.smart.RiderNuGetSmartItem;
import com.jetbrains.rider.nuget.management.smart.RiderNuGetSmartRenderer;
import com.jetbrains.rider.ui.RiderColor;
import com.jetbrains.rider.ui.RiderColorKt;
import com.jetbrains.rider.ui.RiderUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0013\u0014B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ<\u0010\t\u001a\u0004\u0018\u00010\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/nuget/management/smart/RiderNuGetSmartRenderer;", "Ljavax/swing/ListCellRenderer;", "Lcom/jetbrains/rider/nuget/management/smart/RiderNuGetSmartItem;", "project", "Lcom/intellij/openapi/project/Project;", "feedManager", "Lcom/jetbrains/rider/nuget/configs/RiderNuGetFeedManager;", "RiderNuGetSmartRenderer", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/nuget/configs/RiderNuGetFeedManager;)V", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "item", "index", "", "isSelected", "", "cellHasFocus", "PackagePanel", "Header", "intellij.rider"})
public final class RiderNuGetSmartRenderer
implements ListCellRenderer<RiderNuGetSmartItem> {
    @NotNull
    private final Project project;
    @NotNull
    private final RiderNuGetFeedManager feedManager;

    public RiderNuGetSmartRenderer(@NotNull Project project, @NotNull RiderNuGetFeedManager feedManager) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)feedManager, (String)"feedManager");
        this.project = project;
        this.feedManager = feedManager;
    }

    @Override
    @Nullable
    public Component getListCellRendererComponent(@NotNull JList<? extends RiderNuGetSmartItem> list2, @Nullable RiderNuGetSmartItem item, int index, boolean isSelected, boolean cellHasFocus) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        RiderNuGetViewSettings riderNuGetViewSettings = RiderNuGetViewSettings.Companion.tryGetInstance(this.project);
        if (riderNuGetViewSettings == null) {
            return null;
        }
        RiderNuGetViewSettings riderNuGetViewSettings2 = riderNuGetViewSettings;
        RiderNuGetSmartItem riderNuGetSmartItem = item;
        if (riderNuGetSmartItem instanceof RiderNuGetSmartItem.Package) {
            return PackagePanel.INSTANCE.render(this.feedManager, riderNuGetViewSettings2, ((RiderNuGetSmartItem.Package)item).getMeta(), isSelected, cellHasFocus, list2);
        }
        if (riderNuGetSmartItem instanceof RiderNuGetSmartItem.Header) {
            return Header.INSTANCE.render((RiderNuGetSmartItem.Header)item);
        }
        if (riderNuGetSmartItem != null) {
            throw new NoWhenBranchMatchedException();
        }
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000'\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000*\u0001\n\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/nuget/management/smart/RiderNuGetSmartRenderer$Header;", "", "RiderNuGetSmartRenderer$Header", "()V", "titleLabel", "Ljavax/swing/JLabel;", "progressLabel", "separator", "Ljavax/swing/JPanel;", "panelComponent", "com/jetbrains/rider/nuget/management/smart/RiderNuGetSmartRenderer$Header$panelComponent$1", "Lcom/jetbrains/rider/nuget/management/smart/RiderNuGetSmartRenderer$Header$panelComponent$1;", "render", "headerItem", "Lcom/jetbrains/rider/nuget/management/smart/RiderNuGetSmartItem$Header;", "intellij.rider"})
    private static final class Header {
        @NotNull
        public static final Header INSTANCE = new Header();
        @NotNull
        private static final JLabel titleLabel = new JLabel();
        @NotNull
        private static final JLabel progressLabel = new JLabel((Icon)AnimatedIcon.Default.INSTANCE);
        @NotNull
        private static final JPanel separator = new JPanel();
        @NotNull
        private static final panelComponent.1 panelComponent;

        private Header() {
        }

        @NotNull
        public final JPanel render(@NotNull RiderNuGetSmartItem.Header headerItem) {
            JComponent jComponent;
            Intrinsics.checkNotNullParameter((Object)headerItem, (String)"headerItem");
            titleLabel.setText(headerItem.getTitle());
            progressLabel.setVisible(headerItem.getProgressVisible());
            JLabel jLabel = jComponent = titleLabel;
            boolean bl = false;
            jLabel.setFont(RiderUI.Companion.getHeaderFont());
            jLabel.setBorder((Border)new JBEmptyBorder(0, 4, 4, 0));
            jLabel.setBackground(UIUtil.getLabelBackground());
            jLabel.setForeground(UIUtil.getLabelForeground());
            jLabel = jComponent = panelComponent;
            bl = false;
            RiderUI.Companion.setHeight$default((RiderUI.Companion)RiderUI.Companion, (JComponent)jLabel, (int)(RiderNuGetManagementPanel.Companion.getHeaderHeight() + JBUI.scale((int)11)), (boolean)false, (boolean)false, (int)4, null);
            jLabel.setBorder((Border)new JBEmptyBorder(0, 0, 6, 0));
            jLabel = jComponent = separator;
            bl = false;
            jLabel.setPreferredSize(new Dimension(jLabel.getPreferredSize().width, 3));
            jLabel.setBorder((Border)new JBEmptyBorder(0, 0, 4, 0));
            jLabel.setBackground((Color)JBColor.namedColor((String)"Table.gridColor", (Color)((Color)new JBColor(0xF7F7F7, 5198162))));
            return panelComponent;
        }

        public static final /* synthetic */ JPanel access$getSeparator$p() {
            return separator;
        }

        public static final /* synthetic */ JLabel access$getTitleLabel$p() {
            return titleLabel;
        }

        public static final /* synthetic */ JLabel access$getProgressLabel$p() {
            return progressLabel;
        }

        static {
            BorderLayout borderLayout = new BorderLayout();
            panelComponent = new JPanel(borderLayout){
                {
                    this.setBackground(RiderUI.Companion.getUsualBackgroundColor());
                    this.add((Component)RiderUI.Companion.flowPanel(panelComponent.1::x), "West");
                    this.add((Component)Header.access$getSeparator$p(), "South");
                }

                private static final Unit x(JPanel jPanel) {
                    Intrinsics.checkNotNullParameter((Object)jPanel, (String)"$this$flowPanel");
                    jPanel.add(Header.access$getTitleLabel$p());
                    jPanel.add(Header.access$getProgressLabel$p());
                    return Unit.INSTANCE;
                }
            };
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001:\u0001)B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0003J\u001a\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001bH\u0003J>\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u000b2\u000e\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020'0&J\u0010\u0010(\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/jetbrains/rider/nuget/management/smart/RiderNuGetSmartRenderer$PackagePanel;", "", "RiderNuGetSmartRenderer$PackagePanel", "()V", "iconLoader", "Lcom/jetbrains/rider/nuget/helpers/RiderNuGetIconLoader;", "iconSize", "", "x", "()I", "isInstalled", "", "iconLabel", "Ljavax/swing/JLabel;", "iconPanel", "Ljavax/swing/JPanel;", "titleLabel", "titlePanel", "Lcom/jetbrains/rider/nuget/management/smart/RiderNuGetSmartRenderer$PackagePanel$NuGetAccessibleJPanel;", "latestLabel", "latestPanel", "mainPanel", "x", "", "text", "color", "Lcom/jetbrains/rider/ui/RiderColor;", "Lcom/intellij/ui/JBColor;", "render", "feedManager", "Lcom/jetbrains/rider/nuget/configs/RiderNuGetFeedManager;", "viewSettings", "Lcom/jetbrains/rider/nuget/RiderNuGetViewSettings;", "rdPackage", "Lcom/jetbrains/rider/model/RdNuGetSmartMetadata;", "isSelected", "cellHasFocus", "list", "Ljavax/swing/JList;", "Lcom/jetbrains/rider/nuget/management/smart/RiderNuGetSmartItem;", "getToolTip", "NuGetAccessibleJPanel", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nRiderNuGetSmartRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderNuGetSmartRenderer.kt\ncom/jetbrains/rider/nuget/management/smart/RiderNuGetSmartRenderer$PackagePanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,262:1\n1563#2:263\n1634#2,3:264\n1761#2,3:268\n1#3:267\n*S KotlinDebug\n*F\n+ 1 RiderNuGetSmartRenderer.kt\ncom/jetbrains/rider/nuget/management/smart/RiderNuGetSmartRenderer$PackagePanel\n*L\n120#1:263\n120#1:264,3\n198#1:268,3\n*E\n"})
    private static final class PackagePanel {
        @NotNull
        public static final PackagePanel INSTANCE;
        @NotNull
        private static final RiderNuGetIconLoader iconLoader;
        private static boolean isInstalled;
        @NotNull
        private static final JLabel iconLabel;
        @NotNull
        private static final JPanel iconPanel;
        @NotNull
        private static final JLabel titleLabel;
        @NotNull
        private static final NuGetAccessibleJPanel titlePanel;
        @NotNull
        private static final JLabel latestLabel;
        @NotNull
        private static final NuGetAccessibleJPanel latestPanel;
        @NotNull
        private static final NuGetAccessibleJPanel mainPanel;

        private PackagePanel() {
        }

        private final int x() {
            return RiderNuGetIconLoader.Companion.getSmallIconSize();
        }

        @NlsSafe
        private final String x(@Nls String string, RiderColor riderColor) {
            return "<font color=" + RiderColorKt.toHtml((Color)((Color)riderColor)) + ">" + string + "</font>";
        }

        @NlsSafe
        private final String x(@Nls String string, JBColor jBColor) {
            return "<font color=" + RiderColorKt.toHtml((Color)((Color)jBColor)) + ">" + string + "</font>";
        }

        @NotNull
        public final JPanel render(@NotNull RiderNuGetFeedManager feedManager, @NotNull RiderNuGetViewSettings viewSettings, @NotNull RdNuGetSmartMetadata rdPackage, boolean isSelected, boolean cellHasFocus, @NotNull JList<? extends RiderNuGetSmartItem> list2) {
            String string;
            String string2;
            Object object;
            String string3;
            Collection<String> collection;
            RdNuGetImplicitVersion rdNuGetImplicitVersion;
            Object object22;
            Intrinsics.checkNotNullParameter((Object)feedManager, (String)"feedManager");
            Intrinsics.checkNotNullParameter((Object)viewSettings, (String)"viewSettings");
            Intrinsics.checkNotNullParameter((Object)rdPackage, (String)"rdPackage");
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            JLabel jLabel = iconLabel;
            Object object3 = jLabel;
            boolean bl = false;
            ((JComponent)object3).setMinimumSize((Dimension)new JBDimension(16, 16));
            ((JComponent)object3).setPreferredSize((Dimension)new JBDimension(16, 16));
            ((JComponent)object3).setMaximumSize((Dimension)new JBDimension(16, 16));
            iconPanel.setBorder((Border)new JBEmptyBorder(2, 8, 2, 4));
            mainPanel.setBorder((Border)new JBEmptyBorder(0, 0, 0, 8));
            latestPanel.setBorder((Border)new JBEmptyBorder(0, 2, 0, 0));
            titleLabel.setFont(UIUtil.getLabelFont());
            latestLabel.setFont(UIUtil.getLabelFont());
            isInstalled = RiderNuGetExtensionsKt.isInstalled((RdNuGetSmartMetadata)rdPackage);
            jLabel = RiderUI.Companion.getTextColor(isSelected, cellHasFocus);
            object3 = PackagePanel.x(isSelected, (RiderColor)jLabel, rdPackage.getInstalledVersions(), (JBColor)RiderNuGetColors.INSTANCE.getExplicitlyReferenced(), "", "");
            Object object4 = rdPackage.getImplicitlyInstalledVersions();
            JLabel jLabel2 = jLabel;
            boolean bl2 = isSelected;
            boolean bl3 = false;
            Object object5 = object4;
            Object object6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object4, (int)10));
            boolean bl4 = false;
            Object object7 = object5.iterator();
            while (object7.hasNext()) {
                object22 = object7.next();
                rdNuGetImplicitVersion = (RdNuGetImplicitVersion)object22;
                collection = object6;
                boolean bl5 = false;
                collection.add(rdNuGetImplicitVersion.getVersion());
            }
            collection = (List)object6;
            String string4 = PackagePanel.x(bl2, (RiderColor)jLabel2, (List<String>)collection, (JBColor)RiderNuGetColors.INSTANCE.getImplicitlyReferenced(), "(", ")");
            if (rdPackage.getCanBeUpdated() || !RiderNuGetExtensionsKt.isInstalled((RdNuGetSmartMetadata)rdPackage)) {
                string3 = (RdNuGetRemoteVersion)CollectionsKt.lastOrNull((List)rdPackage.getAvailableVersions());
                if (string3 == null || (string3 = string3.getVersion()) == null) {
                    string3 = "";
                }
            } else {
                string3 = "";
            }
            object4 = string3;
            RiderColor riderColor = isSelected ? RiderUI.CommonPalette.Companion.getWhite() : RiderNuGetColors.INSTANCE.getAvailableStable();
            object5 = StringsKt.contains$default((CharSequence)((CharSequence)object4), (CharSequence)"-", (boolean)false, (int)2, null) ? RiderNuGetPrereleaseHelper.Companion.createHtmlItemText((String)object4, isSelected) : this.x((String)object4, riderColor);
            object6 = this.x(rdPackage.getId(), (RiderColor)jLabel);
            StringBuilder stringBuilder = new StringBuilder();
            if (feedManager.isMultipleSelectedSources()) {
                for (Object object22 : rdPackage.getAvailableVersions()) {
                    rdNuGetImplicitVersion = feedManager.getFeedById(object22.getFeedId());
                    if (rdNuGetImplicitVersion == null) continue;
                    Color color = feedManager.getColorManager().getColor((RdNuGetFeed)rdNuGetImplicitVersion);
                    boolean bl6 = false;
                    JBColor jBColor = RiderNuGetFeedColorManager.Companion.getIndicatorColor(color);
                    if (((CharSequence)stringBuilder).length() == 0) {
                        stringBuilder.append(" \u2022");
                    }
                    stringBuilder.append(this.x(" " + rdNuGetImplicitVersion.getAlias(), isSelected ? RiderUI.CommonPalette.Companion.getWhite() : new RiderColor((Color)jBColor)));
                }
            }
            String string5 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
            object7 = string5;
            Shortcut[] shortcutArray = RiderNuGetContextPopupAction.Companion.getInstance().getShortcutSet().getShortcuts();
            Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
            rdNuGetImplicitVersion = (Shortcut)ArraysKt.firstOrNull((Object[])shortcutArray);
            if (rdNuGetImplicitVersion != null) {
                object = rdNuGetImplicitVersion;
                boolean bl7 = false;
                string2 = KeymapUtil.getShortcutText((Shortcut)object);
            } else {
                string2 = null;
            }
            object22 = string2;
            boolean bl8 = viewSettings.getContextPopupShortcutIsLearned().getValue();
            String string6 = "&nbsp;&nbsp;&nbsp;&nbsp;";
            if (!bl8 && isSelected && cellHasFocus && object22 != null) {
                Object[] objectArray = new Object[]{object22};
                string = this.x(string6 + RiderBundle.message("use.0.for.context.actions", objectArray), RiderUI.CommonPalette.Companion.getWhite());
            } else {
                string = "";
            }
            object = string;
            String string7 = (String)object6 + (String)object3 + string4 + (String)object7 + (String)object;
            Color color = isSelected ? UIUtil.getListSelectionBackground((boolean)cellHasFocus) : list2.getBackground();
            Color color2 = isSelected ? UIUtil.getListSelectionForeground((boolean)cellHasFocus) : list2.getForeground();
            Function1 function1 = arg_0 -> PackagePanel.x(color, color2, arg_0);
            function1.invoke((Object)iconLabel);
            function1.invoke((Object)iconPanel);
            function1.invoke((Object)titleLabel);
            function1.invoke((Object)titlePanel);
            function1.invoke((Object)latestLabel);
            function1.invoke((Object)latestPanel);
            function1.invoke((Object)mainPanel);
            iconLabel.setIcon(iconLoader.getIcon(rdPackage.getId(), rdPackage.getIconPath(), this.x()));
            titleLabel.setText("<html>" + string7 + "</html>");
            latestLabel.setText("<html>" + (String)object5 + "</html>");
            if (CollectionsKt.any((Iterable)rdPackage.getImplicitlyInstalledVersions())) {
                mainPanel.setToolTipText(this.getToolTip(rdPackage));
            } else {
                mainPanel.setToolTipText("");
            }
            return mainPanel;
        }

        @NlsSafe
        @NotNull
        public final String getToolTip(@NotNull RdNuGetSmartMetadata rdPackage) {
            boolean bl;
            Object object;
            Object object22;
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2;
            block11: {
                Object object3;
                Object[] objectArray;
                Intrinsics.checkNotNullParameter((Object)rdPackage, (String)"rdPackage");
                stringBuilder = stringBuilder2 = new StringBuilder();
                boolean bl2 = false;
                stringBuilder.append("<div style='text-align:center'><b>" + RiderNugetBundle.Companion.message("implicitly.referenced.versions", new Object[0]) + "</b></div>");
                for (Object object22 : rdPackage.getImplicitlyInstalledVersions()) {
                    List list2 = object22.getOriginPackageIds();
                    object3 = switch (list2.size()) {
                        case 1, 2, 3 -> CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                        default -> {
                            objectArray = new Object[]{list2.size() - 2};
                            yield CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)list2, (int)2), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + RiderNugetBundle.Companion.message("and.0.more.packages", objectArray);
                        }
                    };
                    stringBuilder.append("\u2022 " + object22.getVersion() + " by " + (String)object3 + "<br>");
                }
                object22 = rdPackage.getImplicitlyInstalledVersions();
                boolean bl3 = false;
                if (object22 instanceof Collection && ((Collection)object22).isEmpty()) {
                    v1 = false;
                } else {
                    object3 = object22.iterator();
                    while (object3.hasNext()) {
                        object = object3.next();
                        objectArray = (Object[])object;
                        boolean bl4 = false;
                        if (!(objectArray.getOriginPackageIds().size() > 3)) continue;
                        v1 = true;
                        break block11;
                    }
                    v1 = bl = false;
                }
            }
            if (bl) {
                Shortcut[] shortcutArray = RiderNuGetQuickDocAction.Companion.getInstance().getShortcutSet().getShortcuts();
                Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
                Object[] objectArray = (Object[])ArraysKt.firstOrNull((Object[])shortcutArray);
                if (objectArray != null) {
                    object = objectArray;
                    boolean bl5 = false;
                    v3 = KeymapUtil.getShortcutText(object);
                } else {
                    v3 = object22 = null;
                }
                if (object22 != null) {
                    objectArray = new Object[]{object22};
                    stringBuilder.append("<hr>" + RiderNugetBundle.Companion.message("use.0.to.show.full.information", objectArray));
                }
            }
            String string = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private static final String x(boolean bl, RiderColor riderColor, List<String> list2, JBColor jBColor, @NonNls String string, @NonNls String string2) {
            String string3 = CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)"; ", null, null, (int)0, null, null, (int)62, null);
            JBColor jBColor2 = bl ? (JBColor)riderColor : jBColor;
            String string4 = string + string3 + string2;
            return Intrinsics.areEqual((Object)string3, (Object)"") ? "" : " " + INSTANCE.x("\u2022", riderColor) + " " + INSTANCE.x(string4, jBColor2);
        }

        private static final Unit x(Color color, Color color2, JComponent jComponent) {
            Intrinsics.checkNotNullParameter((Object)jComponent, (String)"it");
            jComponent.setBackground(color);
            jComponent.setForeground(color2);
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ boolean access$isInstalled$p() {
            return isInstalled;
        }

        static {
            JPanel jPanel;
            INSTANCE = new PackagePanel();
            iconLoader = RiderNuGetIconLoader.Companion.getInstance();
            iconLabel = new JLabel();
            JPanel jPanel2 = jPanel = new JPanel();
            boolean bl = false;
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            jPanel2.add(iconLabel);
            iconPanel = jPanel;
            titleLabel = new JLabel();
            jPanel2 = jPanel = new NuGetAccessibleJPanel(new BorderLayout(), false, 2, null);
            bl = false;
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            jPanel2.add(titleLabel);
            titlePanel = jPanel;
            latestLabel = new JLabel();
            jPanel2 = jPanel = new NuGetAccessibleJPanel(new BorderLayout(), false, 2, null);
            bl = false;
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            jPanel2.add(latestLabel);
            latestPanel = jPanel;
            jPanel2 = jPanel = new NuGetAccessibleJPanel(new BorderLayout(), true);
            bl = false;
            jPanel2.add((Component)iconPanel, "West");
            jPanel2.add((Component)titlePanel, "Center");
            jPanel2.add((Component)latestPanel, "East");
            mainPanel = jPanel;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000)\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\n\b\u0012\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/nuget/management/smart/RiderNuGetSmartRenderer$PackagePanel$NuGetAccessibleJPanel;", "Ljavax/swing/JPanel;", "layout", "Ljava/awt/LayoutManager;", "addPrefix", "", "RiderNuGetSmartRenderer$PackagePanel$NuGetAccessibleJPanel", "(Ljava/awt/LayoutManager;Z)V", "accessibleContextLazy", "Lkotlin/Lazy;", "com/jetbrains/rider/nuget/management/smart/RiderNuGetSmartRenderer$PackagePanel$NuGetAccessibleJPanel$accessibleContextLazy$1$1", "getAccessibleContext", "Ljavax/accessibility/AccessibleContext;", "intellij.rider"})
        private static class NuGetAccessibleJPanel
        extends JPanel {
            @NotNull
            private final Lazy<accessibleContextLazy.1.1> accessibleContextLazy;

            public NuGetAccessibleJPanel(@NotNull LayoutManager layout, boolean addPrefix) {
                Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
                super(layout);
                this.accessibleContextLazy = LazyKt.lazy(() -> NuGetAccessibleJPanel.x(this, addPrefix));
            }

            public /* synthetic */ NuGetAccessibleJPanel(LayoutManager layoutManager, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    bl = false;
                }
                this(layoutManager, bl);
            }

            @Override
            @NotNull
            public AccessibleContext getAccessibleContext() {
                return (AccessibleContext)this.accessibleContextLazy.getValue();
            }

            private static final accessibleContextLazy.1.1 x(NuGetAccessibleJPanel nuGetAccessibleJPanel, boolean bl) {
                return new JPanel.AccessibleJPanel(nuGetAccessibleJPanel, bl){
                    final /* synthetic */ NuGetAccessibleJPanel this$0;
                    final /* synthetic */ boolean $addPrefix;
                    {
                        this.this$0 = $receiver;
                        this.$addPrefix = $addPrefix;
                        super($receiver);
                    }

                    public String getAccessibleName() {
                        String string;
                        Component[] componentArray = this.this$0.getComponents();
                        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
                        Object object = componentArray;
                        boolean bl = false;
                        Object[] objectArray = object;
                        Collection collection = new ArrayList<E>();
                        boolean bl2 = false;
                        Object[] objectArray2 = objectArray;
                        boolean bl3 = false;
                        int n = objectArray2.length;
                        for (int j = 0; j < n; ++j) {
                            String string2;
                            Object object2;
                            Object object3 = object2 = objectArray2[j];
                            boolean bl4 = false;
                            Component component2 = (Component)object3;
                            boolean bl5 = false;
                            Object object4 = component2 instanceof Accessible ? (Accessible)((Object)component2) : null;
                            if ((object4 != null && (object4 = object4.getAccessibleContext()) != null ? ((AccessibleContext)object4).getAccessibleName() : null) == null) continue;
                            string2 = string2;
                            boolean bl6 = false;
                            collection.add(string2);
                        }
                        String string3 = CollectionsKt.joinToString$default((Iterable)((List)collection), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
                        if (!this.$addPrefix) {
                            return string3;
                        }
                        bl = PackagePanel.access$isInstalled$p();
                        if (bl) {
                            string = RiderNugetBundle.Companion.message("RiderNuGetSmartRenderer.installed", new Object[0]);
                        } else if (!bl) {
                            string = RiderNugetBundle.Companion.message("RiderNuGetSmartRenderer.available", new Object[0]);
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        object = string;
                        return (String)object + " " + string3;
                    }
                };
            }
        }
    }
}

