/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.nuget.helpers;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.JBUI;
import com.jetbrains.rider.model.RdNuGetSmartMetadata;
import icons.ReSharperIcons;
import java.awt.Image;
import java.awt.Toolkit;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u0000 -2\u00020\u0001:\u0003-./B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019J\"\u0010\u001a\u001a\u00020\f2\b\u0010\u001b\u001a\u0004\u0018\u00010\t2\b\u0010\u001c\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001d\u001a\u00020\u0010J\u0018\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u0010H\u0002J\u000e\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019J \u0010\u001f\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\t2\b\u0010\u001c\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001d\u001a\u00020\u0010J\u001d\u0010 \u001a\u00070\f\u00a2\u0006\u0002\b\u00062\u0006\u0010!\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u0010H\u0002J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u0010H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\tH\u0002J\u0010\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\u0010H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\f\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\f\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010(\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u00060"}, d2={"Lcom/jetbrains/rider/nuget/helpers/RiderNuGetIconLoader;", "", "RiderNuGetIconLoader", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "iconData", "", "", "", "icons", "Ljavax/swing/Icon;", "defaultPackageIcon", "defaultErrorPackageIcon", "iconDataSize", "", "fails", "Ljava/util/ArrayList;", "Lcom/jetbrains/rider/nuget/helpers/RiderNuGetIconLoader$Fail;", "getFails", "()Ljava/util/ArrayList;", "hasLoadedIcon", "", "rdPackage", "Lcom/jetbrains/rider/model/RdNuGetSmartMetadata;", "updateIcon", "id", "iconPath", "size", "x", "getIcon", "x", "icon", "x", "Ljavax/swing/ImageIcon;", "data", "x", "Lcom/jetbrains/rider/nuget/helpers/RiderNuGetIconLoader$LoadedBytes;", "path", "status", "getStatus", "()Ljava/lang/String;", "x", "bytes", "Companion", "LoadedBytes", "Fail", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderNuGetIconLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderNuGetIconLoader.kt\ncom/jetbrains/rider/nuget/helpers/RiderNuGetIconLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n1563#2:161\n1634#2,3:162\n1#3:165\n*S KotlinDebug\n*F\n+ 1 RiderNuGetIconLoader.kt\ncom/jetbrains/rider/nuget/helpers/RiderNuGetIconLoader\n*L\n148#1:161\n148#1:162,3\n*E\n"})
public final class RiderNuGetIconLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final Map<String, byte[]> iconData;
    @NotNull
    private final Map<String, Icon> icons;
    @NotNull
    private final Icon defaultPackageIcon;
    @NotNull
    private final Icon defaultErrorPackageIcon;
    private int iconDataSize;
    @NotNull
    private final ArrayList<Fail> fails;
    private static final int bigIconSize = 44;

    public RiderNuGetIconLoader() {
        Logger logger = Logger.getInstance(RiderNuGetIconLoader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.iconData = new HashMap();
        this.icons = new HashMap();
        Icon icon = ReSharperIcons.ProjectModel.NuGet;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"NuGet");
        this.defaultPackageIcon = icon;
        Icon icon2 = ReSharperIcons.ProjectModel.NuGet;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"NuGet");
        this.defaultErrorPackageIcon = icon2;
        this.fails = new ArrayList();
    }

    @NotNull
    public final ArrayList<Fail> getFails() {
        return this.fails;
    }

    public final boolean hasLoadedIcon(@NotNull RdNuGetSmartMetadata rdPackage) {
        Intrinsics.checkNotNullParameter((Object)rdPackage, (String)"rdPackage");
        String string = rdPackage.getIconPath();
        return string == null || this.iconData.containsKey(string);
    }

    @NotNull
    public final Icon updateIcon(@NotNull RdNuGetSmartMetadata rdPackage) {
        String string;
        Intrinsics.checkNotNullParameter((Object)rdPackage, (String)"rdPackage");
        if (!this.hasLoadedIcon(rdPackage) && (string = rdPackage.getIconPath()) != null) {
            Object object;
            this.iconData.put(string, null);
            LoadedBytes loadedBytes = this.x(string);
            if (loadedBytes.getBytes() == null) {
                String string2 = rdPackage.getId();
                Exception exception = loadedBytes.getException();
                Intrinsics.checkNotNull((Object)exception);
                object = new Fail(string2, string, exception);
                this.fails.add((Fail)object);
                this.logger.warn(((Fail)object).toString());
            }
            this.iconData.put(string, loadedBytes.getBytes());
            byte[] byArray = loadedBytes.getBytes();
            this.iconDataSize += byArray != null ? byArray.length : 0;
            if (loadedBytes.getBytes() != null) {
                object = rdPackage.getId();
                this.icons.put(this.x((String)object, Companion.getSmallIconSize()), this.x(loadedBytes.getBytes(), Companion.getSmallIconSize()));
                this.icons.put(this.x((String)object, 44), this.x(loadedBytes.getBytes(), 44));
            }
        }
        return this.getIcon(rdPackage);
    }

    @NotNull
    public final Icon updateIcon(@Nullable String id2, @Nullable String iconPath, int size) {
        if (id2 == null || iconPath == null) {
            return this.x(this.defaultPackageIcon, size);
        }
        if (!this.iconData.containsKey(iconPath)) {
            this.iconData.put(iconPath, null);
            LoadedBytes loadedBytes = this.x(iconPath);
            if (loadedBytes.getBytes() == null) {
                Exception exception = loadedBytes.getException();
                Intrinsics.checkNotNull((Object)exception);
                Fail fail = new Fail(id2, iconPath, exception);
                this.fails.add(fail);
                this.logger.warn(fail.toString());
            }
            this.iconData.put(iconPath, loadedBytes.getBytes());
            byte[] byArray = loadedBytes.getBytes();
            this.iconDataSize += byArray != null ? byArray.length : 0;
        }
        return this.getIcon(id2, iconPath, size);
    }

    private final String x(String string, int n) {
        String string2 = (string + "-x" + n).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return string2;
    }

    @NotNull
    public final Icon getIcon(@NotNull RdNuGetSmartMetadata rdPackage) {
        Intrinsics.checkNotNullParameter((Object)rdPackage, (String)"rdPackage");
        return this.getIcon(rdPackage.getId(), rdPackage.getIconPath(), 44);
    }

    @NotNull
    public final Icon getIcon(@NotNull String id2, @Nullable String iconPath, int size) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        String string = this.x(id2, size);
        if (this.icons.containsKey(string) && (object = this.icons.get(string)) != null && object.getIconWidth() > 0 && object.getIconHeight() > 0) {
            return object;
        }
        if (this.iconData.containsKey(iconPath)) {
            byte[] byArray = this.iconData.get(iconPath);
            if (byArray == null) {
                return this.x(this.defaultErrorPackageIcon, size);
            }
            object = byArray;
            try {
                ImageIcon imageIcon = this.x((byte[])object, size);
                this.icons.put(string, imageIcon);
                if (imageIcon.getIconWidth() > 0 && imageIcon.getIconHeight() > 0) {
                    return imageIcon;
                }
            }
            catch (Exception exception) {
                String string2;
                if (iconPath != null) {
                    this.iconData.put(iconPath, null);
                }
                if ((string2 = iconPath) == null) {
                    string2 = "?";
                }
                this.logger.warn(new Fail(id2, string2, exception).toString());
                return this.x(this.defaultErrorPackageIcon, size);
            }
        }
        return this.x(this.defaultPackageIcon, size);
    }

    private final Icon x(Icon icon, int n) {
        Icon icon2 = icon instanceof ScalableIcon ? ((ScalableIcon)icon).scale((float)n * 1.0f / (float)((ScalableIcon)icon).getIconWidth()) : icon;
        Intrinsics.checkNotNull((Object)icon2);
        return icon2;
    }

    private final ImageIcon x(byte[] byArray, int n) {
        Image image = Toolkit.getDefaultToolkit().createImage(byArray).getScaledInstance(n, n, 4);
        boolean bl = false;
        return new ImageIcon(image);
    }

    private final LoadedBytes x(String string) {
        try {
            byte[] byArray = Files.readAllBytes(Paths.get(string, new String[0]));
            return new LoadedBytes(byArray, null);
        }
        catch (Exception exception) {
            return new LoadedBytes(null, exception);
        }
    }

    @NotNull
    public final String getStatus() {
        Collection collection;
        StringBuffer stringBuffer = new StringBuffer();
        ((Appendable)stringBuffer).append("*** RiderNuGetIconLoader ***").append('\n');
        ((Appendable)stringBuffer).append("Total cached icons     : " + this.icons.size()).append('\n');
        ((Appendable)stringBuffer).append("Total cached icon data : " + this.iconData.size()).append('\n');
        ((Appendable)stringBuffer).append("Failed icons           : " + this.fails.size()).append('\n');
        ((Appendable)stringBuffer).append('\n');
        ((Appendable)stringBuffer).append("TotalIconDataSize : " + this.x(this.iconDataSize)).append('\n');
        ((Appendable)stringBuffer).append("AverageIconSize   : " + this.x(!this.icons.isEmpty() ? this.iconDataSize / this.icons.size() : 0)).append('\n');
        Appendable appendable = stringBuffer;
        Iterable iterable = CollectionsKt.filterNotNull((Iterable)this.iconData.values());
        RiderNuGetIconLoader riderNuGetIconLoader = this;
        boolean bl = false;
        Object object = iterable;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            byte[] byArray = (byte[])t;
            Collection collection3 = collection2;
            boolean bl3 = false;
            collection3.add(byArray.length);
        }
        Integer n = (Integer)CollectionsKt.maxOrNull((Iterable)((List)collection2));
        appendable.append("MaxIconSize       : " + riderNuGetIconLoader.x(n != null ? n : 0)).append('\n');
        appendable = stringBuffer;
        Iterable iterable2 = this.iconData.entrySet();
        object = iterable2.iterator();
        if (!object.hasNext()) {
            collection = null;
        } else {
            collection2 = object.next();
            if (!object.hasNext()) {
                collection = collection2;
            } else {
                Map.Entry entry2 = (Map.Entry)((Object)collection2);
                boolean bl4 = false;
                byte[] byArray = (byte[])entry2.getValue();
                int n2 = byArray != null ? byArray.length : 0;
                do {
                    int n3;
                    Object e = object.next();
                    Map.Entry entry3 = (Map.Entry)e;
                    boolean bl5 = false;
                    byte[] byArray2 = (byte[])entry3.getValue();
                    int n4 = n3 = byArray2 != null ? byArray2.length : 0;
                    if (n2 >= n3) continue;
                    collection2 = e;
                    n2 = n3;
                } while (object.hasNext());
                collection = collection2;
            }
        }
        Map.Entry entry4 = (Map.Entry)((Object)collection);
        appendable.append("BiggestIcon       : " + (entry4 != null ? (String)entry4.getKey() : null)).append('\n');
        ((Appendable)stringBuffer).append('\n');
        String string = stringBuffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String x(int n) {
        return n < 1024 ? n + " B" : (n < 0x100000 ? n / 1024 + " KB" : n / 1024 / 1024 + " MB " + n / 1024 % 1024 + " KB");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/nuget/helpers/RiderNuGetIconLoader$Companion;", "", "RiderNuGetIconLoader$Companion", "()V", "getInstance", "Lcom/jetbrains/rider/nuget/helpers/RiderNuGetIconLoader;", "smallIconSize", "", "getSmallIconSize", "()I", "bigIconSize", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nRiderNuGetIconLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderNuGetIconLoader.kt\ncom/jetbrains/rider/nuget/helpers/RiderNuGetIconLoader$Companion\n+ 2 ComponentContainerUtil.kt\ncom/jetbrains/rider/util/idea/ComponentContainerUtilKt\n*L\n1#1,160:1\n17#2,2:161\n*S KotlinDebug\n*F\n+ 1 RiderNuGetIconLoader.kt\ncom/jetbrains/rider/nuget/helpers/RiderNuGetIconLoader$Companion\n*L\n22#1:161,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RiderNuGetIconLoader getInstance() {
            ComponentManager componentManager = (ComponentManager)ApplicationKt.getApplication();
            boolean bl = false;
            Object object = componentManager.getService(RiderNuGetIconLoader.class);
            if (object == null) {
                throw new IllegalStateException("Service " + RiderNuGetIconLoader.class + " not found in container " + componentManager);
            }
            return (RiderNuGetIconLoader)object;
        }

        public final int getSmallIconSize() {
            return JBUI.scale((int)16);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\r\u0010\u0011\u001a\u00060\u0006j\u0002`\u0007H\u00c6\u0003J+\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\f\b\u0002\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0015\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/nuget/helpers/RiderNuGetIconLoader$Fail;", "", "id", "", "url", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "RiderNuGetIconLoader$Fail", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Exception;)V", "getId", "()Ljava/lang/String;", "getUrl", "getException", "()Ljava/lang/Exception;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rider"})
    public static final class Fail {
        @NotNull
        private final String id;
        @NotNull
        private final String url;
        @NotNull
        private final Exception exception;

        public Fail(@NotNull String id2, @NotNull String url2, @NotNull Exception exception) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            this.id = id2;
            this.url = url2;
            this.exception = exception;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final Exception getException() {
            return this.exception;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.url;
        }

        @NotNull
        public final Exception component3() {
            return this.exception;
        }

        @NotNull
        public final Fail copy(@NotNull String id2, @NotNull String url2, @NotNull Exception exception) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            return new Fail(id2, url2, exception);
        }

        public static /* synthetic */ Fail copy$default(Fail fail, String string, String string2, Exception exception, int n, Object object) {
            if ((n & 1) != 0) {
                string = fail.id;
            }
            if ((n & 2) != 0) {
                string2 = fail.url;
            }
            if ((n & 4) != 0) {
                exception = fail.exception;
            }
            return fail.copy(string, string2, exception);
        }

        @NotNull
        public String toString() {
            return "Fail(id=" + this.id + ", url=" + this.url + ", exception=" + this.exception + ")";
        }

        public int hashCode() {
            int n = this.id.hashCode();
            n = n * 31 + this.url.hashCode();
            n = n * 31 + this.exception.hashCode();
            return n;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Fail)) {
                return false;
            }
            Fail fail = (Fail)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)fail.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.url, (Object)fail.url)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.exception, (Object)fail.exception);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/nuget/helpers/RiderNuGetIconLoader$LoadedBytes;", "", "bytes", "", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "RiderNuGetIconLoader$LoadedBytes", "([BLjava/lang/Exception;)V", "getBytes", "()[B", "getException", "()Ljava/lang/Exception;", "intellij.rider"})
    private static final class LoadedBytes {
        @Nullable
        private final byte[] bytes;
        @Nullable
        private final Exception exception;

        public LoadedBytes(@Nullable byte[] bytes, @Nullable Exception exception) {
            this.bytes = bytes;
            this.exception = exception;
        }

        @Nullable
        public final byte[] getBytes() {
            return this.bytes;
        }

        @Nullable
        public final Exception getException() {
            return this.exception;
        }
    }
}

