/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.nuget;

import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.RiderBundle;
import com.jetbrains.rider.nuget.RiderNuGetFacade;
import com.jetbrains.rider.nuget.RiderNuGetToolWindowFactory;
import com.jetbrains.rider.nuget.RiderNugetBundle;
import com.jetbrains.rider.nuget.helpers.RiderNuGetProjectHelper;
import com.jetbrains.rider.nuget.panels.RiderNuGetPanelInfo;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/nuget/RiderNuGetUIHelper;", "", "RiderNuGetUIHelper", "()V", "packagesPanelInfo", "Lcom/jetbrains/rider/nuget/panels/RiderNuGetPanelInfo;", "getPackagesPanelInfo", "()Lcom/jetbrains/rider/nuget/panels/RiderNuGetPanelInfo;", "sourcesPanelInfo", "getSourcesPanelInfo", "cachesPanelInfo", "getCachesPanelInfo", "logsPanelInfo", "getLogsPanelInfo", "selectPanel", "", "project", "Lcom/intellij/openapi/project/Project;", "info", "showSettingsDialog", "openPackagesFolder", "intellij.rider"})
public final class RiderNuGetUIHelper {
    @NotNull
    public static final RiderNuGetUIHelper INSTANCE = new RiderNuGetUIHelper();
    @NotNull
    private static final RiderNuGetPanelInfo packagesPanelInfo = new RiderNuGetPanelInfo(RiderBundle.message("nuget.action.packages.text", new Object[0]), 0);
    @NotNull
    private static final RiderNuGetPanelInfo sourcesPanelInfo = new RiderNuGetPanelInfo(RiderBundle.message("nuget.tab.sources.text", new Object[0]), 1);
    @NotNull
    private static final RiderNuGetPanelInfo cachesPanelInfo = new RiderNuGetPanelInfo(RiderBundle.message("nuget.tab.caches.text", new Object[0]), 2);
    @NotNull
    private static final RiderNuGetPanelInfo logsPanelInfo = new RiderNuGetPanelInfo(RiderBundle.message("nuget.tab.log.text", new Object[0]), 3);

    private RiderNuGetUIHelper() {
    }

    @NotNull
    public final RiderNuGetPanelInfo getPackagesPanelInfo() {
        return packagesPanelInfo;
    }

    @NotNull
    public final RiderNuGetPanelInfo getSourcesPanelInfo() {
        return sourcesPanelInfo;
    }

    @NotNull
    public final RiderNuGetPanelInfo getCachesPanelInfo() {
        return cachesPanelInfo;
    }

    @NotNull
    public final RiderNuGetPanelInfo getLogsPanelInfo() {
        return logsPanelInfo;
    }

    public final void selectPanel(@NotNull Project project, @NotNull RiderNuGetPanelInfo info) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        RiderNuGetToolWindowFactory.Companion.showToolWindow(project, (Function0<Unit>)((Function0)() -> RiderNuGetUIHelper.x(project, info)));
    }

    public final void showSettingsDialog(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ShowSettingsUtil.getInstance().showSettingsDialog(project, "NuGet");
    }

    public final void openPackagesFolder(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        File file2 = RiderNuGetProjectHelper.INSTANCE.getPackagesFolder(project);
        if (file2 != null && file2.isDirectory() && file2.exists()) {
            RevealFileAction.openDirectory((File)file2);
        } else {
            String string;
            Object[] objectArray;
            if (file2 != null) {
                objectArray = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)file2.getAbsoluteFile(), (String)"getAbsoluteFile(...)");
                string = RiderNugetBundle.Companion.message("RiderNuGetUIHelper.notification.content.path", objectArray);
            } else {
                string = RiderNugetBundle.Companion.message("RiderNuGetUIHelper.notification.content.can.t.detect.path", new Object[0]);
            }
            String string2 = string;
            objectArray = RiderNuGetFacade.Companion.getInstance(project).getNotifier();
            objectArray.notifyFromFrontend(RiderNugetBundle.Companion.message("RiderNuGetUIHelper.notification.title.packages.folder.not.found", new Object[0]), string2, NotificationType.ERROR);
        }
    }

    private static final Unit x(Project project, RiderNuGetPanelInfo riderNuGetPanelInfo) {
        RiderNuGetFacade.Companion.getInstance(project).getSelectPanel().fire((Object)riderNuGetPanelInfo.getIndex());
        return Unit.INSTANCE;
    }
}

