/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.network;

import com.intellij.CommonBundle;
import com.intellij.diagnostic.PluginException;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.net.ssl.CertificateListener;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.net.ssl.ConfirmingTrustManager;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rider.RiderBundle;
import com.jetbrains.rider.designers.RiderDesignersBundle;
import com.jetbrains.rider.model.RdCertificateManagerHost;
import com.jetbrains.rider.model.RdCertificateManagerHost_PregeneratedKt;
import com.jetbrains.rider.model.RdCheckServerTrustedArgs;
import com.jetbrains.rider.model.RdLocalCertificateManager;
import com.jetbrains.rider.model.RdX509CertificateRaw;
import com.jetbrains.rider.network.RiderCertificateManagerHost;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0003\u0016\u0017\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u000eH\u0002J\u0006\u0010\u0014\u001a\u00020\u000eJ\b\u0010\u0015\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/network/RiderCertificateManagerHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "RiderCertificateManagerHost", "(Lcom/intellij/openapi/project/Project;)V", "rdLocalHost", "Lcom/jetbrains/rider/model/RdLocalCertificateManager;", "x", "()Lcom/jetbrains/rider/model/RdLocalCertificateManager;", "rejectedCertificates", "", "Lcom/jetbrains/rider/model/RdX509CertificateRaw;", "x", "", "args", "Lcom/jetbrains/rider/model/RdCheckServerTrustedArgs;", "model", "Lcom/jetbrains/rider/model/RdCertificateManagerHost;", "x", "sync", "G", "Companion", "Activity", "Listener", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderCertificateManagerHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderCertificateManagerHost.kt\ncom/jetbrains/rider/network/RiderCertificateManagerHost\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1563#2:133\n1634#2,3:134\n*S KotlinDebug\n*F\n+ 1 RiderCertificateManagerHost.kt\ncom/jetbrains/rider/network/RiderCertificateManagerHost\n*L\n94#1:133\n94#1:134,3\n*E\n"})
public final class RiderCertificateManagerHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final List<RdX509CertificateRaw> rejectedCertificates;

    public RiderCertificateManagerHost(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.rejectedCertificates = new ArrayList();
    }

    private final RdLocalCertificateManager x() {
        return RdCertificateManagerHost_PregeneratedKt.getRdCertificateManagerHost((Solution)SolutionHostExtensionsKt.getSolution((Project)this.project)).getLocal();
    }

    private final void x(RdCheckServerTrustedArgs rdCheckServerTrustedArgs, RdCertificateManagerHost rdCertificateManagerHost) {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        Certificate certificate = certificateFactory.generateCertificate(new ByteArrayInputStream(rdCheckServerTrustedArgs.getCertificate().getCertData()));
        Intrinsics.checkNotNull((Object)certificate, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
        X509Certificate x509Certificate = (X509Certificate)certificate;
        try {
            ConfirmingTrustManager.CertificateConfirmationParameters certificateConfirmationParameters = ConfirmingTrustManager.CertificateConfirmationParameters.askConfirmation((boolean)true, (String)rdCheckServerTrustedArgs.getMessage(), this::G);
            Intrinsics.checkNotNullExpressionValue((Object)certificateConfirmationParameters, (String)"askConfirmation(...)");
            ConfirmingTrustManager.CertificateConfirmationParameters certificateConfirmationParameters2 = certificateConfirmationParameters;
            X509Certificate[] x509CertificateArray = new X509Certificate[]{x509Certificate};
            CertificateManager.Companion.getInstance().getTrustManager().checkServerTrusted(x509CertificateArray, "RSA", certificateConfirmationParameters2);
        }
        catch (CertificateException certificateException) {
            this.rejectedCertificates.add(rdCheckServerTrustedArgs.getCertificate());
            rdCertificateManagerHost.getLocal().getRejectedCertificates().set((Object)CollectionsKt.toList((Iterable)this.rejectedCertificates));
        }
    }

    private final void x() {
        ConfirmingTrustManager.MutableTrustManager mutableTrustManager = CertificateManager.Companion.getInstance().getCustomTrustManager();
        CertificateListener certificateListener = new CertificateListener(this){
            final /* synthetic */ RiderCertificateManagerHost this$0;
            {
                this.this$0 = $receiver;
            }

            public void certificateRemoved(X509Certificate certificate) {
                this.this$0.sync();
            }

            public void certificateAdded(X509Certificate certificate) {
                this.this$0.sync();
            }
        };
        this.getServiceLifetime().bracketIfAlive(() -> RiderCertificateManagerHost.G(mutableTrustManager, certificateListener), () -> RiderCertificateManagerHost.x(mutableTrustManager, certificateListener));
    }

    public final void sync() {
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), arg_0 -> RiderCertificateManagerHost.x(this, arg_0), () -> RiderCertificateManagerHost.x(this));
    }

    private final void G() {
        NotificationListener.Adapter adapter = new NotificationListener.Adapter(this){
            final /* synthetic */ RiderCertificateManagerHost this$0;
            {
                this.this$0 = $receiver;
            }

            protected void hyperlinkActivated(Notification notification2, HyperlinkEvent e) {
                Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!RiderCertificateManagerHost.access$getProject$p(this.this$0).isDisposed() && Intrinsics.areEqual((Object)e.getDescription(), (Object)"settings")) {
                    notification2.hideBalloon();
                    try {
                        ShowSettingsUtil.getInstance().showSettingsDialog(RiderCertificateManagerHost.access$getProject$p(this.this$0), RiderBundle.message("RiderCertificateManagerHelper.configurable.name.server.certificates", new Object[0]));
                    }
                    catch (PluginException pluginException) {
                        // empty catch block
                    }
                }
            }
        };
        Object[] objectArray = SystemInfo.isMac ? CommonBundle.message((String)"title.settings.mac", (Object[])new Object[0]) : CommonBundle.message((String)"action.settings.path", (Object[])new Object[0]);
        Intrinsics.checkNotNull((Object)objectArray);
        Object[] objectArray2 = objectArray;
        objectArray = new Object[]{objectArray2};
        new Notification("Certificate Manager", RiderDesignersBundle.Companion.message("RiderCertificateManagerHelper.notification.title.certificate.was.successfully.accepted", new Object[0]), RiderDesignersBundle.Companion.message("RiderCertificateManagerHelper.notification.content.you.can.manage.full.list.of.certificates", objectArray), NotificationType.INFORMATION).setListener((NotificationListener)adapter).notify(this.project);
    }

    private static final Unit G(ConfirmingTrustManager.MutableTrustManager mutableTrustManager, installCertificateListener.listener.1 var1_1) {
        mutableTrustManager.addListener((CertificateListener)var1_1);
        return Unit.INSTANCE;
    }

    private static final Unit x(ConfirmingTrustManager.MutableTrustManager mutableTrustManager, installCertificateListener.listener.1 var1_1) {
        mutableTrustManager.removeListener((CertificateListener)var1_1);
        return Unit.INSTANCE;
    }

    private static final boolean x(RiderCertificateManagerHost riderCertificateManagerHost, Object object) {
        return !RLifetimeKt.isAlive((Lifetime)riderCertificateManagerHost.getServiceLifetime());
    }

    private static final void x(RiderCertificateManagerHost riderCertificateManagerHost) {
        List list2 = CertificateManager.Companion.getInstance().getCustomTrustManager().getCertificates();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getCertificates(...)");
        Iterable iterable = list2;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            X509Certificate x509Certificate = (X509Certificate)t;
            Collection collection2 = collection;
            boolean bl3 = false;
            byte[] byArray = x509Certificate.getEncoded();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
            collection2.add(new RdX509CertificateRaw(byArray));
        }
        List list3 = (List)collection;
        riderCertificateManagerHost.x().getAcceptedCertificates().set((Object)list3);
    }

    public static final /* synthetic */ Project access$getProject$p(RiderCertificateManagerHost $this) {
        return $this.project;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/network/RiderCertificateManagerHost$Activity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "RiderCertificateManagerHost$Activity", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.rider"})
    public static final class Activity
    implements ProjectActivity {
        @Nullable
        public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
            Companion.getInstance(project).x();
            Companion.getInstance(project).sync();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/network/RiderCertificateManagerHost$Companion;", "", "RiderCertificateManagerHost$Companion", "()V", "getInstance", "Lcom/jetbrains/rider/network/RiderCertificateManagerHost;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nRiderCertificateManagerHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderCertificateManagerHost.kt\ncom/jetbrains/rider/network/RiderCertificateManagerHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,132:1\n30#2,2:133\n*S KotlinDebug\n*F\n+ 1 RiderCertificateManagerHost.kt\ncom/jetbrains/rider/network/RiderCertificateManagerHost$Companion\n*L\n44#1:133,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RiderCertificateManagerHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager componentManager = (ComponentManager)project;
            boolean bl = false;
            Class<RiderCertificateManagerHost> clazz = RiderCertificateManagerHost.class;
            Object object = componentManager.getService(clazz);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
            }
            return (RiderCertificateManagerHost)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/network/RiderCertificateManagerHost$Listener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rider/model/RdCertificateManagerHost;", "RiderCertificateManagerHost$Listener", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "intellij.rider"})
    public static final class Listener
    implements SolutionExtListener<RdCertificateManagerHost> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull RdCertificateManagerHost model) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            model.getLocal().getCheckServerTrusted().advise(lifetime, arg_0 -> Listener.x(session, model, arg_0));
        }

        private static final Unit x(ClientProjectSession clientProjectSession, RdCertificateManagerHost rdCertificateManagerHost, RdCheckServerTrustedArgs rdCheckServerTrustedArgs) {
            Intrinsics.checkNotNullParameter((Object)rdCheckServerTrustedArgs, (String)"args");
            Companion.getInstance(clientProjectSession.getProject()).x(rdCheckServerTrustedArgs, rdCertificateManagerHost);
            return Unit.INSTANCE;
        }
    }
}

