/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.navigation;

import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.RiderBundle;
import com.jetbrains.rider.model.RdSolutionViewNavigation;
import com.jetbrains.rider.model.RiderNavigationModel;
import com.jetbrains.rider.projectView.views.SolutionViewUtilsKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/navigation/RiderNavigationProtocolListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rider/model/RiderNavigationModel;", "RiderNavigationProtocolListener", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "x", "project", "Lcom/intellij/openapi/project/Project;", "navigation", "Lcom/jetbrains/rider/model/RdSolutionViewNavigation;", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderNavigationProtocolListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderNavigationProtocolListener.kt\ncom/jetbrains/rider/navigation/RiderNavigationProtocolListener\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,45:1\n13#2:46\n13#3:47\n*S KotlinDebug\n*F\n+ 1 RiderNavigationProtocolListener.kt\ncom/jetbrains/rider/navigation/RiderNavigationProtocolListener\n*L\n20#1:46\n20#1:47\n*E\n"})
public final class RiderNavigationProtocolListener
implements SolutionExtListener<RiderNavigationModel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger myLogger;

    public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull RiderNavigationModel model) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        model.getNavigateToSolutionView().advise(lifetime, arg_0 -> RiderNavigationProtocolListener.x(this, session, arg_0));
    }

    private final void x(Project project, RdSolutionViewNavigation rdSolutionViewNavigation) {
        myLogger.info("Performing navigation... " + rdSolutionViewNavigation);
        CommandProcessor.getInstance().executeCommand(project, () -> RiderNavigationProtocolListener.x(rdSolutionViewNavigation, project), RiderBundle.message("command.name.open.solution.view", new Object[0]), null);
    }

    private static final Unit x(RiderNavigationProtocolListener riderNavigationProtocolListener, ClientProjectSession clientProjectSession, RdSolutionViewNavigation rdSolutionViewNavigation) {
        Intrinsics.checkNotNullParameter((Object)rdSolutionViewNavigation, (String)"navigation");
        ApplicationKt.getApplication().assertIsDispatchThread();
        riderNavigationProtocolListener.x(clientProjectSession.getProject(), rdSolutionViewNavigation);
        return Unit.INSTANCE;
    }

    private static final void x(RdSolutionViewNavigation rdSolutionViewNavigation, Project project) {
        int n = rdSolutionViewNavigation.getProjectModelElementId();
        if (n > 0) {
            SolutionViewUtilsKt.navigateToSolutionView(project, n, true);
        } else {
            String string = rdSolutionViewNavigation.getFilePath();
            VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)new File(string), (boolean)true);
            if (virtualFile == null) {
                throw new Exception("Can't create virtual file for path " + string);
            }
            VirtualFile virtualFile2 = virtualFile;
            SolutionViewUtilsKt.navigateToSolutionView(project, virtualFile2, true);
        }
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger = Logger.getInstance(RiderNavigationProtocolListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        myLogger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/navigation/RiderNavigationProtocolListener$Companion;", "", "RiderNavigationProtocolListener$Companion", "()V", "myLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

