/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.multiPlatform.xcAssets.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0003H\u0016J\b\u0010\u001a\u001a\u00020\u0003H\u0016J\b\u0010\u001b\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0011\u001a\u0004\u0018\u00010\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u000f\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/multiPlatform/xcAssets/ui/ColoredRect;", "Ljavax/swing/JComponent;", "dim", "Ljava/awt/Dimension;", "borderThickness", "", "cornerRadius", "backColor", "Ljava/awt/Color;", "color", "ColoredRect", "(Ljava/awt/Dimension;IILjava/awt/Color;Ljava/awt/Color;)V", "getDim", "()Ljava/awt/Dimension;", "getBackColor", "()Ljava/awt/Color;", "value", "currentColor", "getCurrentColor", "setCurrentColor", "(Ljava/awt/Color;)V", "paintComponent", "", "g", "Ljava/awt/Graphics;", "getPreferredSize", "getMinimumSize", "getMaximumSize", "intellij.rider"})
public final class ColoredRect
extends JComponent {
    @NotNull
    private final Dimension dim;
    private final int borderThickness;
    private final int cornerRadius;
    @NotNull
    private final Color backColor;
    @Nullable
    private Color color;

    public ColoredRect(@NotNull Dimension dim, int borderThickness, int cornerRadius, @NotNull Color backColor, @Nullable Color color) {
        Intrinsics.checkNotNullParameter((Object)dim, (String)"dim");
        Intrinsics.checkNotNullParameter((Object)backColor, (String)"backColor");
        this.dim = dim;
        this.borderThickness = borderThickness;
        this.cornerRadius = cornerRadius;
        this.backColor = backColor;
        this.color = color;
    }

    @NotNull
    public final Dimension getDim() {
        return this.dim;
    }

    @NotNull
    public final Color getBackColor() {
        return this.backColor;
    }

    @Nullable
    public final Color getCurrentColor() {
        return this.color;
    }

    public final void setCurrentColor(@Nullable Color value2) {
        this.color = value2;
        this.repaint();
    }

    @Override
    public void paintComponent(@NotNull Graphics g) {
        Graphics2D graphics2D;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                graphics2D = (Graphics2D)g;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (this.color == null) break block5;
                Color color = this.color;
                Intrinsics.checkNotNull((Object)color);
                if (color.getAlpha() == 255) break block6;
            }
            graphics2D.setPaint(this.backColor);
            graphics2D.fillRoundRect(0, 0, this.dim.width, this.dim.height, this.cornerRadius, this.cornerRadius);
            graphics2D.setPaint(Color.gray);
            int n = (this.dim.height - 2 * this.cornerRadius) / 2;
            graphics2D.fillRect(this.cornerRadius, this.cornerRadius, n, n);
            graphics2D.fillRect(this.cornerRadius + n, this.cornerRadius + n, n, n);
        }
        if (this.color != null) {
            Color color = this.color;
            Intrinsics.checkNotNull((Object)color);
            if (color.getAlpha() != 0) {
                graphics2D.setPaint(this.color);
                graphics2D.fillRoundRect(0, 0, this.dim.width, this.dim.height, this.cornerRadius, this.cornerRadius);
                graphics2D.setColor(this.backColor);
                graphics2D.setStroke(new BasicStroke((float)this.borderThickness * 1.0f));
                graphics2D.drawRoundRect(2 * this.borderThickness, 2 * this.borderThickness, this.dim.width - 4 * this.borderThickness, this.dim.height - 4 * this.borderThickness, this.cornerRadius - 2 * this.borderThickness, this.cornerRadius - 2 * this.borderThickness);
            }
        }
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        return this.dim;
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        return this.dim;
    }

    @Override
    @NotNull
    public Dimension getMaximumSize() {
        return this.dim;
    }
}

