/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.multiPlatform.xcAssets.presenters;

import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rider.multiPlatform.xcAssets.XcAssetInputSource;
import com.jetbrains.rider.multiPlatform.xcAssets.XcAssetsStatistic;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.PresenterUtilsKt;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.SelectionLogic;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.XcItemOperationResult;
import com.jetbrains.rider.multiPlatform.xcAssets.ui.AssetItemControl;
import com.jetbrains.rider.multiPlatform.xcAssets.ui.SelectionIconState;
import com.jetbrains.rider.multiPlatform.xcAssets.ui.XcAssetsStyle;
import icons.ReSharperIcons;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u00106\u001a\u0002072\u0006\u00108\u001a\u000209J\b\u0010:\u001a\u00020\bH\u0002J\b\u0010;\u001a\u00020\bH\u0002J\u000e\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=H$J\b\u0010?\u001a\u00020@H&J\b\u0010A\u001a\u00020\bH&J\b\u0010B\u001a\u00020\bH$J\u0010\u0010C\u001a\u0002072\u0006\u00108\u001a\u000209H$J\u0010\u0010D\u001a\u00020#2\u0006\u0010E\u001a\u00020FH$J\u0010\u0010G\u001a\u00020@2\u0006\u0010E\u001a\u00020HH$J\b\u0010I\u001a\u00020\bH\u0004J\u000f\u0010J\u001a\u0004\u0018\u00010\bH\u0004\u00a2\u0006\u0002\u0010KJ\u0010\u0010L\u001a\u00020\b2\u0006\u0010M\u001a\u00020\u000fH\u0004J\b\u0010N\u001a\u00020\bH\u0004J\u001e\u0010O\u001a\u00020\b2\u0006\u0010P\u001a\u00020*2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020>0=H\u0002J\u0010\u0010R\u001a\u00020\b2\u0006\u0010P\u001a\u00020*H\u0002J\u0010\u0010S\u001a\u00020\b2\u0006\u0010P\u001a\u00020*H\u0002R\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R$\u0010$\u001a\u00020#2\u0006\u0010\"\u001a\u00020#8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0012\u0010(\u001a\u00020#X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010%R\u001c\u0010)\u001a\u0004\u0018\u00010*X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u000e\u0010/\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00100\u001a\u00020\u000fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0011R\u0012\u00102\u001a\u00020\u000fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0011R\u0014\u00104\u001a\u00020\u000fX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u0011\u00a8\u0006T"}, d2={"Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcItemPresenterBase;", "TModel", "", "itemPresenterLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "model", "onContentChanged", "Lkotlin/Function0;", "", "XcItemPresenterBase", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)V", "getModel", "()Ljava/lang/Object;", "Ljava/lang/Object;", "errorStateMessage", "", "getErrorStateMessage", "()Ljava/lang/String;", "setErrorStateMessage", "(Ljava/lang/String;)V", "currentLifetime", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "selector", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/SelectionLogic;", "getSelector", "()Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/SelectionLogic;", "setSelector", "(Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/SelectionLogic;)V", "selectionOrder", "", "getSelectionOrder", "()I", "setSelectionOrder", "(I)V", "value", "", "isSelected", "()Z", "setSelected", "(Z)V", "isEmpty", "assetControl", "Lcom/jetbrains/rider/multiPlatform/xcAssets/ui/AssetItemControl;", "getAssetControl", "()Lcom/jetbrains/rider/multiPlatform/xcAssets/ui/AssetItemControl;", "setAssetControl", "(Lcom/jetbrains/rider/multiPlatform/xcAssets/ui/AssetItemControl;)V", "myIsSelected", "caption", "getCaption", "tooltip", "getTooltip", "hint", "getHint", "draw", "Ljavax/swing/JComponent;", "style", "Lcom/jetbrains/rider/multiPlatform/xcAssets/ui/XcAssetsStyle;", "G", "x", "createPopupMenuItems", "", "Lcom/intellij/openapi/ui/JBMenuItem;", "handleAddAction", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcItemOperationResult;", "handleDeleteAction", "afterDraw", "createContentUI", "tryDrag", "dtde", "Ljava/awt/dnd/DropTargetDragEvent;", "tryDrop", "Ljava/awt/dnd/DropTargetDropEvent;", "modelChanged", "selectMe", "()Lkotlin/Unit;", "setErrorState", "error", "setNormalState", "x", "control", "menuItems", "x", "G", "intellij.rider"})
public abstract class XcItemPresenterBase<TModel> {
    private final TModel model;
    @NotNull
    private final Function0<Unit> onContentChanged;
    @Nullable
    private String errorStateMessage;
    @NotNull
    private final SequentialLifetimes currentLifetime;
    @Nullable
    private SelectionLogic selector;
    private int selectionOrder;
    @Nullable
    private AssetItemControl assetControl;
    private boolean myIsSelected;
    @NotNull
    private final String hint;

    public XcItemPresenterBase(@NotNull Lifetime itemPresenterLifetime, TModel model, @NotNull Function0<Unit> onContentChanged) {
        Intrinsics.checkNotNullParameter((Object)itemPresenterLifetime, (String)"itemPresenterLifetime");
        Intrinsics.checkNotNullParameter(onContentChanged, (String)"onContentChanged");
        this.model = model;
        this.onContentChanged = onContentChanged;
        this.currentLifetime = new SequentialLifetimes(itemPresenterLifetime);
        this.selectionOrder = -1;
        this.hint = "";
    }

    public /* synthetic */ XcItemPresenterBase(Lifetime lifetime, Object object, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function0 = XcItemPresenterBase::x;
        }
        this(lifetime, object, (Function0<Unit>)function0);
    }

    public final TModel getModel() {
        return this.model;
    }

    @Nullable
    protected final String getErrorStateMessage() {
        return this.errorStateMessage;
    }

    protected final void setErrorStateMessage(@Nullable String string) {
        this.errorStateMessage = string;
    }

    @Nullable
    public final SelectionLogic getSelector() {
        return this.selector;
    }

    public final void setSelector(@Nullable SelectionLogic selectionLogic) {
        this.selector = selectionLogic;
    }

    public final int getSelectionOrder() {
        return this.selectionOrder;
    }

    public final void setSelectionOrder(int n) {
        this.selectionOrder = n;
    }

    public final boolean isSelected() {
        return this.myIsSelected;
    }

    public final void setSelected(boolean value2) {
        block0: {
            this.myIsSelected = value2;
            AssetItemControl assetItemControl = this.assetControl;
            if (assetItemControl == null) break block0;
            assetItemControl.setSelected(value2);
        }
    }

    public abstract boolean isEmpty();

    @Nullable
    protected final AssetItemControl getAssetControl() {
        return this.assetControl;
    }

    protected final void setAssetControl(@Nullable AssetItemControl assetItemControl) {
        this.assetControl = assetItemControl;
    }

    @NotNull
    protected abstract String getCaption();

    @NotNull
    protected abstract String getTooltip();

    @NotNull
    protected String getHint() {
        return this.hint;
    }

    @NotNull
    public final JComponent draw(@NotNull XcAssetsStyle style) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        AssetItemControl assetItemControl = new AssetItemControl((Lifetime)this.currentLifetime.next(), style, this.getCaption(), this.createContentUI(style), this.getHint());
        this.x(assetItemControl);
        this.G(assetItemControl);
        this.assetControl = assetItemControl;
        this.afterDraw();
        this.G();
        this.x();
        return assetItemControl;
    }

    private final void G() {
        AssetItemControl assetItemControl = this.assetControl;
        if (assetItemControl == null) {
            return;
        }
        AssetItemControl assetItemControl2 = assetItemControl;
        List<JBMenuItem> list2 = this.createPopupMenuItems();
        if (CollectionsKt.any((Iterable)list2)) {
            this.x(assetItemControl2, list2);
        }
    }

    private final void x() {
        block0: {
            AssetItemControl assetItemControl = this.assetControl;
            if (assetItemControl == null) break block0;
            assetItemControl.setToolTipText(PresenterUtilsKt.wrapToHtmlMultiline(this.getTooltip()));
        }
    }

    @NotNull
    protected abstract List<JBMenuItem> createPopupMenuItems();

    @NotNull
    public abstract XcItemOperationResult handleAddAction();

    public abstract void handleDeleteAction();

    protected abstract void afterDraw();

    @NotNull
    protected abstract JComponent createContentUI(@NotNull XcAssetsStyle var1);

    protected abstract boolean tryDrag(@NotNull DropTargetDragEvent var1);

    @NotNull
    protected abstract XcItemOperationResult tryDrop(@NotNull DropTargetDropEvent var1);

    protected final void modelChanged() {
        this.onContentChanged.invoke();
        this.x();
        this.G();
    }

    @Nullable
    protected final Unit selectMe() {
        Unit unit;
        SelectionLogic selectionLogic = this.selector;
        if (selectionLogic != null) {
            selectionLogic.select(this);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    protected final void setErrorState(@NotNull String error) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            this.errorStateMessage = error;
            AssetItemControl assetItemControl = this.assetControl;
            if (assetItemControl == null) break block0;
            assetItemControl.setLabelIcon(ReSharperIcons.Common.Error);
        }
    }

    protected final void setNormalState() {
        block0: {
            AssetItemControl assetItemControl = this.assetControl;
            if (assetItemControl == null) break block0;
            assetItemControl.setLabelIcon(null);
        }
    }

    private final void x(AssetItemControl assetItemControl, List<? extends JBMenuItem> list2) {
        JBPopupMenu jBPopupMenu = new JBPopupMenu();
        assetItemControl.setComponentPopupMenu((JPopupMenu)jBPopupMenu);
        for (JBMenuItem jBMenuItem : list2) {
            jBPopupMenu.add((JMenuItem)jBMenuItem);
        }
        SelectionLogic selectionLogic = this.selector;
        if (selectionLogic == null) {
            return;
        }
        SelectionLogic selectionLogic2 = selectionLogic;
        jBPopupMenu.addPopupMenuListener(new PopupMenuListener(selectionLogic2, this){
            final /* synthetic */ SelectionLogic $actualSelector;
            final /* synthetic */ XcItemPresenterBase<TModel> this$0;
            {
                this.$actualSelector = $actualSelector;
                this.this$0 = $receiver;
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                this.$actualSelector.select(this.this$0);
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    private final void x(AssetItemControl assetItemControl) {
        SelectionLogic selectionLogic = this.selector;
        if (selectionLogic == null) {
            return;
        }
        SelectionLogic selectionLogic2 = selectionLogic;
        assetItemControl.addMouseListener(new MouseAdapter(this, selectionLogic2){
            final /* synthetic */ XcItemPresenterBase<TModel> this$0;
            final /* synthetic */ SelectionLogic $actualSelector;
            {
                this.this$0 = $receiver;
                this.$actualSelector = $actualSelector;
            }

            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            public void mousePressed(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    XcItemOperationResult xcItemOperationResult = this.this$0.handleAddAction();
                    XcAssetsStatistic.addAssetItem.log(this.this$0.getClass(), (Object)((Object)XcAssetInputSource.MouseClick), (Object)((Object)xcItemOperationResult));
                } else {
                    if (e.getClickCount() != 1) {
                        return;
                    }
                    if (e.isShiftDown()) {
                        this.$actualSelector.selectWithShift(this.this$0);
                    } else if (e.isControlDown()) {
                        this.$actualSelector.selectWithControl(this.this$0);
                    } else if (e.isMetaDown()) {
                        this.$actualSelector.selectWithControl(this.this$0);
                    } else {
                        this.$actualSelector.select(this.this$0);
                    }
                }
            }

            public void mouseEntered(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            public void mouseExited(MouseEvent e) {
            }
        });
    }

    private final void G(AssetItemControl assetItemControl) {
        new DropTarget(assetItemControl, new DropTargetListener(this, assetItemControl){
            final /* synthetic */ XcItemPresenterBase<TModel> this$0;
            final /* synthetic */ AssetItemControl $control;
            {
                this.this$0 = $receiver;
                this.$control = $control;
            }

            public void dragEnter(DropTargetDragEvent dtde) {
                Intrinsics.checkNotNullParameter((Object)dtde, (String)"dtde");
                if (this.this$0.tryDrag(dtde)) {
                    this.$control.setDropHighlight(SelectionIconState.CAN_BE_DROPPED);
                    dtde.acceptDrag(1);
                } else {
                    this.$control.setDropHighlight(SelectionIconState.IMPOSSIBLE_TO_DROP);
                    dtde.rejectDrag();
                }
            }

            public void dragOver(DropTargetDragEvent dtde) {
            }

            public void dropActionChanged(DropTargetDragEvent dtde) {
            }

            public void dragExit(DropTargetEvent dte) {
                this.$control.setDropHighlight(SelectionIconState.EMPTY);
            }

            public void drop(DropTargetDropEvent dtde) {
                Intrinsics.checkNotNullParameter((Object)dtde, (String)"dtde");
                dtde.acceptDrop(1);
                this.$control.setDropHighlight(SelectionIconState.EMPTY);
                XcItemOperationResult xcItemOperationResult = this.this$0.tryDrop(dtde);
                if (xcItemOperationResult == XcItemOperationResult.Success) {
                    dtde.dropComplete(true);
                    this.this$0.selectMe();
                } else {
                    dtde.dropComplete(false);
                }
                XcAssetsStatistic.addAssetItem.log(this.this$0.getClass(), (Object)((Object)XcAssetInputSource.DragNDrop), (Object)((Object)xcItemOperationResult));
            }
        });
    }

    private static final Unit x() {
        return Unit.INSTANCE;
    }
}

