/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.multiPlatform.xcAssets.models;

import com.google.gson.Gson;
import com.jetbrains.rider.multiPlatform.xcAssets.models.FillGroupResults;
import com.jetbrains.rider.multiPlatform.xcAssets.models.IconGroup;
import com.jetbrains.rider.multiPlatform.xcAssets.models.IconScale;
import com.jetbrains.rider.multiPlatform.xcAssets.models.IconSize;
import com.jetbrains.rider.multiPlatform.xcAssets.models.IconSocket;
import com.jetbrains.rider.multiPlatform.xcAssets.models.Idiom;
import com.jetbrains.rider.multiPlatform.xcAssets.models.IdiomRole;
import com.jetbrains.rider.multiPlatform.xcAssets.models.ModelUtilsKt;
import com.jetbrains.rider.multiPlatform.xcAssets.models.WatchSubtype;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcAssetAppIconItem;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcAssetAppIconProperties;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcAssetAppIconset;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcAssetInfo;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a9\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\"\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u000e\u001a<\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0010\u001a\u00020\r2\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002\u001a\u0014\u0010\u0015\u001a\u00020\u00162\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00170\u0007\u001a\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017\u001a\u000e\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0017\u001a\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0003\u001a\u000e\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0003\u001a\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"\u001a\u000e\u0010#\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"\u001a\u0016\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(\u001a$\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001d2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00170\u00072\u0006\u0010\u001e\u001a\u00020\u0003\u001a\u0016\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0003\u00a8\u0006/"}, d2={"x", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/IconGroup;", "caption", "", "idiom", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/Idiom;", "icons", "", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/IconSocket;", "size", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/IconSize;", "scales", "", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/IconScale;", "(Ljava/lang/String;Lcom/jetbrains/rider/multiPlatform/xcAssets/models/Idiom;Lcom/jetbrains/rider/multiPlatform/xcAssets/models/IconSize;[Lcom/jetbrains/rider/multiPlatform/xcAssets/models/IconScale;)Lcom/jetbrains/rider/multiPlatform/xcAssets/models/IconGroup;", "x", "scale", "role", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/IdiomRole;", "watchSubtype", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/WatchSubtype;", "getFilledIconGroups", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/FillGroupResults;", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/XcAssetAppIconItem;", "getIconSize", "", "model", "getScreenHint", "readIconXcAssets", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/XcAssetAppIconset;", "path", "deserializeIconXcAssets", "content", "reader", "Ljava/io/BufferedReader;", "readIconXcAssetItem", "createDefaultIconset", "prerendered", "", "info", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/XcAssetInfo;", "saveAppIconset", "", "originSet", "allIcons", "writeIconXcAssets", "iconset", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nXcIconUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XcIconUtils.kt\ncom/jetbrains/rider/multiPlatform/xcAssets/models/XcIconUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n1#2:161\n*E\n"})
public final class XcIconUtilsKt {
    private static final IconGroup x(String string, Idiom idiom, List<IconSocket> list2) {
        return new IconGroup(string, idiom, list2);
    }

    private static final IconGroup x(String string, Idiom idiom, IconSize iconSize, IconScale ... iconScaleArray) {
        ArrayList<IconSocket> arrayList;
        if (iconScaleArray.length == 0) {
            throw new IllegalArgumentException("scales have to have at least 1 element");
        }
        int n = iconScaleArray.length;
        Idiom idiom2 = idiom;
        String string2 = string;
        ArrayList<IconSocket> arrayList2 = new ArrayList<IconSocket>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            arrayList = arrayList2;
            boolean bl = false;
            arrayList.add(new IconSocket(iconSize, iconScaleArray[n4], null, null, null, 28, null));
        }
        ArrayList<IconSocket> arrayList3 = arrayList = (ArrayList<IconSocket>)arrayList2;
        Idiom idiom3 = idiom2;
        String string3 = string2;
        return new IconGroup(string3, idiom3, arrayList3);
    }

    private static final IconSocket x(IconSize iconSize, IconScale iconScale, String string, IdiomRole idiomRole, WatchSubtype watchSubtype) {
        return new IconSocket(iconSize, iconScale, string, idiomRole, watchSubtype);
    }

    static /* synthetic */ IconSocket icon$default(IconSize iconSize, IconScale iconScale, String string, IdiomRole idiomRole, WatchSubtype watchSubtype, int n, Object object) {
        if ((n & 2) != 0) {
            iconScale = IconScale.X1;
        }
        if ((n & 4) != 0) {
            string = "";
        }
        if ((n & 8) != 0) {
            idiomRole = null;
        }
        if ((n & 0x10) != 0) {
            watchSubtype = null;
        }
        return XcIconUtilsKt.x(iconSize, iconScale, string, idiomRole, watchSubtype);
    }

    @NotNull
    public static final FillGroupResults getFilledIconGroups(@NotNull List<XcAssetAppIconItem> icons) {
        Intrinsics.checkNotNullParameter(icons, (String)"icons");
        String string = "iOS 7+";
        String string2 = "iOS 9+";
        Object[] objectArray = new IconGroup[21];
        Object object = new IconScale[]{IconScale.X2, IconScale.X3};
        objectArray[0] = XcIconUtilsKt.x("iPhone Notifications\r" + string, Idiom.IPHONE, IconSize.S20, (IconScale[])object);
        object = new IconScale[]{IconScale.X2, IconScale.X3};
        objectArray[1] = XcIconUtilsKt.x("iPhone Settings\r" + string, Idiom.IPHONE, IconSize.S29, (IconScale[])object);
        object = new IconScale[]{IconScale.X2, IconScale.X3};
        objectArray[2] = XcIconUtilsKt.x("iPhone Spotlight\r" + string, Idiom.IPHONE, IconSize.S40, (IconScale[])object);
        object = new IconScale[]{IconScale.X2, IconScale.X3};
        objectArray[3] = XcIconUtilsKt.x("iPhone App\r" + string, Idiom.IPHONE, IconSize.S60, (IconScale[])object);
        object = new IconScale[]{IconScale.X1, IconScale.X2};
        objectArray[4] = XcIconUtilsKt.x("iPad Notification\r" + string, Idiom.IPAD, IconSize.S20, (IconScale[])object);
        object = new IconScale[]{IconScale.X1, IconScale.X2};
        objectArray[5] = XcIconUtilsKt.x("iPad Settings\r" + string, Idiom.IPAD, IconSize.S29, (IconScale[])object);
        object = new IconScale[]{IconScale.X1, IconScale.X2};
        objectArray[6] = XcIconUtilsKt.x("iPad Spotlight\r" + string, Idiom.IPAD, IconSize.S40, (IconScale[])object);
        object = new IconScale[]{IconScale.X1, IconScale.X2};
        objectArray[7] = XcIconUtilsKt.x("iPad App\r" + string, Idiom.IPAD, IconSize.S76, (IconScale[])object);
        object = new IconScale[]{IconScale.X2};
        objectArray[8] = XcIconUtilsKt.x("iPad Pro(12.9-inch) App\r" + string2, Idiom.IPAD, IconSize.S83_5, (IconScale[])object);
        object = new IconScale[]{IconScale.X1};
        objectArray[9] = XcIconUtilsKt.x("App Store\riOS", Idiom.IOS_MARKETING, IconSize.S1024, (IconScale[])object);
        object = new IconScale[]{IconScale.X2, IconScale.X3};
        objectArray[10] = XcIconUtilsKt.x("CarPlay\riOS", Idiom.CAR, IconSize.S60, (IconScale[])object);
        object = new IconSocket[]{XcIconUtilsKt.x(IconSize.S24, IconScale.X2, "38mm", IdiomRole.NOTIFICATION_CENTER, WatchSubtype.SIZE_38MM), XcIconUtilsKt.x(IconSize.S27_5, IconScale.X2, "40mm\r42mm", IdiomRole.NOTIFICATION_CENTER, WatchSubtype.SIZE_42MM)};
        objectArray[11] = XcIconUtilsKt.x("Apple Watch\rNotification Center", Idiom.WATCH, CollectionsKt.listOf((Object[])object));
        object = new IconSocket[]{XcIconUtilsKt.icon$default(IconSize.S29, IconScale.X2, "44mm", IdiomRole.COMPANION_SETTINGS, null, 16, null), XcIconUtilsKt.icon$default(IconSize.S29, IconScale.X3, "", IdiomRole.COMPANION_SETTINGS, null, 16, null)};
        objectArray[12] = XcIconUtilsKt.x("Apple Watch\rCompanion Settings\rNotification Center", Idiom.WATCH, CollectionsKt.listOf((Object[])object));
        object = new IconSocket[]{XcIconUtilsKt.x(IconSize.S40, IconScale.X2, "38mm", IdiomRole.APP_LAUNCHER, WatchSubtype.SIZE_38MM), XcIconUtilsKt.x(IconSize.S44, IconScale.X2, "40mm\r42mm\r", IdiomRole.APP_LAUNCHER, WatchSubtype.SIZE_40MM), XcIconUtilsKt.x(IconSize.S50, IconScale.X2, "44mm", IdiomRole.APP_LAUNCHER, WatchSubtype.SIZE_44MM)};
        objectArray[13] = XcIconUtilsKt.x("Apple Watch\rHome Screen", Idiom.WATCH, CollectionsKt.listOf((Object[])object));
        object = new IconSocket[]{XcIconUtilsKt.x(IconSize.S86, IconScale.X2, "38mm", IdiomRole.QUICK_LOOK, WatchSubtype.SIZE_38MM), XcIconUtilsKt.x(IconSize.S98, IconScale.X2, "40mm\r42mm", IdiomRole.QUICK_LOOK, WatchSubtype.SIZE_42MM), XcIconUtilsKt.x(IconSize.S108, IconScale.X2, "44mm", IdiomRole.QUICK_LOOK, WatchSubtype.SIZE_44MM)};
        objectArray[14] = XcIconUtilsKt.x("Apple Watch\rShort Lock", Idiom.WATCH, CollectionsKt.listOf((Object[])object));
        object = new IconScale[]{IconScale.X1};
        objectArray[15] = XcIconUtilsKt.x("Apple Watch\rApp Store", Idiom.WATCH_MARKETING, IconSize.S1024, (IconScale[])object);
        object = new IconScale[]{IconScale.X1, IconScale.X2};
        objectArray[16] = XcIconUtilsKt.x("Mac", Idiom.MAC, IconSize.S16, (IconScale[])object);
        object = new IconScale[]{IconScale.X1, IconScale.X2};
        objectArray[17] = XcIconUtilsKt.x("Mac", Idiom.MAC, IconSize.S32, (IconScale[])object);
        object = new IconScale[]{IconScale.X1, IconScale.X2};
        objectArray[18] = XcIconUtilsKt.x("Mac", Idiom.MAC, IconSize.S128, (IconScale[])object);
        object = new IconScale[]{IconScale.X1, IconScale.X2};
        objectArray[19] = XcIconUtilsKt.x("Mac", Idiom.MAC, IconSize.S256, (IconScale[])object);
        object = new IconSocket[]{XcIconUtilsKt.icon$default(IconSize.S512, IconScale.X1, null, null, null, 28, null), XcIconUtilsKt.icon$default(IconSize.S512, IconScale.X2, "App Store", null, null, 24, null)};
        objectArray[20] = XcIconUtilsKt.x("Mac", Idiom.MAC, CollectionsKt.listOf((Object[])object));
        List list2 = CollectionsKt.listOf((Object[])objectArray);
        boolean bl = false;
        object = CollectionsKt.toMutableList((Collection)icons);
        for (IconGroup iconGroup : list2) {
            for (IconSocket iconSocket : iconGroup.getIconSockets()) {
                if (iconSocket.getModel() != null) continue;
                int n = -1;
                Iterator iterator2 = ((Iterable)object).iterator();
                int n2 = 0;
                while (iterator2.hasNext()) {
                    int n3 = n2++;
                    XcAssetAppIconItem xcAssetAppIconItem = (XcAssetAppIconItem)iterator2.next();
                    if (xcAssetAppIconItem.getIdiom() != iconGroup.getIdiom() || !iconSocket.trySetIcon(xcAssetAppIconItem) || !iconSocket.trySetIcon(xcAssetAppIconItem)) continue;
                    n = n3;
                    break;
                }
                if (n != -1) {
                    object.remove(n);
                    continue;
                }
                iconSocket.setDefaultIcon(iconGroup.getIdiom());
                bl = true;
            }
        }
        return new FillGroupResults(list2, bl);
    }

    public static final int getIconSize(@NotNull XcAssetAppIconItem model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return MathKt.roundToInt((double)(model.getSize().getValue() * (double)model.getScale().getValue()));
    }

    @NotNull
    public static final String getScreenHint(@NotNull XcAssetAppIconItem model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        int n = XcIconUtilsKt.getIconSize(model);
        return n + "x" + n;
    }

    @Nullable
    public static final XcAssetAppIconset readIconXcAssets(@Nullable String path) {
        XcAssetAppIconset xcAssetAppIconset;
        if (path == null) {
            xcAssetAppIconset = null;
        } else if (new File(path).exists()) {
            BufferedReader bufferedReader = Files.newBufferedReader(Paths.get(path, new String[0]));
            Intrinsics.checkNotNullExpressionValue((Object)bufferedReader, (String)"newBufferedReader(...)");
            xcAssetAppIconset = XcIconUtilsKt.readIconXcAssets(bufferedReader);
        } else {
            xcAssetAppIconset = null;
        }
        return xcAssetAppIconset;
    }

    @NotNull
    public static final XcAssetAppIconset deserializeIconXcAssets(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Object object = new Gson().fromJson((Reader)new StringReader(content), XcAssetAppIconset.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
        return (XcAssetAppIconset)object;
    }

    @NotNull
    public static final XcAssetAppIconset readIconXcAssets(@NotNull BufferedReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Object object = new Gson().fromJson((Reader)reader, XcAssetAppIconset.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
        return (XcAssetAppIconset)object;
    }

    @NotNull
    public static final XcAssetAppIconItem readIconXcAssetItem(@NotNull BufferedReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Object object = new Gson().fromJson((Reader)reader, XcAssetAppIconItem.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
        return (XcAssetAppIconItem)object;
    }

    @NotNull
    public static final XcAssetAppIconset createDefaultIconset(boolean prerendered, @NotNull XcAssetInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        return new XcAssetAppIconset(CollectionsKt.emptyList(), info, new XcAssetAppIconProperties(prerendered));
    }

    public static final void saveAppIconset(@NotNull XcAssetAppIconset originSet, @NotNull List<XcAssetAppIconItem> allIcons, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)originSet, (String)"originSet");
        Intrinsics.checkNotNullParameter(allIcons, (String)"allIcons");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        XcAssetAppIconset xcAssetAppIconset = new XcAssetAppIconset(allIcons, originSet.getInfo(), originSet.getProperties());
        XcIconUtilsKt.writeIconXcAssets(xcAssetAppIconset, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeIconXcAssets(@NotNull XcAssetAppIconset iconset, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)iconset, (String)"iconset");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Closeable closeable = new FileWriter(path);
        Throwable throwable = null;
        try {
            FileWriter fileWriter = (FileWriter)closeable;
            boolean bl = false;
            ModelUtilsKt.serializeToJson(iconset, fileWriter);
            fileWriter = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

