/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.multiPlatform.xcAssets.editors;

import com.google.gson.JsonSyntaxException;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FailedEditorBuilder;
import com.intellij.openapi.fileEditor.impl.FailedEditorPaneKt;
import com.intellij.openapi.fileEditor.impl.MultilineWrapMode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rider.actions.RiderActionsBundle;
import com.jetbrains.rider.designers.DesignerEditorBase;
import com.jetbrains.rider.multiPlatform.RiderMultiPlatformBundle;
import com.jetbrains.rider.multiPlatform.xcAssets.ContentsJsonFailure;
import com.jetbrains.rider.multiPlatform.xcAssets.UserConfirmationResults;
import com.jetbrains.rider.multiPlatform.xcAssets.XcAssetsStatistic;
import com.jetbrains.rider.multiPlatform.xcAssets.assetFolder.TypeOfFsChanges;
import com.jetbrains.rider.multiPlatform.xcAssets.assetFolder.XcAssetFolder;
import com.jetbrains.rider.multiPlatform.xcAssets.editors.XcAssetEditorUtilsKt;
import com.jetbrains.rider.multiPlatform.xcAssets.models.ModelUtilsKt;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcAssetInfo;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.SelectionLogic;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.XcAssetPresenter;
import com.jetbrains.rider.multiPlatform.xcAssets.ui.XcAssetsStyle;
import java.awt.Component;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010%\u001a\u00020\u0006J\u0006\u0010&\u001a\u00020\u0012J\u0006\u0010'\u001a\u00020\u0012J\b\u0010(\u001a\u00020)H\u0016J\u0006\u0010*\u001a\u00020\u0010J\u0006\u0010+\u001a\u00020\u0010J\u0006\u0010,\u001a\u00020)J\u001d\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00028\u0000H$\u00a2\u0006\u0002\u00102J\u0017\u00103\u001a\u0004\u0018\u00010\u00142\u0006\u00101\u001a\u00028\u0000H$\u00a2\u0006\u0002\u00104J\u0015\u00105\u001a\u00028\u00002\u0006\u00106\u001a\u000207H$\u00a2\u0006\u0002\u00108J\r\u00109\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010:J\u0012\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010=\u001a\u00020.H$J\u0012\u0010>\u001a\u0004\u0018\u00010<2\u0006\u0010=\u001a\u00020.H$J\u0010\u0010?\u001a\u00020)2\u0006\u0010=\u001a\u00020.H\u0014J\u0015\u0010@\u001a\u00020)2\u0006\u00101\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010AJ\n\u0010B\u001a\u0004\u0018\u00010.H\u0002J\u0015\u0010C\u001a\u00020.2\u0006\u00101\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010DJ\b\u0010E\u001a\u00020)H\u0002J\b\u0010F\u001a\u00020)H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u00148DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u00020\"X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006G"}, d2={"Lcom/jetbrains/rider/multiPlatform/xcAssets/editors/XcAssetEditorBase;", "TAssetModel", "Lcom/jetbrains/rider/designers/DesignerEditorBase;", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "XcAssetEditorBase", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "selector", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/SelectionLogic;", "getSelector", "()Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/SelectionLogic;", "setSelector", "(Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/SelectionLogic;)V", "mainPanel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "myIsValid", "", "myInfo", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/XcAssetInfo;", "assetFolder", "Lcom/jetbrains/rider/multiPlatform/xcAssets/assetFolder/XcAssetFolder;", "getAssetFolder", "()Lcom/jetbrains/rider/multiPlatform/xcAssets/assetFolder/XcAssetFolder;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "info", "getInfo", "()Lcom/jetbrains/rider/multiPlatform/xcAssets/models/XcAssetInfo;", "presenterSequentialLifetime", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "style", "Lcom/jetbrains/rider/multiPlatform/xcAssets/ui/XcAssetsStyle;", "getStyle", "()Lcom/jetbrains/rider/multiPlatform/xcAssets/ui/XcAssetsStyle;", "getFile", "isValid", "isModified", "dispose", "", "getComponent", "getPreferredFocusedComponent", "selectNotify", "createPresenter", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcAssetPresenter;", "presenterLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "model", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/lang/Object;)Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcAssetPresenter;", "getInfoFrom", "(Ljava/lang/Object;)Lcom/jetbrains/rider/multiPlatform/xcAssets/models/XcAssetInfo;", "parseModel", "input", "", "(Ljava/lang/String;)Ljava/lang/Object;", "createEmptyModel", "()Ljava/lang/Object;", "createPropertyPanel", "Ljavax/swing/JComponent;", "presenter", "createBottomPanel", "synchronizeWorkspaceModel", "saveModel", "(Ljava/lang/Object;)V", "x", "x", "(Ljava/lang/Object;)Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcAssetPresenter;", "x", "G", "intellij.rider"})
public abstract class XcAssetEditorBase<TAssetModel>
extends DesignerEditorBase {
    @NotNull
    private final VirtualFile root;
    @NotNull
    private SelectionLogic selector;
    @NotNull
    private final BorderLayoutPanel mainPanel;
    private boolean myIsValid;
    @NotNull
    private XcAssetInfo myInfo;
    @NotNull
    private final XcAssetFolder assetFolder;
    @NotNull
    private final Logger logger;
    @NotNull
    private final SequentialLifetimes presenterSequentialLifetime;
    @NotNull
    private final XcAssetsStyle style;

    public XcAssetEditorBase(@NotNull Project project, @NotNull VirtualFile root2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        super(project);
        this.root = root2;
        this.selector = new SelectionLogic();
        this.mainPanel = new BorderLayoutPanel();
        this.myIsValid = true;
        this.myInfo = XcAssetEditorUtilsKt.getDefaultInfo();
        Logger logger = Logger.getInstance((String)"#com.intellij.xamarin.XcAssetFileEditorImpl");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.presenterSequentialLifetime = new SequentialLifetimes(this.getLifetime());
        this.style = XcAssetEditorUtilsKt.getAssetStyle();
        this.assetFolder = new XcAssetFolder(this.getLifetime(), this.root, project, (Function1<? super TypeOfFsChanges, Unit>)((Function1)arg_0 -> XcAssetEditorBase.x(this, arg_0)));
        this.x();
    }

    @NotNull
    protected final SelectionLogic getSelector() {
        return this.selector;
    }

    protected final void setSelector(@NotNull SelectionLogic selectionLogic) {
        Intrinsics.checkNotNullParameter((Object)selectionLogic, (String)"<set-?>");
        this.selector = selectionLogic;
    }

    @NotNull
    protected final XcAssetFolder getAssetFolder() {
        return this.assetFolder;
    }

    @NotNull
    protected final XcAssetInfo getInfo() {
        return this.myInfo;
    }

    @NotNull
    protected final XcAssetsStyle getStyle() {
        return this.style;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.root;
    }

    public final boolean isValid() {
        return this.root.isValid() && this.myIsValid;
    }

    public final boolean isModified() {
        return false;
    }

    public void dispose() {
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.getLifetimeDefinition(), (boolean)false, (int)1, null);
    }

    @NotNull
    public final BorderLayoutPanel getComponent() {
        return this.mainPanel;
    }

    @NotNull
    public final BorderLayoutPanel getPreferredFocusedComponent() {
        return this.mainPanel;
    }

    public final void selectNotify() {
        Document document = FileDocumentManager.getInstance().getCachedDocument(this.root);
        if (document != null) {
            FileDocumentManager.getInstance().saveDocument(document);
        }
    }

    @NotNull
    protected abstract XcAssetPresenter createPresenter(@NotNull Lifetime var1, TAssetModel var2);

    @Nullable
    protected abstract XcAssetInfo getInfoFrom(TAssetModel var1);

    protected abstract TAssetModel parseModel(@NotNull String var1);

    protected abstract TAssetModel createEmptyModel();

    @Nullable
    protected abstract JComponent createPropertyPanel(@NotNull XcAssetPresenter var1);

    @Nullable
    protected abstract JComponent createBottomPanel(@NotNull XcAssetPresenter var1);

    protected void synchronizeWorkspaceModel(@NotNull XcAssetPresenter presenter) {
        Intrinsics.checkNotNullParameter((Object)presenter, (String)"presenter");
    }

    protected final void saveModel(TAssetModel model) {
        Intrinsics.checkNotNull(model, (String)"null cannot be cast to non-null type kotlin.Any");
        this.assetFolder.writeContentsJson(ModelUtilsKt.serializeToTextJson(model));
    }

    private final XcAssetPresenter x() {
        TAssetModel TAssetModel;
        String string = this.assetFolder.readContentsJson();
        if (string == null) {
            this.logger.warn("Cannot open editor " + ((Object)((Object)this)).getClass().getName() + " because Contents.json is missing}");
            this.x();
            return null;
        }
        if (((CharSequence)string).length() == 0) {
            this.logger.warn("Cannot open editor " + ((Object)((Object)this)).getClass().getName() + " because Contents.json is empty}");
            this.G();
            return null;
        }
        try {
            TAssetModel = this.parseModel(string);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            String string2 = ((Object)((Object)this)).getClass().getName();
            String string3 = jsonSyntaxException.getMessage();
            if (string3 == null) {
                string3 = jsonSyntaxException.toString();
            }
            this.logger.warn("Cannot open editor " + string2 + ": " + string3);
            this.G();
            return null;
        }
        TAssetModel TAssetModel2 = TAssetModel;
        return this.x(TAssetModel2);
    }

    private final XcAssetPresenter x(TAssetModel TAssetModel) {
        this.myIsValid = false;
        XcAssetInfo xcAssetInfo = this.getInfoFrom(TAssetModel);
        if (xcAssetInfo == null) {
            xcAssetInfo = XcAssetEditorUtilsKt.getDefaultInfo();
        }
        this.myInfo = xcAssetInfo;
        this.selector.unregistrateAll();
        XcAssetPresenter xcAssetPresenter = this.createPresenter((Lifetime)this.presenterSequentialLifetime.next(), TAssetModel);
        JComponent jComponent = this.createPropertyPanel(xcAssetPresenter);
        JComponent jComponent2 = this.createBottomPanel(xcAssetPresenter);
        this.mainPanel.removeAll();
        JBScrollPane jBScrollPane = new JBScrollPane((Component)xcAssetPresenter.draw(this.style));
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jBScrollPane.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
        if (jComponent != null) {
            this.mainPanel.addToTop((Component)jComponent);
        }
        if (jComponent2 != null) {
            this.mainPanel.addToBottom((Component)jComponent2);
        }
        this.mainPanel.addToCenter((Component)jBScrollPane);
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
        this.myIsValid = true;
        return xcAssetPresenter;
    }

    private final void x() {
        this.myIsValid = false;
        XcAssetsStatistic.corruptedAsset.log(((Object)((Object)this)).getClass(), (Object)ContentsJsonFailure.JsonIsMissing);
        this.mainPanel.removeAll();
        Object[] objectArray = new Object[]{"Contents.json"};
        this.mainPanel.addToCenter((Component)FailedEditorPaneKt.failedEditorPane((String)RiderMultiPlatformBundle.Companion.message("rider.xcassets.editor.failed.contentsMissing.message", objectArray), (boolean)true, (MultilineWrapMode)MultilineWrapMode.DoNotWrap, arg_0 -> XcAssetEditorBase.x(this, arg_0)));
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
    }

    private final void G() {
        this.myIsValid = false;
        XcAssetsStatistic.corruptedAsset.log(((Object)((Object)this)).getClass(), (Object)ContentsJsonFailure.JsonIsCorrupted);
        this.mainPanel.removeAll();
        Object[] objectArray = new Object[]{"Contents.json"};
        this.mainPanel.addToCenter((Component)FailedEditorPaneKt.failedEditorPane((String)RiderMultiPlatformBundle.Companion.message("rider.xcassets.editor.failed.contentsCorrupted.message", objectArray), (boolean)true, (MultilineWrapMode)MultilineWrapMode.DoNotWrap, arg_0 -> XcAssetEditorBase.G(this, arg_0)));
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
    }

    private static final Unit x(XcAssetEditorBase xcAssetEditorBase, TypeOfFsChanges typeOfFsChanges) {
        Intrinsics.checkNotNullParameter((Object)((Object)typeOfFsChanges), (String)"source");
        XcAssetPresenter xcAssetPresenter = xcAssetEditorBase.x();
        if (xcAssetPresenter != null && typeOfFsChanges == TypeOfFsChanges.HasToBeProcessed) {
            xcAssetEditorBase.synchronizeWorkspaceModel(xcAssetPresenter);
        }
        return Unit.INSTANCE;
    }

    private static final Unit x(XcAssetEditorBase xcAssetEditorBase, FailedEditorBuilder failedEditorBuilder) {
        Intrinsics.checkNotNullParameter((Object)failedEditorBuilder, (String)"$this$failedEditorPane");
        String string = RevealFileAction.getActionName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getActionName(...)");
        failedEditorBuilder.link(string, () -> XcAssetEditorBase.G(failedEditorBuilder, xcAssetEditorBase));
        Object[] objectArray = new Object[]{"Contents.json"};
        failedEditorBuilder.link(RiderMultiPlatformBundle.Companion.message("rider.xcassets.editor.failed.contentsMissing.generate.link", objectArray), () -> XcAssetEditorBase.x(failedEditorBuilder, xcAssetEditorBase));
        return Unit.INSTANCE;
    }

    private static final Unit G(FailedEditorBuilder failedEditorBuilder, XcAssetEditorBase xcAssetEditorBase) {
        XcAssetsStatistic.revealCorruptedAsset.log(failedEditorBuilder.getClass(), (Object)ContentsJsonFailure.JsonIsMissing);
        RevealFileAction.openDirectory((File)VfsUtil.virtualToIoFile((VirtualFile)xcAssetEditorBase.root));
        return Unit.INSTANCE;
    }

    private static final Unit x(FailedEditorBuilder failedEditorBuilder, XcAssetEditorBase xcAssetEditorBase) {
        XcAssetsStatistic.recreateCorruptedContentsJson.log(failedEditorBuilder.getClass(), (Object)ContentsJsonFailure.JsonIsMissing, (Object)UserConfirmationResults.ConfirmedNotAsked);
        xcAssetEditorBase.saveModel(xcAssetEditorBase.createEmptyModel());
        xcAssetEditorBase.x();
        return Unit.INSTANCE;
    }

    private static final Unit G(XcAssetEditorBase xcAssetEditorBase, FailedEditorBuilder failedEditorBuilder) {
        Intrinsics.checkNotNullParameter((Object)failedEditorBuilder, (String)"$this$failedEditorPane");
        String string = RevealFileAction.getActionName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getActionName(...)");
        failedEditorBuilder.link(string, () -> XcAssetEditorBase.k(xcAssetEditorBase));
        Object[] objectArray = new Object[]{"Contents.json"};
        failedEditorBuilder.link(RiderMultiPlatformBundle.Companion.message(RiderMultiPlatformBundle.Companion.message("rider.xcassets.editor.failed.contentsCorrupted.edit.link", objectArray), new Object[0]), () -> XcAssetEditorBase.x(xcAssetEditorBase));
        objectArray = new Object[]{"Contents.json"};
        failedEditorBuilder.link(RiderMultiPlatformBundle.Companion.message("rider.xcassets.editor.failed.contentsCorrupted.generate.link", objectArray), () -> XcAssetEditorBase.G(xcAssetEditorBase));
        return Unit.INSTANCE;
    }

    private static final Unit k(XcAssetEditorBase xcAssetEditorBase) {
        XcAssetsStatistic.revealCorruptedAsset.log(((Object)((Object)xcAssetEditorBase)).getClass(), (Object)ContentsJsonFailure.JsonIsCorrupted);
        RevealFileAction.openDirectory((File)VfsUtil.virtualToIoFile((VirtualFile)xcAssetEditorBase.root));
        return Unit.INSTANCE;
    }

    private static final Unit x(XcAssetEditorBase xcAssetEditorBase) {
        VirtualFile virtualFile = xcAssetEditorBase.assetFolder.getAssetJsonFile();
        if (virtualFile != null) {
            XcAssetsStatistic.navigateToCorruptedContentsEditor.log(((Object)((Object)xcAssetEditorBase)).getClass());
            v0 = FileEditorManager.getInstance((Project)xcAssetEditorBase.getProject()).openFile(virtualFile, true);
        } else {
            Object[] objectArray = new Object[]{"Contents.json"};
            Messages.showErrorDialog((Project)xcAssetEditorBase.getProject(), (String)RiderMultiPlatformBundle.Companion.message("rider.xcassets.editor.failed.contentsCorrupted.edit.fileNotFound.dialog.message", new Object[0]), (String)RiderMultiPlatformBundle.Companion.message("rider.xcassets.editor.failed.contentsCorrupted.edit.fileNotFound.dialog.title", objectArray));
            v0 = xcAssetEditorBase.x();
        }
        return Unit.INSTANCE;
    }

    private static final Unit G(XcAssetEditorBase xcAssetEditorBase) {
        Object[] objectArray = new Object[]{"Contents.json"};
        if (Messages.showOkCancelDialog((String)RiderMultiPlatformBundle.Companion.message("rider.xcassets.editor.failed.contentsCorrupted.generate.dialog.message", objectArray), (String)RiderMultiPlatformBundle.Companion.message("rider.xcassets.confirm.title", new Object[0]), (String)RiderActionsBundle.Companion.message("button.ok", new Object[0]), (String)RiderActionsBundle.Companion.message("action.cancel.text", new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
            XcAssetsStatistic.recreateCorruptedContentsJson.log(((Object)((Object)xcAssetEditorBase)).getClass(), (Object)ContentsJsonFailure.JsonIsCorrupted, (Object)UserConfirmationResults.Confirmed);
            xcAssetEditorBase.saveModel(xcAssetEditorBase.createEmptyModel());
            xcAssetEditorBase.x();
        } else {
            XcAssetsStatistic.recreateCorruptedContentsJson.log(((Object)((Object)xcAssetEditorBase)).getClass(), (Object)ContentsJsonFailure.JsonIsCorrupted, (Object)UserConfirmationResults.Canceled);
        }
        return Unit.INSTANCE;
    }
}

