/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.multiPlatform.xcAssets.assetFolder;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.multiPlatform.RiderMultiPlatformBundle;
import com.jetbrains.rider.multiPlatform.xcAssets.assetFolder.AssetFolderUtilsKt;
import com.jetbrains.rider.multiPlatform.xcAssets.assetFolder.RootChangesObserverForEditor;
import com.jetbrains.rider.multiPlatform.xcAssets.assetFolder.TypeOfFsChanges;
import com.jetbrains.rider.multiPlatform.xcAssets.assetFolder.XcAssetContentsFile;
import com.jetbrains.rider.multiPlatform.xcAssets.models.ModelUtilsKt;
import com.jetbrains.rider.projectView.actions.addExisting.AddExistingFileSession;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityReference;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\u0018\u0000 22\u00020\u0001:\u00012B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0014\u0010\u001e\u001a\u00020\u000b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0 J\u000e\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u0013J\u000e\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u0013J\b\u0010%\u001a\u0004\u0018\u00010\u0013J\u000e\u0010&\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u0013J\u0010\u0010'\u001a\u0004\u0018\u00010\u00132\u0006\u0010(\u001a\u00020)J\u0012\u0010*\u001a\u0004\u0018\u00010)2\b\u0010\"\u001a\u0004\u0018\u00010\u0013J\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00130,J\u0010\u0010-\u001a\u00020)2\u0006\u0010.\u001a\u00020\u0013H\u0002J\u0010\u0010/\u001a\u00020)2\u0006\u0010.\u001a\u00020\u0013H\u0002J\u001a\u00100\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00101\u001a\u00020\u0005H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000fR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/jetbrains/rider/multiPlatform/xcAssets/assetFolder/XcAssetFolder;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "onFileChanges", "Lkotlin/Function1;", "Lcom/jetbrains/rider/multiPlatform/xcAssets/assetFolder/TypeOfFsChanges;", "", "XcAssetFolder", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function1;)V", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "contentsFile", "Lcom/jetbrains/rider/multiPlatform/xcAssets/assetFolder/XcAssetContentsFile;", "rootPath", "", "x", "()Ljava/lang/String;", "rootPointer", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntityReference;", "x", "()Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntityReference;", "assetJsonFile", "getAssetJsonFile", "fsObserver", "Lcom/jetbrains/rider/multiPlatform/xcAssets/assetFolder/RootChangesObserverForEditor;", "editScope", "editAction", "Lkotlin/Function0;", "removeFile", "fileName", "writeContentsJson", "content", "readContentsJson", "includeInWorkspaceModelIfNotIncluded", "copyToDirectory", "source", "Ljava/io/File;", "searchExistedFile", "getAllFileNames", "", "G", "relative", "x", "x", "virtualFile", "Companion", "intellij.rider"})
public final class XcAssetFolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VirtualFile root;
    @NotNull
    private final Project project;
    @NotNull
    private final XcAssetContentsFile contentsFile;
    @Nullable
    private final VirtualFile assetJsonFile;
    @NotNull
    private final RootChangesObserverForEditor fsObserver;

    public XcAssetFolder(@NotNull Lifetime lifetime, @NotNull VirtualFile root2, @NotNull Project project, @NotNull Function1<? super TypeOfFsChanges, Unit> onFileChanges) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(onFileChanges, (String)"onFileChanges");
        this.root = root2;
        this.project = project;
        this.contentsFile = new XcAssetContentsFile(this.root, this.project);
        this.assetJsonFile = this.contentsFile.getFile();
        this.fsObserver = RootChangesObserverForEditor.Companion.getInstance(this.project);
        this.fsObserver.startFsListenerIfNotStarted(this, this.root, lifetime, onFileChanges);
    }

    @NotNull
    public final VirtualFile getRoot() {
        return this.root;
    }

    private final String x() {
        String string = this.root.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    private final ProjectModelEntityReference x() {
        return this.x(this.project, this.root);
    }

    @Nullable
    public final VirtualFile getAssetJsonFile() {
        return this.assetJsonFile;
    }

    public final void editScope(@NotNull Function0<Unit> editAction) {
        Intrinsics.checkNotNullParameter(editAction, (String)"editAction");
        this.fsObserver.registrateEdit(this, editAction);
    }

    public final void removeFile(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this.fsObserver.registrateEdit(this, (Function0<Unit>)((Function0)() -> XcAssetFolder.x(this, fileName)));
    }

    public final void writeContentsJson(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.fsObserver.registrateEdit(this, (Function0<Unit>)((Function0)() -> XcAssetFolder.G(this, content)));
    }

    @Nullable
    public final String readContentsJson() {
        return this.contentsFile.readContent();
    }

    public final void includeInWorkspaceModelIfNotIncluded(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        File file2 = this.x(fileName);
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(this.project);
        Path path = file2.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        ProjectModelEntity projectModelEntity = (ProjectModelEntity)CollectionsKt.singleOrNull((List)WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)workspaceModel, (Path)path, (Project)this.project));
        if (projectModelEntity != null) {
            return;
        }
        this.fsObserver.registrateEdit(this, (Function0<Unit>)((Function0)() -> XcAssetFolder.x(this, file2)));
    }

    @Nullable
    public final String copyToDirectory(@NotNull File source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!source.exists()) {
            return null;
        }
        String string = source.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        File file2 = this.G(string);
        this.fsObserver.registrateEdit(this, (Function0<Unit>)((Function0)() -> XcAssetFolder.x(this, source, file2)));
        return file2.getName();
    }

    @Nullable
    public final File searchExistedFile(@Nullable String fileName) {
        Object object = fileName;
        if (object == null || object.length() == 0) {
            return null;
        }
        object = this.x(fileName);
        if (!((File)object).exists()) {
            return null;
        }
        return object;
    }

    @NotNull
    public final List<String> getAllFileNames() {
        Object object = new File(this.x()).list();
        if (object == null || (object = ArraysKt.asList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final File G(String string) {
        File file2 = this.x(string);
        while (file2.exists()) {
            String string2 = ModelUtilsKt.getNextFileName(FilesKt.getNameWithoutExtension((File)file2)) + "." + FilesKt.getExtension((File)file2);
            file2 = this.x(string2);
        }
        return file2;
    }

    private final File x(String string) {
        String[] stringArray = new String[]{string};
        File file2 = Path.of(this.x(), stringArray).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
        return file2;
    }

    private final ProjectModelEntityReference x(Project project, VirtualFile virtualFile) {
        ProjectModelEntity projectModelEntity = AssetFolderUtilsKt.getEntity(project, virtualFile);
        return projectModelEntity != null ? ProjectModelEntityExtensionsKt.toReference((ProjectModelEntity)projectModelEntity) : null;
    }

    private static final Unit x(XcAssetFolder xcAssetFolder, String string) {
        CommandProcessor.getInstance().executeCommand(xcAssetFolder.project, () -> XcAssetFolder.x(xcAssetFolder, string), RiderMultiPlatformBundle.Companion.message("rider.xcassets.command.removefile", new Object[0]), null);
        return Unit.INSTANCE;
    }

    private static final void x(XcAssetFolder xcAssetFolder, String string) {
        ProjectModelEntityReference projectModelEntityReference = xcAssetFolder.x();
        ProjectModelEntity projectModelEntity = projectModelEntityReference != null ? projectModelEntityReference.getEntity(xcAssetFolder.project) : null;
        ProjectModelEntity projectModelEntity2 = projectModelEntity;
        if (projectModelEntity2 == null || (projectModelEntity2 = ProjectModelEntityExtensionsKt.getVirtualFileAsContentRoot((ProjectModelEntity)projectModelEntity2)) == null) {
            return;
        }
        ProjectModelEntity projectModelEntity3 = projectModelEntity2;
        VirtualFile virtualFile = projectModelEntity3.findChild(string);
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        ApplicationKt.getApplication().runWriteAction(() -> XcAssetFolder.x(virtualFile2, xcAssetFolder));
    }

    private static final Unit x(VirtualFile virtualFile, XcAssetFolder xcAssetFolder) {
        virtualFile.delete((Object)xcAssetFolder);
        return Unit.INSTANCE;
    }

    private static final Unit G(XcAssetFolder xcAssetFolder, String string) {
        xcAssetFolder.contentsFile.writeContent(string);
        return Unit.INSTANCE;
    }

    private static final Unit x(XcAssetFolder xcAssetFolder, File file2) {
        CommandProcessor.getInstance().executeCommand(xcAssetFolder.project, () -> XcAssetFolder.x(xcAssetFolder, file2), RiderMultiPlatformBundle.Companion.message("rider.xcassets.command.addFile", new Object[0]), null);
        return Unit.INSTANCE;
    }

    private static final void x(XcAssetFolder xcAssetFolder, File file2) {
        ProjectModelEntityReference projectModelEntityReference = xcAssetFolder.x();
        if (projectModelEntityReference == null || (projectModelEntityReference = projectModelEntityReference.getEntity(xcAssetFolder.project)) == null) {
            return;
        }
        ProjectModelEntityReference projectModelEntityReference2 = projectModelEntityReference;
        AddExistingFileSession.Companion.run(xcAssetFolder.project, (Function1<? super AddExistingFileSession, Unit>)((Function1)arg_0 -> XcAssetFolder.x((ProjectModelEntity)projectModelEntityReference2, file2, arg_0)));
    }

    private static final Unit x(ProjectModelEntity projectModelEntity, File file2, AddExistingFileSession addExistingFileSession) {
        Intrinsics.checkNotNullParameter((Object)addExistingFileSession, (String)"it");
        Path path = file2.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        AddExistingFileSession.add$default(addExistingFileSession, projectModelEntity, path, null, 4, null);
        return Unit.INSTANCE;
    }

    private static final Unit x(XcAssetFolder xcAssetFolder, File file2, File file3) {
        CommandProcessor.getInstance().executeCommand(xcAssetFolder.project, () -> XcAssetFolder.x(xcAssetFolder, file2, file3), RiderMultiPlatformBundle.Companion.message("rider.xcassets.command.movefile", new Object[0]), null);
        return Unit.INSTANCE;
    }

    private static final void x(XcAssetFolder xcAssetFolder, File file2, File file3) {
        ProjectModelEntityReference projectModelEntityReference = xcAssetFolder.x();
        ProjectModelEntity projectModelEntity = projectModelEntityReference != null ? projectModelEntityReference.getEntity(xcAssetFolder.project) : null;
        ProjectModelEntity projectModelEntity2 = projectModelEntity;
        if (projectModelEntity2 == null || (projectModelEntity2 = ProjectModelEntityExtensionsKt.getVirtualFileAsContentRoot((ProjectModelEntity)projectModelEntity2)) == null) {
            return;
        }
        ProjectModelEntity projectModelEntity3 = projectModelEntity2;
        VirtualFile virtualFile = (VirtualFile)ApplicationKt.getApplication().runWriteAction(() -> XcAssetFolder.x(file2, xcAssetFolder, (VirtualFile)projectModelEntity3, file3));
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        AddExistingFileSession.Companion.run(xcAssetFolder.project, (Function1<? super AddExistingFileSession, Unit>)((Function1)arg_0 -> XcAssetFolder.x(projectModelEntity, virtualFile2, arg_0)));
    }

    private static final VirtualFile x(File file2, XcAssetFolder xcAssetFolder, VirtualFile virtualFile, File file3) {
        VirtualFile virtualFile2 = DocumentUtilKt.toVirtualFile$default((File)file2, (boolean)false, (int)1, null);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile virtualFile3 = virtualFile2;
        return VfsUtil.copyFile((Object)xcAssetFolder, (VirtualFile)virtualFile3, (VirtualFile)virtualFile, (String)file3.getName());
    }

    private static final Unit x(ProjectModelEntity projectModelEntity, VirtualFile virtualFile, AddExistingFileSession addExistingFileSession) {
        Intrinsics.checkNotNullParameter((Object)addExistingFileSession, (String)"it");
        AddExistingFileSession.add$default(addExistingFileSession, projectModelEntity, virtualFile, null, 4, null);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0001\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/multiPlatform/xcAssets/assetFolder/XcAssetFolder$Companion;", "", "XcAssetFolder$Companion", "()V", "createAssetFolderOnDisk", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "parentEntity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "commandText", "", "folderPath", "Ljava/io/File;", "assetContents", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final VirtualFile createAssetFolderOnDisk(@NotNull Project project, @NotNull ProjectModelEntity parentEntity, @NlsContexts.Command @NotNull String commandText, @NotNull File folderPath, @NotNull Object assetContents) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)parentEntity, (String)"parentEntity");
            Intrinsics.checkNotNullParameter((Object)commandText, (String)"commandText");
            Intrinsics.checkNotNullParameter((Object)folderPath, (String)"folderPath");
            Intrinsics.checkNotNullParameter((Object)assetContents, (String)"assetContents");
            VirtualFileUrl virtualFileUrl = parentEntity.getUrl();
            if (virtualFileUrl == null || (virtualFileUrl = VirtualFileUrls.getVirtualFile((VirtualFileUrl)virtualFileUrl)) == null) {
                return null;
            }
            VirtualFileUrl virtualFileUrl2 = virtualFileUrl;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            CommandProcessor.getInstance().executeCommand(project, () -> Companion.x(objectRef, project, (VirtualFile)virtualFileUrl2, folderPath, assetContents, parentEntity), commandText, null);
            return (VirtualFile)objectRef.element;
        }

        private static final void x(Ref.ObjectRef objectRef, Project project, VirtualFile virtualFile, File file2, Object object, ProjectModelEntity projectModelEntity) {
            Pair pair = (Pair)ApplicationKt.getApplication().runWriteAction(() -> Companion.x(virtualFile, file2, object));
            VirtualFile virtualFile2 = (VirtualFile)pair.component1();
            VirtualFile virtualFile3 = (VirtualFile)pair.component2();
            objectRef.element = virtualFile2;
            AddExistingFileSession.Companion.run(project, (Function1<? super AddExistingFileSession, Unit>)((Function1)arg_0 -> Companion.x(projectModelEntity, virtualFile3, arg_0)));
        }

        private static final Pair x(VirtualFile virtualFile, File file2, Object object) {
            VirtualFile virtualFile2 = virtualFile.createChildDirectory((Object)Companion, file2.getName());
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"createChildDirectory(...)");
            VirtualFile virtualFile3 = virtualFile2;
            VirtualFile virtualFile4 = virtualFile3.createChildData((Object)Companion, "Contents.json");
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"createChildData(...)");
            VirtualFile virtualFile5 = virtualFile4;
            VfsUtil.saveText((VirtualFile)virtualFile5, (String)ModelUtilsKt.serializeToTextJson(object));
            return new Pair((Object)virtualFile3, (Object)virtualFile5);
        }

        private static final Unit x(ProjectModelEntity projectModelEntity, VirtualFile virtualFile, AddExistingFileSession addExistingFileSession) {
            Intrinsics.checkNotNullParameter((Object)addExistingFileSession, (String)"it");
            AddExistingFileSession.add$default(addExistingFileSession, projectModelEntity, virtualFile, null, 4, null);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

