/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.microservices.urlResolver;

import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlQueryParameter;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.RdUrlQueryParameter;
import com.jetbrains.rd.ide.model.RdUrlTargetInfo;
import com.jetbrains.rd.ui.icons.UtilKt;
import com.jetbrains.rider.microservices.navigation.RiderFakeNavigatablePsiElement;
import com.jetbrains.rider.microservices.urlResolver.RiderUrlQueryParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lcom/jetbrains/rider/microservices/urlResolver/RiderUrlTargetInfo;", "Lcom/intellij/microservices/url/UrlTargetInfo;", "project", "Lcom/intellij/openapi/project/Project;", "schemes", "", "", "authorities", "Lcom/intellij/microservices/url/Authority;", "urlTargetInfo", "Lcom/jetbrains/rd/ide/model/RdUrlTargetInfo;", "path", "Lcom/intellij/microservices/url/UrlPath;", "RiderUrlTargetInfo", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/util/List;Lcom/jetbrains/rd/ide/model/RdUrlTargetInfo;Lcom/intellij/microservices/url/UrlPath;)V", "getSchemes", "()Ljava/util/List;", "getAuthorities", "getPath", "()Lcom/intellij/microservices/url/UrlPath;", "queryParameters", "", "Lcom/intellij/microservices/url/UrlQueryParameter;", "getQueryParameters", "()Ljava/lang/Iterable;", "resolveToPsiElement", "Lcom/intellij/psi/PsiElement;", "methods", "", "getMethods", "()Ljava/util/Set;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "source", "getSource", "()Ljava/lang/String;", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderUrlTargetInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderUrlTargetInfo.kt\ncom/jetbrains/rider/microservices/urlResolver/RiderUrlTargetInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n1563#2:55\n1634#2,3:56\n*S KotlinDebug\n*F\n+ 1 RiderUrlTargetInfo.kt\ncom/jetbrains/rider/microservices/urlResolver/RiderUrlTargetInfo\n*L\n22#1:55\n22#1:56,3\n*E\n"})
public final class RiderUrlTargetInfo
implements UrlTargetInfo {
    @NotNull
    private final Project project;
    @NotNull
    private final List<String> schemes;
    @NotNull
    private final List<Authority> authorities;
    @NotNull
    private final RdUrlTargetInfo urlTargetInfo;
    @NotNull
    private final UrlPath path;
    @NotNull
    private final Icon icon;

    public RiderUrlTargetInfo(@NotNull Project project, @NotNull List<String> schemes, @NotNull List<? extends Authority> authorities, @NotNull RdUrlTargetInfo urlTargetInfo, @NotNull UrlPath path) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(schemes, (String)"schemes");
        Intrinsics.checkNotNullParameter(authorities, (String)"authorities");
        Intrinsics.checkNotNullParameter((Object)urlTargetInfo, (String)"urlTargetInfo");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.project = project;
        this.schemes = schemes;
        this.authorities = authorities;
        this.urlTargetInfo = urlTargetInfo;
        this.path = path;
        Object object = this.urlTargetInfo.getIcon();
        if (object == null || (object = UtilKt.fromModel((IconModel)object)) == null) {
            object = super.getIcon();
        }
        this.icon = object;
    }

    @NotNull
    public List<String> getSchemes() {
        return this.schemes;
    }

    @NotNull
    public List<Authority> getAuthorities() {
        return this.authorities;
    }

    @NotNull
    public UrlPath getPath() {
        return this.path;
    }

    @NotNull
    public Iterable<UrlQueryParameter> getQueryParameters() {
        Iterable iterable = this.urlTargetInfo.getQueryParameters();
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            RdUrlQueryParameter rdUrlQueryParameter = (RdUrlQueryParameter)t;
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(new RiderUrlQueryParameter(this.project, rdUrlQueryParameter));
        }
        return (List)collection;
    }

    @NotNull
    public PsiElement resolveToPsiElement() {
        return (PsiElement)new RiderFakeNavigatablePsiElement(this.project, this.urlTargetInfo.getPosition(), this.urlTargetInfo.getIcon());
    }

    @NotNull
    public Set<String> getMethods() {
        return CollectionsKt.toSet((Iterable)this.urlTargetInfo.getMethods());
    }

    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @NotNull
    public String getSource() {
        return this.urlTargetInfo.getSource();
    }
}

