/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.microservices.endpointsProviders;

import com.intellij.microservices.endpoints.EndpointsViewListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rider.microservices.endpointsProviders.WebFrameworkChecker;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityVisitor;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelEvents;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/microservices/endpointsProviders/WebFrameworkChecker;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "assembliesToCheck", "", "", "WebFrameworkChecker", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "referencesCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "getReferencesCounter", "()Ljava/util/concurrent/atomic/AtomicInteger;", "setReferencesCounter", "(Ljava/util/concurrent/atomic/AtomicInteger;)V", "hasFramework", "", "x", "", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nWebFrameworkChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebFrameworkChecker.kt\ncom/jetbrains/rider/microservices/endpointsProviders/WebFrameworkChecker\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,69:1\n23#2:70\n*S KotlinDebug\n*F\n+ 1 WebFrameworkChecker.kt\ncom/jetbrains/rider/microservices/endpointsProviders/WebFrameworkChecker\n*L\n21#1:70\n*E\n"})
public abstract class WebFrameworkChecker
extends LifetimedService {
    @NotNull
    private final Project project;
    @NotNull
    private final Set<String> assembliesToCheck;
    @NotNull
    private final Logger logger;
    @NotNull
    private AtomicInteger referencesCounter;

    public WebFrameworkChecker(@NotNull Project project, @NotNull Set<String> assembliesToCheck) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(assembliesToCheck, (String)"assembliesToCheck");
        this.project = project;
        this.assembliesToCheck = assembliesToCheck;
        WebFrameworkChecker webFrameworkChecker = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WebFrameworkChecker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.referencesCounter = new AtomicInteger(0);
        webFrameworkChecker = WorkspaceModelEvents.Companion.getInstance(this.project);
        BoolPropertyExKt.whenTrue((IViewable)((IViewable)webFrameworkChecker.getSynced()), (Lifetime)this.getServiceLifetime(), arg_0 -> WebFrameworkChecker.x(this, (WorkspaceModelEvents)webFrameworkChecker, arg_0));
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final AtomicInteger getReferencesCounter() {
        return this.referencesCounter;
    }

    public final void setReferencesCounter(@NotNull AtomicInteger atomicInteger) {
        Intrinsics.checkNotNullParameter((Object)atomicInteger, (String)"<set-?>");
        this.referencesCounter = atomicInteger;
    }

    public final boolean hasFramework() {
        return this.referencesCounter.get() > 0;
    }

    private final void x() {
        ((EndpointsViewListener)this.project.getMessageBus().syncPublisher(EndpointsViewListener.Companion.getTOPIC())).endpointsChanged(new EndpointsViewListener.ChangeEvent(this.project, EndpointsViewListener.ChangeType.PROVIDERS));
    }

    private static final Unit x(WebFrameworkChecker webFrameworkChecker, WorkspaceModelEvents workspaceModelEvents, Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lt");
        ProjectModelEntityVisitor projectModelEntityVisitor = new ProjectModelEntityVisitor(webFrameworkChecker){
            final /* synthetic */ WebFrameworkChecker this$0;
            {
                this.this$0 = $receiver;
            }

            protected ProjectModelEntityVisitor.Result visitReference(ProjectModelEntity entity) {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                if (WebFrameworkChecker.access$getAssembliesToCheck$p(this.this$0).contains(entity.getName())) {
                    this.this$0.getReferencesCounter().incrementAndGet();
                }
                return ProjectModelEntityVisitor.Result.Stop;
            }

            protected ProjectModelEntityVisitor.Result visitUnknownNode(ProjectModelEntity entity) {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                return ProjectModelEntityVisitor.Result.Continue;
            }
        };
        ApplicationKt.getApplication().executeOnPooledThread(() -> WebFrameworkChecker.x(projectModelEntityVisitor, webFrameworkChecker, workspaceModelEvents));
        return Unit.INSTANCE;
    }

    private static final void x(1.visitor.1 var0, WebFrameworkChecker webFrameworkChecker, WorkspaceModelEvents workspaceModelEvents) {
        var0.visit(webFrameworkChecker.project);
        webFrameworkChecker.x();
        webFrameworkChecker.logger.trace("Initialized for " + CollectionsKt.joinToString$default((Iterable)webFrameworkChecker.assembliesToCheck, null, null, null, (int)0, null, null, (int)63, null) + ", referencesCounter = " + webFrameworkChecker.referencesCounter.get());
        workspaceModelEvents.getAddSignal().advise(webFrameworkChecker.getServiceLifetime(), arg_0 -> WebFrameworkChecker.x(webFrameworkChecker, arg_0));
        workspaceModelEvents.getRemoveSignal().advise(webFrameworkChecker.getServiceLifetime(), arg_0 -> WebFrameworkChecker.x(webFrameworkChecker, arg_0));
    }

    private static final Unit x(WebFrameworkChecker webFrameworkChecker, WorkspaceModelEvents.AddEntityEvent addEntityEvent) {
        Intrinsics.checkNotNullParameter((Object)addEntityEvent, (String)"add");
        if (webFrameworkChecker.assembliesToCheck.contains(addEntityEvent.getEntity().getName())) {
            webFrameworkChecker.referencesCounter.incrementAndGet();
            webFrameworkChecker.logger.trace("Added entity " + addEntityEvent.getEntity().getName() + ", referencesCounter = " + webFrameworkChecker.referencesCounter.get());
            webFrameworkChecker.x();
        }
        return Unit.INSTANCE;
    }

    private static final Unit x(WebFrameworkChecker webFrameworkChecker, WorkspaceModelEvents.RemoveEntityEvent removeEntityEvent) {
        Intrinsics.checkNotNullParameter((Object)removeEntityEvent, (String)"remove");
        if (webFrameworkChecker.assembliesToCheck.contains(removeEntityEvent.getEntity().getName())) {
            webFrameworkChecker.referencesCounter.decrementAndGet();
            webFrameworkChecker.logger.trace("Removed entity " + removeEntityEvent.getEntity().getName() + ", referencesCounter = " + webFrameworkChecker.referencesCounter.get());
            webFrameworkChecker.x();
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Set access$getAssembliesToCheck$p(WebFrameworkChecker $this) {
        return $this.assembliesToCheck;
    }
}

