/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.interactive.repl.history;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.interactive.repl.history.CommandHistory;
import com.jetbrains.rider.interactive.repl.history.HistoryUpdateListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u001cB)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/interactive/repl/history/HistoryKeyListener;", "Ljava/awt/event/KeyAdapter;", "Lcom/jetbrains/rider/interactive/repl/history/HistoryUpdateListener;", "project", "Lcom/intellij/openapi/project/Project;", "consoleEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "history", "Lcom/jetbrains/rider/interactive/repl/history/CommandHistory;", "moveCaretToEndOnUp", "", "HistoryKeyListener", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/jetbrains/rider/interactive/repl/history/CommandHistory;Z)V", "historyPos", "", "prevCaretOffset", "unfinishedCommand", "", "onNewEntry", "", "entry", "Lcom/jetbrains/rider/interactive/repl/history/CommandHistory$Entry;", "keyReleased", "e", "Ljava/awt/event/KeyEvent;", "x", "move", "Lcom/jetbrains/rider/interactive/repl/history/HistoryKeyListener$HistoryMove;", "HistoryMove", "intellij.rider"})
public final class HistoryKeyListener
extends KeyAdapter
implements HistoryUpdateListener {
    @NotNull
    private final Project project;
    @NotNull
    private final EditorEx consoleEditor;
    @NotNull
    private final CommandHistory history;
    private final boolean moveCaretToEndOnUp;
    private int historyPos;
    private int prevCaretOffset;
    @NotNull
    private String unfinishedCommand;

    public HistoryKeyListener(@NotNull Project project, @NotNull EditorEx consoleEditor, @NotNull CommandHistory history, boolean moveCaretToEndOnUp) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)consoleEditor, (String)"consoleEditor");
        Intrinsics.checkNotNullParameter((Object)history, (String)"history");
        this.project = project;
        this.consoleEditor = consoleEditor;
        this.history = history;
        this.moveCaretToEndOnUp = moveCaretToEndOnUp;
        this.prevCaretOffset = -1;
        this.unfinishedCommand = "";
    }

    public /* synthetic */ HistoryKeyListener(Project project, EditorEx editorEx, CommandHistory commandHistory, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(project, editorEx, commandHistory, bl);
    }

    @Override
    public void onNewEntry(@NotNull CommandHistory.Entry entry2) {
        Intrinsics.checkNotNullParameter((Object)entry2, (String)"entry");
        this.historyPos = this.history.getSize();
        this.prevCaretOffset = -1;
        this.unfinishedCommand = "";
    }

    @Override
    public void keyReleased(@NotNull KeyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.getModifiersEx() != 0) {
            return;
        }
        switch (e.getKeyCode()) {
            case 38: {
                this.x(HistoryMove.UP);
                break;
            }
            case 40: {
                this.x(HistoryMove.DOWN);
                break;
            }
            case 37: 
            case 39: {
                this.prevCaretOffset = this.consoleEditor.getCaretModel().getOffset();
            }
        }
    }

    private final void x(HistoryMove historyMove) {
        if (this.history.getSize() == 0) {
            return;
        }
        if (LookupManager.getInstance((Project)this.project).getActiveLookup() != null) {
            return;
        }
        CaretModel caretModel = this.consoleEditor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        CaretModel caretModel2 = caretModel;
        DocumentEx documentEx = this.consoleEditor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx documentEx2 = documentEx;
        int n = caretModel2.getOffset();
        int n2 = documentEx2.getLineNumber(n);
        int n3 = documentEx2.getLineCount();
        boolean bl = n3 > 1;
        switch (WhenMappings.$EnumSwitchMapping$0[historyMove.ordinal()]) {
            case 1: {
                if (n2 != 0 || bl && this.prevCaretOffset != 0) {
                    this.prevCaretOffset = n;
                    return;
                }
                if (this.historyPos == this.history.getSize()) {
                    String string = documentEx2.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    this.unfinishedCommand = string;
                }
                boolean bl2 = this.historyPos == 0;
                this.historyPos = Math.max(this.historyPos - 1, 0);
                WriteCommandAction.runWriteCommandAction((Project)this.project, () -> HistoryKeyListener.x(this, documentEx2, bl2, caretModel2));
                break;
            }
            case 2: {
                if (this.historyPos == this.history.getSize()) {
                    return;
                }
                if (n2 != n3 - 1 || bl && this.prevCaretOffset != documentEx2.getTextLength()) {
                    this.prevCaretOffset = n;
                    return;
                }
                this.historyPos = Math.min(this.historyPos + 1, this.history.getSize());
                WriteCommandAction.runWriteCommandAction((Project)this.project, () -> HistoryKeyListener.x(documentEx2, this));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private static final void x(HistoryKeyListener historyKeyListener, DocumentEx documentEx, boolean bl, CaretModel caretModel) {
        String string = historyKeyListener.history.get(historyKeyListener.historyPos).getVisibleText();
        documentEx.setText((CharSequence)string);
        EditorUtil.scrollToTheEnd((Editor)((Editor)historyKeyListener.consoleEditor));
        if (historyKeyListener.moveCaretToEndOnUp && !bl) {
            historyKeyListener.prevCaretOffset = string.length();
            caretModel.moveToOffset(string.length());
            return;
        }
        historyKeyListener.prevCaretOffset = 0;
        caretModel.moveToOffset(0);
    }

    private static final void x(DocumentEx documentEx, HistoryKeyListener historyKeyListener) {
        documentEx.setText((CharSequence)(historyKeyListener.historyPos == historyKeyListener.history.getSize() ? historyKeyListener.unfinishedCommand : historyKeyListener.history.get(historyKeyListener.historyPos).getVisibleText()));
        historyKeyListener.prevCaretOffset = documentEx.getTextLength();
        EditorUtil.scrollToTheEnd((Editor)((Editor)historyKeyListener.consoleEditor));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/interactive/repl/history/HistoryKeyListener$HistoryMove;", "", "HistoryKeyListener$HistoryMove", "(Ljava/lang/String;I)V", "UP", "DOWN", "intellij.rider"})
    private static final class HistoryMove
    extends Enum<HistoryMove> {
        public static final /* enum */ HistoryMove UP = new HistoryMove();
        public static final /* enum */ HistoryMove DOWN = new HistoryMove();
        private static final /* synthetic */ HistoryMove[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static HistoryMove[] values() {
            return (HistoryMove[])$VALUES.clone();
        }

        public static HistoryMove valueOf(String value2) {
            return Enum.valueOf(HistoryMove.class, value2);
        }

        @NotNull
        public static EnumEntries<HistoryMove> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = historyMoveArray = new HistoryMove[]{HistoryMove.UP, HistoryMove.DOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HistoryMove.values().length];
            try {
                nArray[HistoryMove.UP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HistoryMove.DOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

