/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ideaInterop.find;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.SearchScope;
import com.jetbrains.rider.ideaInterop.RiderIdeaInteropBundle;
import com.jetbrains.rider.ideaInterop.find.scopes.RiderProjectModelEntitiesScope;
import com.jetbrains.rider.ideaInterop.find.scopes.RiderScopeUtilsKt;
import com.jetbrains.rider.ideaInterop.find.scopes.RiderSingleProjectModelEntityScope;
import com.jetbrains.rider.ideaInterop.find.scopes.RiderSolutionScope;
import com.jetbrains.rider.projectView.views.SolutionViewPaneBase;
import com.jetbrains.rider.projectView.views.SolutionViewUtilsKt;
import com.jetbrains.rider.projectView.views.solutionExplorer.SolutionExplorerViewPane;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"getScopeForSelectedObjectsInExplorer", "Lcom/intellij/psi/search/SearchScope;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.rider"})
public final class RiderPredefinedSearchScopeProviderKt {
    @Nullable
    public static final SearchScope getScopeForSelectedObjectsInExplorer(@NotNull Project project, @NotNull DataContext dataContext) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        SolutionViewPaneBase solutionViewPaneBase = SolutionViewUtilsKt.getSolutionView(dataContext);
        if (solutionViewPaneBase == null) {
            return null;
        }
        SolutionViewPaneBase solutionViewPaneBase2 = solutionViewPaneBase;
        SolutionExplorerViewPane solutionExplorerViewPane = solutionViewPaneBase2 instanceof SolutionExplorerViewPane ? (SolutionExplorerViewPane)solutionViewPaneBase2 : null;
        Object object = solutionExplorerViewPane;
        boolean bl = object != null && (object = object.getViewSettings()) != null ? object.isShowAllFiles() : true;
        List list2 = ProjectModelEntityExtensionsKt.getProjectModelEntities((DataContext)dataContext, (boolean)false);
        if (list2.isEmpty()) {
            return null;
        }
        ProjectModelEntity projectModelEntity = (ProjectModelEntity)CollectionsKt.singleOrNull((List)list2);
        if (projectModelEntity != null) {
            if (ProjectModelEntityExtensionsKt.isSolution((ProjectModelEntity)projectModelEntity)) {
                return (SearchScope)new RiderSolutionScope(project, bl);
            }
            if (ProjectModelEntityExtensionsKt.isProject((ProjectModelEntity)projectModelEntity) || ProjectModelEntityExtensionsKt.isDirectory((ProjectModelEntity)projectModelEntity)) {
                return (SearchScope)new RiderSingleProjectModelEntityScope(project, projectModelEntity, bl);
            }
        }
        ProjectModelEntity projectModelEntity2 = (ProjectModelEntity)list2.get(0);
        String string2 = RiderScopeUtilsKt.getCaption(projectModelEntity2);
        if (list2.size() == 1) {
            string = string2;
        } else {
            Object[] objectArray = new Object[]{string2, list2.size() - 1};
            string = RiderIdeaInteropBundle.Companion.message("display.name.selected.files.and.folders.named", objectArray);
        }
        String string3 = string;
        return (SearchScope)new RiderProjectModelEntitiesScope(project, list2, string3, bl);
    }
}

