/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.environmentSetup.analyzers;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.rider.environmentSetup.ComponentsLocalReader;
import com.jetbrains.rider.environmentSetup.ComponentsUpdatesReader;
import com.jetbrains.rider.environmentSetup.RiderEnvironmentSetupBundle;
import com.jetbrains.rider.environmentSetup.SingleEnvironmentComponent;
import com.jetbrains.rider.environmentSetup.impl.EnvironmentSetupUtils;
import com.jetbrains.rider.nuget.helpers.RiderNuGetOperation;
import icons.RiderIcons;
import java.util.Iterator;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\u0019\u001a\u0004\u0018\u00010\tH\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0016\u0010\u0012\u001a\u00020\u000b8\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0019\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006 "}, d2={"Lcom/jetbrains/rider/environmentSetup/analyzers/MonoEnvironmentComponent;", "Lcom/jetbrains/rider/environmentSetup/SingleEnvironmentComponent;", "localReader", "Lcom/jetbrains/rider/environmentSetup/ComponentsLocalReader;", "updatesReader", "Lcom/jetbrains/rider/environmentSetup/ComponentsUpdatesReader;", "MonoEnvironmentComponent", "(Lcom/jetbrains/rider/environmentSetup/ComponentsLocalReader;Lcom/jetbrains/rider/environmentSetup/ComponentsUpdatesReader;)V", "localVersion", "Lcom/jetbrains/rider/nuget/helpers/RiderNuGetOperation$Version;", "id", "", "getId", "()Ljava/lang/String;", "name", "getName", "url", "getUrl", "description", "getDescription", "icon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getIcon", "()Ljavax/swing/Icon;", "getLocalVersion", "supportedByOS", "", "doExecute", "", "pi", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.rider"})
public final class MonoEnvironmentComponent
extends SingleEnvironmentComponent {
    @Nullable
    private RiderNuGetOperation.Version localVersion;
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final String url;
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    private final String description;
    @NotNull
    private final Icon icon;

    public MonoEnvironmentComponent(@NotNull ComponentsLocalReader localReader, @NotNull ComponentsUpdatesReader updatesReader) {
        Intrinsics.checkNotNullParameter((Object)localReader, (String)"localReader");
        Intrinsics.checkNotNullParameter((Object)updatesReader, (String)"updatesReader");
        super(localReader, updatesReader);
        Object object = localReader.find("monoRuntimes");
        if (object == null || (object = object.getChildren("monoRuntime")) == null) {
            object = CollectionsKt.emptyList();
        }
        Object object2 = object;
        Iterator iterator2 = object2.iterator();
        while (iterator2.hasNext()) {
            Element element = (Element)iterator2.next();
            Object object3 = element.getAttribute("version");
            if (object3 == null || (object3 = object3.getValue()) == null) continue;
            Object object4 = object3;
            RiderNuGetOperation.Version version = RiderNuGetOperation.Version.Companion.parse((String)object4);
            RiderNuGetOperation.Version version2 = this.localVersion;
            if (version2 != null && version2.compareTo(version) >= 0) continue;
            this.localVersion = version;
        }
        this.id = "mono";
        this.name = "Mono";
        this.url = "https://www.mono-project.com/";
        this.description = RiderEnvironmentSetupBundle.Companion.message("mono.environment.component.description", new Object[0]);
        Icon icon = RiderIcons.Components.EnvironmentMono;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"EnvironmentMono");
        this.icon = icon;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getUrl() {
        return this.url;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    @Nullable
    protected RiderNuGetOperation.Version getLocalVersion() {
        return this.localVersion;
    }

    @Override
    public boolean supportedByOS() {
        return !SystemInfo.isWindows;
    }

    @Override
    public void doExecute(@NotNull ProgressIndicator pi, @NotNull String url2) {
        Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        EnvironmentSetupUtils.INSTANCE.downloadAndInstallPkg(url2, pi);
    }
}

