/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.environmentSetup.analyzers;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.system.CpuArch;
import com.jetbrains.rider.RiderBundle;
import com.jetbrains.rider.environmentSetup.ComponentsLocalReader;
import com.jetbrains.rider.environmentSetup.ComponentsUpdatesReader;
import com.jetbrains.rider.environmentSetup.RiderEnvironmentSetupBundle;
import com.jetbrains.rider.environmentSetup.SingleEnvironmentComponent;
import com.jetbrains.rider.environmentSetup.impl.EnvironmentSetupUtils;
import com.jetbrains.rider.nuget.helpers.RiderNuGetOperation;
import com.jetbrains.rider.utils.DownloadHelperKt;
import com.jetbrains.rider.utils.DownloadStatusHandler;
import icons.RiderIcons;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 *2\u00020\u0001:\u0005*+,-.B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020 H\u0014J\n\u0010$\u001a\u0004\u0018\u00010\tH\u0014J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J\b\u0010)\u001a\u00020 H\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u000fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0014\u0010\u0016\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u0016\u0010\u0018\u001a\u00020\u000f8\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011R\u0019\u0010\u001a\u001a\u00070\u001b\u00a2\u0006\u0002\b\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010\"\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0011\u00a8\u0006/"}, d2={"Lcom/jetbrains/rider/environmentSetup/analyzers/DotNetCoreEnvironmentComponent;", "Lcom/jetbrains/rider/environmentSetup/SingleEnvironmentComponent;", "localReader", "Lcom/jetbrains/rider/environmentSetup/ComponentsLocalReader;", "updatesReader", "Lcom/jetbrains/rider/environmentSetup/ComponentsUpdatesReader;", "DotNetCoreEnvironmentComponent", "(Lcom/jetbrains/rider/environmentSetup/ComponentsLocalReader;Lcom/jetbrains/rider/environmentSetup/ComponentsUpdatesReader;)V", "localVersion", "Lcom/jetbrains/rider/nuget/helpers/RiderNuGetOperation$Version;", "localPath", "Ljava/io/File;", "strategy", "Lcom/jetbrains/rider/environmentSetup/analyzers/DotNetCoreEnvironmentComponent$InstallationStrategy;", "id", "", "getId", "()Ljava/lang/String;", "packageName", "getPackageName", "name", "getName", "url", "getUrl", "description", "getDescription", "icon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getIcon", "()Ljavax/swing/Icon;", "supportedByOS", "", "isActionAvailable", "actionNotAvailableReason", "getActionNotAvailableReason", "getLocalVersion", "doExecute", "", "pi", "Lcom/intellij/openapi/progress/ProgressIndicator;", "x", "Companion", "InstallationStrategy", "PortableStrategy", "ProgramFilesStrategy", "UsrLocalStrategy", "intellij.rider"})
public final class DotNetCoreEnvironmentComponent
extends SingleEnvironmentComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private RiderNuGetOperation.Version localVersion;
    @Nullable
    private File localPath;
    @Nullable
    private final InstallationStrategy strategy;
    @NotNull
    private final String id;
    @Nullable
    private final String packageName;
    @NotNull
    private final String name;
    @NotNull
    private final String url;
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    private final String description;
    @NotNull
    private final Icon icon;

    public DotNetCoreEnvironmentComponent(@NotNull ComponentsLocalReader localReader, @NotNull ComponentsUpdatesReader updatesReader) {
        Intrinsics.checkNotNullParameter((Object)localReader, (String)"localReader");
        Intrinsics.checkNotNullParameter((Object)updatesReader, (String)"updatesReader");
        super(localReader, updatesReader);
        Element element = localReader.find("dotNetCoreRuntimes");
        if (element != null) {
            Element element2 = element;
            boolean bl = false;
            for (Element element3 : element2.getChildren("dotNetCoreRuntime")) {
                Object object = element3.getAttribute("path");
                if (object == null || (object = object.getValue()) == null) continue;
                Object object2 = object;
                for (Element element4 : element3.getChildren("sdk")) {
                    String string;
                    if (element4.getAttribute("version").getValue() == null) continue;
                    RiderNuGetOperation.Version version = RiderNuGetOperation.Version.Companion.parse(string);
                    RiderNuGetOperation.Version version2 = this.localVersion;
                    if (version2 != null && version2.compareTo(version) >= 0) continue;
                    this.localVersion = version;
                    this.localPath = new File((String)object2);
                }
            }
        }
        this.strategy = DotNetCoreEnvironmentComponent.Companion.x(this.localPath);
        this.id = "dotnet-core";
        InstallationStrategy installationStrategy = this.strategy;
        this.packageName = installationStrategy != null ? installationStrategy.getPackageName() : null;
        this.name = ".NET";
        this.url = "https://docs.microsoft.com/en-us/dotnet/";
        this.description = RiderEnvironmentSetupBundle.Companion.message("DotNetCoreEnvironmentComponent.net.sdk.and.runtime.for.building.net.core.applications", new Object[0]);
        Icon icon = RiderIcons.Components.EnvironmentDotNet;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"EnvironmentDotNet");
        this.icon = icon;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    protected String getPackageName() {
        return this.packageName;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getUrl() {
        return this.url;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public boolean supportedByOS() {
        return true;
    }

    @Override
    protected boolean isActionAvailable() {
        return super.isActionAvailable() && this.strategy != null && !this.x();
    }

    @Override
    @Nullable
    public String getActionNotAvailableReason() {
        if (this.strategy == null && this.localPath != null) {
            Object[] objectArray = new Object[]{String.valueOf(this.localPath)};
            return RiderEnvironmentSetupBundle.Companion.message("DotNetCoreEnvironmentComponent.can.not.update.dotnet.core.in.path.0", objectArray);
        }
        if (this.x()) {
            Object[] objectArray = new Object[]{String.valueOf(this.localPath)};
            return RiderEnvironmentSetupBundle.Companion.message("DotNetCoreEnvironmentComponent.can.not.update.dotnet.arm", objectArray);
        }
        return super.getActionNotAvailableReason();
    }

    @Override
    @Nullable
    protected RiderNuGetOperation.Version getLocalVersion() {
        return this.localVersion;
    }

    @Override
    public void doExecute(@NotNull ProgressIndicator pi, @NotNull String url2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
            Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
            InstallationStrategy installationStrategy = this.strategy;
            if (installationStrategy == null) break block0;
            installationStrategy.doExecute(pi, url2);
        }
    }

    private final boolean x() {
        RiderNuGetOperation.Version version = this.localVersion;
        if (version == null) {
            return false;
        }
        RiderNuGetOperation.Version version2 = version;
        Object object = this.getUpdatesReader().get(this.getId(), this.getPackageName());
        if (object == null || (object = ((ComponentsUpdatesReader.Info)object).getVersion()) == null) {
            return false;
        }
        Object object2 = object;
        return SystemInfo.isMac && CpuArch.isArm64() && version2.getMajor() < 6 && ((RiderNuGetOperation.Version)object2).getMajor() >= 6;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/environmentSetup/analyzers/DotNetCoreEnvironmentComponent$Companion;", "", "DotNetCoreEnvironmentComponent$Companion", "()V", "x", "Lcom/jetbrains/rider/environmentSetup/analyzers/DotNetCoreEnvironmentComponent$InstallationStrategy;", "path", "Ljava/io/File;", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nDotNetEnvironmentComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotNetEnvironmentComponent.kt\ncom/jetbrains/rider/environmentSetup/analyzers/DotNetCoreEnvironmentComponent$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,171:1\n12970#2,2:172\n*S KotlinDebug\n*F\n+ 1 DotNetEnvironmentComponent.kt\ncom/jetbrains/rider/environmentSetup/analyzers/DotNetCoreEnvironmentComponent$Companion\n*L\n65#1:172,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final InstallationStrategy x(File file2) {
            File[] fileArray;
            if (file2 == null) {
                return PortableStrategy.INSTANCE;
            }
            File file3 = new File(System.getProperty("user.home"), ".dotnet");
            if (FileUtil.isAncestor((File)file3, (File)file2, (boolean)false)) {
                return PortableStrategy.INSTANCE;
            }
            if (SystemInfo.isWindows) {
                boolean bl;
                block6: {
                    File[] fileArray2 = new File[]{new File(System.getenv("ProgramFiles"), "dotnet"), new File(System.getenv("ProgramFiles(X86)"), "dotnet")};
                    fileArray2 = fileArray = fileArray2;
                    boolean bl2 = false;
                    int n = fileArray2.length;
                    for (int j = 0; j < n; ++j) {
                        File file4;
                        File file5 = file4 = fileArray2[j];
                        boolean bl3 = false;
                        if (!FileUtil.isAncestor((File)file5, (File)file2, (boolean)false)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
                if (bl) {
                    return ProgramFilesStrategy.INSTANCE;
                }
            }
            if (SystemInfo.isMac && FileUtil.isAncestor((File)(fileArray = new File("/usr/local")), (File)file2, (boolean)false)) {
                return UsrLocalStrategy.INSTANCE;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rider/environmentSetup/analyzers/DotNetCoreEnvironmentComponent$InstallationStrategy;", "", "packageName", "", "getPackageName", "()Ljava/lang/String;", "doExecute", "", "pi", "Lcom/intellij/openapi/progress/ProgressIndicator;", "url", "intellij.rider"})
    public static interface InstallationStrategy {
        @NotNull
        public String getPackageName();

        public void doExecute(@NotNull ProgressIndicator var1, @NotNull String var2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/environmentSetup/analyzers/DotNetCoreEnvironmentComponent$PortableStrategy;", "Lcom/jetbrains/rider/environmentSetup/analyzers/DotNetCoreEnvironmentComponent$InstallationStrategy;", "DotNetCoreEnvironmentComponent$PortableStrategy", "()V", "packageName", "", "getPackageName", "()Ljava/lang/String;", "doExecute", "", "pi", "Lcom/intellij/openapi/progress/ProgressIndicator;", "url", "intellij.rider"})
    public static final class PortableStrategy
    implements InstallationStrategy {
        @NotNull
        public static final PortableStrategy INSTANCE = new PortableStrategy();
        @NotNull
        private static final String packageName = CpuArch.isArm64() ? "zip_arm" : "zip";

        private PortableStrategy() {
        }

        @Override
        @NotNull
        public String getPackageName() {
            return packageName;
        }

        @Override
        public void doExecute(@NotNull ProgressIndicator pi, @NotNull String url2) {
            Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
            Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
            EnvironmentSetupUtils.INSTANCE.downloadAndExtract(url2, pi, (Function1<? super File, Unit>)((Function1)arg_0 -> PortableStrategy.x(pi, arg_0)));
        }

        private static final Unit x(ProgressIndicator progressIndicator, File file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"folder");
            progressIndicator.setText2(RiderBundle.message("progress.details.installing", new Object[0]));
            progressIndicator.setIndeterminate(true);
            progressIndicator.startNonCancelableSection();
            File file3 = new File(System.getProperty("user.home"), ".dotnet");
            EnvironmentSetupUtils.moveDirectoryContentRecursive$default(EnvironmentSetupUtils.INSTANCE, file2, file3, EnvironmentSetupUtils.MoveStrategy.MoveOverwrite, null, 8, null);
            progressIndicator.finishNonCancelableSection();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/environmentSetup/analyzers/DotNetCoreEnvironmentComponent$ProgramFilesStrategy;", "Lcom/jetbrains/rider/environmentSetup/analyzers/DotNetCoreEnvironmentComponent$InstallationStrategy;", "DotNetCoreEnvironmentComponent$ProgramFilesStrategy", "()V", "packageName", "", "getPackageName", "()Ljava/lang/String;", "doExecute", "", "pi", "Lcom/intellij/openapi/progress/ProgressIndicator;", "url", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nDotNetEnvironmentComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotNetEnvironmentComponent.kt\ncom/jetbrains/rider/environmentSetup/analyzers/DotNetCoreEnvironmentComponent$ProgramFilesStrategy\n+ 2 EnvironmentSetupUtils.kt\ncom/jetbrains/rider/environmentSetup/impl/EnvironmentSetupUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,171:1\n61#2:172\n119#2,5:173\n124#2,6:189\n141#2,5:195\n62#2,2:200\n146#2,9:202\n64#2:211\n669#3,11:178\n*S KotlinDebug\n*F\n+ 1 DotNetEnvironmentComponent.kt\ncom/jetbrains/rider/environmentSetup/analyzers/DotNetCoreEnvironmentComponent$ProgramFilesStrategy\n*L\n150#1:172\n150#1:173,5\n150#1:189,6\n150#1:195,5\n150#1:200,2\n150#1:202,9\n150#1:211\n150#1:178,11\n*E\n"})
    public static final class ProgramFilesStrategy
    implements InstallationStrategy {
        @NotNull
        public static final ProgramFilesStrategy INSTANCE = new ProgramFilesStrategy();
        @NotNull
        private static final String packageName = CpuArch.isArm64() ? "exe_arm" : "exe";

        private ProgramFilesStrategy() {
        }

        @Override
        @NotNull
        public String getPackageName() {
            return packageName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doExecute(@NotNull ProgressIndicator pi, @NotNull String url2) {
            String string;
            Unit unit;
            Unit unit2;
            Object object;
            Object object2;
            String string2;
            ProgressIndicator progressIndicator;
            String string3;
            block11: {
                Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
                Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
                EnvironmentSetupUtils environmentSetupUtils = EnvironmentSetupUtils.INSTANCE;
                String string4 = url2;
                ProgressIndicator progressIndicator2 = pi;
                boolean bl = false;
                EnvironmentSetupUtils environmentSetupUtils2 = environmentSetupUtils;
                string3 = string4;
                progressIndicator = progressIndicator2;
                boolean bl2 = true;
                boolean bl3 = false;
                Object object3 = new String[]{"/", "\\"};
                string2 = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)string3, (String[])object3, (boolean)false, (int)0, (int)6, null));
                object2 = new String[]{"exe", "zip", "pkg", "tar.gz"};
                object3 = CollectionsKt.listOf((Object[])object2);
                object = (Iterable)object3;
                boolean bl4 = false;
                unit2 = null;
                boolean bl5 = false;
                Iterator iterator2 = object.iterator();
                while (iterator2.hasNext()) {
                    Object t = iterator2.next();
                    String string5 = (String)t;
                    boolean bl6 = false;
                    if (!StringsKt.endsWith((String)string2, (String)("." + string5), (boolean)true)) continue;
                    if (bl5) {
                        unit = null;
                        break block11;
                    }
                    unit2 = (Unit)t;
                    bl5 = true;
                }
                unit = !bl5 ? null : unit2;
            }
            if ((string = (String)unit) == null) {
                string = StringsKt.substringAfterLast$default((String)string2, (char)'.', null, (int)2, null);
            }
            Object object4 = ((CharSequence)(object2 = string)).length() > 0 ? "." + (String)object2 : "";
            object = File.createTempFile(StringsKt.removeSuffix((String)string2, (CharSequence)((CharSequence)object4)), (String)object4);
            ((File)object).delete();
            DownloadStatusHandler downloadStatusHandler = new DownloadStatusHandler(progressIndicator){
                final /* synthetic */ ProgressIndicator $pi;
                {
                    this.$pi = $pi;
                }

                public void reportProgress(long totalSize, long currentSize) {
                    this.$pi.setFraction((double)currentSize / (double)totalSize / 2.0);
                    Object[] objectArray = new Object[]{MathKt.roundToInt((double)((double)currentSize / 1024.0 / 1024.0)), MathKt.roundToInt((double)((double)totalSize / 1024.0 / 1024.0))};
                    this.$pi.setText2(RiderEnvironmentSetupBundle.Companion.message("EnvironmentSetupUtils.progress.details.downloading.mb", objectArray));
                }

                public boolean isCancelled() {
                    return this.$pi.isCanceled();
                }
            };
            try {
                Intrinsics.checkNotNull((Object)object);
                DownloadHelperKt.downloadUrlToFile((String)string3, (File)object, null, (DownloadStatusHandler)downloadStatusHandler, (int)3);
                if (progressIndicator.isCanceled()) {
                    throw new CancellationException();
                }
                Object object5 = object;
                boolean bl = false;
                Object object6 = object5;
                boolean bl7 = false;
                pi.setText2(RiderBundle.message("progress.details.installing", new Object[0]));
                pi.setIndeterminate(true);
                pi.startNonCancelableSection();
                String[] stringArray = new String[]{((File)object6).getPath(), "/install", "/norestart", "/quiet"};
                Process process2 = new ProcessBuilder(stringArray).start();
                process2.waitFor();
                pi.finishNonCancelableSection();
                unit2 = Unit.INSTANCE;
                if (progressIndicator.isCanceled()) {
                    throw new CancellationException();
                }
                Unit unit3 = unit2;
            }
            catch (Throwable throwable) {
                try {
                    ((File)object).delete();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                ((File)object).delete();
            }
            catch (Throwable throwable) {}
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/environmentSetup/analyzers/DotNetCoreEnvironmentComponent$UsrLocalStrategy;", "Lcom/jetbrains/rider/environmentSetup/analyzers/DotNetCoreEnvironmentComponent$InstallationStrategy;", "DotNetCoreEnvironmentComponent$UsrLocalStrategy", "()V", "packageName", "", "getPackageName", "()Ljava/lang/String;", "doExecute", "", "pi", "Lcom/intellij/openapi/progress/ProgressIndicator;", "url", "intellij.rider"})
    public static final class UsrLocalStrategy
    implements InstallationStrategy {
        @NotNull
        public static final UsrLocalStrategy INSTANCE = new UsrLocalStrategy();
        @NotNull
        private static final String packageName = CpuArch.isArm64() ? "pkg_arm" : "pkg";

        private UsrLocalStrategy() {
        }

        @Override
        @NotNull
        public String getPackageName() {
            return packageName;
        }

        @Override
        public void doExecute(@NotNull ProgressIndicator pi, @NotNull String url2) {
            Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
            Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
            EnvironmentSetupUtils.INSTANCE.downloadAndInstallPkg(url2, pi);
        }
    }
}

