/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.environmentSetup;

import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.newui.VerticalLayout;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.rider.environmentSetup.ComponentsLocalReader;
import com.jetbrains.rider.environmentSetup.ComponentsUpdatesReader;
import com.jetbrains.rider.environmentSetup.EnvironmentAnalyzer;
import com.jetbrains.rider.environmentSetup.EnvironmentComponent;
import com.jetbrains.rider.environmentSetup.EnvironmentIndicatorBase;
import com.jetbrains.rider.environmentSetup.EnvironmentSetupPanel;
import com.jetbrains.rider.environmentSetup.RiderEnvironmentSetupBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0001(B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH$J\b\u0010\u001c\u001a\u00020\u0019H$J\b\u0010\u001d\u001a\u00020\u0019H$J\b\u0010\u001e\u001a\u00020\u0019H$J\b\u0010\u001f\u001a\u00020\u0019H$J\"\u0010 \u001a\u00020\u00192\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0006\u0010%\u001a\u00020\u0019J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020&H\u0002J\u0006\u0010'\u001a\u00020\u0019R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006)"}, d2={"Lcom/jetbrains/rider/environmentSetup/EnvironmentSetupSingleComponentView;", "", "project", "Lcom/intellij/openapi/project/Project;", "componentName", "", "EnvironmentSetupSingleComponentView", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getComponentName", "()Ljava/lang/String;", "analyzer", "Lcom/jetbrains/rider/environmentSetup/EnvironmentAnalyzer;", "infoLabel", "Ljavax/swing/JLabel;", "component", "Lcom/jetbrains/rider/environmentSetup/EnvironmentComponent;", "indicator", "Lcom/jetbrains/rider/environmentSetup/EnvironmentSetupSingleComponentView$MyIndicator;", "mainPanel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "getMainPanel", "()Lcom/intellij/util/ui/components/BorderLayoutPanel;", "onEnabled", "", "action", "Lcom/jetbrains/rider/environmentSetup/EnvironmentComponent$Action;", "onReady", "onCancel", "onCancelEnabled", "onCancelDisabled", "x", "localReader", "Lcom/jetbrains/rider/environmentSetup/ComponentsLocalReader;", "updatesReader", "Lcom/jetbrains/rider/environmentSetup/ComponentsUpdatesReader;", "install", "Ljavax/swing/JComponent;", "cancel", "MyIndicator", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nEnvironmentSetupSingleComponentView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnvironmentSetupSingleComponentView.kt\ncom/jetbrains/rider/environmentSetup/EnvironmentSetupSingleComponentView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,240:1\n1#2:241\n*E\n"})
public abstract class EnvironmentSetupSingleComponentView {
    @Nullable
    private final Project project;
    @NotNull
    private final String componentName;
    @NotNull
    private final EnvironmentAnalyzer analyzer;
    @NotNull
    private final JLabel infoLabel;
    @Nullable
    private EnvironmentComponent component;
    @Nullable
    private MyIndicator indicator;
    @NotNull
    private final BorderLayoutPanel mainPanel;

    public EnvironmentSetupSingleComponentView(@Nullable Project project, @NotNull String componentName) {
        BorderLayoutPanel borderLayoutPanel;
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        this.project = project;
        this.componentName = componentName;
        this.analyzer = new EnvironmentAnalyzer(this.project, false);
        this.infoLabel = new JLabel(RiderEnvironmentSetupBundle.Companion.message("EnvironmentSetupManager.info.label.refreshing", new Object[0]), 0);
        BorderLayoutPanel borderLayoutPanel2 = borderLayoutPanel = new BorderLayoutPanel();
        EnvironmentSetupSingleComponentView environmentSetupSingleComponentView = this;
        boolean bl = false;
        borderLayoutPanel2.add((Component)this.infoLabel);
        environmentSetupSingleComponentView.mainPanel = borderLayoutPanel;
        this.analyzer.analyze((Function3<? super List<? extends EnvironmentComponent>, ? super ComponentsLocalReader, ? super ComponentsUpdatesReader, Unit>)((Function3)(arg_0, arg_1, arg_2) -> EnvironmentSetupSingleComponentView.x(this, arg_0, arg_1, arg_2)), (Function1<? super String, Unit>)((Function1)arg_0 -> EnvironmentSetupSingleComponentView.x(this, arg_0)), (Function1<? super EnvironmentComponent, Boolean>)((Function1)arg_0 -> EnvironmentSetupSingleComponentView.x(this, arg_0)));
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final String getComponentName() {
        return this.componentName;
    }

    @NotNull
    public final BorderLayoutPanel getMainPanel() {
        return this.mainPanel;
    }

    protected abstract void onEnabled(@NotNull EnvironmentComponent.Action var1);

    protected abstract void onReady();

    protected abstract void onCancel();

    protected abstract void onCancelEnabled();

    protected abstract void onCancelDisabled();

    private final void x(EnvironmentComponent environmentComponent, ComponentsLocalReader componentsLocalReader, ComponentsUpdatesReader componentsUpdatesReader) {
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (environmentComponent == null) {
            Object[] objectArray = new Object[]{this.componentName};
            this.infoLabel.setText(RiderEnvironmentSetupBundle.Companion.message("EnvironmentSetupManager.label.can.not.find.component.with.name", objectArray));
            return;
        }
        this.component = environmentComponent;
        OpaquePanel opaquePanel = object5 = new OpaquePanel((LayoutManager)new BorderLayout(JBUI.scale((int)10), 0));
        boolean bl2 = false;
        opaquePanel.setBorder(JBUI.Borders.empty((int)15));
        OpaquePanel opaquePanel2 = object5;
        opaquePanel = object5 = new JLabel(environmentComponent.getIcon());
        OpaquePanel opaquePanel3 = opaquePanel2;
        bl2 = false;
        opaquePanel.setVerticalAlignment(1);
        opaquePanel3.add((Component)object5, (Object)"West");
        object5 = new OpaquePanel((LayoutManager)new VerticalLayout(JBUI.scale((int)5), JBUI.scale((int)181)));
        opaquePanel2.add((Component)object5);
        opaquePanel = new LinkLabel("<html><b>" + environmentComponent.getName() + "</b></html>", null, (arg_0, arg_1) -> EnvironmentSetupSingleComponentView.x(environmentComponent, arg_0, arg_1));
        object5.add(RelativeFont.LARGE.install((Component)opaquePanel));
        Object object6 = new Object[]{environmentComponent.getVersion()};
        JLabel jLabel = new JLabel(HtmlChunk.raw((String)RiderEnvironmentSetupBundle.Companion.message("EnvironmentSetupSingleComponentView.label.version", object6)).wrapWith(HtmlChunk.html()).toString());
        object5.add((Component)jLabel);
        Object object7 = object4 = new JLabel("<html>" + environmentComponent.getDescription() + "</html>");
        boolean bl3 = false;
        ((JComponent)object7).setBorder((Border)JBUI.Borders.empty((int)5, (int)0, (int)0, (int)0));
        object6 = object4;
        object5.add((Component)object6);
        object4 = environmentComponent.getAction();
        if (object4 != null) {
            object3 = new Object[]{object4.getVersion(), object4.getSize()};
            Object object8 = HtmlChunk.raw((String)RiderEnvironmentSetupBundle.Companion.message("EnvironmentSetupSingleComponentView.available.version", (Object[])object3)).wrapWith(HtmlChunk.p()).wrapWith(HtmlChunk.html()).toString();
            Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"toString(...)");
            object7 = object8;
            Object object9 = object3 = new JLabel((String)object7, 0);
            boolean bl4 = false;
            ((JComponent)object9).setBackground(PluginManagerConfigurable.MAIN_BG_COLOR);
            ((JComponent)object9).setBorder((Border)JBUI.Borders.empty((int)5, (int)0));
            object8 = object3;
            object5.add((Component)object8);
            object2 = object9 = new JLabel("", 0);
            boolean bl5 = false;
            ((JComponent)object2).setBackground(PluginManagerConfigurable.MAIN_BG_COLOR);
            object3 = object9;
            object = object2 = new JProgressBar(0, 100);
            boolean bl6 = false;
            ((JComponent)object).setBackground(PluginManagerConfigurable.MAIN_BG_COLOR);
            ((JComponent)object).setVisible(false);
            object9 = object2;
            this.indicator = new MyIndicator(this, (JProgressBar)object9, (JLabel)object3);
            object5.add((Component)object9);
            object5.add((Component)object3);
            this.onEnabled((EnvironmentComponent.Action)object4);
        } else {
            String string = environmentComponent.getActionNotAvailableReason();
            if (string == null) {
                string = RiderEnvironmentSetupBundle.Companion.message("EnvironmentSetupSingleComponentView.label.can.not.install.component", new Object[0]);
            }
            object7 = string;
            JLabel jLabel2 = new JLabel(HtmlChunk.raw((String)object7).wrapWith(HtmlChunk.font((String)"gray")).wrapWith(HtmlChunk.html()).toString());
            object3 = jLabel2;
            opaquePanel3 = object5;
            boolean bl7 = false;
            ((JComponent)object3).setBackground(PluginManagerConfigurable.MAIN_BG_COLOR);
            opaquePanel3.add((Component)jLabel2);
        }
        this.mainPanel.removeAll();
        this.mainPanel.add((Component)opaquePanel2);
        Throwable throwable = componentsLocalReader.getError();
        if (throwable != null) {
            object3 = throwable;
            boolean bl8 = false;
            object = object2 = EnvironmentSetupPanel.Companion.createLocalErrorLabel((Throwable)object3);
            BorderLayoutPanel borderLayoutPanel = this.mainPanel;
            bl = false;
            ((JComponent)object).setBorder(JBUI.Borders.empty((int)15));
            borderLayoutPanel.addToBottom((Component)object2);
        }
        Throwable throwable2 = componentsUpdatesReader.getError();
        if (throwable2 != null) {
            object3 = throwable2;
            boolean bl9 = false;
            object = object2 = EnvironmentSetupPanel.Companion.createUpdatesErrorLabel((Throwable)object3);
            BorderLayoutPanel borderLayoutPanel = this.mainPanel;
            bl = false;
            ((JComponent)object).setBorder(JBUI.Borders.empty((int)15));
            borderLayoutPanel.addToBottom((Component)object2);
        }
        this.mainPanel.setBackground(PluginManagerConfigurable.MAIN_BG_COLOR);
        this.mainPanel.updateUI();
    }

    public final void install() {
        MyIndicator myIndicator = this.indicator;
        if (myIndicator == null) {
            return;
        }
        MyIndicator myIndicator2 = myIndicator;
        EnvironmentComponent environmentComponent = this.component;
        if (environmentComponent == null) {
            return;
        }
        EnvironmentComponent environmentComponent2 = environmentComponent;
        myIndicator2.start();
        environmentComponent2.execute((ProgressIndicator)myIndicator2, (Function0<Unit>)((Function0)() -> EnvironmentSetupSingleComponentView.x(this)), (Function1<? super String, Unit>)((Function1)arg_0 -> EnvironmentSetupSingleComponentView.G(this, arg_0)));
    }

    private final void x(JComponent jComponent) {
        SwingUtilities.invokeLater(() -> EnvironmentSetupSingleComponentView.x(this, jComponent));
    }

    public final void cancel() {
        block1: {
            MyIndicator myIndicator = this.indicator;
            boolean bl = myIndicator != null ? myIndicator.isRunning() : false;
            if (!bl) break block1;
            MyIndicator myIndicator2 = this.indicator;
            if (myIndicator2 != null) {
                myIndicator2.cancel();
            }
        }
    }

    private static final Unit x(EnvironmentSetupSingleComponentView environmentSetupSingleComponentView, List list2, ComponentsLocalReader componentsLocalReader, ComponentsUpdatesReader componentsUpdatesReader) {
        Intrinsics.checkNotNullParameter((Object)list2, (String)"components");
        Intrinsics.checkNotNullParameter((Object)componentsLocalReader, (String)"localReader");
        Intrinsics.checkNotNullParameter((Object)componentsUpdatesReader, (String)"updatesReader");
        environmentSetupSingleComponentView.x((EnvironmentComponent)CollectionsKt.singleOrNull((List)list2), componentsLocalReader, componentsUpdatesReader);
        return Unit.INSTANCE;
    }

    private static final Unit x(EnvironmentSetupSingleComponentView environmentSetupSingleComponentView, String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"it");
        environmentSetupSingleComponentView.infoLabel.setText(string);
        return Unit.INSTANCE;
    }

    private static final boolean x(EnvironmentSetupSingleComponentView environmentSetupSingleComponentView, EnvironmentComponent environmentComponent) {
        Intrinsics.checkNotNullParameter((Object)environmentComponent, (String)"it");
        return StringsKt.equals((String)environmentComponent.getName(), (String)environmentSetupSingleComponentView.componentName, (boolean)true);
    }

    private static final void x(EnvironmentComponent environmentComponent, LinkLabel linkLabel, Object object) {
        BrowserUtil.browse((String)environmentComponent.getUrl());
    }

    private static final Unit x(EnvironmentSetupSingleComponentView environmentSetupSingleComponentView) {
        environmentSetupSingleComponentView.x(new JLabel(HtmlChunk.raw((String)RiderEnvironmentSetupBundle.Companion.message("EnvironmentSetupSingleComponentView.label.installation.completed", new Object[0])).wrapWith(HtmlChunk.font((String)"green")).wrapWith(HtmlChunk.html()).toString(), AllIcons.General.InspectionsOK, 0));
        return Unit.INSTANCE;
    }

    private static final Unit G(EnvironmentSetupSingleComponentView environmentSetupSingleComponentView, String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"error");
        Object[] objectArray = new Object[]{string};
        environmentSetupSingleComponentView.x(new JLabel(HtmlChunk.raw((String)RiderEnvironmentSetupBundle.Companion.message("EnvironmentSetupSingleComponentView.label.can.not.install.component.0", objectArray)).wrapWith(HtmlChunk.font((String)"red")).wrapWith(HtmlChunk.html()).toString(), AllIcons.General.Error, 0));
        return Unit.INSTANCE;
    }

    private static final void x(EnvironmentSetupSingleComponentView environmentSetupSingleComponentView, JComponent jComponent) {
        JComponent jComponent2;
        MyIndicator myIndicator = environmentSetupSingleComponentView.indicator;
        if (myIndicator != null) {
            MyIndicator myIndicator2 = myIndicator;
            boolean bl = false;
            myIndicator2.getProgressBar().setVisible(false);
            myIndicator2.getStatusLabel().setVisible(false);
        }
        environmentSetupSingleComponentView.indicator = null;
        JComponent jComponent3 = jComponent2 = jComponent;
        BorderLayoutPanel borderLayoutPanel = environmentSetupSingleComponentView.mainPanel;
        boolean bl = false;
        jComponent3.setBorder(JBUI.Borders.empty((int)15));
        borderLayoutPanel.addToBottom((Component)jComponent2);
        environmentSetupSingleComponentView.mainPanel.updateUI();
        environmentSetupSingleComponentView.onReady();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/environmentSetup/EnvironmentSetupSingleComponentView$MyIndicator;", "Lcom/jetbrains/rider/environmentSetup/EnvironmentIndicatorBase;", "owner", "Lcom/jetbrains/rider/environmentSetup/EnvironmentSetupSingleComponentView;", "progressBar", "Ljavax/swing/JProgressBar;", "statusLabel", "Ljavax/swing/JLabel;", "EnvironmentSetupSingleComponentView$MyIndicator", "(Lcom/jetbrains/rider/environmentSetup/EnvironmentSetupSingleComponentView;Ljavax/swing/JProgressBar;Ljavax/swing/JLabel;)V", "getProgressBar", "()Ljavax/swing/JProgressBar;", "getStatusLabel", "()Ljavax/swing/JLabel;", "start", "", "cancel", "startNonCancelableSection", "finishNonCancelableSection", "intellij.rider"})
    private static final class MyIndicator
    extends EnvironmentIndicatorBase {
        @NotNull
        private final EnvironmentSetupSingleComponentView owner;
        @NotNull
        private final JProgressBar progressBar;
        @NotNull
        private final JLabel statusLabel;

        public MyIndicator(@NotNull EnvironmentSetupSingleComponentView owner, @NotNull JProgressBar progressBar, @NotNull JLabel statusLabel) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)progressBar, (String)"progressBar");
            Intrinsics.checkNotNullParameter((Object)statusLabel, (String)"statusLabel");
            super(progressBar, statusLabel);
            this.owner = owner;
            this.progressBar = progressBar;
            this.statusLabel = statusLabel;
        }

        @NotNull
        public final JProgressBar getProgressBar() {
            return this.progressBar;
        }

        @NotNull
        public final JLabel getStatusLabel() {
            return this.statusLabel;
        }

        public void start() {
            super.start();
            SwingUtilities.invokeLater(() -> MyIndicator.x(this));
        }

        @Override
        public void cancel() {
            super.cancel();
            SwingUtilities.invokeLater(() -> MyIndicator.w(this));
        }

        public void startNonCancelableSection() {
            super.startNonCancelableSection();
            SwingUtilities.invokeLater(() -> MyIndicator.k(this));
        }

        public void finishNonCancelableSection() {
            super.finishNonCancelableSection();
            SwingUtilities.invokeLater(() -> MyIndicator.G(this));
        }

        private static final void x(MyIndicator myIndicator) {
            myIndicator.progressBar.setVisible(true);
        }

        private static final void w(MyIndicator myIndicator) {
            myIndicator.owner.onCancel();
        }

        private static final void k(MyIndicator myIndicator) {
            myIndicator.owner.onCancelDisabled();
        }

        private static final void G(MyIndicator myIndicator) {
            myIndicator.owner.onCancelEnabled();
        }
    }
}

