/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.environmentSetup;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.rider.environmentSetup.RiderEnvironmentSetupBundle;
import com.jetbrains.rider.environmentSetup.impl.EnvironmentSetupManager;
import com.jetbrains.rider.wizard.RiderUnderWizardRunner;
import com.jetbrains.rider.wizard.core.stat.RiderWizardStat;
import java.util.HashSet;
import java.util.concurrent.CancellationException;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 )2\u00020\u0001:\u0005)*+,-B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0017\u0010\n\u001a\u0013\u0012\t\u0012\u00070\f\u00a2\u0006\u0002\b\r\u0012\u0004\u0012\u00020\u00050\u000bJ\b\u0010%\u001a\u00020\u0012H&J\n\u0010&\u001a\u0004\u0018\u00010'H&J\u0010\u0010(\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H$R\u0012\u0010\u000e\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\f8'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0010R\u0014\u0010\u0019\u001a\u00020\f8'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0010R\u0014\u0010\u001b\u001a\u00020\f8'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0010R\u0012\u0010\u001d\u001a\u00020\u001eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\f8'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0010R\u0016\u0010#\u001a\u0004\u0018\u00010\f8'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0010\u00a8\u0006."}, d2={"Lcom/jetbrains/rider/environmentSetup/EnvironmentComponent;", "", "EnvironmentComponent", "()V", "execute", "", "pi", "Lcom/intellij/openapi/progress/ProgressIndicator;", "onDone", "Lkotlin/Function0;", "onError", "Lkotlin/Function1;", "", "Lorg/jetbrains/annotations/Nls;", "id", "getId", "()Ljava/lang/String;", "restartRequested", "", "getRestartRequested", "()Z", "setRestartRequested", "(Z)V", "name", "getName", "url", "getUrl", "description", "getDescription", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "version", "getVersion", "actionNotAvailableReason", "getActionNotAvailableReason", "supportedByOS", "getAction", "Lcom/jetbrains/rider/environmentSetup/EnvironmentComponent$Action;", "doExecute", "Companion", "Action", "InstallAction", "UpdateAction", "Tag", "intellij.rider"})
public abstract class EnvironmentComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean restartRequested;
    @NotNull
    private static final HashSet<String> installedComponentsSet = new HashSet();

    public final void execute(@NotNull ProgressIndicator pi, @NotNull Function0<Unit> onDone, @NotNull Function1<? super String, Unit> onError) {
        Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
        Intrinsics.checkNotNullParameter(onDone, (String)"onDone");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        EnvironmentSetupManager.INSTANCE.registerJob(this.getName(), pi, (Function0<Boolean>)((Function0)() -> EnvironmentComponent.x(this, pi, onDone, onError)));
    }

    @NotNull
    public abstract String getId();

    public final boolean getRestartRequested() {
        return this.restartRequested;
    }

    public final void setRestartRequested(boolean bl) {
        this.restartRequested = bl;
    }

    @Nls
    @NotNull
    public abstract String getName();

    @NlsSafe
    @NotNull
    public abstract String getUrl();

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public abstract String getDescription();

    @NotNull
    public abstract Icon getIcon();

    @NlsSafe
    @NotNull
    public abstract String getVersion();

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable
    public abstract String getActionNotAvailableReason();

    public abstract boolean supportedByOS();

    @Nullable
    public abstract Action getAction();

    protected abstract void doExecute(@NotNull ProgressIndicator var1);

    private static final boolean x(EnvironmentComponent environmentComponent, ProgressIndicator progressIndicator, Function0 function0, Function1 function1) {
        try {
            environmentComponent.doExecute(progressIndicator);
            function0.invoke();
            installedComponentsSet.add(environmentComponent.getId());
            RiderUnderWizardRunner.INSTANCE.runAction((Function0<Unit>)((Function0)() -> EnvironmentComponent.G(environmentComponent)));
            return true;
        }
        catch (CancellationException cancellationException) {
            RiderUnderWizardRunner.INSTANCE.runAction((Function0<Unit>)((Function0)() -> EnvironmentComponent.x(environmentComponent)));
            return false;
        }
        catch (Throwable throwable) {
            RiderUnderWizardRunner.INSTANCE.runAction((Function0<Unit>)((Function0)() -> EnvironmentComponent.k(environmentComponent)));
            Logger.getInstance((String)"EnvironmentComponent").error(throwable);
            String string = throwable.getLocalizedMessage();
            if (string == null && (string = throwable.getMessage()) == null) {
                string = RiderEnvironmentSetupBundle.Companion.message("EnvironmentComponent.unknown.error", new Object[0]);
            }
            String string2 = string;
            function1.invoke((Object)string2);
            return false;
        }
    }

    private static final Unit G(EnvironmentComponent environmentComponent) {
        RiderWizardStat.INSTANCE.envStepOnInstall(environmentComponent);
        return Unit.INSTANCE;
    }

    private static final Unit x(EnvironmentComponent environmentComponent) {
        RiderWizardStat.INSTANCE.envStepOnCancel(environmentComponent);
        return Unit.INSTANCE;
    }

    private static final Unit k(EnvironmentComponent environmentComponent) {
        RiderWizardStat.INSTANCE.envStepOnFail(environmentComponent);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0012\u0010\b\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rider/environmentSetup/EnvironmentComponent$Action;", "", "name", "", "getName", "()Ljava/lang/String;", "version", "getVersion", "size", "getSize", "intellij.rider"})
    public static interface Action {
        @NotNull
        public String getName();

        @NotNull
        public String getVersion();

        @NotNull
        public String getSize();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/environmentSetup/EnvironmentComponent$Companion;", "", "EnvironmentComponent$Companion", "()V", "installedComponentsSet", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "isInstalled", "", "id", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isInstalled(@NotNull String id2) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            return installedComponentsSet.contains(id2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/environmentSetup/EnvironmentComponent$InstallAction;", "Lcom/jetbrains/rider/environmentSetup/EnvironmentComponent$Action;", "version", "", "size", "EnvironmentComponent$InstallAction", "(Ljava/lang/String;Ljava/lang/String;)V", "getVersion", "()Ljava/lang/String;", "getSize", "name", "getName", "intellij.rider"})
    public static final class InstallAction
    implements Action {
        @NotNull
        private final String version;
        @NotNull
        private final String size;
        @NotNull
        private final String name;

        public InstallAction(@NotNull String version, @NotNull String size) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)size, (String)"size");
            this.version = version;
            this.size = size;
            this.name = "Install";
        }

        @Override
        @NotNull
        public String getVersion() {
            return this.version;
        }

        @Override
        @NotNull
        public String getSize() {
            return this.size;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/environmentSetup/EnvironmentComponent$Tag;", "", "name", "", "value", "EnvironmentComponent$Tag", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getValue", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rider"})
    public static final class Tag {
        @NotNull
        private final String name;
        @NotNull
        private final String value;

        public Tag(@NotNull String name, @NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            this.name = name;
            this.value = value2;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.value;
        }

        @NotNull
        public final Tag copy(@NotNull String name, @NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            return new Tag(name, value2);
        }

        public static /* synthetic */ Tag copy$default(Tag tag, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = tag.name;
            }
            if ((n & 2) != 0) {
                string2 = tag.value;
            }
            return tag.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Tag(name=" + this.name + ", value=" + this.value + ")";
        }

        public int hashCode() {
            int n = this.name.hashCode();
            n = n * 31 + this.value.hashCode();
            return n;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Tag)) {
                return false;
            }
            Tag tag = (Tag)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)tag.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.value, (Object)tag.value);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/environmentSetup/EnvironmentComponent$UpdateAction;", "Lcom/jetbrains/rider/environmentSetup/EnvironmentComponent$Action;", "version", "", "size", "EnvironmentComponent$UpdateAction", "(Ljava/lang/String;Ljava/lang/String;)V", "getVersion", "()Ljava/lang/String;", "getSize", "name", "getName", "intellij.rider"})
    public static final class UpdateAction
    implements Action {
        @NotNull
        private final String version;
        @NotNull
        private final String size;
        @NotNull
        private final String name;

        public UpdateAction(@NotNull String version, @NotNull String size) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)size, (String)"size");
            this.version = version;
            this.size = size;
            this.name = "Update";
        }

        @Override
        @NotNull
        public String getVersion() {
            return this.version;
        }

        @Override
        @NotNull
        public String getSize() {
            return this.size;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }
    }
}

