/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editors;

import com.intellij.openapi.fileEditor.impl.EditorTabColorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.FileColorManager;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rider.projectView.nodes.ProjectModelNodeExtensionKt;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/editors/RiderEditorTabColorProvider;", "Lcom/intellij/openapi/fileEditor/impl/EditorTabColorProvider;", "Lcom/intellij/openapi/project/DumbAware;", "RiderEditorTabColorProvider", "()V", "getEditorTabColor", "Ljava/awt/Color;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getProjectViewColor", "intellij.rider"})
public final class RiderEditorTabColorProvider
implements EditorTabColorProvider,
DumbAware {
    @Nullable
    public Color getEditorTabColor(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        FileColorManager fileColorManager = FileColorManager.getInstance((Project)project);
        if (fileColorManager.isEnabledForTabs()) {
            return (Color)ApplicationKt.getApplication().runReadAction(() -> RiderEditorTabColorProvider.G(file2, project, fileColorManager));
        }
        return null;
    }

    @Nullable
    public Color getProjectViewColor(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        FileColorManager fileColorManager = FileColorManager.getInstance((Project)project);
        if (fileColorManager.isEnabledForProjectView()) {
            return (Color)ApplicationKt.getApplication().runReadAction(() -> RiderEditorTabColorProvider.x(file2, project, fileColorManager));
        }
        return null;
    }

    private static final Color G(VirtualFile virtualFile, Project project, FileColorManager fileColorManager) {
        Intrinsics.checkNotNull((Object)fileColorManager);
        return ProjectModelNodeExtensionKt.getScopeColor((VirtualFile)virtualFile, (Project)project, (FileColorManager)fileColorManager, null, (boolean)true);
    }

    private static final Color x(VirtualFile virtualFile, Project project, FileColorManager fileColorManager) {
        Intrinsics.checkNotNull((Object)fileColorManager);
        return ProjectModelNodeExtensionKt.getScopeColor((VirtualFile)virtualFile, (Project)project, (FileColorManager)fileColorManager, null, (boolean)true);
    }
}

