/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.designers.winforms.editor.exception;

import com.intellij.ide.ui.UISettings;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.ide.model.SettingsModel;
import com.jetbrains.rd.ide.model.SettingsModel_GeneratedKt;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rdclient.ui.NotificationLinkHandler;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.designers.winforms.editor.WinFormsEditor;
import com.jetbrains.rider.designers.winforms.editor.exception.popup.DesignerExceptionBalloon;
import com.jetbrains.rider.model.DesignerDescriptor;
import com.jetbrains.rider.model.FrontendExceptionPresentation;
import com.jetbrains.rider.model.WinFormsExceptionInfo;
import com.jetbrains.rider.model.WinFormsParsingException;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import com.jetbrains.rider.ui.components.utils.RdSwingKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/designers/winforms/editor/exception/DesignerExceptionNotificationController;", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/jetbrains/rider/designers/winforms/editor/WinFormsEditor;", "DesignerExceptionNotificationController", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/designers/winforms/editor/WinFormsEditor;)V", "editorManager", "Lcom/intellij/openapi/fileEditor/ex/FileEditorManagerEx;", "settings", "Lcom/jetbrains/rd/ide/model/SettingsModel;", "processException", "", "exception", "Lcom/jetbrains/rider/model/WinFormsExceptionInfo;", "G", "x", "exceptionInfo", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nDesignerExceptionNotificationController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesignerExceptionNotificationController.kt\ncom/jetbrains/rider/designers/winforms/editor/exception/DesignerExceptionNotificationController\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n11561#2:151\n11896#2,3:152\n1869#3,2:155\n*S KotlinDebug\n*F\n+ 1 DesignerExceptionNotificationController.kt\ncom/jetbrains/rider/designers/winforms/editor/exception/DesignerExceptionNotificationController\n*L\n90#1:151\n90#1:152,3\n141#1:155,2\n*E\n"})
public final class DesignerExceptionNotificationController {
    @NotNull
    private final Project project;
    @NotNull
    private final WinFormsEditor editor;
    @NotNull
    private final FileEditorManagerEx editorManager;
    @NotNull
    private final SettingsModel settings;

    public DesignerExceptionNotificationController(@NotNull Project project, @NotNull WinFormsEditor editor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)editor2), (String)"editor");
        this.project = project;
        this.editor = editor2;
        this.editorManager = FileEditorManagerEx.Companion.getInstanceEx(this.project);
        this.settings = SettingsModel_GeneratedKt.getSettingsModel((IProtocol)ApplicationProtocolKt.getProtocolHost((Project)this.project).getProtocol());
    }

    public final void processException(@NotNull WinFormsExceptionInfo exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        switch (WhenMappings.$EnumSwitchMapping$0[exception.getPresentation().ordinal()]) {
            case 1: {
                this.x(exception);
                break;
            }
            case 2: {
                this.G(exception);
                break;
            }
            case 3: {
                if (Intrinsics.areEqual((Object)this.settings.getShowDesignerExceptions().getValueOrNull(), (Object)true) && UISettings.Companion.getInstance().getEditorTabPlacement() != 0) {
                    this.G(exception);
                    break;
                }
                this.x(exception);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void G(WinFormsExceptionInfo winFormsExceptionInfo) {
        block2: {
            VirtualFile virtualFile = DocumentUtilKt.toVirtualFile$default((File)new File(winFormsExceptionInfo.getFilePath()), (boolean)false, (int)1, null);
            if (virtualFile == null) break block2;
            VirtualFile virtualFile2 = virtualFile;
            boolean bl = false;
            Editor editor2 = this.editorManager.openTextEditor(new OpenFileDescriptor(this.project, virtualFile2), true);
            Intrinsics.checkNotNull((Object)editor2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
            EditorImpl editorImpl = (EditorImpl)editor2;
            LifetimeDefinition lifetimeDefinition = this.editor.getLifetime().createNested();
            DocumentEx documentEx = editorImpl.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
            RdSwingKt.documentChanged((Document)((Document)documentEx)).advise(this.editor.getLifetime(), arg_0 -> DesignerExceptionNotificationController.x(lifetimeDefinition, arg_0));
            Disposable disposable = editorImpl.getDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
            LifetimeDisposableExKt.createLifetime((Disposable)disposable).onTermination(() -> DesignerExceptionNotificationController.x(lifetimeDefinition));
            this.editor.getReload().advise(this.editor.getLifetime(), arg_0 -> DesignerExceptionNotificationController.x(lifetimeDefinition, arg_0));
            DesignerDescriptor designerDescriptor = this.editor.getDescriptor();
            DesignerDescriptor designerDescriptor2 = designerDescriptor;
            if (designerDescriptor2 != null && (designerDescriptor2 = designerDescriptor2.getShowExceptionPopup()) != null) {
                designerDescriptor2.advise(this.editor.getLifetime(), arg_0 -> DesignerExceptionNotificationController.x(lifetimeDefinition, arg_0));
            }
            this.editor.getLifetime().onTermination(() -> DesignerExceptionNotificationController.G(lifetimeDefinition));
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = CollectionsKt.emptyList();
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = -1;
            int n = winFormsExceptionInfo.getExceptions().length;
            Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
            WinFormsParsingException[] winFormsParsingExceptionArray = winFormsExceptionInfo.getExceptions();
            Ref.ObjectRef objectRef3 = objectRef;
            boolean bl2 = false;
            WinFormsParsingException[] winFormsParsingExceptionArray2 = winFormsParsingExceptionArray;
            Collection collection = new ArrayList(winFormsParsingExceptionArray.length);
            boolean bl3 = false;
            int n2 = winFormsParsingExceptionArray2.length;
            for (int j = 0; j < n2; ++j) {
                MarkupModelEx markupModelEx;
                LogicalPosition logicalPosition;
                WinFormsParsingException winFormsParsingException;
                WinFormsParsingException winFormsParsingException2 = winFormsParsingException = winFormsParsingExceptionArray2[j];
                Collection collection2 = collection;
                boolean bl4 = false;
                DesignerExceptionBalloon designerExceptionBalloon = new DesignerExceptionBalloon(lifetimeDefinition.getLifetime(), editorImpl, this.project, winFormsParsingException2);
                designerExceptionBalloon.getResume().advise(this.editor.getLifetime(), arg_0 -> DesignerExceptionNotificationController.x(objectRef2, intRef, n, objectRef, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)editorImpl.offsetToLogicalPosition(winFormsParsingException2.getOffset()), (String)"offsetToLogicalPosition(...)");
                int n3 = editorImpl.getDocument().getLineStartOffset(logicalPosition.line);
                int n4 = editorImpl.getDocument().getLineEndOffset(logicalPosition.line);
                Intrinsics.checkNotNullExpressionValue((Object)editorImpl.getMarkupModel(), (String)"getMarkupModel(...)");
                RangeHighlighterEx rangeHighlighterEx = markupModelEx.addRangeHighlighterAndChangeAttributes(null, n3, n4, 1000, HighlighterTargetArea.LINES_IN_RANGE, false, arg_0 -> DesignerExceptionNotificationController.x(arg_0 -> DesignerExceptionNotificationController.x(winFormsParsingException2, objectRef2, designerExceptionBalloon, arg_0), arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterEx, (String)"addRangeHighlighterAndChangeAttributes(...)");
                RangeHighlighterEx rangeHighlighterEx2 = rangeHighlighterEx;
                lifetimeDefinition.onTermination(() -> DesignerExceptionNotificationController.x(markupModelEx, rangeHighlighterEx2, designerExceptionBalloon));
                collection2.add(designerExceptionBalloon);
            }
            objectRef3.element = (List)collection;
            DesignerExceptionNotificationController.x(intRef, n, (Ref.ObjectRef<List<DesignerExceptionBalloon>>)objectRef, (Ref.ObjectRef<DesignerExceptionBalloon>)objectRef2);
        }
    }

    private final void x(WinFormsExceptionInfo winFormsExceptionInfo) {
        WinFormsParsingException winFormsParsingException = (WinFormsParsingException)ArraysKt.firstOrNull((Object[])winFormsExceptionInfo.getExceptions());
        if (winFormsParsingException == null || (winFormsParsingException = winFormsParsingException.getException()) == null) {
            return;
        }
        WinFormsParsingException winFormsParsingException2 = winFormsParsingException;
        Notification notification2 = new Notification("WinFormsDesigner", winFormsParsingException2.getTitle(), winFormsParsingException2.getMessage(), NotificationType.ERROR);
        if (StringsKt.contains$default((CharSequence)winFormsParsingException2.getMessage(), (CharSequence)"<a href=", (boolean)false, (int)2, null)) {
            notification2.setListener((arg_0, arg_1) -> DesignerExceptionNotificationController.x(this, arg_0, arg_1));
        }
        Notifications.Bus.notify((Notification)notification2, (Project)this.project);
    }

    private static final Unit x(LifetimeDefinition lifetimeDefinition, DocumentEvent documentEvent) {
        Intrinsics.checkNotNullParameter((Object)documentEvent, (String)"it");
        LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit x(LifetimeDefinition lifetimeDefinition) {
        LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit x(LifetimeDefinition lifetimeDefinition, Unit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"it");
        LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit x(LifetimeDefinition lifetimeDefinition, WinFormsExceptionInfo winFormsExceptionInfo) {
        Intrinsics.checkNotNullParameter((Object)winFormsExceptionInfo, (String)"it");
        if (winFormsExceptionInfo.getPresentation() != FrontendExceptionPresentation.Message) {
            LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit G(LifetimeDefinition lifetimeDefinition) {
        LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final void x(Ref.IntRef intRef, int n, Ref.ObjectRef<List<DesignerExceptionBalloon>> objectRef, Ref.ObjectRef<DesignerExceptionBalloon> objectRef2) {
        ++intRef.element;
        if (intRef.element >= n) {
            intRef.element = 0;
        }
        DesignerExceptionBalloon designerExceptionBalloon = (DesignerExceptionBalloon)((List)objectRef.element).get(intRef.element);
        objectRef2.element = designerExceptionBalloon;
        designerExceptionBalloon.show();
    }

    private static final Unit x(Ref.ObjectRef objectRef, Ref.IntRef intRef, int n, Ref.ObjectRef objectRef2, Unit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"it");
        DesignerExceptionBalloon designerExceptionBalloon = (DesignerExceptionBalloon)objectRef.element;
        if (designerExceptionBalloon != null) {
            designerExceptionBalloon.hide();
        }
        DesignerExceptionNotificationController.x(intRef, n, (Ref.ObjectRef<List<DesignerExceptionBalloon>>)objectRef2, (Ref.ObjectRef<DesignerExceptionBalloon>)objectRef);
        return Unit.INSTANCE;
    }

    private static final Unit x(WinFormsParsingException winFormsParsingException, Ref.ObjectRef objectRef, DesignerExceptionBalloon designerExceptionBalloon, RangeHighlighterEx rangeHighlighterEx) {
        rangeHighlighterEx.setGutterIconRenderer((GutterIconRenderer)new DesignerExceptionBalloon.GutterRenderer(winFormsParsingException.getException().getTitle(), (Function0<Unit>)((Function0)() -> DesignerExceptionNotificationController.x(objectRef, designerExceptionBalloon))));
        return Unit.INSTANCE;
    }

    private static final Unit x(Ref.ObjectRef objectRef, DesignerExceptionBalloon designerExceptionBalloon) {
        DesignerExceptionBalloon designerExceptionBalloon2 = (DesignerExceptionBalloon)objectRef.element;
        if (designerExceptionBalloon2 != null) {
            designerExceptionBalloon2.hide();
        }
        designerExceptionBalloon.show();
        return Unit.INSTANCE;
    }

    private static final void x(Function1 function1, Object object) {
        function1.invoke(object);
    }

    private static final Unit x(MarkupModelEx markupModelEx, RangeHighlighterEx rangeHighlighterEx, DesignerExceptionBalloon designerExceptionBalloon) {
        markupModelEx.removeHighlighter((RangeHighlighter)rangeHighlighterEx);
        designerExceptionBalloon.hide();
        return Unit.INSTANCE;
    }

    private static final void x(DesignerExceptionNotificationController designerExceptionNotificationController, Notification notification2, HyperlinkEvent hyperlinkEvent) {
        Intrinsics.checkNotNullParameter((Object)notification2, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)hyperlinkEvent, (String)"hyperlinkEvent");
        if (!Intrinsics.areEqual((Object)hyperlinkEvent.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            return;
        }
        Iterable iterable = NotificationLinkHandler.Companion.getEP_NAME().getExtensionList();
        boolean bl = false;
        for (Object t : iterable) {
            NotificationLinkHandler notificationLinkHandler = (NotificationLinkHandler)t;
            boolean bl2 = false;
            Project project = designerExceptionNotificationController.project;
            String string = hyperlinkEvent.getDescription();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescription(...)");
            notificationLinkHandler.handleNotificationLink(project, string, hyperlinkEvent);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FrontendExceptionPresentation.values().length];
            try {
                nArray[FrontendExceptionPresentation.Message.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FrontendExceptionPresentation.Popup.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FrontendExceptionPresentation.Any.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

