/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.designers.winforms.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.impl.FailedEditorBuilder;
import com.intellij.openapi.fileEditor.impl.FailedEditorPaneKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.components.JBLoadingPanel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rider.RiderBundle;
import com.jetbrains.rider.designers.DesignerUtils;
import com.jetbrains.rider.designers.winforms.editor.WinFormsDesignerComponent;
import com.jetbrains.rider.designers.winforms.editor.WinFormsEditor;
import com.jetbrains.wormhole.awt.Wormhole;
import java.awt.BorderLayout;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000E\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\u0013\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0016H\u0002J\b\u0010\u001a\u001a\u00020\u0016H\u0016J\b\u0010\u001b\u001a\u00020\u0016H\u0016J\u0006\u0010\u001c\u001a\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/designers/winforms/editor/WinFormsDesignerComponent;", "Lcom/intellij/ui/components/JBLoadingPanel;", "editor", "Lcom/jetbrains/rider/designers/winforms/editor/WinFormsEditor;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "wormhole", "Lcom/jetbrains/wormhole/awt/Wormhole;", "WinFormsDesignerComponent", "(Lcom/jetbrains/rider/designers/winforms/editor/WinFormsEditor;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/wormhole/awt/Wormhole;)V", "focused", "Lcom/jetbrains/rd/util/reactive/Property;", "", "getFocused", "()Lcom/jetbrains/rd/util/reactive/Property;", "focusListenerAdded", "focusManager", "Lcom/intellij/openapi/wm/IdeFocusManager;", "focusListener", "com/jetbrains/rider/designers/winforms/editor/WinFormsDesignerComponent$focusListener$1", "Lcom/jetbrains/rider/designers/winforms/editor/WinFormsDesignerComponent$focusListener$1;", "paint", "", "g", "Ljava/awt/Graphics;", "x", "startLoading", "stopLoading", "markAsUnsupported", "intellij.rider"})
public final class WinFormsDesignerComponent
extends JBLoadingPanel {
    @NotNull
    private final WinFormsEditor editor;
    @NotNull
    private final Wormhole wormhole;
    @NotNull
    private final Property<Boolean> focused;
    private boolean focusListenerAdded;
    @NotNull
    private final IdeFocusManager focusManager;
    @NotNull
    private final focusListener.1 focusListener;

    public WinFormsDesignerComponent(@NotNull WinFormsEditor editor2, @NotNull Lifetime lifetime, @NotNull Wormhole wormhole) {
        Intrinsics.checkNotNullParameter((Object)((Object)editor2), (String)"editor");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)wormhole, (String)"wormhole");
        super((LayoutManager)new BorderLayout(), (Disposable)editor2, 0, 4, null);
        this.editor = editor2;
        this.wormhole = wormhole;
        this.focused = new Property((Object)false);
        IdeFocusManager ideFocusManager = IdeFocusManager.getInstance((Project)this.editor.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)ideFocusManager, (String)"getInstance(...)");
        this.focusManager = ideFocusManager;
        this.focusListener = new FocusListener(this){
            final /* synthetic */ WinFormsDesignerComponent this$0;
            {
                this.this$0 = $receiver;
            }

            public void focusLost(FocusEvent p0) {
                if (!Intrinsics.areEqual((Object)WinFormsDesignerComponent.access$getFocusManager$p(this.this$0).getFocusOwner(), (Object)WinFormsDesignerComponent.access$getEditor$p(this.this$0).getComponent())) {
                    this.this$0.getFocused().set((Object)false);
                }
            }

            public void focusGained(FocusEvent p0) {
                this.this$0.getFocused().set((Object)true);
            }
        };
        this.add(this.wormhole, "Center");
        this.startLoading();
        this.focused.advise(lifetime, arg_0 -> WinFormsDesignerComponent.x(this, arg_0));
    }

    @NotNull
    public final Property<Boolean> getFocused() {
        return this.focused;
    }

    public void paint(@Nullable Graphics g) {
        super.paint(g);
        if (!this.focusListenerAdded) {
            this.focusListenerAdded = true;
            this.x();
        }
    }

    private final void x() {
        this.requestFocusInWindow();
        this.addFocusListener(this.focusListener);
    }

    public void startLoading() {
        super.startLoading();
        this.wormhole.setVisible(false);
    }

    public void stopLoading() {
        this.wormhole.setVisible(true);
        super.stopLoading();
    }

    public final void markAsUnsupported() {
        this.stopLoading();
        this.remove(this.wormhole);
        this.add(FailedEditorPaneKt.failedEditorPane$default((String)RiderBundle.message("dialog.message.windows.forms.designer.not.supported.for.projects.targeting.net.core", new Object[0]), (boolean)false, null, arg_0 -> WinFormsDesignerComponent.x(this, arg_0), (int)4, null), "Center");
        this.revalidate();
        this.repaint();
    }

    private static final Unit x(WinFormsDesignerComponent winFormsDesignerComponent, boolean bl) {
        if (bl) {
            winFormsDesignerComponent.requestFocus();
        }
        return Unit.INSTANCE;
    }

    private static final Unit x(WinFormsDesignerComponent winFormsDesignerComponent, FailedEditorBuilder failedEditorBuilder) {
        Intrinsics.checkNotNullParameter((Object)failedEditorBuilder, (String)"$this$failedEditorPane");
        failedEditorBuilder.link(RiderBundle.message("link.label.switch.to.code.editor", new Object[0]), () -> WinFormsDesignerComponent.x(winFormsDesignerComponent));
        return Unit.INSTANCE;
    }

    private static final Unit x(WinFormsDesignerComponent winFormsDesignerComponent) {
        DesignerUtils.INSTANCE.tryOpenTab(winFormsDesignerComponent.editor, "text-editor");
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ IdeFocusManager access$getFocusManager$p(WinFormsDesignerComponent $this) {
        return $this.focusManager;
    }

    public static final /* synthetic */ WinFormsEditor access$getEditor$p(WinFormsDesignerComponent $this) {
        return $this.editor;
    }
}

