/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.designers.resx.grid.table;

import com.intellij.util.ui.JBUI;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rider.designers.resx.grid.ResxComponent;
import com.jetbrains.rider.designers.resx.grid.data.OnDemandData;
import com.jetbrains.rider.designers.resx.grid.data.OnDemandDataChangeListener;
import com.jetbrains.rider.designers.resx.grid.renderers.ResxEditor;
import com.jetbrains.rider.designers.resx.grid.table.CustomTableColumn;
import com.jetbrains.rider.designers.resx.grid.table.EditingController;
import com.jetbrains.rider.designers.resx.grid.table.ResxTableModel;
import com.jetbrains.rider.model.BeDataGrid;
import com.jetbrains.rider.model.BeDataGridColumnDefinition;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b0\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0016\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ \u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\t2\b\u0010*\u001a\u0004\u0018\u00010+R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010 R\u000e\u0010#\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/jetbrains/rider/designers/resx/grid/table/ResxController;", "", "component", "Lcom/jetbrains/rider/designers/resx/grid/ResxComponent;", "viewModel", "Lcom/jetbrains/rider/model/BeDataGrid;", "visibleArea", "Lcom/jetbrains/rd/util/reactive/IProperty;", "Lkotlin/Pair;", "", "loadingProperty", "Lcom/jetbrains/rd/util/reactive/Property;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "ResxController", "(Lcom/jetbrains/rider/designers/resx/grid/ResxComponent;Lcom/jetbrains/rider/model/BeDataGrid;Lcom/jetbrains/rd/util/reactive/IProperty;Lcom/jetbrains/rd/util/reactive/Property;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "getComponent", "()Lcom/jetbrains/rider/designers/resx/grid/ResxComponent;", "getViewModel", "()Lcom/jetbrains/rider/model/BeDataGrid;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "onDemandDataChangeListener", "Lcom/jetbrains/rider/designers/resx/grid/data/OnDemandDataChangeListener;", "onDemandData", "Lcom/jetbrains/rider/designers/resx/grid/data/OnDemandData;", "editingController", "Lcom/jetbrains/rider/designers/resx/grid/table/EditingController;", "tableModel", "Lcom/jetbrains/rider/designers/resx/grid/table/ResxTableModel;", "getTableModel", "()Lcom/jetbrains/rider/designers/resx/grid/table/ResxTableModel;", "firstColumnTableModel", "getFirstColumnTableModel", "currentLt", "reset", "", "cnt", "editingStopped", "rowIndex", "columnIndex", "value", "", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nResxController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResxController.kt\ncom/jetbrains/rider/designers/resx/grid/table/ResxController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1878#2,3:62\n*S KotlinDebug\n*F\n+ 1 ResxController.kt\ncom/jetbrains/rider/designers/resx/grid/table/ResxController\n*L\n33#1:62,3\n*E\n"})
public final class ResxController {
    @NotNull
    private final ResxComponent component;
    @NotNull
    private final BeDataGrid viewModel;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final OnDemandDataChangeListener onDemandDataChangeListener;
    @NotNull
    private final OnDemandData onDemandData;
    @NotNull
    private final EditingController editingController;
    @NotNull
    private final ResxTableModel tableModel;
    @NotNull
    private final ResxTableModel firstColumnTableModel;
    @NotNull
    private Lifetime currentLt;

    public ResxController(@NotNull ResxComponent component2, @NotNull BeDataGrid viewModel, @NotNull IProperty<Pair<Integer, Integer>> visibleArea, @NotNull Property<Boolean> loadingProperty, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        Intrinsics.checkNotNullParameter(visibleArea, (String)"visibleArea");
        Intrinsics.checkNotNullParameter(loadingProperty, (String)"loadingProperty");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.component = component2;
        this.viewModel = viewModel;
        this.lifetime = lifetime;
        this.onDemandDataChangeListener = new OnDemandDataChangeListener();
        this.onDemandData = new OnDemandData(this.viewModel, visibleArea, loadingProperty, this.onDemandDataChangeListener, this.lifetime, 0, 32, null);
        this.editingController = new EditingController(this, this.onDemandData, this.lifetime);
        this.tableModel = new ResxTableModel(this.onDemandData, this.editingController);
        this.firstColumnTableModel = new ResxTableModel(this.onDemandData, this.editingController);
        this.currentLt = this.lifetime;
        Object object = new ResxTableModel[]{this.tableModel, this.firstColumnTableModel};
        this.onDemandDataChangeListener.setTables(CollectionsKt.listOf((Object[])object));
        object = this.viewModel.getConfiguration().getColumnDefinitions();
        boolean bl = false;
        int n = 0;
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            ResxEditor resxEditor;
            int n2;
            Object t = iterator2.next();
            if ((n2 = n++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            BeDataGridColumnDefinition beDataGridColumnDefinition = (BeDataGridColumnDefinition)t;
            int n3 = n2;
            boolean bl2 = false;
            ResxEditor resxEditor2 = resxEditor = beDataGridColumnDefinition.getEditable() ? this.editingController.getEditor() : null;
            if (n3 == 0) {
                int n4 = JBUI.scale((int)350);
                CustomTableColumn customTableColumn = new CustomTableColumn(n3, n4, this.editingController.getRenderer(), resxEditor, beDataGridColumnDefinition.getRtl());
                customTableColumn.setHeaderValue(beDataGridColumnDefinition.getColumnName());
                this.firstColumnTableModel.addColumn(customTableColumn);
                customTableColumn.setPreferredWidth(n4);
                continue;
            }
            CustomTableColumn customTableColumn = new CustomTableColumn(n3, JBUI.scale((int)200), this.editingController.getRenderer(), resxEditor, beDataGridColumnDefinition.getRtl());
            customTableColumn.setHeaderValue(beDataGridColumnDefinition.getColumnName());
            this.tableModel.addColumn(customTableColumn);
        }
    }

    @NotNull
    public final ResxComponent getComponent() {
        return this.component;
    }

    @NotNull
    public final BeDataGrid getViewModel() {
        return this.viewModel;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final ResxTableModel getTableModel() {
        return this.tableModel;
    }

    @NotNull
    public final ResxTableModel getFirstColumnTableModel() {
        return this.firstColumnTableModel;
    }

    public final void reset(int cnt, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.currentLt = lifetime;
        this.editingController.reset();
        this.onDemandData.reset(cnt, lifetime);
    }

    public final void editingStopped(int rowIndex, int columnIndex, @Nullable String value2) {
        this.editingController.editingStopped(rowIndex, columnIndex, value2);
    }
}

