/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.designers;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.designers.DesignerEditorBase;
import com.jetbrains.rider.designers.DesignerUtils;
import com.jetbrains.rider.model.RdProjectFileDescriptor;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH&\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H&J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0004R$\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0007j\b\u0012\u0004\u0012\u00028\u0000`\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/designers/DesignerEditorProviderBase;", "T", "Lcom/jetbrains/rider/designers/DesignerEditorBase;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "DesignerEditorProviderBase", "()V", "openedDesignerEditors", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getOpenedDesignerEditors", "()Ljava/util/HashSet;", "createDesignerEditor", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)Lcom/jetbrains/rider/designers/DesignerEditorBase;", "isDesignerNodeDescriptor", "", "descriptor", "Lcom/jetbrains/rider/model/RdProjectFileDescriptor;", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "disposeEditor", "", "editor", "isDesignerNode", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nDesignerEditorProviderBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesignerEditorProviderBase.kt\ncom/jetbrains/rider/designers/DesignerEditorProviderBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n1761#2,3:55\n*S KotlinDebug\n*F\n+ 1 DesignerEditorProviderBase.kt\ncom/jetbrains/rider/designers/DesignerEditorProviderBase\n*L\n46#1:55,3\n*E\n"})
public abstract class DesignerEditorProviderBase<T extends DesignerEditorBase>
implements FileEditorProvider {
    @NotNull
    private final HashSet<T> openedDesignerEditors = new HashSet();

    public DesignerEditorProviderBase() {
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect();
        Topic topic = ProjectManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ProjectManagerListener(){

            public void projectClosed(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                this.getOpenedDesignerEditors().removeIf(arg_0 -> 1.x(arg_0 -> 1.x(project, arg_0), arg_0));
            }

            private static final boolean x(Project project, DesignerEditorBase designerEditorBase) {
                return Intrinsics.areEqual((Object)designerEditorBase.getProject(), (Object)project);
            }

            private static final boolean x(Function1 function1, Object object) {
                return (Boolean)function1.invoke(object);
            }
        });
    }

    @NotNull
    protected final HashSet<T> getOpenedDesignerEditors() {
        return this.openedDesignerEditors;
    }

    @NotNull
    public abstract T createDesignerEditor(@NotNull Project var1, @NotNull VirtualFile var2);

    public abstract boolean isDesignerNodeDescriptor(@NotNull RdProjectFileDescriptor var1);

    @NotNull
    public final FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        T t = this.createDesignerEditor(project, file2);
        CollectionExKt.addUnique((Collection)this.openedDesignerEditors, (Lifetime)((DesignerEditorBase)((Object)t)).getLifetime(), t);
        SwingUtilities.invokeLater(() -> DesignerEditorProviderBase.x(file2, project));
        return (FileEditor)t;
    }

    public void disposeEditor(@NotNull FileEditor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        TypeIntrinsics.asMutableCollection((Object)this.openedDesignerEditors).remove(editor2);
    }

    protected final boolean isDesignerNode(@NotNull Project project, @NotNull VirtualFile file2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Iterable iterable = WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)WorkspaceModel.Companion.getInstance(project), (VirtualFile)file2, (Project)project);
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object t : iterable) {
                    ProjectModelEntity projectModelEntity = (ProjectModelEntity)t;
                    boolean bl3 = false;
                    RdProjectModelItemDescriptor rdProjectModelItemDescriptor = projectModelEntity.getDescriptor();
                    if (!(rdProjectModelItemDescriptor instanceof RdProjectFileDescriptor ? this.isDesignerNodeDescriptor((RdProjectFileDescriptor)rdProjectModelItemDescriptor) : false)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final void x(VirtualFile virtualFile, Project project) {
        DesignerUtils.INSTANCE.renameDefaultEditor(virtualFile, project);
    }
}

