/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.visualizers.collections;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.debugger.IDotNetValue;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.statistics.VisualizerContentType;
import com.jetbrains.rider.debugger.visualizers.RiderDebuggerPresenterTab;
import com.jetbrains.rider.debugger.visualizers.RiderDebuggerPresenterTabWithStats;
import com.jetbrains.rider.debugger.visualizers.RiderDebuggerValuePresenter;
import com.jetbrains.rider.debugger.visualizers.collections.RiderDebuggerCollectionGridCreator;
import com.jetbrains.rider.debugger.visualizers.collections.RiderDebuggerCollectionPresenterKt;
import com.jetbrains.rider.model.debuggerWorker.ObjectPropertiesBase;
import com.jetbrains.rider.model.debuggerWorker.ObjectPropertiesProxy;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016JH\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J(\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0015H\u0016\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/debugger/visualizers/collections/RiderDebuggerCollectionPresenter;", "Lcom/jetbrains/rider/debugger/visualizers/RiderDebuggerValuePresenter;", "RiderDebuggerCollectionPresenter", "()V", "isApplicable", "", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "properties", "Lcom/jetbrains/rider/model/debuggerWorker/ObjectPropertiesProxy;", "place", "Lcom/intellij/xdebugger/frame/XValuePlace;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "createTabs", "", "Lcom/jetbrains/rider/debugger/visualizers/RiderDebuggerPresenterTab;", "value", "Lcom/jetbrains/rider/debugger/IDotNetValue;", "Lcom/jetbrains/rider/model/debuggerWorker/ObjectPropertiesBase;", "stringPresentation", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "shouldIgnorePropertiesReevaluation", "getPriority", "", "getLinkName", "intellij.rider"})
public final class RiderDebuggerCollectionPresenter
implements RiderDebuggerValuePresenter {
    @Override
    public boolean isApplicable(@NotNull XValueNode node, @NotNull ObjectPropertiesProxy properties, @NotNull XValuePlace place, @NotNull XDebugSession session) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return properties.getCanBeShownAsTable() && Registry.Companion.is("rider.debugger.enable.collections.visualizers");
    }

    @Override
    @NotNull
    public List<RiderDebuggerPresenterTab> createTabs(@NotNull IDotNetValue value2, @NotNull XValueNode node, @NotNull ObjectPropertiesBase properties, @Nullable String stringPresentation, @NotNull XValuePlace place, @NotNull XDebugSession session, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        RiderDebuggerCollectionGridCreator riderDebuggerCollectionGridCreator = (RiderDebuggerCollectionGridCreator)session.getProject().getService(RiderDebuggerCollectionGridCreator.class);
        JComponent jComponent = riderDebuggerCollectionGridCreator.create(value2, node, session, lifetime, RiderDebuggerCollectionPresenterKt.access$getLogger$p());
        String string = RiderDebuggerBundle.Companion.message("RiderCollectionAsTablePresenter.tab.name.text", new Object[0]);
        return CollectionsKt.listOf((Object)new RiderDebuggerPresenterTabWithStats(string, "collectionVisualizer", jComponent, VisualizerContentType.Collection));
    }

    @Override
    public boolean shouldIgnorePropertiesReevaluation(@NotNull XValueNode node, @NotNull ObjectPropertiesProxy properties, @NotNull XValuePlace place, @NotNull XDebugSession session) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return true;
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    @NotNull
    public String getLinkName() {
        return RiderDebuggerBundle.Companion.message("collection.presenter.explore.link", new Object[0]);
    }
}

