/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.visualizers;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.impl.ui.visualizedtext.VisualizedTextPopupUtil;
import com.intellij.xdebugger.ui.VisualizedContentTab;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.debugger.DotNetValueUtilsKt;
import com.jetbrains.rider.debugger.IDotNetValue;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.visualizers.RiderDebuggerPresenterTab;
import com.jetbrains.rider.debugger.visualizers.RiderDebuggerValuePresenter;
import com.jetbrains.rider.model.debuggerWorker.ObjectPropertiesBase;
import com.jetbrains.rider.model.debuggerWorker.ObjectPropertiesProxy;
import com.jetbrains.rider.model.debuggerWorker.ValueFlags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016JH\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J(\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0015H\u0016\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/debugger/visualizers/RiderDebuggerStringPresenter;", "Lcom/jetbrains/rider/debugger/visualizers/RiderDebuggerValuePresenter;", "RiderDebuggerStringPresenter", "()V", "isApplicable", "", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "properties", "Lcom/jetbrains/rider/model/debuggerWorker/ObjectPropertiesProxy;", "place", "Lcom/intellij/xdebugger/frame/XValuePlace;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "createTabs", "", "Lcom/jetbrains/rider/debugger/visualizers/RiderDebuggerPresenterTab;", "value", "Lcom/jetbrains/rider/debugger/IDotNetValue;", "Lcom/jetbrains/rider/model/debuggerWorker/ObjectPropertiesBase;", "stringPresentation", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "shouldIgnorePropertiesReevaluation", "getPriority", "", "getLinkName", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderDebuggerStringPresenter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderDebuggerStringPresenter.kt\ncom/jetbrains/rider/debugger/visualizers/RiderDebuggerStringPresenter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n1563#2:53\n1634#2,3:54\n*S KotlinDebug\n*F\n+ 1 RiderDebuggerStringPresenter.kt\ncom/jetbrains/rider/debugger/visualizers/RiderDebuggerStringPresenter\n*L\n35#1:53\n35#1:54,3\n*E\n"})
public final class RiderDebuggerStringPresenter
implements RiderDebuggerValuePresenter {
    @Override
    public boolean isApplicable(@NotNull XValueNode node, @NotNull ObjectPropertiesProxy properties, @NotNull XValuePlace place, @NotNull XDebugSession session) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return properties.getValueFlags().contains(ValueFlags.EllipsizedValue) || properties.getValueFlags().contains(ValueFlags.IsString) && !properties.getValueFlags().contains(ValueFlags.IsNull);
    }

    @Override
    @NotNull
    public List<RiderDebuggerPresenterTab> createTabs(@NotNull IDotNetValue value2, @NotNull XValueNode node, @NotNull ObjectPropertiesBase properties, @Nullable String stringPresentation, @NotNull XValuePlace place, @NotNull XDebugSession session, @NotNull Lifetime lifetime) {
        String string;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        if (properties.getValueFlags().contains(ValueFlags.IsNull)) {
            v0 = null;
        } else {
            v0 = stringPresentation;
            if (v0 == null) {
                v0 = string = DotNetValueUtilsKt.getSimplePresentation(properties.getValue());
            }
        }
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        Disposable disposable = LifetimeDisposableExKt.createNestedDisposable((Lifetime)lifetime, (String)("Debug value " + value2.getObjectProxy().getName() + " lifetime disposable"));
        Project project = session.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Iterable iterable = VisualizedTextPopupUtil.INSTANCE.collectVisualizedTabs(project, string, disposable);
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            Pair pair = (Pair)t;
            Collection collection2 = collection;
            boolean bl3 = false;
            VisualizedContentTab visualizedContentTab = (VisualizedContentTab)pair.component1();
            JComponent jComponent = (JComponent)pair.component2();
            String string2 = visualizedContentTab.getName();
            String string3 = visualizedContentTab.getId();
            collection2.add(new RiderDebuggerPresenterTab(jComponent, visualizedContentTab, string2, string3){
                final /* synthetic */ VisualizedContentTab $xtab;
                {
                    this.$xtab = $xtab;
                    super($super_call_param$1, $super_call_param$2, $component);
                }

                public void onShown(Project project, boolean firstTime) {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    this.$xtab.onShown(project, firstTime);
                }
            });
        }
        return (List)collection;
    }

    @Override
    public boolean shouldIgnorePropertiesReevaluation(@NotNull XValueNode node, @NotNull ObjectPropertiesProxy properties, @NotNull XValuePlace place, @NotNull XDebugSession session) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return properties.getValueFlags().contains(ValueFlags.IsString) && !properties.getValueFlags().contains(ValueFlags.EllipsizedValue);
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    @NotNull
    public String getLinkName() {
        return RiderDebuggerBundle.Companion.message("debugger.action.link.view", new Object[0]);
    }
}

