/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.tasksView.shared.graph;

import com.jetbrains.rider.debugger.tasksView.shared.graph.ParallelTasksNode;
import com.jetbrains.rider.debugger.tasksView.shared.graph.TaskNode;
import com.jetbrains.rider.debugger.tasksView.shared.graph.frames.plain.execution.ExecutionInfo;
import com.jetbrains.rider.debugger.tasksView.shared.graph.frames.plain.nodes.ThreadFrameNode;
import com.jetbrains.rider.model.debuggerWorker.RdTasksViewNode;
import com.jetbrains.rider.model.debuggerWorker.RdThreadNode;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0006\u0010\u0010\u001a\u00020\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/debugger/tasksView/shared/graph/ThreadNode;", "Lcom/jetbrains/rider/debugger/tasksView/shared/graph/ParallelTasksNode;", "Lcom/jetbrains/rider/debugger/tasksView/shared/graph/frames/plain/nodes/ThreadFrameNode;", "rdNode", "Lcom/jetbrains/rider/model/debuggerWorker/RdThreadNode;", "ThreadNode", "(Lcom/jetbrains/rider/model/debuggerWorker/RdThreadNode;)V", "getRdNode", "()Lcom/jetbrains/rider/model/debuggerWorker/RdThreadNode;", "createFrameNode", "executionInfo", "Lcom/jetbrains/rider/debugger/tasksView/shared/graph/frames/plain/execution/ExecutionInfo;", "threadId", "", "getThreadId", "()J", "waitsForTask", "Lcom/jetbrains/rider/debugger/tasksView/shared/graph/TaskNode;", "equals", "", "other", "", "hashCode", "", "intellij.rider"})
public final class ThreadNode
extends ParallelTasksNode<ThreadFrameNode> {
    @NotNull
    private final RdThreadNode rdNode;
    private final long threadId;

    public ThreadNode(@NotNull RdThreadNode rdNode) {
        Intrinsics.checkNotNullParameter((Object)rdNode, (String)"rdNode");
        super((RdTasksViewNode)rdNode);
        this.rdNode = rdNode;
        this.threadId = this.getRdNode().getExecutionInfo().getThreadId();
    }

    @NotNull
    public RdThreadNode getRdNode() {
        return this.rdNode;
    }

    @Override
    @NotNull
    public ThreadFrameNode createFrameNode(@NotNull ExecutionInfo executionInfo) {
        Intrinsics.checkNotNullParameter((Object)executionInfo, (String)"executionInfo");
        return new ThreadFrameNode(this, executionInfo);
    }

    public final long getThreadId() {
        return this.threadId;
    }

    @NotNull
    public final TaskNode waitsForTask() {
        Collection collection = this.getOutEdges();
        if (collection.size() != 1) {
            throw new IllegalArgumentException("A thread must wait for exactly one node");
        }
        Object object = CollectionsKt.single((Iterable)collection);
        TaskNode taskNode = object instanceof TaskNode ? (TaskNode)object : null;
        if (taskNode == null) {
            throw new IllegalArgumentException("A thread must wait only for a task");
        }
        return taskNode;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.jetbrains.rider.debugger.tasksView.shared.graph.ThreadNode");
        ThreadNode cfr_ignored_0 = (ThreadNode)object2;
        return this.threadId == ((ThreadNode)other).threadId;
    }

    public int hashCode() {
        return Long.hashCode(this.threadId);
    }
}

