/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.tasksView.shared;

import com.jetbrains.rider.debugger.DotNetStackFrame;
import com.jetbrains.rider.debugger.tasksView.shared.ThreadInfo;
import com.jetbrains.rider.debugger.tasksView.shared.graph.frames.plain.execution.ExecutionInfoVisitor;
import com.jetbrains.rider.debugger.tasksView.shared.graph.frames.plain.execution.FrameExecutionInfo;
import com.jetbrains.rider.debugger.tasksView.shared.graph.frames.plain.nodes.ParallelTasksFrameNode;
import com.jetbrains.rider.model.debuggerWorker.ThreadProxy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/debugger/tasksView/shared/ThreadExtractor;", "Lcom/jetbrains/rider/debugger/tasksView/shared/graph/frames/plain/execution/ExecutionInfoVisitor;", "Lcom/jetbrains/rider/debugger/tasksView/shared/ThreadInfo;", "ThreadExtractor", "()V", "getThreadInfo", "frameNode", "Lcom/jetbrains/rider/debugger/tasksView/shared/graph/frames/plain/nodes/ParallelTasksFrameNode;", "visit", "executionInfo", "Lcom/jetbrains/rider/debugger/tasksView/shared/graph/frames/plain/execution/FrameExecutionInfo;", "intellij.rider"})
public final class ThreadExtractor
implements ExecutionInfoVisitor<ThreadInfo> {
    @NotNull
    public static final ThreadExtractor INSTANCE = new ThreadExtractor();

    private ThreadExtractor() {
    }

    @Nullable
    public final ThreadInfo getThreadInfo(@NotNull ParallelTasksFrameNode frameNode) {
        Intrinsics.checkNotNullParameter((Object)frameNode, (String)"frameNode");
        return (ThreadInfo)frameNode.getExecutionInfo().visit(this);
    }

    @Override
    @Nullable
    public ThreadInfo visit(@NotNull FrameExecutionInfo executionInfo) {
        Intrinsics.checkNotNullParameter((Object)executionInfo, (String)"executionInfo");
        if (executionInfo.isAsync()) {
            return null;
        }
        DotNetStackFrame dotNetStackFrame = executionInfo.getStackFrame();
        ThreadProxy threadProxy = dotNetStackFrame.getStack().getThreadProxy();
        boolean bl = false;
        String string = !StringsKt.isBlank((CharSequence)threadProxy.getDisplayName()) ? "(" + threadProxy.getDisplayName() + ")" : null;
        String string2 = string == null ? String.valueOf(threadProxy.getThreadId()) : threadProxy.getThreadId() + " (" + threadProxy.getDisplayName() + ")";
        boolean bl2 = Intrinsics.areEqual((Object)threadProxy.isFrozen().getValueOrNull(), (Object)true);
        return new ThreadInfo(string2, bl2);
    }
}

