/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.tasksView;

import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.xdebugger.impl.parallelStacks.base.ParallelStacksLayer;
import com.intellij.xdebugger.impl.parallelStacks.base.ParallelStacksOverlayUI;
import com.intellij.xdebugger.impl.parallelStacks.base.ViewState;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.debugger.statistics.RiderTasksViewStatisticsCollector;
import com.jetbrains.rider.debugger.tasksView.TasksViewSubView;
import com.jetbrains.rider.debugger.tasksView.shared.graph.TasksInfo;
import com.jetbrains.rider.debugger.tasksView.ui.TasksViewOverlayUI;
import com.jetbrains.rider.debugger.tasksView.ui.TasksViewWithFloatingToolbar;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006J\u0006\u0010\u0019\u001a\u00020\u0017J\u0006\u0010\u001a\u001a\u00020\u0017J\u0006\u0010\u001b\u001a\u00020\u0017J\u0006\u0010\u001c\u001a\u00020\u0017J\u0006\u0010\u001d\u001a\u00020\u0017J\u0006\u0010\u001e\u001a\u00020\u0017J\u000e\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006#"}, d2={"Lcom/jetbrains/rider/debugger/tasksView/SubViews;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "subViews", "", "Lcom/jetbrains/rider/debugger/tasksView/TasksViewSubView;", "SubViews", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/util/List;)V", "component", "Lcom/jetbrains/rider/debugger/tasksView/ui/TasksViewWithFloatingToolbar;", "layer", "Lcom/intellij/xdebugger/impl/parallelStacks/base/ParallelStacksLayer;", "mainComponent", "Ljavax/swing/JLayer;", "Ljavax/swing/JComponent;", "getMainComponent", "()Ljavax/swing/JLayer;", "value", "currentView", "getCurrentView", "()Lcom/jetbrains/rider/debugger/tasksView/TasksViewSubView;", "selectView", "", "view", "showLoadingScreen", "suspend", "showUnsupported", "showUnavailable", "showError", "stop", "resume", "info", "Lcom/jetbrains/rider/debugger/tasksView/shared/graph/TasksInfo;", "getAll", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nSubViews.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubViews.kt\ncom/jetbrains/rider/debugger/tasksView/SubViews\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1869#2,2:62\n1869#2,2:64\n*S KotlinDebug\n*F\n+ 1 SubViews.kt\ncom/jetbrains/rider/debugger/tasksView/SubViews\n*L\n32#1:62,2\n49#1:64,2\n*E\n"})
public final class SubViews {
    @NotNull
    private final List<TasksViewSubView> subViews;
    @NotNull
    private final TasksViewWithFloatingToolbar component;
    @NotNull
    private final ParallelStacksLayer layer;
    @NotNull
    private final JLayer<JComponent> mainComponent;
    @NotNull
    private TasksViewSubView currentView;

    public SubViews(@NotNull Lifetime lifetime, @NotNull List<? extends TasksViewSubView> subViews) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(subViews, (String)"subViews");
        this.subViews = subViews;
        this.component = new TasksViewWithFloatingToolbar(this.subViews, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null));
        this.layer = new ParallelStacksLayer((JComponent)((Object)this.component), (ParallelStacksOverlayUI)new TasksViewOverlayUI());
        this.mainComponent = this.layer.getMainComponent();
        this.currentView = (TasksViewSubView)CollectionsKt.first(this.subViews);
    }

    @NotNull
    public final JLayer<JComponent> getMainComponent() {
        return this.mainComponent;
    }

    @NotNull
    public final TasksViewSubView getCurrentView() {
        return this.currentView;
    }

    public final void selectView(@NotNull TasksViewSubView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.currentView = view;
        this.component.selectSubView(view);
        RiderTasksViewStatisticsCollector.INSTANCE.subViewSelected(view.getId());
    }

    public final void showLoadingScreen() {
        this.layer.setState(ViewState.Loading);
    }

    public final void suspend() {
        Iterable iterable = this.subViews;
        boolean bl = false;
        for (Object t : iterable) {
            TasksViewSubView tasksViewSubView = (TasksViewSubView)t;
            boolean bl2 = false;
            tasksViewSubView.suspend();
        }
        this.layer.setState(ViewState.Paused);
    }

    public final void showUnsupported() {
        this.layer.setState(ViewState.Unsupported);
    }

    public final void showUnavailable() {
        this.layer.setState(ViewState.Unavailable);
    }

    public final void showError() {
        this.layer.setState(ViewState.Error);
    }

    public final void stop() {
        Iterable iterable = this.subViews;
        boolean bl = false;
        for (Object t : iterable) {
            TasksViewSubView tasksViewSubView = (TasksViewSubView)t;
            boolean bl2 = false;
            tasksViewSubView.stop();
        }
        this.layer.setState(ViewState.Stopped);
    }

    public final void resume(@NotNull TasksInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.currentView.resume(info);
        ViewState viewState = info.isEmpty() ? ViewState.Empty : ViewState.Ready;
        this.layer.setState(viewState);
    }

    @NotNull
    public final List<TasksViewSubView> getAll() {
        return this.subViews;
    }
}

