/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.statistics;

import com.jetbrains.rider.debugger.DotNetDebugProcess;
import com.jetbrains.rider.debugger.DotNetDebugSessionInfo;
import com.jetbrains.rider.debugger.statistics.RiderDebuggerStatisticsCollector;
import com.jetbrains.rider.debugger.statistics.RiderDebuggerStatisticsUtilKt;
import com.jetbrains.rider.debugger.statistics.RiderDebuggerSteppingTrackerKt;
import com.jetbrains.rider.debugger.statistics.SteppingType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0006\u0010\u000f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/debugger/statistics/RiderDebuggerSteppingTracker;", "", "debugProcess", "Lcom/jetbrains/rider/debugger/DotNetDebugProcess;", "RiderDebuggerSteppingTracker", "(Lcom/jetbrains/rider/debugger/DotNetDebugProcess;)V", "trackerLock", "currentSteppingRequestNanoTimeMillis", "", "Ljava/lang/Long;", "currentSteppingType", "Lcom/jetbrains/rider/debugger/statistics/SteppingType;", "registerSteppingStart", "", "steppingType", "onNextPause", "intellij.rider"})
public final class RiderDebuggerSteppingTracker {
    @NotNull
    private final DotNetDebugProcess debugProcess;
    @NotNull
    private final Object trackerLock;
    @Nullable
    private Long currentSteppingRequestNanoTimeMillis;
    @Nullable
    private SteppingType currentSteppingType;

    public RiderDebuggerSteppingTracker(@NotNull DotNetDebugProcess debugProcess) {
        Intrinsics.checkNotNullParameter((Object)((Object)debugProcess), (String)"debugProcess");
        this.debugProcess = debugProcess;
        this.trackerLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerSteppingStart(@NotNull SteppingType steppingType) {
        Intrinsics.checkNotNullParameter((Object)((Object)steppingType), (String)"steppingType");
        Object object = this.trackerLock;
        synchronized (object) {
            boolean bl = false;
            if (this.currentSteppingRequestNanoTimeMillis != null) {
                RiderDebuggerSteppingTrackerKt.access$getLogger$p().warn("There's another active stepping request, the debugger state is invalid");
            }
            this.currentSteppingType = steppingType;
            this.currentSteppingRequestNanoTimeMillis = System.nanoTime();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onNextPause() {
        Object object = this.trackerLock;
        synchronized (object) {
            Object object2;
            boolean bl = false;
            long l = System.nanoTime();
            Long l2 = this.currentSteppingRequestNanoTimeMillis;
            if (l2 == null) {
                return;
            }
            long l3 = l2;
            this.currentSteppingRequestNanoTimeMillis = null;
            SteppingType steppingType = this.currentSteppingType;
            if (steppingType == null) {
                SteppingType steppingType2 = SteppingType.Over;
                object2 = steppingType2;
                boolean bl2 = false;
                RiderDebuggerSteppingTrackerKt.access$getLogger$p().error("Stepping type is not expected to be null");
                steppingType = steppingType2;
            }
            SteppingType steppingType3 = steppingType;
            this.currentSteppingType = null;
            long l4 = (l - l3) / 1000000L;
            object2 = (DotNetDebugSessionInfo)this.debugProcess.getSessionInfo().getValueOrNull();
            if (object2 == null) {
                RiderDebuggerSteppingTrackerKt.access$getLogger$p().error("Session info is unavailable");
                return;
            }
            RiderDebuggerStatisticsCollector.INSTANCE.onSteppingCompleted(this.debugProcess.getProject(), l4, steppingType3, RiderDebuggerStatisticsUtilKt.getRuntime(((DotNetDebugSessionInfo)object2).getInfo()));
            Unit unit = Unit.INSTANCE;
        }
    }
}

