/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.statistics;

import com.intellij.execution.configurations.RunProfileState;
import com.intellij.internal.statistic.IdeActivityDefinition;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.ClassEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.debugger.DotNetDebugProcess;
import com.jetbrains.rider.debugger.DotNetDebugSessionInfo;
import com.jetbrains.rider.debugger.DotnetDebuggerExtKt;
import com.jetbrains.rider.debugger.statistics.DFAState;
import com.jetbrains.rider.debugger.statistics.MixedModeType;
import com.jetbrains.rider.debugger.statistics.OSType;
import com.jetbrains.rider.debugger.statistics.RiderDebuggerStatisticsUtilKt;
import com.jetbrains.rider.debugger.statistics.RuntimeType;
import com.jetbrains.rider.debugger.statistics.StatisticsEvaluationResultKind;
import com.jetbrains.rider.debugger.statistics.SteppingType;
import com.jetbrains.rider.debugger.statistics.VisualizerContentType;
import com.jetbrains.rider.model.debuggerWorker.StatisticsKind;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0013J&\u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\nJ\u0016\u0010)\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010&\u001a\u00020\u0016J\u0016\u0010*\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010+\u001a\u00020\u001aJ\u001e\u0010,\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200J\u001a\u00101\u001a\u0002022\u0006\u0010\"\u001a\u00020#2\n\u00103\u001a\u0006\u0012\u0002\b\u000304J&\u00105\u001a\u00020!2\u0006\u00106\u001a\u0002022\u0006\u00107\u001a\u00020\b2\u0006\u0010(\u001a\u00020\n2\u0006\u00108\u001a\u00020\fJ\b\u00109\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\n0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001d0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/jetbrains/rider/debugger/statistics/RiderDebuggerStatisticsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "RiderDebuggerStatisticsCollector", "()V", "RUN_PROFILE_STATE_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/ClassEventField;", "DFA_STATE_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lcom/jetbrains/rider/debugger/statistics/DFAState;", "RUNTIME_FIELD", "Lcom/jetbrains/rider/debugger/statistics/RuntimeType;", "MIXED_MODE_FIELD", "Lcom/jetbrains/rider/debugger/statistics/MixedModeType;", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getGROUP$intellij_rider", "()Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "VIEW_LINK_HIT", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "Lcom/jetbrains/rider/debugger/statistics/VisualizerContentType;", "STEPPING_COMPLETED", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "", "Lcom/jetbrains/rider/debugger/statistics/SteppingType;", "SMART_STEPPING_INFO_COLLECTED", "DFA_SWITCHED_WITHIN_SESSION", "", "EVALUATED", "Lcom/jetbrains/rider/debugger/statistics/StatisticsEvaluationResultKind;", "Lcom/jetbrains/rider/debugger/statistics/OSType;", "STARTUP_ACTIVITY", "Lcom/intellij/internal/statistic/IdeActivityDefinition;", "logViewLinkHit", "", "project", "Lcom/intellij/openapi/project/Project;", "contentType", "onSteppingCompleted", "durationMillis", "steppingType", "runtime", "onSmartStepIntoCollected", "dfaSwitchedWithinSession", "enabled", "logEvaluated", "session", "Lcom/intellij/xdebugger/XDebugSession;", "kind", "Lcom/jetbrains/rider/model/debuggerWorker/StatisticsKind;", "initializeDebuggerStartupActivity", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "runProfileStateClass", "Ljava/lang/Class;", "finishStartupActivity", "startupActivity", "dfaState", "mixedModeType", "getGroup", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderDebuggerStatisticsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderDebuggerStatisticsCollector.kt\ncom/jetbrains/rider/debugger/statistics/RiderDebuggerStatisticsCollector\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,132:1\n13#2:133\n13#3:134\n*S KotlinDebug\n*F\n+ 1 RiderDebuggerStatisticsCollector.kt\ncom/jetbrains/rider/debugger/statistics/RiderDebuggerStatisticsCollector\n*L\n114#1:133\n114#1:134\n*E\n"})
public final class RiderDebuggerStatisticsCollector
extends CounterUsagesCollector {
    @NotNull
    public static final RiderDebuggerStatisticsCollector INSTANCE = new RiderDebuggerStatisticsCollector();
    @NotNull
    private static final ClassEventField RUN_PROFILE_STATE_FIELD = EventFields.Class((String)"RunProfileState");
    @NotNull
    private static final EnumEventField<DFAState> DFA_STATE_FIELD = EventFields.Enum$default((String)"dfaState", DFAState.class, null, (int)4, null);
    @NotNull
    private static final EnumEventField<RuntimeType> RUNTIME_FIELD = EventFields.Enum$default((String)"runtime", RuntimeType.class, null, (int)4, null);
    @NotNull
    private static final EnumEventField<MixedModeType> MIXED_MODE_FIELD = EventFields.Enum$default((String)"mixedMode", MixedModeType.class, null, (int)4, null);
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("rider.debug", 8, null, 4, null);
    @NotNull
    private static final EventId1<VisualizerContentType> VIEW_LINK_HIT = GROUP.registerEvent("view.link.hit", (EventField)EventFields.Enum$default((String)"contentType", VisualizerContentType.class, null, (int)4, null));
    @NotNull
    private static final EventId3<Long, SteppingType, RuntimeType> STEPPING_COMPLETED = GROUP.registerEvent("stepping.completed", (EventField)EventFields.DurationMs, (EventField)EventFields.Enum$default((String)"type", SteppingType.class, null, (int)4, null), (EventField)RUNTIME_FIELD);
    @NotNull
    private static final EventId1<Long> SMART_STEPPING_INFO_COLLECTED = GROUP.registerEvent("smart.stepping.info.collected", (EventField)EventFields.DurationMs);
    @NotNull
    private static final EventId1<Boolean> DFA_SWITCHED_WITHIN_SESSION = GROUP.registerEvent("dfa.switched.within.session", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId3<StatisticsEvaluationResultKind, RuntimeType, OSType> EVALUATED = GROUP.registerEvent("evaluated", (EventField)EventFields.Enum$default((String)"status", StatisticsEvaluationResultKind.class, null, (int)4, null), (EventField)RUNTIME_FIELD, (EventField)EventFields.Enum$default((String)"OS", OSType.class, null, (int)4, null));
    @NotNull
    private static final IdeActivityDefinition STARTUP_ACTIVITY;

    private RiderDebuggerStatisticsCollector() {
    }

    @NotNull
    public final EventLogGroup getGROUP$intellij_rider() {
        return GROUP;
    }

    public final void logViewLinkHit(@NotNull Project project, @NotNull VisualizerContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)contentType), (String)"contentType");
        VIEW_LINK_HIT.log(project, (Object)contentType);
    }

    public final void onSteppingCompleted(@NotNull Project project, long durationMillis, @NotNull SteppingType steppingType, @NotNull RuntimeType runtime) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)steppingType), (String)"steppingType");
        Intrinsics.checkNotNullParameter((Object)((Object)runtime), (String)"runtime");
        STEPPING_COMPLETED.log(project, (Object)durationMillis, (Object)steppingType, (Object)runtime);
    }

    public final void onSmartStepIntoCollected(@NotNull Project project, long durationMillis) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SMART_STEPPING_INFO_COLLECTED.log(project, (Object)durationMillis);
    }

    public final void dfaSwitchedWithinSession(@NotNull Project project, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DFA_SWITCHED_WITHIN_SESSION.log(project, (Object)enabled);
    }

    public final void logEvaluated(@NotNull Project project, @NotNull XDebugSession session, @NotNull StatisticsKind kind) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        DotNetDebugProcess dotNetDebugProcess = DotnetDebuggerExtKt.getDotnetDebugProcessOrThrow(session);
        SourceExKt.adviseNotNullOnce((ISource)((ISource)dotNetDebugProcess.getSessionInfo()), (Lifetime)dotNetDebugProcess.getSessionLifetime(), arg_0 -> RiderDebuggerStatisticsCollector.x(project, kind, arg_0));
    }

    @NotNull
    public final StructuredIdeActivity initializeDebuggerStartupActivity(@NotNull Project project, @NotNull Class<?> runProfileStateClass) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(runProfileStateClass, (String)"runProfileStateClass");
        return STARTUP_ACTIVITY.started(project, () -> RiderDebuggerStatisticsCollector.x(runProfileStateClass));
    }

    public final void finishStartupActivity(@NotNull StructuredIdeActivity startupActivity, @NotNull DFAState dfaState, @NotNull RuntimeType runtime, @NotNull MixedModeType mixedModeType) {
        Intrinsics.checkNotNullParameter((Object)startupActivity, (String)"startupActivity");
        Intrinsics.checkNotNullParameter((Object)((Object)dfaState), (String)"dfaState");
        Intrinsics.checkNotNullParameter((Object)((Object)runtime), (String)"runtime");
        Intrinsics.checkNotNullParameter((Object)((Object)mixedModeType), (String)"mixedModeType");
        startupActivity.finished(() -> RiderDebuggerStatisticsCollector.x(dfaState, runtime, mixedModeType));
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    private static final Unit x(Project project, StatisticsKind statisticsKind, DotNetDebugSessionInfo dotNetDebugSessionInfo) {
        Intrinsics.checkNotNullParameter((Object)dotNetDebugSessionInfo, (String)"it");
        EVALUATED.log(project, (Object)RiderDebuggerStatisticsUtilKt.toStatisticsModel(statisticsKind), (Object)RiderDebuggerStatisticsUtilKt.getRuntime(dotNetDebugSessionInfo.getInfo()), (Object)RiderDebuggerStatisticsUtilKt.toStatisticsModel(dotNetDebugSessionInfo.getInfo().getTargetProcessOS()));
        return Unit.INSTANCE;
    }

    private static final List x(Class clazz) {
        if (!RunProfileState.class.isAssignableFrom(clazz)) {
            boolean bl = false;
            boolean bl2 = false;
            Logger logger = Logger.getInstance(RiderDebuggerStatisticsCollector.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Class " + clazz.getName() + " is not instance of RunProfileState");
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)RUN_PROFILE_STATE_FIELD.with((Object)clazz));
    }

    private static final List x(DFAState dFAState, RuntimeType runtimeType, MixedModeType mixedModeType) {
        Object[] objectArray = new EventPair[]{DFA_STATE_FIELD.with((Object)dFAState), RUNTIME_FIELD.with((Object)runtimeType), MIXED_MODE_FIELD.with((Object)mixedModeType)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    static {
        EventField[] eventFieldArray = new EventField[]{RUN_PROFILE_STATE_FIELD};
        EventField[] eventFieldArray2 = eventFieldArray;
        eventFieldArray = new EventField[]{DFA_STATE_FIELD, RUNTIME_FIELD, MIXED_MODE_FIELD};
        STARTUP_ACTIVITY = EventLogGroup.registerIdeActivity$default((EventLogGroup)GROUP, (String)"launch", (EventField[])eventFieldArray2, (EventField[])eventFieldArray, null, (boolean)false, (int)24, null);
    }
}

