/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.multiPlatform.mac.runners;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.DefaultProgramRunnerKt;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.rider.debugger.DotNetRunnerBase;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.run.RiderAsyncProgramRunner;
import com.jetbrains.rider.run.configurations.multiPlatform.mac.MacRunConfiguration;
import com.jetbrains.rider.run.multiPlatform.mac.MacRunProfileState;
import java.io.File;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0094@\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/debugger/multiPlatform/mac/runners/MacProgramRunner;", "Lcom/jetbrains/rider/run/RiderAsyncProgramRunner;", "Lcom/intellij/execution/configurations/RunnerSettings;", "Lcom/jetbrains/rider/debugger/DotNetRunnerBase;", "MacProgramRunner", "()V", "canRun", "", "executorId", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "executeAsync", "Lcom/intellij/execution/ui/RunContentDescriptor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "(Lcom/intellij/execution/runners/ExecutionEnvironment;Lcom/intellij/execution/configurations/RunProfileState;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.rider"})
public final class MacProgramRunner
extends RiderAsyncProgramRunner<RunnerSettings>
implements DotNetRunnerBase {
    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile2) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)profile2, (String)"profile");
        return Intrinsics.areEqual((Object)executorId, (Object)"Run") && profile2 instanceof MacRunConfiguration && SystemInfo.isMac;
    }

    @Override
    @Nullable
    protected Object executeAsync(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state, @NotNull Continuation<? super RunContentDescriptor> $completion) {
        MacRunProfileState macRunProfileState = state instanceof MacRunProfileState ? (MacRunProfileState)state : null;
        if (macRunProfileState == null) {
            Object[] objectArray = new Object[]{state.getClass()};
            throw new CantRunException(RiderDebuggerBundle.Companion.message("dialog.message.this.run.profile.not.supported", objectArray));
        }
        MacRunProfileState macRunProfileState2 = macRunProfileState;
        if (!new File(macRunProfileState2.getMacExecutable().getExecutablePath()).exists()) {
            Object[] objectArray = new Object[]{macRunProfileState2.getMacExecutable().getExecutablePath()};
            throw new CantRunException(RiderDebuggerBundle.Companion.message("dialog.message.failed.to.launch.application.file.doesn.t.exist", objectArray));
        }
        GeneralCommandLine generalCommandLine = macRunProfileState2.getMacExecutable().getCommandLine();
        ColoredProcessHandler coloredProcessHandler = new ColoredProcessHandler(generalCommandLine);
        ExecutionResult executionResult = ((MacRunProfileState)state).execute((ProcessHandler)coloredProcessHandler);
        return DefaultProgramRunnerKt.showRunContent((ExecutionResult)executionResult, (ExecutionEnvironment)environment);
    }
}

