/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.memoryView;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.memory.ui.InstancesTree;
import com.intellij.xdebugger.memory.ui.InstancesViewBase;
import com.intellij.xdebugger.memory.utils.InstancesProvider;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rider.debugger.DotnetDebuggerExtKt;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.memoryView.DotNetMemoryViewValue;
import com.jetbrains.rider.debugger.memoryView.DotNetMemoryViewValueGroup;
import com.jetbrains.rider.debugger.memoryView.RiderAsyncInstancesProvider;
import com.jetbrains.rider.debugger.memoryView.RiderReferenceInfo;
import com.jetbrains.rider.model.debuggerWorker.ExecutionContextProxy;
import com.jetbrains.rider.model.debuggerWorker.GroupProxy;
import com.jetbrains.rider.model.debuggerWorker.ObjectEntityBase;
import com.jetbrains.rider.model.debuggerWorker.ObjectProxy;
import com.jetbrains.rider.ui.components.ComponentFactories;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0016\u001a\u00020\u000fH\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/debugger/memoryView/RiderInstancesView;", "Lcom/intellij/xdebugger/memory/ui/InstancesViewBase;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "instancesProvider", "Lcom/jetbrains/rider/debugger/memoryView/RiderAsyncInstancesProvider;", "executionContextProxy", "Lcom/jetbrains/rider/model/debuggerWorker/ExecutionContextProxy;", "totalCount", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "RiderInstancesView", "(Lcom/intellij/xdebugger/XDebugSession;Lcom/jetbrains/rider/debugger/memoryView/RiderAsyncInstancesProvider;Lcom/jetbrains/rider/model/debuggerWorker/ExecutionContextProxy;JLcom/jetbrains/rd/util/lifetime/Lifetime;)V", "instancesTree", "Lcom/intellij/xdebugger/memory/ui/InstancesTree;", "statusPanel", "Ljavax/swing/JPanel;", "statusLabel", "Ljavax/swing/JLabel;", "hyperlinkLabel", "Lcom/intellij/ui/HyperlinkLabel;", "getInstancesTree", "numberOfInstancesShown", "x", "Ljava/lang/Runnable;", "x", "", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderInstancesView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderInstancesView.kt\ncom/jetbrains/rider/debugger/memoryView/RiderInstancesView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,110:1\n1869#2,2:111\n13#3:113\n13#4:114\n*S KotlinDebug\n*F\n+ 1 RiderInstancesView.kt\ncom/jetbrains/rider/debugger/memoryView/RiderInstancesView\n*L\n77#1:111,2\n36#1:113\n36#1:114\n*E\n"})
public final class RiderInstancesView
extends InstancesViewBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final XDebugSession session;
    @NotNull
    private final RiderAsyncInstancesProvider instancesProvider;
    @NotNull
    private final ExecutionContextProxy executionContextProxy;
    private final long totalCount;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final InstancesTree instancesTree;
    @NotNull
    private final JPanel statusPanel;
    @NotNull
    private final JLabel statusLabel;
    @NotNull
    private final HyperlinkLabel hyperlinkLabel;
    private long numberOfInstancesShown;
    @NotNull
    private static final Logger logger;
    private static final int BORDER_LAYOUT_DEFAULT_GAP = 5;
    private static final long INSTANCES_BATCH_SIZE = 2000L;

    public RiderInstancesView(@NotNull XDebugSession session, @NotNull RiderAsyncInstancesProvider instancesProvider, @NotNull ExecutionContextProxy executionContextProxy, long totalCount, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)instancesProvider, (String)"instancesProvider");
        Intrinsics.checkNotNullParameter((Object)executionContextProxy, (String)"executionContextProxy");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        super((LayoutManager)new BorderLayout(0, JBUI.scale((int)5)), session, (InstancesProvider)instancesProvider);
        this.session = session;
        this.instancesProvider = instancesProvider;
        this.executionContextProxy = executionContextProxy;
        this.totalCount = totalCount;
        this.lifetime = lifetime;
        this.instancesTree = new InstancesTree(this.session.getProject(), (XDebuggerEditorsProvider)DotnetDebuggerExtKt.getDotnetDebugProcessOrThrow(this.session).getEditorsProvider(), this.getValueMarkers(this.session), this.x());
        this.statusPanel = new JPanel();
        this.statusLabel = new JLabel();
        this.hyperlinkLabel = ComponentFactories.Companion.hyperlinkLabel(RiderDebuggerBundle.Companion.message("RiderInstancesView.label.shown.more", new Object[0]), () -> RiderInstancesView.x(this));
        this.setLayout((LayoutManager)new MigLayout("ins 0, fill, flowy, gap " + JBUI.scale((int)5), "", "[][min!]"));
        this.add((Component)new JBScrollPane((Component)this.instancesTree), "grow");
        this.statusPanel.setLayout((LayoutManager)new HorizontalLayout(5, 0, 2, null));
        this.statusPanel.add(this.statusLabel);
        this.statusPanel.add((Component)this.hyperlinkLabel);
        this.add(this.statusPanel);
    }

    @NotNull
    protected InstancesTree getInstancesTree() {
        return this.instancesTree;
    }

    private final Runnable x() {
        return () -> RiderInstancesView.x(this);
    }

    private final void x() {
        Object[] objectArray = new Object[]{this.numberOfInstancesShown, this.totalCount};
        this.statusLabel.setText(RiderDebuggerBundle.Companion.message("RiderInstancesView.label.shown.0.1", objectArray));
        this.hyperlinkLabel.setVisible(this.numberOfInstancesShown < this.totalCount);
    }

    private static final Unit x(RiderInstancesView riderInstancesView) {
        riderInstancesView.x().run();
        return Unit.INSTANCE;
    }

    private static final void x(RiderInstancesView riderInstancesView) {
        long l = Math.min(2000L, riderInstancesView.totalCount - riderInstancesView.numberOfInstancesShown);
        if (!RLifetimeKt.isAlive((Lifetime)riderInstancesView.lifetime)) {
            return;
        }
        riderInstancesView.instancesProvider.getInstancesAsync(riderInstancesView.numberOfInstancesShown, l).onSuccess(arg_0 -> RiderInstancesView.x(arg_0 -> RiderInstancesView.x(riderInstancesView, l, arg_0), arg_0)).onError(arg_0 -> RiderInstancesView.G(RiderInstancesView::x, arg_0));
    }

    private static final Unit x(RiderInstancesView riderInstancesView, long l, List list2) {
        Intrinsics.checkNotNullParameter((Object)list2, (String)"it");
        XValueChildrenList xValueChildrenList = new XValueChildrenList();
        Iterable iterable = list2;
        boolean bl = false;
        for (Object t : iterable) {
            RiderReferenceInfo riderReferenceInfo = (RiderReferenceInfo)t;
            boolean bl2 = false;
            ObjectEntityBase objectEntityBase = riderReferenceInfo.getObjectEntity();
            ObjectEntityBase objectEntityBase2 = objectEntityBase;
            if (objectEntityBase2 instanceof GroupProxy) {
                DotNetMemoryViewValueGroup dotNetMemoryViewValueGroup = new DotNetMemoryViewValueGroup((GroupProxy)objectEntityBase, riderInstancesView.executionContextProxy, riderInstancesView.lifetime, riderInstancesView.session);
                if (((GroupProxy)objectEntityBase).isTop()) {
                    xValueChildrenList.addTopGroup((XValueGroup)dotNetMemoryViewValueGroup);
                    continue;
                }
                xValueChildrenList.addBottomGroup((XValueGroup)dotNetMemoryViewValueGroup);
                continue;
            }
            if (objectEntityBase2 instanceof ObjectProxy) {
                xValueChildrenList.add((XNamedValue)new DotNetMemoryViewValue((ObjectProxy)objectEntityBase, riderInstancesView.executionContextProxy, riderInstancesView.lifetime, riderInstancesView.session, null));
                continue;
            }
            throw new IllegalStateException("Unsupported value entity");
        }
        riderInstancesView.numberOfInstancesShown += l;
        riderInstancesView.x();
        riderInstancesView.instancesTree.addChildren(xValueChildrenList, riderInstancesView.numberOfInstancesShown >= riderInstancesView.totalCount);
        return Unit.INSTANCE;
    }

    private static final void x(Function1 function1, Object object) {
        function1.invoke(object);
    }

    private static final Unit x(Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"it");
        if (throwable instanceof ProcessCanceledException) {
            return Unit.INSTANCE;
        }
        logger.error(throwable);
        return Unit.INSTANCE;
    }

    private static final void G(Function1 function1, Object object) {
        function1.invoke(object);
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger = Logger.getInstance(RiderInstancesView.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RiderInstancesView.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/debugger/memoryView/RiderInstancesView$Companion;", "", "RiderInstancesView$Companion", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "BORDER_LAYOUT_DEFAULT_GAP", "", "INSTANCES_BATCH_SIZE", "", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

