/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.immediateWindow;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBSplitter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XSplitterWatchesViewImpl;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.jetbrains.rd.ide.model.ValuePresentationPartKind;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.debugger.DotNetDebuggerEditorsProvider;
import com.jetbrains.rider.debugger.DotNetStackFrame;
import com.jetbrains.rider.debugger.DotnetDebuggerExtKt;
import com.jetbrains.rider.debugger.evaluation.DotNetExpression;
import com.jetbrains.rider.debugger.evaluation.RiderExpressionUtilKt;
import com.jetbrains.rider.debugger.immediateWindow.ImmediateWindow;
import com.jetbrains.rider.debugger.immediateWindow.ImmediateWindowEvaluator;
import com.jetbrains.rider.debugger.immediateWindow.ImmediateWindowKt;
import com.jetbrains.rider.debugger.immediateWindow.ImmediateWindowOperations;
import com.jetbrains.rider.debugger.immediateWindow.ImmediateWindowStatistics;
import com.jetbrains.rider.debugger.immediateWindow.actions.ImmediateWindowCollapseExpandAction;
import com.jetbrains.rider.debugger.immediateWindow.consoleImpl.ImmediateWindowConsoleImpl;
import com.jetbrains.rider.languages.fileTypes.csharp.CSharpLanguage;
import com.jetbrains.rider.model.debuggerWorker.ImmediateEvaluationResult;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 72\u00020\u0001:\u0003789B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010+\u001a\u00020\u0017J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\u0006\u00100\u001a\u00020-J\u0006\u00101\u001a\u00020\u001dJ\u000e\u00102\u001a\u00020-2\u0006\u00103\u001a\u000204J\u0010\u00105\u001a\u00020-2\u0006\u00103\u001a\u000204H\u0016J\u0010\u00106\u001a\u00020-2\u0006\u00103\u001a\u000204H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010%\u001a\u00060&R\u00020\u0000X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u0006:"}, d2={"Lcom/jetbrains/rider/debugger/immediateWindow/ImmediateWindow;", "Lcom/jetbrains/rider/debugger/immediateWindow/ImmediateWindowOperations;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "sessionLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "debugTabLifetime", "immediateEvaluator", "Lcom/jetbrains/rider/debugger/immediateWindow/ImmediateWindowEvaluator;", "editorsProvider", "Lcom/jetbrains/rider/debugger/DotNetDebuggerEditorsProvider;", "ImmediateWindow", "(Lcom/intellij/xdebugger/XDebugSession;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rider/debugger/immediateWindow/ImmediateWindowEvaluator;Lcom/jetbrains/rider/debugger/DotNetDebuggerEditorsProvider;)V", "getSession", "()Lcom/intellij/xdebugger/XDebugSession;", "getSessionLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getDebugTabLifetime", "getImmediateEvaluator", "()Lcom/jetbrains/rider/debugger/immediateWindow/ImmediateWindowEvaluator;", "getEditorsProvider", "()Lcom/jetbrains/rider/debugger/DotNetDebuggerEditorsProvider;", "console", "Lcom/jetbrains/rider/debugger/immediateWindow/consoleImpl/ImmediateWindowConsoleImpl;", "consoleEditor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "getConsoleEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "isImmediateMode", "", "()Z", "collapseExpandAction", "Lcom/jetbrains/rider/debugger/immediateWindow/actions/ImmediateWindowCollapseExpandAction;", "getCollapseExpandAction", "()Lcom/jetbrains/rider/debugger/immediateWindow/actions/ImmediateWindowCollapseExpandAction;", "evalCounter", "Lcom/jetbrains/rider/debugger/immediateWindow/ImmediateWindow$EvalCounter;", "sandboxManager", "Lcom/jetbrains/rider/debugger/immediateWindow/ImmediateWindow$SandboxManager;", "getSandboxManager", "()Lcom/jetbrains/rider/debugger/immediateWindow/ImmediateWindow$SandboxManager;", "setSandboxManager", "(Lcom/jetbrains/rider/debugger/immediateWindow/ImmediateWindow$SandboxManager;)V", "createConsole", "applyCollapsedImmediateHeightChanges", "", "newHeight", "", "requestFocus", "consoleIsFocusOwner", "insertText", "text", "", "addWatch", "startEval", "Companion", "EvalCounter", "SandboxManager", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nImmediateWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImmediateWindow.kt\ncom/jetbrains/rider/debugger/immediateWindow/ImmediateWindow\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,277:1\n1#2:278\n*E\n"})
public final class ImmediateWindow
implements ImmediateWindowOperations {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final XDebugSession session;
    @NotNull
    private final Lifetime sessionLifetime;
    @NotNull
    private final Lifetime debugTabLifetime;
    @NotNull
    private final ImmediateWindowEvaluator immediateEvaluator;
    @NotNull
    private final DotNetDebuggerEditorsProvider editorsProvider;
    private ImmediateWindowConsoleImpl console;
    @NotNull
    private final ImmediateWindowCollapseExpandAction collapseExpandAction;
    @NotNull
    private final EvalCounter evalCounter;
    public SandboxManager sandboxManager;
    @NotNull
    public static final String stopOnBreakEventsKey = "debugger.immediate.window.stop.on.break.events";

    public ImmediateWindow(@NotNull XDebugSession session, @NotNull Lifetime sessionLifetime, @NotNull Lifetime debugTabLifetime, @NotNull ImmediateWindowEvaluator immediateEvaluator, @NotNull DotNetDebuggerEditorsProvider editorsProvider) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)sessionLifetime, (String)"sessionLifetime");
        Intrinsics.checkNotNullParameter((Object)debugTabLifetime, (String)"debugTabLifetime");
        Intrinsics.checkNotNullParameter((Object)immediateEvaluator, (String)"immediateEvaluator");
        Intrinsics.checkNotNullParameter((Object)((Object)editorsProvider), (String)"editorsProvider");
        this.session = session;
        this.sessionLifetime = sessionLifetime;
        this.debugTabLifetime = debugTabLifetime;
        this.immediateEvaluator = immediateEvaluator;
        this.editorsProvider = editorsProvider;
        XDebugSession xDebugSession = this.session;
        Intrinsics.checkNotNull((Object)xDebugSession, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.XDebugSessionImpl");
        this.collapseExpandAction = new ImmediateWindowCollapseExpandAction((XDebugSessionImpl)xDebugSession);
        this.evalCounter = new EvalCounter();
    }

    @NotNull
    public final XDebugSession getSession() {
        return this.session;
    }

    @NotNull
    public final Lifetime getSessionLifetime() {
        return this.sessionLifetime;
    }

    @NotNull
    public final Lifetime getDebugTabLifetime() {
        return this.debugTabLifetime;
    }

    @NotNull
    public final ImmediateWindowEvaluator getImmediateEvaluator() {
        return this.immediateEvaluator;
    }

    @NotNull
    public final DotNetDebuggerEditorsProvider getEditorsProvider() {
        return this.editorsProvider;
    }

    @NotNull
    public final EditorImpl getConsoleEditor() {
        ImmediateWindowConsoleImpl immediateWindowConsoleImpl = this.console;
        if (immediateWindowConsoleImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"console");
            immediateWindowConsoleImpl = null;
        }
        EditorEx editorEx = immediateWindowConsoleImpl.getConsoleEditor();
        Intrinsics.checkNotNull((Object)editorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        return (EditorImpl)editorEx;
    }

    public final boolean isImmediateMode() {
        return ImmediateWindowCollapseExpandAction.Companion.isExpanded();
    }

    @NotNull
    public final ImmediateWindowCollapseExpandAction getCollapseExpandAction() {
        return this.collapseExpandAction;
    }

    @NotNull
    public final SandboxManager getSandboxManager() {
        SandboxManager sandboxManager = this.sandboxManager;
        if (sandboxManager != null) {
            return sandboxManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"sandboxManager");
        return null;
    }

    public final void setSandboxManager(@NotNull SandboxManager sandboxManager) {
        Intrinsics.checkNotNullParameter((Object)sandboxManager, (String)"<set-?>");
        this.sandboxManager = sandboxManager;
    }

    @NotNull
    public final ImmediateWindowConsoleImpl createConsole() {
        Project project = this.session.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        AnAction[] anActionArray = new AnAction[]{this.collapseExpandAction};
        this.console = new ImmediateWindowConsoleImpl(project, this.collapseExpandAction.getExpanded(), this, anActionArray);
        ImmediateWindowKt.access$getLogger$p().debug("Immediate console created");
        ImmediateWindowConsoleImpl immediateWindowConsoleImpl = this.console;
        if (immediateWindowConsoleImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"console");
            immediateWindowConsoleImpl = null;
        }
        immediateWindowConsoleImpl.setEditable(false);
        ImmediateWindowConsoleImpl immediateWindowConsoleImpl2 = this.console;
        if (immediateWindowConsoleImpl2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"console");
            immediateWindowConsoleImpl2 = null;
        }
        this.immediateEvaluator.setConsole(immediateWindowConsoleImpl2);
        ImmediateWindowConsoleImpl immediateWindowConsoleImpl3 = this.console;
        if (immediateWindowConsoleImpl3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"console");
            immediateWindowConsoleImpl3 = null;
        }
        EditorEx editorEx = immediateWindowConsoleImpl3.getConsoleEditor();
        Intrinsics.checkNotNull((Object)editorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        this.immediateEvaluator.setEditor((EditorImpl)editorEx);
        this.debugTabLifetime.onTermination(() -> ImmediateWindow.G(this));
        this.setSandboxManager(new SandboxManager());
        this.sessionLifetime.onTermination(() -> ImmediateWindow.x(this));
        ImmediateWindowConsoleImpl immediateWindowConsoleImpl4 = this.console;
        if (immediateWindowConsoleImpl4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"console");
            immediateWindowConsoleImpl4 = null;
        }
        return immediateWindowConsoleImpl4;
    }

    @Override
    public void applyCollapsedImmediateHeightChanges(float newHeight) {
        this.collapseExpandAction.applyCollapsedImmediateHeightChanges(newHeight);
    }

    public final void requestFocus() {
        ImmediateWindowConsoleImpl immediateWindowConsoleImpl = this.console;
        if (immediateWindowConsoleImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"console");
            immediateWindowConsoleImpl = null;
        }
        immediateWindowConsoleImpl.getConsoleEditor().getContentComponent().requestFocus();
    }

    public final boolean consoleIsFocusOwner() {
        return this.getConsoleEditor().getContentComponent().isFocusOwner();
    }

    public final void insertText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (StringsKt.isBlank((CharSequence)text)) {
            return;
        }
        ImmediateWindowConsoleImpl immediateWindowConsoleImpl = this.console;
        if (immediateWindowConsoleImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"console");
            immediateWindowConsoleImpl = null;
        }
        immediateWindowConsoleImpl.setInputText(text);
        this.getConsoleEditor().getCaretModel().moveToOffset(text.length());
    }

    @Override
    public void addWatch(@NotNull String text) {
        XExpression xExpression;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (StringsKt.isBlank((CharSequence)text)) {
            DotNetExpression dotNetExpression;
            ImmediateWindowConsoleImpl immediateWindowConsoleImpl = this.console;
            if (immediateWindowConsoleImpl == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                immediateWindowConsoleImpl = null;
            }
            DotNetExpression dotNetExpression2 = immediateWindowConsoleImpl.getHistoryManager().getLastDotnetExpression();
            if (dotNetExpression2 != null) {
                DotNetExpression dotNetExpression3;
                DotNetExpression dotNetExpression4 = dotNetExpression3 = dotNetExpression2;
                boolean bl = false;
                RiderExpressionUtilKt.setNew(dotNetExpression4, true);
                dotNetExpression = dotNetExpression3;
            } else {
                dotNetExpression = null;
            }
            xExpression = (XExpression)dotNetExpression;
        } else {
            DotNetDebuggerEditorsProvider dotNetDebuggerEditorsProvider = DotnetDebuggerExtKt.getDotnetDebugProcessOrThrow(this.session).getEditorsProvider();
            Project project = this.session.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            DocumentEx documentEx = this.immediateEvaluator.getEditor().getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
            xExpression = dotNetDebuggerEditorsProvider.createExpression(project, (Document)documentEx, (Language)CSharpLanguage.INSTANCE, EvaluationMode.EXPRESSION);
        }
        if (xExpression == null) {
            return;
        }
        XExpression xExpression2 = xExpression;
        XDebugSession xDebugSession = this.session;
        Intrinsics.checkNotNull((Object)xDebugSession, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.XDebugSessionImpl");
        XDebugSessionImpl xDebugSessionImpl = (XDebugSessionImpl)xDebugSession;
        XDebugSessionTab xDebugSessionTab = xDebugSessionImpl.getSessionTab();
        if (xDebugSessionTab == null || (xDebugSessionTab = xDebugSessionTab.getWatchesView()) == null) {
            throw new IllegalStateException("Not null session tab is expected here");
        }
        XDebugSessionTab xDebugSessionTab2 = xDebugSessionTab;
        xDebugSessionTab2.addWatchExpression(xExpression2, -1, false);
    }

    @Override
    public void startEval(@NotNull String text) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Project project = this.session.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DocumentEx documentEx = this.immediateEvaluator.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        XExpression xExpression = this.editorsProvider.createExpression(project, (Document)documentEx, (Language)CSharpLanguage.INSTANCE, EvaluationMode.EXPRESSION);
        Intrinsics.checkNotNull((Object)xExpression, (String)"null cannot be cast to non-null type com.jetbrains.rider.debugger.evaluation.DotNetExpression");
        DotNetExpression dotNetExpression = (DotNetExpression)xExpression;
        int n = ThreadLocalRandom.current().nextInt();
        Object object = this.session.getCurrentStackFrame();
        DotNetStackFrame dotNetStackFrame = object instanceof DotNetStackFrame ? (DotNetStackFrame)object : null;
        Integer n2 = dotNetStackFrame != null && (dotNetStackFrame = dotNetStackFrame.getFrameProxy()) != null ? Integer.valueOf(dotNetStackFrame.getId()) : null;
        ImmediateWindowStatistics.INSTANCE.getSTART_IMMEDIATE_EVALUATION().log((Object)n);
        boolean bl2 = bl = n2 != null;
        if (_Assertions.ENABLED && !bl) {
            object = "Assertion failed";
            throw new AssertionError(object);
        }
        this.evalCounter.onStartEval();
        ImmediateWindowKt.access$getLogger$p().debug("Start evaluation");
        bl = PropertiesComponent.getInstance().getBoolean(stopOnBreakEventsKey, true);
        Integer n3 = n2;
        Intrinsics.checkNotNull((Object)n3);
        this.immediateEvaluator.evaluateAsync(n3, dotNetExpression, bl, n, (Function0<Unit>)((Function0)() -> ImmediateWindow.x(this, dotNetExpression))).then(arg_0 -> ImmediateWindow.x(arg_0 -> ImmediateWindow.x(this, n, arg_0), arg_0)).onError(arg_0 -> ImmediateWindow.x(arg_0 -> ImmediateWindow.x(n, this, arg_0), arg_0));
    }

    private static final Unit G(ImmediateWindow immediateWindow) {
        ImmediateWindowConsoleImpl immediateWindowConsoleImpl = immediateWindow.console;
        if (immediateWindowConsoleImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"console");
            immediateWindowConsoleImpl = null;
        }
        Disposer.dispose((Disposable)((Disposable)immediateWindowConsoleImpl));
        return Unit.INSTANCE;
    }

    private static final Unit x(ImmediateWindow immediateWindow) {
        ImmediateWindowConsoleImpl immediateWindowConsoleImpl = immediateWindow.console;
        if (immediateWindowConsoleImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"console");
            immediateWindowConsoleImpl = null;
        }
        immediateWindowConsoleImpl.deactivate();
        return Unit.INSTANCE;
    }

    private static final void x(ImmediateWindow immediateWindow, int n) {
        ImmediateWindowStatistics.INSTANCE.getEND_IMMEDIATE_EVALUATION().log((Object)n);
        if (immediateWindow.isImmediateMode()) {
            ImmediateWindowConsoleImpl immediateWindowConsoleImpl = immediateWindow.console;
            if (immediateWindowConsoleImpl == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                immediateWindowConsoleImpl = null;
            }
            immediateWindowConsoleImpl.getPlaceHolderManager().removePlaceHolderIfNeeded();
        }
        immediateWindow.evalCounter.onEndEval();
        if (PropertiesComponent.getInstance().getInt("immediate.window.eval.count.until.watch.got.it.hidden", 0) >= 3) {
            ImmediateWindowConsoleImpl immediateWindowConsoleImpl = immediateWindow.console;
            if (immediateWindowConsoleImpl == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                immediateWindowConsoleImpl = null;
            }
            immediateWindowConsoleImpl.getToolbarManager().addGotItPopup();
        }
    }

    private static final Unit x(ImmediateWindow immediateWindow, DotNetExpression dotNetExpression) {
        ImmediateWindowConsoleImpl immediateWindowConsoleImpl = immediateWindow.console;
        if (immediateWindowConsoleImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"console");
            immediateWindowConsoleImpl = null;
        }
        immediateWindowConsoleImpl.getHistoryManager().addToHistory(dotNetExpression);
        ImmediateWindowConsoleImpl immediateWindowConsoleImpl2 = immediateWindow.console;
        if (immediateWindowConsoleImpl2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"console");
            immediateWindowConsoleImpl2 = null;
        }
        immediateWindowConsoleImpl2.requestScrollingToEnd();
        if (immediateWindow.isImmediateMode()) {
            ImmediateWindowConsoleImpl immediateWindowConsoleImpl3 = immediateWindow.console;
            if (immediateWindowConsoleImpl3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                immediateWindowConsoleImpl3 = null;
            }
            immediateWindowConsoleImpl3.setInputText("");
        }
        return Unit.INSTANCE;
    }

    private static final Unit x(ImmediateWindow immediateWindow, int n, ImmediateEvaluationResult immediateEvaluationResult) {
        if (immediateEvaluationResult.getCreatedNewSyntheticVar()) {
            immediateWindow.getSandboxManager().recreateSandbox();
            ImmediateWindowConsoleImpl immediateWindowConsoleImpl = immediateWindow.console;
            if (immediateWindowConsoleImpl == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                immediateWindowConsoleImpl = null;
            }
            immediateWindowConsoleImpl.requestFocus();
            ImmediateWindowConsoleImpl immediateWindowConsoleImpl2 = immediateWindow.console;
            if (immediateWindowConsoleImpl2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                immediateWindowConsoleImpl2 = null;
            }
            immediateWindowConsoleImpl2.getConsoleEditor().getContentComponent().requestFocus();
        }
        ImmediateWindow.x(immediateWindow, n);
        immediateWindow.session.rebuildViews();
        String string = immediateWindow.evalCounter.getWasExtraEvalOnStop() ? "\n" : "";
        String string2 = string + immediateEvaluationResult.getResultOnConsole().getValue();
        if (immediateEvaluationResult.getResultOnConsole().getKind() == ValuePresentationPartKind.Error) {
            ImmediateWindowConsoleImpl immediateWindowConsoleImpl = immediateWindow.console;
            if (immediateWindowConsoleImpl == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                immediateWindowConsoleImpl = null;
            }
            immediateWindowConsoleImpl.getPrinter().printError(string2);
            ImmediateWindowKt.access$getLogger$p().debug("Error message with text: \"" + string2 + "\" was printed into history console");
        } else {
            ImmediateWindowConsoleImpl immediateWindowConsoleImpl = immediateWindow.console;
            if (immediateWindowConsoleImpl == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                immediateWindowConsoleImpl = null;
            }
            immediateWindowConsoleImpl.getPrinter().printSuccess(string2);
            ImmediateWindowKt.access$getLogger$p().debug("Success message with text: \"" + string2 + "\" was printed into history console");
        }
        return Unit.INSTANCE;
    }

    private static final Unit x(Function1 function1, Object object) {
        return (Unit)function1.invoke(object);
    }

    private static final Unit x(int n, ImmediateWindow immediateWindow, Throwable throwable) {
        if (throwable.getCause() instanceof CancellationException) {
            ImmediateWindowKt.access$getLogger$p().debug("Evaluation(" + n + ") was cancelled");
            ImmediateWindow.x(immediateWindow, "Request was cancelled");
        } else {
            String string = throwable.getMessage();
            Intrinsics.checkNotNull((Object)string);
            ImmediateWindow.x(immediateWindow, string);
            ImmediateWindowKt.access$getLogger$p().debug("Throws exception during evaluation, message: \"" + throwable.getMessage() + "\" (" + n + ")");
        }
        ImmediateWindow.x(immediateWindow, n);
        return Unit.INSTANCE;
    }

    private static final void x(ImmediateWindow immediateWindow, String string) {
        immediateWindow.session.rebuildViews();
        ImmediateWindowConsoleImpl immediateWindowConsoleImpl = immediateWindow.console;
        if (immediateWindowConsoleImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"console");
            immediateWindowConsoleImpl = null;
        }
        immediateWindowConsoleImpl.getPrinter().printError(string + "\n");
    }

    private static final void x(Function1 function1, Object object) {
        function1.invoke(object);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/debugger/immediateWindow/ImmediateWindow$Companion;", "", "ImmediateWindow$Companion", "()V", "stopOnBreakEventsKey", "", "getDebuggerSplitterSafe", "Lcom/intellij/ui/JBSplitter;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "getDebuggerSplitter", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final JBSplitter getDebuggerSplitterSafe(@NotNull XDebugSession session) {
            XSplitterWatchesViewImpl xSplitterWatchesViewImpl;
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            XDebugSessionTab xDebugSessionTab = ((XDebugSessionImpl)session).getSessionTab();
            if (xDebugSessionTab == null) {
                return null;
            }
            XDebugSessionTab xDebugSessionTab2 = xDebugSessionTab;
            XWatchesView xWatchesView = xDebugSessionTab2.getWatchesView();
            XSplitterWatchesViewImpl xSplitterWatchesViewImpl2 = xSplitterWatchesViewImpl = xWatchesView instanceof XSplitterWatchesViewImpl ? (XSplitterWatchesViewImpl)xWatchesView : null;
            return (JBSplitter)(xSplitterWatchesViewImpl2 != null ? xSplitterWatchesViewImpl2.getSplitter() : null);
        }

        @NotNull
        public final JBSplitter getDebuggerSplitter(@NotNull XDebugSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            JBSplitter jBSplitter = this.getDebuggerSplitterSafe(session);
            if (jBSplitter == null) {
                throw new IllegalStateException("Not null session tab is expected here");
            }
            return jBSplitter;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/debugger/immediateWindow/ImmediateWindow$EvalCounter;", "", "ImmediateWindow$EvalCounter", "()V", "lastStartedEvalIndex", "", "getLastStartedEvalIndex", "()I", "setLastStartedEvalIndex", "(I)V", "currentEvalIndex", "getCurrentEvalIndex", "setCurrentEvalIndex", "wasExtraEvalOnStop", "", "getWasExtraEvalOnStop", "()Z", "onStartEval", "", "onEndEval", "intellij.rider"})
    private static final class EvalCounter {
        private int lastStartedEvalIndex;
        private int currentEvalIndex;

        public final int getLastStartedEvalIndex() {
            return this.lastStartedEvalIndex;
        }

        public final void setLastStartedEvalIndex(int n) {
            this.lastStartedEvalIndex = n;
        }

        public final int getCurrentEvalIndex() {
            return this.currentEvalIndex;
        }

        public final void setCurrentEvalIndex(int n) {
            this.currentEvalIndex = n;
        }

        public final boolean getWasExtraEvalOnStop() {
            return this.currentEvalIndex != this.lastStartedEvalIndex;
        }

        public final void onStartEval() {
            int n = this.currentEvalIndex;
            this.currentEvalIndex = n + 1;
            this.lastStartedEvalIndex = n;
        }

        public final void onEndEval() {
            int n = this.currentEvalIndex;
            this.currentEvalIndex = n + -1;
            n = PropertiesComponent.getInstance().getInt("immediate.window.eval.count.until.watch.got.it.hidden", 0);
            if (n != -1) {
                PropertiesComponent.getInstance().setValue("immediate.window.eval.count.until.watch.got.it.hidden", n + 1, 0);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u0006\u0010\r\u001a\u00020\u000bJ\u0006\u0010\u000e\u001a\u00020\u000bJ\u0006\u0010\u000f\u001a\u00020\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/debugger/immediateWindow/ImmediateWindow$SandboxManager;", "", "ImmediateWindow$SandboxManager", "(Lcom/jetbrains/rider/debugger/immediateWindow/ImmediateWindow;)V", "sandboxAlreadyCreated", "", "getSandboxAlreadyCreated", "()Z", "setSandboxAlreadyCreated", "(Z)V", "disableEnableTypeHandler", "", "enable", "recreateSandboxIfNeeded", "recreateSandbox", "prepareSandboxBeforeCreating", "focusGained", "getFocusGained", "setFocusGained", "intellij.rider"})
    public final class SandboxManager {
        private boolean sandboxAlreadyCreated;
        private boolean focusGained;

        public SandboxManager() {
            FocusListener focusListener2 = new FocusListener(this){
                final /* synthetic */ SandboxManager this$0;
                {
                    this.this$0 = $receiver;
                }

                public void focusGained(FocusEvent e) {
                    this.this$0.setFocusGained(true);
                    this.this$0.recreateSandboxIfNeeded();
                }

                public void focusLost(FocusEvent e) {
                    this.this$0.setFocusGained(false);
                }
            };
            ImmediateWindowConsoleImpl immediateWindowConsoleImpl = ImmediateWindow.this.console;
            if (immediateWindowConsoleImpl == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                immediateWindowConsoleImpl = null;
            }
            immediateWindowConsoleImpl.getConsoleEditor().getContentComponent().addFocusListener(focusListener2);
            ImmediateWindow.this.getSessionLifetime().onTermination(() -> SandboxManager.x(ImmediateWindow.this, focusListener2));
            XDebugSessionListener xDebugSessionListener = new XDebugSessionListener(this, ImmediateWindow.this){
                final /* synthetic */ SandboxManager this$0;
                final /* synthetic */ ImmediateWindow this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public void sessionPaused() {
                    this.this$0.prepareSandboxBeforeCreating();
                    if (this.this$0.getFocusGained()) {
                        this.this$0.recreateSandbox();
                    }
                }

                public void sessionResumed() {
                    this.this$0.setSandboxAlreadyCreated(false);
                    ImmediateWindowConsoleImpl immediateWindowConsoleImpl = ImmediateWindow.access$getConsole$p(this.this$1);
                    if (immediateWindowConsoleImpl == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                        immediateWindowConsoleImpl = null;
                    }
                    immediateWindowConsoleImpl.setEditable(false);
                }

                public void stackFrameChanged() {
                    this.this$0.setSandboxAlreadyCreated(false);
                }
            };
            ImmediateWindow.this.getSession().addSessionListener(xDebugSessionListener, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)ImmediateWindow.this.getSessionLifetime(), null, (int)1, null));
        }

        public final boolean getSandboxAlreadyCreated() {
            return this.sandboxAlreadyCreated;
        }

        public final void setSandboxAlreadyCreated(boolean bl) {
            this.sandboxAlreadyCreated = bl;
        }

        public final void disableEnableTypeHandler(boolean enable) {
            ImmediateWindowConsoleImpl immediateWindowConsoleImpl;
            ImmediateWindowConsoleImpl immediateWindowConsoleImpl2 = ImmediateWindow.this.console;
            if (immediateWindowConsoleImpl2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                immediateWindowConsoleImpl2 = null;
            }
            Editor editor2 = immediateWindowConsoleImpl2.getEditor();
            Intrinsics.checkNotNull((Object)editor2);
            if (enable) {
                immediateWindowConsoleImpl = ImmediateWindow.this.console;
                if (immediateWindowConsoleImpl == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                    immediateWindowConsoleImpl = null;
                }
            } else {
                immediateWindowConsoleImpl = null;
            }
            editor2.putUserData(ConsoleViewImpl.CONSOLE_VIEW_IN_EDITOR_VIEW, immediateWindowConsoleImpl);
        }

        public final void recreateSandboxIfNeeded() {
            if (this.sandboxAlreadyCreated) {
                return;
            }
            this.recreateSandbox();
        }

        public final void recreateSandbox() {
            ImmediateWindow.this.getImmediateEvaluator().tryReCreateSandbox();
            this.sandboxAlreadyCreated = true;
            this.disableEnableTypeHandler(true);
        }

        public final void prepareSandboxBeforeCreating() {
            this.disableEnableTypeHandler(false);
            ImmediateWindowConsoleImpl immediateWindowConsoleImpl = ImmediateWindow.this.console;
            if (immediateWindowConsoleImpl == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                immediateWindowConsoleImpl = null;
            }
            immediateWindowConsoleImpl.setEditable(true);
        }

        public final boolean getFocusGained() {
            return this.focusGained;
        }

        public final void setFocusGained(boolean bl) {
            this.focusGained = bl;
        }

        private static final Unit x(ImmediateWindow immediateWindow, focusListener.1 var1_1) {
            ImmediateWindowConsoleImpl immediateWindowConsoleImpl = immediateWindow.console;
            if (immediateWindowConsoleImpl == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                immediateWindowConsoleImpl = null;
            }
            immediateWindowConsoleImpl.getConsoleEditor().getContentComponent().removeFocusListener(var1_1);
            return Unit.INSTANCE;
        }
    }
}

