/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.exception;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.swing.RdSwingKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IPropertyView;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.PropertyCombinatorsKt;
import com.jetbrains.rider.services.popups.nova.layouter.LayoutResult;
import com.jetbrains.rider.services.popups.nova.layouter.PopupLayouter;
import com.jetbrains.rider.services.popups.nova.layouter.PopupLayouterKt;
import com.jetbrains.rider.ui.components.balloon.SimpleBalloon;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001aJ\b\u0010\u001c\u001a\u00020\u001aH\u0002J\b\u0010\u001d\u001a\u00020\u001aH\u0014J\u0012\u0010\u001e\u001a\u00020\u001a2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\b\u0010!\u001a\u00020\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/rider/debugger/exception/EditorBalloonLayouter;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "balloon", "Lcom/jetbrains/rider/ui/components/balloon/SimpleBalloon;", "popupLayouter", "Lcom/jetbrains/rider/services/popups/nova/layouter/PopupLayouter;", "EditorBalloonLayouter", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/rider/ui/components/balloon/SimpleBalloon;Lcom/jetbrains/rider/services/popups/nova/layouter/PopupLayouter;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getBalloon", "()Lcom/jetbrains/rider/ui/components/balloon/SimpleBalloon;", "active", "Lcom/jetbrains/rd/util/reactive/Property;", "", "install", "", "uninstall", "G", "update", "x", "location", "Ljava/awt/Point;", "x", "intellij.rider"})
public class EditorBalloonLayouter {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Project project;
    @NotNull
    private final Editor editor;
    @NotNull
    private final SimpleBalloon balloon;
    @NotNull
    private final PopupLayouter popupLayouter;
    @NotNull
    private Property<Boolean> active;

    public EditorBalloonLayouter(@NotNull Lifetime lifetime, @NotNull Project project, @NotNull Editor editor2, @NotNull SimpleBalloon balloon, @NotNull PopupLayouter popupLayouter) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)balloon, (String)"balloon");
        Intrinsics.checkNotNullParameter((Object)popupLayouter, (String)"popupLayouter");
        this.lifetime = lifetime;
        this.project = project;
        this.editor = editor2;
        this.balloon = balloon;
        this.popupLayouter = popupLayouter;
        this.active = new Property((Object)false);
        RdSwingKt.sizeProperty((JComponent)this.balloon.getComponent()).advise(this.lifetime, arg_0 -> EditorBalloonLayouter.x(this, arg_0));
        this.active.view(this.lifetime, (arg_0, arg_1) -> EditorBalloonLayouter.G(this, arg_0, arg_1));
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final SimpleBalloon getBalloon() {
        return this.balloon;
    }

    public final void install() {
        this.active.set((Object)true);
    }

    public final void uninstall() {
        this.active.set((Object)false);
    }

    private final void G() {
        if (RLifetimeKt.isNotAlive((Lifetime)this.lifetime)) {
            return;
        }
        this.balloon.show();
    }

    protected void update() {
        LayoutResult layoutResult = (LayoutResult)this.popupLayouter.getLayout().getValue();
        this.x(layoutResult != null ? PopupLayouterKt.getLocation((LayoutResult)layoutResult) : null);
    }

    private final void x(Point point) {
        if (point == null) {
            return;
        }
        SwingUtilities.convertPointFromScreen(point, this.balloon.getComponent().getParent());
        this.balloon.getComponent().setLocation(point);
    }

    private final void x() {
        this.balloon.hide();
    }

    private static final Unit x(EditorBalloonLayouter editorBalloonLayouter, Dimension dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"it");
        editorBalloonLayouter.popupLayouter.getSize().set((Object)dimension);
        return Unit.INSTANCE;
    }

    private static final Unit G(EditorBalloonLayouter editorBalloonLayouter, Lifetime lifetime, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lt");
        if (!bl) {
            return Unit.INSTANCE;
        }
        editorBalloonLayouter.popupLayouter.getLayout().advise(lifetime, arg_0 -> EditorBalloonLayouter.x(editorBalloonLayouter, arg_0));
        PropertyCombinatorsKt.map((IPropertyView)((IPropertyView)editorBalloonLayouter.popupLayouter.getLayout()), EditorBalloonLayouter::x).view(lifetime, (arg_0, arg_1) -> EditorBalloonLayouter.x(editorBalloonLayouter, arg_0, arg_1));
        editorBalloonLayouter.update();
        return Unit.INSTANCE;
    }

    private static final Unit x(EditorBalloonLayouter editorBalloonLayouter, LayoutResult layoutResult) {
        editorBalloonLayouter.update();
        return Unit.INSTANCE;
    }

    private static final boolean x(LayoutResult layoutResult) {
        return layoutResult != null;
    }

    private static final Unit x(EditorBalloonLayouter editorBalloonLayouter, Lifetime lifetime, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"sbslt");
        if (bl) {
            editorBalloonLayouter.G();
        } else {
            editorBalloonLayouter.x();
        }
        return Unit.INSTANCE;
    }
}

