/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.evaluators;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBTabbedPane;
import com.jetbrains.rider.debugger.visualizers.RiderDebuggerPresenterTab;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/debugger/evaluators/TabsSelectionListener;", "Ljavax/swing/event/ChangeListener;", "project", "Lcom/intellij/openapi/project/Project;", "panel", "Lcom/intellij/ui/components/JBTabbedPane;", "presenterObjectSelectionKey", "", "tabs", "", "Lcom/jetbrains/rider/debugger/visualizers/RiderDebuggerPresenterTab;", "TabsSelectionListener", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ui/components/JBTabbedPane;Ljava/lang/String;[Lcom/jetbrains/rider/debugger/visualizers/RiderDebuggerPresenterTab;)V", "[Lcom/jetbrains/rider/debugger/visualizers/RiderDebuggerPresenterTab;", "reportedTabs", "", "getReportedTabs", "()Ljava/util/Set;", "stateChanged", "", "e", "Ljavax/swing/event/ChangeEvent;", "x", "newSelectedIndex", "", "intellij.rider"})
final class TabsSelectionListener
implements ChangeListener {
    @NotNull
    private final Project project;
    @NotNull
    private final JBTabbedPane panel;
    @NotNull
    private final String presenterObjectSelectionKey;
    @NotNull
    private final RiderDebuggerPresenterTab[] tabs;
    @NotNull
    private final Set<String> reportedTabs;

    public TabsSelectionListener(@NotNull Project project, @NotNull JBTabbedPane panel2, @NotNull String presenterObjectSelectionKey, @NotNull RiderDebuggerPresenterTab[] tabs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)presenterObjectSelectionKey, (String)"presenterObjectSelectionKey");
        Intrinsics.checkNotNullParameter((Object)tabs, (String)"tabs");
        this.project = project;
        this.panel = panel2;
        this.presenterObjectSelectionKey = presenterObjectSelectionKey;
        this.tabs = tabs;
        this.reportedTabs = new LinkedHashSet();
        this.x(this.panel.getModel().getSelectedIndex());
    }

    @NotNull
    public final Set<String> getReportedTabs() {
        return this.reportedTabs;
    }

    @Override
    public void stateChanged(@Nullable ChangeEvent e) {
        int n = this.panel.getSelectedIndex();
        if (n < 0 || n >= this.tabs.length) {
            return;
        }
        this.x(n);
    }

    private final void x(int n) {
        RiderDebuggerPresenterTab riderDebuggerPresenterTab = this.tabs[n];
        PropertiesComponent.getInstance().setValue(this.presenterObjectSelectionKey, riderDebuggerPresenterTab.getId());
        boolean bl = this.reportedTabs.add(riderDebuggerPresenterTab.getId());
        riderDebuggerPresenterTab.onShown(this.project, bl);
    }
}

