/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.editor;

import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsCollectorImpl;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsEventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultCompactActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.JBColor;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.paint.RectanglePainter2D;
import com.intellij.util.ApplicationKt;
import com.intellij.util.IconUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.actions.RunToCursorAction;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.actions.RiderActionsBundle;
import com.jetbrains.rider.debugger.DotNetDebugProcess;
import com.jetbrains.rider.debugger.DotNetExecutionStack;
import com.jetbrains.rider.debugger.DotnetDebuggerExtKt;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.actions.RiderJumpToStatementAction;
import com.jetbrains.rider.debugger.editor.EmptyInlayRenderer;
import com.jetbrains.rider.debugger.editor.RiderRunToPopupManagerKt;
import com.jetbrains.rider.debugger.util.DotNetDebugProcessUtilKt;
import com.jetbrains.rider.debugger.util.JumpToStatementUtilKt;
import com.jetbrains.rider.editors.PlatformTextControlUtilsKt;
import com.jetbrains.rider.util.idea.ExtensionsKt;
import icons.ReSharperIcons;
import icons.RiderIcons;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u0000 :2\u00020\u0001:\u0002:;B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\t2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002002\u0006\u00102\u001a\u00020\u00152\u0006\u00103\u001a\u00020\u0015H\u0002J\u0010\u00104\u001a\u00020-2\u0006\u00105\u001a\u000206H\u0002J.\u00107\u001a\u00020-2\u0006\u0010.\u001a\u00020\t2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002002\u0006\u00102\u001a\u00020\u00152\u0006\u00103\u001a\u00020\u0015J\u0010\u00108\u001a\u00020-2\b\b\u0002\u00109\u001a\u00020)R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\"\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010&\u001a\u0004\u0018\u00010\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u001eR\u0014\u0010(\u001a\u00020)8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006<"}, d2={"Lcom/jetbrains/rider/debugger/editor/RiderRunToPopupManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "RiderRunToPopupManager", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "currentEditor", "Lcom/intellij/openapi/editor/Editor;", "getCurrentEditor", "()Lcom/intellij/openapi/editor/Editor;", "setCurrentEditor", "(Lcom/intellij/openapi/editor/Editor;)V", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "getPosition", "()Lcom/intellij/xdebugger/XSourcePosition;", "setPosition", "(Lcom/intellij/xdebugger/XSourcePosition;)V", "visualLine", "", "getVisualLine", "()I", "setVisualLine", "(I)V", "value", "Lcom/jetbrains/rider/debugger/DotNetDebugProcess;", "debugProcessForPanel", "getDebugProcessForPanel", "()Lcom/jetbrains/rider/debugger/DotNetDebugProcess;", "popupMenu", "Lcom/intellij/openapi/actionSystem/ActionPopupMenu;", "runToIconComponent", "Lcom/jetbrains/rider/debugger/editor/RiderRunToPopupManager$ScalableIconComponent;", "jumpToIconComponent", "component", "Ljavax/swing/JComponent;", "currentDebugProcess", "x", "currentlyCanSetNextStatement", "", "x", "()Z", "x", "", "editor", "prefixWidth", "", "fullWidth", "lineY", "scrolledOffset", "x", "id", "", "showPanel", "hidePanel", "hideComponent", "Companion", "ScalableIconComponent", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderRunToPopupManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderRunToPopupManager.kt\ncom/jetbrains/rider/debugger/editor/RiderRunToPopupManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,350:1\n67#2,4:351\n67#2,4:357\n67#2,4:361\n67#2,4:365\n1869#3,2:355\n1869#3,2:369\n*S KotlinDebug\n*F\n+ 1 RiderRunToPopupManager.kt\ncom/jetbrains/rider/debugger/editor/RiderRunToPopupManager\n*L\n159#1:351,4\n195#1:357,4\n225#1:361,4\n245#1:365,4\n185#1:355,2\n254#1:369,2\n*E\n"})
public final class RiderRunToPopupManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private Editor currentEditor;
    @Nullable
    private XSourcePosition position;
    private int visualLine;
    @Nullable
    private DotNetDebugProcess debugProcessForPanel;
    @NotNull
    private final ActionPopupMenu popupMenu;
    @NotNull
    private final ScalableIconComponent runToIconComponent;
    @NotNull
    private final ScalableIconComponent jumpToIconComponent;
    @NotNull
    private final JComponent component;
    private static final int LAYER_INDEX = 3;
    private static final float OPACITY = 0.4f;

    public RiderRunToPopupManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.visualLine = -1;
        Icon icon = RiderIcons.Debugger.RunToHere;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"RunToHere");
        this.runToIconComponent = new ScalableIconComponent(icon, RiderDebuggerBundle.Companion.message("RiderRunToPopupManager.tooltip.run.to.here", new Object[0]), (Function0<Unit>)((Function0)() -> RiderRunToPopupManager.G(this)));
        Icon icon2 = ReSharperIcons.Debugger.SetNextStatement;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"SetNextStatement");
        this.jumpToIconComponent = new ScalableIconComponent(icon2, RiderDebuggerBundle.Companion.message("RiderRunToPopupManager.tooltip.skip.to.here", new Object[0]), (Function0<Unit>)((Function0)() -> RiderRunToPopupManager.x(this)));
        AnAction[] anActionArray = new AnAction[1];
        String string = RiderActionsBundle.Companion.message("RiderRunToPopupManager.action.settings.text", new Object[0]);
        anActionArray[0] = new AnAction(string){

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ShowSettingsUtilImpl.Companion.showSettingsDialog(this.getProject(), "project.propDebugger", "Show floating debugger actions");
            }
        };
        ActionPopupMenu actionPopupMenu = ActionManager.getInstance().createActionPopupMenu("debugger.editor.popup", (ActionGroup)new DefaultCompactActionGroup(anActionArray));
        Intrinsics.checkNotNullExpressionValue((Object)actionPopupMenu, (String)"createActionPopupMenu(...)");
        this.popupMenu = actionPopupMenu;
        GridLayout gridLayout = new GridLayout(1, 2);
        this.component = new JPanel(this, gridLayout){
            {
                this.add($receiver.jumpToIconComponent);
                this.add($receiver.runToIconComponent);
                this.setOpaque(false);
                3.x(this, (Function1<? super JComponent, Unit>)((Function1)arg_0 -> 3.x($receiver, arg_0)));
            }

            @Override
            public void addMouseListener(MouseListener l) {
            }

            @Override
            public void addMouseMotionListener(MouseMotionListener l) {
            }

            private static final void x(JComponent jComponent, Function1<? super JComponent, Unit> function1) {
                function1.invoke((Object)jComponent);
                Component[] componentArray = jComponent.getComponents();
                Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
                Object object = componentArray;
                boolean bl = false;
                Object object2 = object;
                Collection collection = new ArrayList();
                boolean bl2 = false;
                for (Object object3 : object2) {
                    if (!(object3 instanceof JComponent)) continue;
                    collection.add(object3);
                }
                object = (List)collection;
                bl = false;
                object2 = object.iterator();
                while (object2.hasNext()) {
                    collection = object2.next();
                    JComponent jComponent2 = (JComponent)((Object)collection);
                    int n = 0;
                    3.x(jComponent2, function1);
                }
            }

            private static final Unit x(RiderRunToPopupManager riderRunToPopupManager, JComponent jComponent) {
                Intrinsics.checkNotNullParameter((Object)jComponent, (String)"component");
                jComponent.addMouseListener(new MouseAdapter(riderRunToPopupManager, jComponent){
                    final /* synthetic */ RiderRunToPopupManager this$0;
                    final /* synthetic */ JComponent $component;
                    {
                        this.this$0 = $receiver;
                        this.$component = $component;
                    }

                    public void mouseClicked(MouseEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        if (e.getButton() != 3) {
                            return;
                        }
                        RiderRunToPopupManager.access$getPopupMenu$p(this.this$0).getComponent().show(this.$component, e.getX(), e.getY());
                    }
                });
                return Unit.INSTANCE;
            }
        };
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final Editor getCurrentEditor() {
        return this.currentEditor;
    }

    public final void setCurrentEditor(@Nullable Editor editor2) {
        this.currentEditor = editor2;
    }

    @Nullable
    public final XSourcePosition getPosition() {
        return this.position;
    }

    public final void setPosition(@Nullable XSourcePosition xSourcePosition) {
        this.position = xSourcePosition;
    }

    public final int getVisualLine() {
        return this.visualLine;
    }

    public final void setVisualLine(int n) {
        this.visualLine = n;
    }

    @Nullable
    public final DotNetDebugProcess getDebugProcessForPanel() {
        return this.debugProcessForPanel;
    }

    private final DotNetDebugProcess x() {
        XDebugSession xDebugSession;
        XDebugSession xDebugSession2 = xDebugSession = XDebuggerManager.getInstance((Project)this.project).getCurrentSession();
        return xDebugSession2 != null ? DotnetDebuggerExtKt.getDotnetDebugProcess(xDebugSession2) : null;
    }

    private final boolean x() {
        XSourcePosition xSourcePosition = this.position;
        if (xSourcePosition == null) {
            return false;
        }
        XSourcePosition xSourcePosition2 = xSourcePosition;
        DotNetDebugProcess dotNetDebugProcess = this.x();
        if (dotNetDebugProcess == null) {
            return false;
        }
        DotNetDebugProcess dotNetDebugProcess2 = dotNetDebugProcess;
        if (!DotNetDebugProcessUtilKt.canSetNextStatement(dotNetDebugProcess2)) {
            return false;
        }
        XDebugSession xDebugSession = dotNetDebugProcess2.getSession();
        XDebugSessionImpl xDebugSessionImpl = xDebugSession instanceof XDebugSessionImpl ? (XDebugSessionImpl)xDebugSession : null;
        if (xDebugSessionImpl == null) {
            return false;
        }
        XDebugSessionImpl xDebugSessionImpl2 = xDebugSessionImpl;
        XExecutionStack xExecutionStack = xDebugSessionImpl2.getCurrentExecutionStack();
        DotNetExecutionStack dotNetExecutionStack = xExecutionStack instanceof DotNetExecutionStack ? (DotNetExecutionStack)xExecutionStack : null;
        if (dotNetExecutionStack == null) {
            return false;
        }
        DotNetExecutionStack dotNetExecutionStack2 = dotNetExecutionStack;
        return JumpToStatementUtilKt.canJumpToStatement(xSourcePosition2, dotNetExecutionStack2);
    }

    private final void x(Editor editor2, double d, double d2, int n, int n2) {
        Object object;
        Object object2;
        boolean bl;
        Object object3;
        Editor editor3;
        Object object4;
        Object object5;
        double d3;
        Object object6;
        this.x("showImpl");
        Logger logger = RiderRunToPopupManagerKt.access$getLogger$p();
        boolean bl2 = false;
        if (logger.isTraceEnabled()) {
            object6 = logger;
            boolean bl3 = false;
            object6.trace("Drawing run to popup panel, Editor: " + editor2 + ", lineY: " + n);
        }
        int n3 = editor2.getLineHeight() / 5;
        double d4 = 1.2;
        double d5 = 2.0 * d4 * (double)editor2.getLineHeight() + (double)n3;
        this.jumpToIconComponent.setVisible(this.x());
        double d6 = this.jumpToIconComponent.isVisible() ? 0.0 : d4 * (double)editor2.getLineHeight() + (double)n3;
        double d7 = (double)editor2.getLineHeight() * d4;
        Dimension dimension = new Dimension(MathKt.roundToInt((double)d5), MathKt.roundToInt((double)d7));
        int n4 = MathKt.roundToInt((double)((double)editor2.getLineHeight() * d4));
        double d8 = (double)n4 * 0.1;
        double d9 = (double)editor2.getLineHeight() * 1.2;
        int n5 = (double)dimension.width < d - d9 ? MathKt.roundToInt((double)d) - dimension.width - n4 : ((double)n4 - (d3 = (double)dimension.width - d + d9) < d8 ? MathKt.roundToInt((double)d2) + n4 - MathKt.roundToInt((double)d6) : MathKt.roundToInt((double)d9) - n4);
        Editor editor4 = this.currentEditor;
        if (editor4 != null && (object5 = editor4.getInlayModel()) != null && (object4 = object5.getAfterLineEndElementsInRange(0, (editor3 = this.currentEditor) != null && (editor3 = editor3.getDocument()) != null ? editor3.getTextLength() : 0, EmptyInlayRenderer.class)) != null) {
            object3 = (Iterable)object4;
            bl = false;
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                Inlay inlay = (Inlay)object;
                boolean bl4 = false;
                Disposer.dispose((Disposable)((Disposable)inlay));
            }
        }
        int n6 = PlatformTextControlUtilsKt.getStartOffset((Editor)editor2);
        if (editor2.getDocument().getLineStartOffset(editor2.offsetToVisualLine(n6, false)) < n5) {
            editor2.getInlayModel().addAfterLineEndElement(n6, EmptyInlayRenderer.Companion.getProps(), (EditorCustomElementRenderer)new EmptyInlayRenderer(70));
        }
        if ((object5 = editor2.getComponent().getRootPane()) == null) {
            object4 = RiderRunToPopupManagerKt.access$getLogger$p();
            boolean bl5 = false;
            if (object4.isTraceEnabled()) {
                object6 = object4;
                bl = false;
                object6.trace("Root pane is null");
            }
            RiderRunToPopupManager.hidePanel$default(this, false, 1, null);
            return;
        }
        object4 = ((JRootPane)object5).getLayeredPane();
        object3 = new Point(editor2.getContentComponent().getLocationOnScreen().x - ((Component)object4).getLocationOnScreen().x + n5, editor2.getComponent().getLocationOnScreen().y - ((Component)object4).getLocationOnScreen().y + (n - n2) + MathKt.roundToInt((double)(((double)editor2.getLineHeight() - d7) * 0.5 - 0.5)));
        object2 = this.component.getLayout();
        GridLayout gridLayout = object2 instanceof GridLayout ? (GridLayout)object2 : null;
        if (gridLayout != null) {
            gridLayout.setHgap(n3);
        }
        this.component.setBounds(new Rectangle((Point)object3, dimension));
        object = editor2.getComponent();
        boolean bl6 = false;
        Rectangle rectangle = new Rectangle(((Component)object).getLocationOnScreen().x - ((Component)object4).getLocationOnScreen().x, ((Component)object).getLocationOnScreen().y - ((Component)object4).getLocationOnScreen().y, ((JComponent)object).getWidth(), ((JComponent)object).getHeight());
        if (rectangle.contains(this.component.getBounds())) {
            this.component.setVisible(false);
            Container container = this.component.getParent();
            if (container != null) {
                container.remove(this.component);
            }
            this.component.setVisible(true);
            ((Container)object4).add(this.component, null, 3);
            this.debugProcessForPanel = this.x();
            this.currentEditor = editor2;
        } else {
            object2 = RiderRunToPopupManagerKt.access$getLogger$p();
            boolean bl7 = false;
            if (object2.isTraceEnabled()) {
                object6 = object2;
                bl6 = false;
                object6.trace("Run to popup component bounds do not fit Editor bounds");
            }
            RiderRunToPopupManager.hidePanel$default(this, false, 1, null);
        }
    }

    private final void x(String string) {
        if (ApplicationKt.getApplication().isDispatchThread()) {
            return;
        }
        RiderRunToPopupManagerKt.access$getLogger$p().error(string + " must be executed on Ui thread. Current thread: " + Thread.currentThread() + ",\n stack trace: " + ExtensionsKt.getStackTrace());
    }

    public final void showPanel(@NotNull Editor editor2, double prefixWidth, double fullWidth, int lineY, int scrolledOffset) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        try {
            this.x(editor2, prefixWidth, fullWidth, lineY, scrolledOffset);
        }
        catch (Throwable throwable) {
            RiderRunToPopupManagerKt.access$getLogger$p().error("Failed to show debugger run to popup icons", throwable);
        }
    }

    public final void hidePanel(boolean hideComponent) {
        Editor editor2;
        List list2;
        InlayModel inlayModel;
        Logger logger = RiderRunToPopupManagerKt.access$getLogger$p();
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl2 = false;
            logger2.trace("Disabling run to popup panel");
        }
        this.x("hidePanel");
        if (hideComponent) {
            this.component.setVisible(false);
            Container container = this.component.getParent();
            if (container != null) {
                container.remove(this.component);
            }
        }
        if ((logger = this.currentEditor) != null && (inlayModel = logger.getInlayModel()) != null && (list2 = inlayModel.getAfterLineEndElementsInRange(0, (editor2 = this.currentEditor) != null && (editor2 = editor2.getDocument()) != null ? editor2.getTextLength() : 0, EmptyInlayRenderer.class)) != null) {
            Iterable iterable = list2;
            boolean bl3 = false;
            for (Object t : iterable) {
                Inlay inlay = (Inlay)t;
                boolean bl4 = false;
                Disposer.dispose((Disposable)((Disposable)inlay));
            }
        }
        this.popupMenu.getComponent().setVisible(false);
        this.visualLine = -1;
        this.debugProcessForPanel = null;
        this.currentEditor = null;
    }

    public static /* synthetic */ void hidePanel$default(RiderRunToPopupManager riderRunToPopupManager, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        riderRunToPopupManager.hidePanel(bl);
    }

    private static final Unit G(RiderRunToPopupManager riderRunToPopupManager) {
        XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)riderRunToPopupManager.project).getCurrentSession();
        if (xDebugSession == null) {
            return Unit.INSTANCE;
        }
        XDebugSession xDebugSession2 = xDebugSession;
        if (!xDebugSession2.isSuspended()) {
            return Unit.INSTANCE;
        }
        XSourcePosition xSourcePosition = riderRunToPopupManager.position;
        if (xSourcePosition == null) {
            return Unit.INSTANCE;
        }
        XSourcePosition xSourcePosition2 = xSourcePosition;
        xDebugSession2.runToPosition(xSourcePosition2, false);
        ActionsCollectorImpl.Companion.recordActionInvoked(riderRunToPopupManager.project, arg_0 -> RiderRunToPopupManager.x(riderRunToPopupManager, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit x(RiderRunToPopupManager riderRunToPopupManager, List list2) {
        Intrinsics.checkNotNullParameter((Object)list2, (String)"$this$recordActionInvoked");
        list2.add(EventFields.PluginInfoFromInstance.with((Object)list2));
        list2.add(EventFields.ActionPlace.with((Object)"EditorFloatingPanel"));
        Editor editor2 = riderRunToPopupManager.currentEditor;
        list2.add(EventFields.CurrentFile.with(editor2 != null ? DocumentUtilKt.getLanguage((Editor)editor2) : null));
        list2.add(ActionsEventLogGroup.ACTION_CLASS.with(RunToCursorAction.class));
        list2.add(ActionsEventLogGroup.ACTION_ID.with((Object)"RunToCursor"));
        return Unit.INSTANCE;
    }

    private static final Unit x(RiderRunToPopupManager riderRunToPopupManager) {
        Editor editor2 = riderRunToPopupManager.currentEditor;
        if (editor2 == null) {
            return Unit.INSTANCE;
        }
        Editor editor3 = editor2;
        XSourcePosition xSourcePosition = riderRunToPopupManager.position;
        if (xSourcePosition == null) {
            return Unit.INSTANCE;
        }
        int n = xSourcePosition.getLine();
        RiderJumpToStatementAction.Companion.executeWithLineNumber(editor3, "EditorFloatingPanel", n);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ ActionPopupMenu access$getPopupMenu$p(RiderRunToPopupManager $this) {
        return $this.popupMenu;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/debugger/editor/RiderRunToPopupManager$Companion;", "", "RiderRunToPopupManager$Companion", "()V", "LAYER_INDEX", "", "OPACITY", "", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u0018\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J$\u0010\u0018\u001a\u00020\b*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/rider/debugger/editor/RiderRunToPopupManager$ScalableIconComponent;", "Ljavax/swing/JComponent;", "icon", "Ljavax/swing/Icon;", "tooltipText", "", "action", "Lkotlin/Function0;", "", "RiderRunToPopupManager$ScalableIconComponent", "(Ljavax/swing/Icon;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "getIcon", "()Ljavax/swing/Icon;", "scaledIcon", "currentHeight", "", "isHovered", "", "isPressed", "x", "newHeight", "x", "scale", "", "x", "Ljava/awt/Graphics2D;", "rect", "Ljava/awt/Rectangle;", "color", "Ljava/awt/Color;", "lineWidth", "", "paint", "g", "Ljava/awt/Graphics;", "intellij.rider"})
    public static final class ScalableIconComponent
    extends JComponent {
        @NotNull
        private final Icon icon;
        @NotNull
        private Icon scaledIcon;
        private int currentHeight;
        private boolean isHovered;
        private boolean isPressed;

        public ScalableIconComponent(@NotNull Icon icon, @NlsContexts.Tooltip @NotNull String tooltipText, final @NotNull Function0<Unit> action2) {
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            Intrinsics.checkNotNullParameter((Object)tooltipText, (String)"tooltipText");
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            this.scaledIcon = this.icon = icon;
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (e.getButton() != 1) {
                        return;
                    }
                    isPressed = true;
                    this.repaint();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (e.getButton() != 1) {
                        return;
                    }
                    isPressed = false;
                    this.repaint();
                    if (isHovered) {
                        action2.invoke();
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    isHovered = true;
                    this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    isHovered = false;
                    this.repaint();
                }
            });
            this.setToolTipText(tooltipText);
        }

        @NotNull
        public final Icon getIcon() {
            return this.icon;
        }

        private final void x(int n) {
            if (n == this.currentHeight) {
                return;
            }
            this.scaledIcon = this.x(this.icon, (float)n / (float)this.icon.getIconHeight());
            this.currentHeight = n;
        }

        private final Icon x(Icon icon, float f) {
            return IconUtil.scale((Icon)icon, (Component)this, (float)(f * 0.8f));
        }

        private final void x(Graphics2D graphics2D, Rectangle rectangle, Color color, double d) {
            graphics2D.setColor(color);
            RectanglePainter2D.DRAW.paint(graphics2D, (double)rectangle.x, (double)rectangle.y, (double)rectangle.width, (double)rectangle.height, null, LinePainter2D.StrokeType.INSIDE, d, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }

        @Override
        public void paint(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            this.x(this.getHeight());
            Graphics graphics = g.create();
            Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (!this.isHovered) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.4f));
            }
            this.scaledIcon.paintIcon(this, graphics2D, (this.getWidth() - this.scaledIcon.getIconWidth()) / 2, (this.getHeight() - this.scaledIcon.getIconHeight()) / 2);
            if (this.isHovered || this.isPressed) {
                double d = Math.max(1.0, (double)this.scaledIcon.getIconWidth() / 16.0);
                JBColor jBColor = this.isPressed ? JBColor.DARK_GRAY : JBColor.LIGHT_GRAY;
                Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                Intrinsics.checkNotNull((Object)jBColor);
                this.x(graphics2D, rectangle, (Color)jBColor, d);
            }
            graphics2D.dispose();
        }
    }
}

