/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.editAndContinue;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.model.SuspendContextModelBase;
import com.jetbrains.rd.util.Logger;
import com.jetbrains.rd.util.LoggerKt;
import com.jetbrains.rd.util.SwitchLogger;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rider.build.diagnostics.BuildDiagnostic;
import com.jetbrains.rider.build.diagnostics.DiagnosticKind;
import com.jetbrains.rider.debugger.DotNetDebugProcess;
import com.jetbrains.rider.debugger.DotnetDebuggerExtKt;
import com.jetbrains.rider.debugger.access.RiderWritingAccessUtilKt;
import com.jetbrains.rider.debugger.editAndContinue.DocumentChange;
import com.jetbrains.rider.debugger.editAndContinue.DocumentChangeType;
import com.jetbrains.rider.debugger.editAndContinue.DotNetHotReloadManager;
import com.jetbrains.rider.debugger.editAndContinue.HotReloadApplyResultKind;
import com.jetbrains.rider.debugger.statistics.HotReloadUsageKind;
import com.jetbrains.rider.debugger.statistics.RiderDebuggerStatisticsUtilKt;
import com.jetbrains.rider.document.DocumentHostUtilKt;
import com.jetbrains.rider.model.BackendHotReloadDiagnostic;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelEvents;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0007\u001a\u00020\b*\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\f\u001a\u0012\u0010\u000e\u001a\u00020\u000f*\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\b\u0012\u0004\u0012\u00020\u00150\u0013\u001a\u0012\u0010\u0016\u001a\u00020\b*\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0002\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"logger", "Lcom/jetbrains/rd/util/SwitchLogger;", "hotReloadManager", "Lcom/jetbrains/rider/debugger/editAndContinue/DotNetHotReloadManager;", "Lcom/intellij/openapi/project/Project;", "getHotReloadManager", "(Lcom/intellij/openapi/project/Project;)Lcom/jetbrains/rider/debugger/editAndContinue/DotNetHotReloadManager;", "adviseOnDocumentChangeForEnC", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "handler", "Lkotlin/Function1;", "Lcom/jetbrains/rider/debugger/editAndContinue/DocumentChange;", "isDocumentInProject", "", "document", "Lcom/intellij/openapi/editor/Document;", "toBuildDiagnostics", "", "Lcom/jetbrains/rider/build/diagnostics/BuildDiagnostic;", "Lcom/jetbrains/rider/model/BackendHotReloadDiagnostic;", "applyChangesIfNeededWithRebuildViews", "usageKind", "Lcom/jetbrains/rider/debugger/statistics/HotReloadUsageKind;", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nEncUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EncUtil.kt\ncom/jetbrains/rider/debugger/editAndContinue/EncUtilKt\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,117:1\n30#2,2:118\n1563#3:120\n1634#3,3:121\n13805#4,2:124\n*S KotlinDebug\n*F\n+ 1 EncUtil.kt\ncom/jetbrains/rider/debugger/editAndContinue/EncUtilKt\n*L\n34#1:118,2\n94#1:120\n94#1:121,3\n110#1:124,2\n*E\n"})
public final class EncUtilKt {
    @NotNull
    private static final SwitchLogger logger = LoggerKt.getLogger((String)"EncUtil");

    @NotNull
    public static final DotNetHotReloadManager getHotReloadManager(@NotNull Project $this$hotReloadManager) {
        Intrinsics.checkNotNullParameter((Object)$this$hotReloadManager, (String)"<this>");
        ComponentManager componentManager = (ComponentManager)$this$hotReloadManager;
        boolean bl = false;
        Class<DotNetHotReloadManager> clazz = DotNetHotReloadManager.class;
        Object object = componentManager.getService(clazz);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
        }
        return (DotNetHotReloadManager)object;
    }

    public static final void adviseOnDocumentChangeForEnC(@NotNull Project $this$adviseOnDocumentChangeForEnC, @NotNull Lifetime lifetime, @NotNull Function1<? super DocumentChange, Unit> handler2) {
        WorkspaceModelEvents workspaceModelEvents;
        Intrinsics.checkNotNullParameter((Object)$this$adviseOnDocumentChangeForEnC, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)$this$adviseOnDocumentChangeForEnC);
        EditorEventMulticaster editorEventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        Intrinsics.checkNotNullExpressionValue((Object)editorEventMulticaster, (String)"getEventMulticaster(...)");
        EditorEventMulticaster editorEventMulticaster2 = editorEventMulticaster;
        DocumentListener documentListener2 = new DocumentListener(lifetime, $this$adviseOnDocumentChangeForEnC, psiDocumentManager, handler2){
            final /* synthetic */ Lifetime $lifetime;
            final /* synthetic */ Project $this_adviseOnDocumentChangeForEnC;
            final /* synthetic */ PsiDocumentManager $psiDocumentManager;
            final /* synthetic */ Function1<DocumentChange, Unit> $handler;
            {
                this.$lifetime = $lifetime;
                this.$this_adviseOnDocumentChangeForEnC = $receiver;
                this.$psiDocumentManager = $psiDocumentManager;
                this.$handler = $handler;
            }

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Document document = event.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                EncUtilKt.access$adviseOnDocumentChangeForEnC$handleChangeEvent(this.$lifetime, this.$this_adviseOnDocumentChangeForEnC, this.$psiDocumentManager, this.$handler, document, DocumentChangeType.MODIFIED);
            }
        };
        editorEventMulticaster2.addDocumentListener(documentListener2, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null));
        WorkspaceModelEvents workspaceModelEvents2 = workspaceModelEvents = WorkspaceModelEvents.Companion.getInstance($this$adviseOnDocumentChangeForEnC);
        boolean bl = false;
        workspaceModelEvents2.getAddSignal().advise(lifetime, arg_0 -> EncUtilKt.x(lifetime, $this$adviseOnDocumentChangeForEnC, psiDocumentManager, handler2, arg_0));
        workspaceModelEvents2.getRemoveSignal().advise(lifetime, arg_0 -> EncUtilKt.x(lifetime, $this$adviseOnDocumentChangeForEnC, psiDocumentManager, handler2, arg_0));
    }

    public static final boolean isDocumentInProject(@NotNull Project $this$isDocumentInProject, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)$this$isDocumentInProject, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance($this$isDocumentInProject);
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        FileDocumentManager fileDocumentManager2 = fileDocumentManager;
        VirtualFile virtualFile = fileDocumentManager2.getFile(document);
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile;
        List list2 = WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)workspaceModel, (VirtualFile)virtualFile2, (Project)$this$isDocumentInProject);
        return !((Collection)list2).isEmpty();
    }

    @NotNull
    public static final List<BuildDiagnostic> toBuildDiagnostics(@NotNull List<BackendHotReloadDiagnostic> $this$toBuildDiagnostics) {
        Intrinsics.checkNotNullParameter($this$toBuildDiagnostics, (String)"<this>");
        Iterable iterable = $this$toBuildDiagnostics;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            BackendHotReloadDiagnostic backendHotReloadDiagnostic = (BackendHotReloadDiagnostic)t;
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(new BuildDiagnostic(DiagnosticKind.Error, backendHotReloadDiagnostic.getMessage(), backendHotReloadDiagnostic.getCode(), backendHotReloadDiagnostic.getProjectId(), null, backendHotReloadDiagnostic.getFilePath(), backendHotReloadDiagnostic.getLine(), backendHotReloadDiagnostic.getColumn()));
        }
        return (List)collection;
    }

    public static final void applyChangesIfNeededWithRebuildViews(@NotNull DotNetHotReloadManager $this$applyChangesIfNeededWithRebuildViews, @NotNull HotReloadUsageKind usageKind) {
        Intrinsics.checkNotNullParameter((Object)$this$applyChangesIfNeededWithRebuildViews, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)usageKind), (String)"usageKind");
        if (RiderDebuggerStatisticsUtilKt.withStatistics($this$applyChangesIfNeededWithRebuildViews.applyChangesIfNeeded(), usageKind, $this$applyChangesIfNeededWithRebuildViews.getProject()) == HotReloadApplyResultKind.Applied) {
            XDebugSession[] xDebugSessionArray = XDebuggerManager.getInstance((Project)$this$applyChangesIfNeededWithRebuildViews.getProject()).getDebugSessions();
            Intrinsics.checkNotNullExpressionValue((Object)xDebugSessionArray, (String)"getDebugSessions(...)");
            Object[] objectArray = xDebugSessionArray;
            boolean bl = false;
            for (Object object : objectArray) {
                DotNetDebugProcess dotNetDebugProcess;
                XDebugSession xDebugSession = (XDebugSession)object;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)xDebugSession);
                if (DotnetDebuggerExtKt.getDotnetDebugProcess(xDebugSession) == null || (SuspendContextModelBase)dotNetDebugProcess.getSessionProxy().getSuspendContext().getValue() == null) continue;
                dotNetDebugProcess.getSession().rebuildViews();
            }
        }
    }

    private static final void x(Lifetime lifetime, Project project, PsiDocumentManager psiDocumentManager, Function1<? super DocumentChange, Unit> function1, Document document, DocumentChangeType documentChangeType) {
        try {
            DocumentSynchronizer documentSynchronizer;
            if (!RLifetimeKt.isAlive((Lifetime)lifetime)) {
                return;
            }
            DocumentSynchronizer documentSynchronizer2 = documentSynchronizer = DocumentExKt.getDocumentSynchronizer((Document)document, (Project)project);
            boolean bl = documentSynchronizer2 != null ? DocumentHostUtilKt.isSandbox((DocumentSynchronizer)documentSynchronizer2) : false;
            if (bl) {
                return;
            }
            if (!EncUtilKt.isDocumentInProject(project, document)) {
                return;
            }
            PsiFile psiFile = psiDocumentManager.getPsiFile(document);
            PsiFile psiFile2 = psiFile;
            if (psiFile2 == null || (psiFile2 = psiFile2.getVirtualFile()) == null) {
                return;
            }
            PsiFile psiFile3 = psiFile2;
            if (RiderWritingAccessUtilKt.isSupportedForEncFile((VirtualFile)psiFile3, project)) {
                function1.invoke((Object)new DocumentChange(documentChangeType, document, (VirtualFile)psiFile3));
            }
        }
        catch (CancellationException cancellationException) {
        }
        catch (Throwable throwable) {
            LoggerKt.error((Logger)((Logger)logger), (Throwable)throwable);
        }
    }

    private static final Unit x(Lifetime lifetime, Project project, PsiDocumentManager psiDocumentManager, Function1 function1, WorkspaceModelEvents.AddEntityEvent addEntityEvent) {
        Intrinsics.checkNotNullParameter((Object)addEntityEvent, (String)"it");
        VirtualFileUrl virtualFileUrl = addEntityEvent.getEntity().getUrl();
        if (virtualFileUrl == null || (virtualFileUrl = VirtualFileUrls.getVirtualFile((VirtualFileUrl)virtualFileUrl)) == null) {
            return Unit.INSTANCE;
        }
        VirtualFileUrl virtualFileUrl2 = virtualFileUrl;
        Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)virtualFileUrl2);
        if (document == null) {
            return Unit.INSTANCE;
        }
        Document document2 = document;
        EncUtilKt.x(lifetime, project, psiDocumentManager, (Function1<? super DocumentChange, Unit>)function1, document2, DocumentChangeType.ADDED);
        return Unit.INSTANCE;
    }

    private static final Unit x(Lifetime lifetime, Project project, PsiDocumentManager psiDocumentManager, Function1 function1, WorkspaceModelEvents.RemoveEntityEvent removeEntityEvent) {
        Intrinsics.checkNotNullParameter((Object)removeEntityEvent, (String)"it");
        VirtualFileUrl virtualFileUrl = removeEntityEvent.getEntity().getUrl();
        if (virtualFileUrl == null || (virtualFileUrl = VirtualFileUrls.getVirtualFile((VirtualFileUrl)virtualFileUrl)) == null) {
            return Unit.INSTANCE;
        }
        VirtualFileUrl virtualFileUrl2 = virtualFileUrl;
        Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)virtualFileUrl2);
        if (document == null) {
            return Unit.INSTANCE;
        }
        Document document2 = document;
        EncUtilKt.x(lifetime, project, psiDocumentManager, (Function1<? super DocumentChange, Unit>)function1, document2, DocumentChangeType.REMOVED);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$adviseOnDocumentChangeForEnC$handleChangeEvent(Lifetime $lifetime, Project $this_adviseOnDocumentChangeForEnC, PsiDocumentManager psiDocumentManager, Function1 $handler, Document document, DocumentChangeType changeType) {
        EncUtilKt.x($lifetime, $this_adviseOnDocumentChangeForEnC, psiDocumentManager, (Function1<? super DocumentChange, Unit>)$handler, document, changeType);
    }
}

