/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.dialogs;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.editors.FrontendTextControlHost;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.settings.DotNetDebuggerSettings;
import com.jetbrains.rider.ui.RiderEditorNotifier;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/debugger/dialogs/JITDebuggerNotifier;", "", "JITDebuggerNotifier", "()V", "debuggerLaunchRegex", "Lkotlin/text/Regex;", "getDebuggerLaunchRegex", "()Lkotlin/text/Regex;", "showNotification", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nJITDebuggerNotifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JITDebuggerNotifier.kt\ncom/jetbrains/rider/debugger/dialogs/JITDebuggerNotifier\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,35:1\n1#2:36\n*E\n"})
public final class JITDebuggerNotifier {
    @NotNull
    public static final JITDebuggerNotifier INSTANCE = new JITDebuggerNotifier();
    @NotNull
    private static final Regex debuggerLaunchRegex = new Regex("Debugger *\\. *Launch");

    private JITDebuggerNotifier() {
    }

    @NotNull
    public final Regex getDebuggerLaunchRegex() {
        return debuggerLaunchRegex;
    }

    public final void showNotification(@NotNull Lifetime lifetime, @NotNull Project project) {
        Editor editor2;
        Object v1;
        Sequence sequence;
        FrontendTextControlHost frontendTextControlHost;
        block2: {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            frontendTextControlHost = FrontendTextControlHost.Companion.getInstance(project);
            sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)frontendTextControlHost.getEditors()), arg_0 -> JITDebuggerNotifier.x(project, arg_0));
            for (Object e : sequence) {
                Editor editor3 = (Editor)e;
                boolean bl = false;
                String string = editor3.getDocument().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                CharSequence charSequence = string;
                if (!debuggerLaunchRegex.containsMatchIn(charSequence)) continue;
                v1 = e;
                break block2;
            }
            v1 = null;
        }
        if ((editor2 = (Editor)v1) == null && (editor2 = (Editor)CollectionsKt.firstOrNull((List)frontendTextControlHost.getEditors())) == null) {
            return;
        }
        Editor editor4 = editor2;
        TextEditor textEditor = TextEditorProvider.Companion.getInstance().getTextEditor(editor4);
        RiderEditorNotifier riderEditorNotifier = new RiderEditorNotifier(project, lifetime);
        sequence = riderEditorNotifier;
        boolean bl = false;
        sequence.setPanelText(RiderDebuggerBundle.Companion.message("JITDebuggerNotifier.message", new Object[0]));
        sequence.setKeyName("PromoteJITDebugger");
        RiderEditorNotifier.defineSettingsAction$default((RiderEditorNotifier)sequence, null, (String)"project.propDebugger", (String)"Set Rider as a default debugger", (boolean)true, null, (int)17, null);
        RiderEditorNotifier.defineDontShowAgainAction$default((RiderEditorNotifier)sequence, null, JITDebuggerNotifier::x, (int)1, null);
        RiderEditorNotifier.defineHideAction$default((RiderEditorNotifier)sequence, null, null, (int)3, null);
        riderEditorNotifier.showNotification(textEditor);
    }

    private static final boolean x(Project project, Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return Intrinsics.areEqual((Object)editor2.getProject(), (Object)project);
    }

    private static final Unit x(DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"it");
        DotNetDebuggerSettings.Companion.getInstance().setShouldPromoteJITDebugger(false);
        return Unit.INSTANCE;
    }
}

