/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.components;

import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.debugger.components.RiderExceptionPaneKt;
import com.jetbrains.rider.debugger.components.RiderPaneWithTitle;
import com.jetbrains.rider.debugger.components.RiderPopupBalloonState;
import com.jetbrains.rider.debugger.exception.model.CompositeExceptionModel;
import com.jetbrains.rider.debugger.exception.view.ExceptionContentPane;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/debugger/components/RiderExceptionPane;", "Lcom/jetbrains/rider/debugger/components/RiderPaneWithTitle;", "exceptionModel", "Lcom/jetbrains/rider/debugger/exception/model/CompositeExceptionModel;", "state", "Lcom/jetbrains/rider/debugger/components/RiderPopupBalloonState;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "RiderExceptionPane", "(Lcom/jetbrains/rider/debugger/exception/model/CompositeExceptionModel;Lcom/jetbrains/rider/debugger/components/RiderPopupBalloonState;Lcom/intellij/xdebugger/XDebugSession;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "getActionGroupId", "", "createContentPane", "Ljavax/swing/JComponent;", "uiDataSnapshot", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "intellij.rider"})
public final class RiderExceptionPane
extends RiderPaneWithTitle {
    @NotNull
    private final CompositeExceptionModel exceptionModel;
    @NotNull
    private final XDebugSession session;

    public RiderExceptionPane(@NotNull CompositeExceptionModel exceptionModel, @NotNull RiderPopupBalloonState state, @NotNull XDebugSession session, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)exceptionModel, (String)"exceptionModel");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        super(exceptionModel.getExceptionTypeString(), state, lifetime, session);
        this.exceptionModel = exceptionModel;
        this.session = session;
    }

    @Override
    @NotNull
    protected String getActionGroupId() {
        return "Rider.Debugger.Exception.Popup";
    }

    @Override
    @NotNull
    protected JComponent createContentPane() {
        Lifetime lifetime = this.getLifetime();
        Project project = this.session.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new ExceptionContentPane(this.exceptionModel, lifetime, project).getView();
    }

    @Override
    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        super.uiDataSnapshot(sink);
        sink.set(RiderExceptionPaneKt.getRIDER_POPUP_EXCEPTION_KEY(), (Object)this.exceptionModel);
    }
}

