/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.components;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.debugger.components.ExceptionGutterRenderer;
import com.jetbrains.rider.debugger.components.RiderDebugBalloon;
import com.jetbrains.rider.debugger.components.RiderExceptionPane;
import com.jetbrains.rider.debugger.components.RiderPaneWithTitle;
import com.jetbrains.rider.debugger.exception.model.CompositeExceptionModel;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u0012\u001a\u00020\u0013H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/debugger/components/ExceptionBalloon;", "Lcom/jetbrains/rider/debugger/components/RiderDebugBalloon;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "logicalPosition", "Lcom/intellij/openapi/editor/LogicalPosition;", "exceptionModel", "Lcom/jetbrains/rider/debugger/exception/model/CompositeExceptionModel;", "project", "Lcom/intellij/openapi/project/Project;", "debugSession", "Lcom/intellij/xdebugger/XDebugSession;", "parentLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "ExceptionBalloon", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/openapi/editor/LogicalPosition;Lcom/jetbrains/rider/debugger/exception/model/CompositeExceptionModel;Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/XDebugSession;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "createPanel", "Lcom/jetbrains/rider/debugger/components/RiderPaneWithTitle;", "Companion", "intellij.rider"})
public final class ExceptionBalloon
extends RiderDebugBalloon {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final CompositeExceptionModel exceptionModel;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Key<Unit> THROWN_EXCEPTION_HIGHLIGHTER;

    public ExceptionBalloon(@NotNull EditorImpl editor2, @NotNull LogicalPosition logicalPosition, @NotNull CompositeExceptionModel exceptionModel, @NotNull Project project, @NotNull XDebugSession debugSession, @NotNull Lifetime parentLifetime) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)logicalPosition, (String)"logicalPosition");
        Intrinsics.checkNotNullParameter((Object)exceptionModel, (String)"exceptionModel");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)debugSession, (String)"debugSession");
        Intrinsics.checkNotNullParameter((Object)parentLifetime, (String)"parentLifetime");
        super(editor2, logicalPosition, project, debugSession, parentLifetime);
        this.editor = editor2;
        this.exceptionModel = exceptionModel;
        MarkupModelEx markupModelEx = this.editor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx, (String)"getMarkupModel(...)");
        MarkupModelEx markupModelEx2 = markupModelEx;
        Icon icon = AllIcons.Debugger.Db_exception_breakpoint;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Db_exception_breakpoint");
        Icon icon2 = icon;
        int n = this.editor.getDocument().getLineStartOffset(logicalPosition.line);
        RangeHighlighterEx rangeHighlighterEx = markupModelEx2.addRangeHighlighterAndChangeAttributes(null, n, n, 1000, HighlighterTargetArea.LINES_IN_RANGE, false, arg_0 -> ExceptionBalloon.x(arg_0 -> ExceptionBalloon.x(icon2, this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterEx, (String)"addRangeHighlighterAndChangeAttributes(...)");
        RangeHighlighterEx rangeHighlighterEx2 = rangeHighlighterEx;
        this.getLifetime().onTermination(() -> ExceptionBalloon.x(markupModelEx2, rangeHighlighterEx2));
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    @Override
    @NotNull
    protected RiderPaneWithTitle createPanel() {
        return new RiderExceptionPane(this.exceptionModel, this.getState(), this.getDebugSession(), this.getLifetime());
    }

    private static final Unit x(Icon icon, ExceptionBalloon exceptionBalloon, RangeHighlighterEx rangeHighlighterEx) {
        rangeHighlighterEx.setGutterIconRenderer((GutterIconRenderer)new ExceptionGutterRenderer(icon, exceptionBalloon.exceptionModel.getExceptionTypeString(), (Function0<Unit>)((Function0)new Function0<Unit>((Object)exceptionBalloon){

            public final void invoke() {
                ((ExceptionBalloon)this.receiver).show();
            }
        })));
        rangeHighlighterEx.putUserData(THROWN_EXCEPTION_HIGHLIGHTER, (Object)Unit.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final void x(Function1 function1, Object object) {
        function1.invoke(object);
    }

    private static final Unit x(MarkupModelEx markupModelEx, RangeHighlighterEx rangeHighlighterEx) {
        markupModelEx.removeHighlighter((RangeHighlighter)rangeHighlighterEx);
        return Unit.INSTANCE;
    }

    static {
        Logger logger = Logger.getInstance(ExceptionBalloon.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ExceptionBalloon.logger = logger;
        THROWN_EXCEPTION_HIGHLIGHTER = new Key("ExceptionBalloon_THROWN_EXCEPTION_HIGHLIGHTER");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/debugger/components/ExceptionBalloon$Companion;", "", "ExceptionBalloon$Companion", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "THROWN_EXCEPTION_HIGHLIGHTER", "Lcom/intellij/openapi/util/Key;", "", "getTHROWN_EXCEPTION_HIGHLIGHTER", "()Lcom/intellij/openapi/util/Key;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        @NotNull
        public final Key<Unit> getTHROWN_EXCEPTION_HIGHLIGHTER() {
            return THROWN_EXCEPTION_HIGHLIGHTER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

