/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.breakpoint.dialogs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.rd.framework.RdTaskResult;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.util.Logger;
import com.jetbrains.rd.util.LoggerKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.breakpoint.dialogs.DotNetExceptionNode;
import com.jetbrains.rider.debugger.breakpoint.dialogs.DotNetExceptionsTree;
import com.jetbrains.rider.model.ProjectExceptionModel;
import com.jetbrains.rider.model.PsiDebuggerHostModel_PregeneratedKt;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0003\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0005H\u0014J\b\u0010\u0018\u001a\u00020\u0005H\u0014J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u001aJ\b\u0010\u001b\u001a\u00020\u0015H\u0002J\u0016\u0010\u001c\u001a\u00020\u00152\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u001aH\u0002J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/rider/debugger/breakpoint/dialogs/DotNetNewExceptionBreakpointsDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljavax/swing/JComponent;", "dialogTitle", "", "addEntityMessage", "DotNetNewExceptionBreakpointsDialog", "(Lcom/intellij/openapi/project/Project;Ljavax/swing/JComponent;Ljava/lang/String;Ljava/lang/String;)V", "panel", "Ljavax/swing/JPanel;", "filterTextField", "Lcom/intellij/ui/SearchTextField;", "tree", "Lcom/jetbrains/rider/debugger/breakpoint/dialogs/DotNetExceptionsTree;", "selectedExceptions", "", "Lcom/jetbrains/rider/model/ProjectExceptionModel;", "k", "", "x", "createCenterPanel", "createNorthPanel", "getSelectedModels", "", "G", "x", "exceptions", "x", "view", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nDotNetNewExceptionBreakpointsDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotNetNewExceptionBreakpointsDialog.kt\ncom/jetbrains/rider/debugger/breakpoint/dialogs/DotNetNewExceptionBreakpointsDialog\n+ 2 Logger.kt\ncom/jetbrains/rd/util/LoggerKt\n*L\n1#1,149:1\n94#2:150\n*S KotlinDebug\n*F\n+ 1 DotNetNewExceptionBreakpointsDialog.kt\ncom/jetbrains/rider/debugger/breakpoint/dialogs/DotNetNewExceptionBreakpointsDialog\n*L\n41#1:150\n*E\n"})
public final class DotNetNewExceptionBreakpointsDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String addEntityMessage;
    @NotNull
    private final JPanel panel;
    @NotNull
    private final SearchTextField filterTextField;
    @NotNull
    private final DotNetExceptionsTree tree;
    @NotNull
    private final Set<ProjectExceptionModel> selectedExceptions;
    @NotNull
    private static final Logger logger;

    public DotNetNewExceptionBreakpointsDialog(@NotNull Project project, @Nullable JComponent parentComponent, @NlsContexts.DialogTitle @NotNull String dialogTitle, @NlsContexts.DialogMessage @NotNull String addEntityMessage) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        Intrinsics.checkNotNullParameter((Object)addEntityMessage, (String)"addEntityMessage");
        super(project, (Component)parentComponent, true, DialogWrapper.IdeModalityType.IDE);
        this.project = project;
        this.addEntityMessage = addEntityMessage;
        this.panel = new JPanel();
        this.filterTextField = new SearchTextField(false);
        Disposable disposable = this.myDisposable;
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"myDisposable");
        this.tree = new DotNetExceptionsTree((Lifetime)LifetimeDisposableExKt.defineNestedLifetime((Disposable)disposable));
        this.selectedExceptions = new LinkedHashSet();
        this.setTitle(dialogTitle);
        this.panel.setLayout(new GridLayout(0, 1));
        this.panel.setBorder((Border)JBUI.Borders.empty());
        this.panel.setMinimumSize(new Dimension(400, 400));
        this.G();
        super.init();
        this.filterTextField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                String string = filterTextField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                tree.updateNodesFilter(string2);
            }
        });
        this.x();
        this.k();
        this.setOKActionEnabled(false);
        this.tree.addCheckboxTreeListener(new CheckboxTreeListener(){

            public void nodeStateChanged(CheckedTreeNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (node instanceof DotNetExceptionNode) {
                    if (((DotNetExceptionNode)node).isChecked()) {
                        selectedExceptions.add(((DotNetExceptionNode)node).getExceptionModel());
                        this.setOKActionEnabled(true);
                    } else {
                        selectedExceptions.remove(((DotNetExceptionNode)node).getExceptionModel());
                        if (selectedExceptions.isEmpty()) {
                            this.setOKActionEnabled(false);
                        }
                    }
                    this.k();
                }
            }
        });
    }

    public /* synthetic */ DotNetNewExceptionBreakpointsDialog(Project project, JComponent jComponent, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = RiderDebuggerBundle.Companion.message("DotNetNewExceptionBreakpointsDialog.dialog.title.add.clr.exception.breakpoints", new Object[0]);
        }
        if ((n & 8) != 0) {
            string2 = RiderDebuggerBundle.Companion.message("debugger.new.exception.breakpoint.entry.message", new Object[0]);
        }
        this(project, jComponent, string, string2);
    }

    private final void k() {
        this.getOKAction().putValue("Name", this.addEntityMessage + " (" + this.selectedExceptions.size() + ")");
    }

    private final void x() {
        Disposable disposable = this.myDisposable;
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"myDisposable");
        LifetimeDefinition lifetimeDefinition = LifetimeDisposableExKt.defineNestedLifetime((Disposable)disposable);
        SourceExKt.adviseOnce((ISource)((ISource)PsiDebuggerHostModel_PregeneratedKt.getPsiDebuggerHostModel((Solution)SolutionHostExtensionsKt.getSolution((Project)this.project)).getEvaluateExceptionInheritors().start((Lifetime)lifetimeDefinition, (Object)Unit.INSTANCE).getResult()), (Lifetime)((Lifetime)lifetimeDefinition), arg_0 -> DotNetNewExceptionBreakpointsDialog.x(lifetimeDefinition, this, arg_0));
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return this.panel;
    }

    @NotNull
    protected JComponent createNorthPanel() {
        BorderLayoutPanel borderLayoutPanel = new BorderLayoutPanel();
        borderLayoutPanel.addToCenter((Component)this.filterTextField);
        return (JComponent)borderLayoutPanel;
    }

    @NotNull
    public final List<ProjectExceptionModel> getSelectedModels() {
        return CollectionsKt.toList((Iterable)this.selectedExceptions);
    }

    private final void G() {
        LayoutManager layoutManager = new BorderLayout();
        Disposable disposable = this.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        JBLoadingPanel jBLoadingPanel = new JBLoadingPanel(layoutManager, disposable, 0, 4, null);
        jBLoadingPanel.startLoading();
        this.x((JComponent)jBLoadingPanel);
    }

    private final void x(List<ProjectExceptionModel> list2) {
        this.tree.updateExceptions(list2);
        JBScrollPane jBScrollPane = new JBScrollPane((Component)((Object)this.tree));
        this.x((JComponent)jBScrollPane);
        this.filterTextField.requestFocus();
    }

    private final void x(JComponent jComponent) {
        this.panel.removeAll();
        this.panel.add((Component)jComponent, "North");
        this.panel.validate();
        this.panel.repaint();
    }

    private static final Unit x(LifetimeDefinition lifetimeDefinition, DotNetNewExceptionBreakpointsDialog dotNetNewExceptionBreakpointsDialog, RdTaskResult rdTaskResult) {
        Intrinsics.checkNotNullParameter((Object)rdTaskResult, (String)"result");
        LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null);
        RdTaskResult rdTaskResult2 = rdTaskResult;
        if (rdTaskResult2 instanceof RdTaskResult.Success) {
            dotNetNewExceptionBreakpointsDialog.x((List)((RdTaskResult.Success)rdTaskResult).getValue());
        } else if (rdTaskResult2 instanceof RdTaskResult.Fault) {
            LoggerKt.error((Logger)logger, (Throwable)((Throwable)((RdTaskResult.Fault)rdTaskResult).getError()));
            dotNetNewExceptionBreakpointsDialog.close(-1);
        } else if (rdTaskResult2 instanceof RdTaskResult.Cancelled) {
            dotNetNewExceptionBreakpointsDialog.close(1);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
    }

    static {
        boolean bl = false;
        logger = LoggerKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(DotNetNewExceptionBreakpointsDialog.class));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/debugger/breakpoint/dialogs/DotNetNewExceptionBreakpointsDialog$Companion;", "", "DotNetNewExceptionBreakpointsDialog$Companion", "()V", "logger", "Lcom/jetbrains/rd/util/Logger;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

