/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.breakpoint;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.jetbrains.rd.ide.model.AbstractDocumentVersion;
import com.jetbrains.rd.platform.util.IDocumentRangeShifter;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import com.jetbrains.rider.debugger.DotNetDebuggerEditorsProvider;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.breakpoint.BreakpointComputationRequestsService;
import com.jetbrains.rider.debugger.breakpoint.BreakpointHitCountMode;
import com.jetbrains.rider.debugger.breakpoint.DotNetBreakpointFiltersPanel;
import com.jetbrains.rider.debugger.breakpoint.DotNetLineBreakpointProperties;
import com.jetbrains.rider.debugger.breakpoint.IDotNetLineBreakpointPopupActionsProvider;
import com.jetbrains.rider.debugger.breakpoint.IDotNetVerifiableBreakpointType;
import com.jetbrains.rider.debugger.breakpoint.RiderBreakpointCompoundPanel;
import com.jetbrains.rider.debugger.breakpoint.RiderBreakpointHost;
import com.jetbrains.rider.debugger.breakpoint.validation.RiderBreakpointDocumentRangeShifters;
import com.jetbrains.rider.model.BreakpointVariantModel;
import com.jetbrains.rider.model.BreakpointVariantModelBase;
import com.jetbrains.rider.model.DummyBreakpointVariantModel;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 52\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u00044567B\u001b\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\t\b\u0016\u00a2\u0006\u0004\b\u0007\u0010\tJ\u0018\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0002H\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J&\u0010\u0014\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0018\u001a\u0004\u0018\u00010\u00192\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\"\u0010\u001a\u001a\f\u0012\b\u0012\u00060\u001cR\u00020\u00000\u001b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0017J.\u0010\u001f\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f0!R\b\u0012\u0004\u0012\u00020\u00020\u00010\u001b0 2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u001eH\u0016J4\u0010\u001f\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f0!R\b\u0012\u0004\u0012\u00020\u00020\u00010\u001b0 2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$2\u0006\u0010\"\u001a\u00020\u001eJ(\u0010%\u001a\f\u0012\b\u0012\u00060\u001cR\u00020\u00000\u001b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u001eH\u0082@\u00a2\u0006\u0002\u0010&J\u0018\u0010'\u001a\u0004\u0018\u00010(2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0016J\u001e\u0010)\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0016\u0018\u00010*2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010+\u001a\u00020\u000eH\u0016J\u0018\u0010,\u001a\u00020\u00052\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0016H\u0016J\u001e\u0010-\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0016\u0018\u00010*2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J(\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u0002000/2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00162\b\u00101\u001a\u0004\u0018\u000102H\u0016J\u0018\u00103\u001a\u00020\u00052\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0016H\u0016\u00a8\u00068"}, d2={"Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType;", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointProperties;", "Lcom/jetbrains/rider/debugger/breakpoint/IDotNetVerifiableBreakpointType;", "id", "", "title", "DotNetLineBreakpointType", "(Ljava/lang/String;Ljava/lang/String;)V", "()V", "createBreakpointProperties", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "createProperties", "canPutAt", "", "project", "Lcom/intellij/openapi/project/Project;", "lineShouldBeChanged", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "newLine", "getEditorsProvider", "Lcom/intellij/xdebugger/evaluation/XDebuggerEditorsProvider;", "computeVariants", "", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType$DotNetBreakpointVariant;", "sourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "computeVariantsAsync", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType$XLineBreakpointVariant;", "position", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "x", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/XSourcePosition;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getHighlightRange", "Lcom/intellij/openapi/util/TextRange;", "createCustomRightPropertiesPanel", "Lcom/intellij/xdebugger/breakpoints/ui/XBreakpointCustomPropertiesPanel;", "getPriority", "getDisplayText", "createCustomPropertiesPanel", "getAdditionalPopupMenuActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "currentSession", "Lcom/intellij/xdebugger/XDebugSession;", "getGeneralDescription", "Util", "Companion", "DotNetBreakpointVariant", "DotNetAllBreakpointsVariant", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nDotNetLineBreakpointType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotNetLineBreakpointType.kt\ncom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,321:1\n30#2,2:322\n1869#3,2:324\n13#4:326\n13#5:327\n*S KotlinDebug\n*F\n+ 1 DotNetLineBreakpointType.kt\ncom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType\n*L\n158#1:322,2\n235#1:324,2\n74#1:326\n74#1:327\n*E\n"})
public class DotNetLineBreakpointType
extends XLineBreakpointType<DotNetLineBreakpointProperties>
implements IDotNetVerifiableBreakpointType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ID = "DotNet Breakpoints";
    @NotNull
    private static final Logger logger;

    protected DotNetLineBreakpointType(@NotNull String id2, @Nls @NotNull String title2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        super(id2, title2);
    }

    public DotNetLineBreakpointType() {
        this(ID, Util.INSTANCE.getTitle());
    }

    @NotNull
    public DotNetLineBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file2, int line) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return (DotNetLineBreakpointProperties)((Object)ActionsKt.runReadAction(() -> DotNetLineBreakpointType.x(file2, line)));
    }

    @NotNull
    public DotNetLineBreakpointProperties createProperties() {
        return new DotNetLineBreakpointProperties(false, 0, null, true, 7, null);
    }

    public boolean canPutAt(@NotNull VirtualFile file2, int line, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        logger.trace("Verifying possibility of breakpoint insertion for " + file2.getName() + ":" + line);
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file2);
        if (psiFile != null) {
            logger.trace("Found psi file " + psiFile);
            RiderBreakpointHost riderBreakpointHost = RiderBreakpointHost.Companion.getInstance(project);
            return riderBreakpointHost.isSupportedLanguage(psiFile, line);
        }
        logger.trace("Cannot find psi file for " + file2.getName() + ":" + line + ", return false");
        return false;
    }

    public boolean lineShouldBeChanged(@NotNull XLineBreakpoint<DotNetLineBreakpointProperties> breakpoint, int newLine, @NotNull Project project) {
        List list2;
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(breakpoint.getFileUrl());
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile;
        DotNetLineBreakpointProperties dotNetLineBreakpointProperties = (DotNetLineBreakpointProperties)breakpoint.getProperties();
        if (dotNetLineBreakpointProperties == null) {
            return false;
        }
        DotNetLineBreakpointProperties dotNetLineBreakpointProperties2 = dotNetLineBreakpointProperties;
        Deferred deferred2 = LifetimeCoroutineUtilKt.async$default((Lifetime)UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project)), (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends DotNetBreakpointVariant>>, Object>(this, project, virtualFile2, newLine, null){
            int label;
            final /* synthetic */ DotNetLineBreakpointType this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ int $newLine;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$virtualFile = $virtualFile;
                this.$newLine = $newLine;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        XSourcePositionImpl xSourcePositionImpl = XSourcePositionImpl.create((VirtualFile)this.$virtualFile, (int)this.$newLine);
                        Intrinsics.checkNotNullExpressionValue((Object)xSourcePositionImpl, (String)"create(...)");
                        this.label = 1;
                        Object object2 = DotNetLineBreakpointType.access$computeVariantsInternal(this.this$0, this.$project, (XSourcePosition)xSourcePositionImpl, (Continuation)this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends DotNetBreakpointVariant>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        Duration duration = Util.INSTANCE.getWAIT_FOR_VARIANTS_DURATION$intellij_rider();
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"<get-WAIT_FOR_VARIANTS_DURATION>(...)");
        if (!ExtensionsKt.pumpMessages((Duration)duration, () -> DotNetLineBreakpointType.x(deferred2))) {
            logger.warn("Failed to wait for variants computation (file: " + virtualFile2 + ", line: " + newLine + ")");
            return false;
        }
        try {
            list2 = (List)deferred2.getCompleted();
        }
        catch (Throwable throwable) {
            list2 = CollectionsKt.emptyList();
        }
        List list3 = list2;
        if (list3.isEmpty()) {
            return false;
        }
        dotNetLineBreakpointProperties2.setVariant((DotNetBreakpointVariant)((Object)CollectionsKt.first((List)list3)));
        return true;
    }

    @Nullable
    public XDebuggerEditorsProvider getEditorsProvider(@NotNull XLineBreakpoint<DotNetLineBreakpointProperties> breakpoint, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new DotNetDebuggerEditorsProvider(project, breakpoint);
    }

    @RequiresBackgroundThread
    @NotNull
    public List<DotNetBreakpointVariant> computeVariants(@NotNull Project project, @NotNull XSourcePosition sourcePosition) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sourcePosition, (String)"sourcePosition");
        return (List)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends DotNetBreakpointVariant>>, Object>(this, project, sourcePosition, null){
            int label;
            final /* synthetic */ DotNetLineBreakpointType this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ XSourcePosition $sourcePosition;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$sourcePosition = $sourcePosition;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = DotNetLineBreakpointType.access$computeVariantsInternal(this.this$0, this.$project, this.$sourcePosition, (Continuation)this);
                        Object object3 = object2;
                        if (object2 != object) return (List)object3;
                        return object;
                    }
                    case 1: {
                        Object object3;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            object3 = $result;
                            return (List)object3;
                        }
                        catch (CancellationException cancellationException) {
                            throw cancellationException;
                        }
                        catch (Throwable throwable) {
                            DotNetLineBreakpointType.access$getLogger$cp().error(throwable);
                            throw throwable;
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends DotNetBreakpointVariant>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @NotNull
    public Promise<List<XLineBreakpointType.XLineBreakpointVariant>> computeVariantsAsync(@NotNull Project project, @NotNull XSourcePosition position) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return this.computeVariantsAsync(project, UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project)), position);
    }

    @NotNull
    public final Promise<List<XLineBreakpointType.XLineBreakpointVariant>> computeVariantsAsync(@NotNull Project project, @NotNull Lifetime lifetime, @NotNull XSourcePosition position) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return RdCoroutinesUtilKt.toPromise((Deferred)LifetimeCoroutineUtilKt.async$default((Lifetime)lifetime, (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends DotNetBreakpointVariant>>, Object>(this, project, position, null){
            int label;
            final /* synthetic */ DotNetLineBreakpointType this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ XSourcePosition $position;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$position = $position;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = DotNetLineBreakpointType.access$computeVariantsInternal(this.this$0, this.$project, this.$position, (Continuation)this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends DotNetBreakpointVariant>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null));
    }

    private final Object x(Project project, XSourcePosition xSourcePosition, Continuation<? super List<? extends DotNetBreakpointVariant>> continuation) {
        ComponentManager componentManager = (ComponentManager)project;
        boolean bl = false;
        Class<BreakpointComputationRequestsService> clazz = BreakpointComputationRequestsService.class;
        Object object = componentManager.getService(clazz);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
        }
        return ((BreakpointComputationRequestsService)object).queueBreakpointsComputation(xSourcePosition, (Function1)new Function1<Continuation<? super List<DotNetBreakpointVariant>>, Object>(project, xSourcePosition, this, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ XSourcePosition $position;
            final /* synthetic */ DotNetLineBreakpointType this$0;
            {
                this.$project = $project;
                this.$position = $position;
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var23_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = RiderBreakpointHost.Companion.getInstance(this.$project).requestVariantsComputation(this.$position, (Continuation<? super List<? extends BreakpointVariantModelBase>>)((Continuation)this));
                        if (v0 == var23_2) {
                            return var23_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        var2_3 = (List)v0;
                        var4_4 = var2_3;
                        var5_6 = this.this$0;
                        var6_7 = this.$position;
                        var7_9 = this.$project;
                        var8_10 = false;
                        var9_12 = var4_4;
                        var10_13 = new ArrayList<E>();
                        var11_15 = false;
                        var12_16 = var9_12;
                        var13_17 = false;
                        var14_18 = var12_16.iterator();
                        while (var14_18.hasNext()) {
                            var16_20 = var15_19 = var14_18.next();
                            var17_21 = false;
                            var18_22 = (BreakpointVariantModelBase)var16_20;
                            var19_23 = false;
                            var20_24 = var18_22;
                            if (var20_24 instanceof DummyBreakpointVariantModel) {
                                v1 = RiderDebuggerBundle.Companion.message("rider.debugger.line.breakpoint.text", new Object[0]);
                                v2 = var6_7.getFile();
                                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getFile(...)");
                                v3 = (DotNetLineBreakpointType)var5_6.new DotNetBreakpointVariant(v1, null, null, v2, var6_7.getLine(), var18_22.getDocumentVersion(), false, (Project)var7_9);
                            } else if (var20_24 instanceof BreakpointVariantModel) {
                                v4 = ((BreakpointVariantModel)var18_22).getText();
                                v5 = ((BreakpointVariantModel)var18_22).getContainingFunctionPresentation();
                                v6 = new TextRange(((BreakpointVariantModel)var18_22).getStartOffset(), ((BreakpointVariantModel)var18_22).getEndOffset());
                                v7 = var6_7.getFile();
                                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getFile(...)");
                                v3 = (DotNetLineBreakpointType)var5_6.new DotNetBreakpointVariant(v4, v5, v6, v7, var6_7.getLine(), var18_22.getDocumentVersion(), ((BreakpointVariantModel)var18_22).isMultiMethodBreakpoint(), (Project)var7_9);
                            } else {
                                DotNetLineBreakpointType.access$getLogger$cp().error("Unsupported type of breakpoint model: " + var18_22.getClass().getSimpleName());
                                v3 = null;
                            }
                            if (v3 == null) continue;
                            var21_25 = v3;
                            var22_26 = false;
                            var10_13.add(var21_25);
                        }
                        var3_27 = CollectionsKt.toMutableList((Collection)((List)var10_13));
                        if (var3_27.size() <= 1) ** GOTO lbl74
                        var5_6 = var3_27;
                        var6_8 = false;
                        if (!(var5_6 instanceof Collection) || !((Collection)var5_6).isEmpty()) ** GOTO lbl61
                        v8 = false;
                        ** GOTO lbl70
lbl61:
                        // 1 sources

                        var7_9 = var5_6.iterator();
                        while (var7_9.hasNext()) {
                            var8_11 = var7_9.next();
                            var9_12 = (DotNetBreakpointVariant)var8_11;
                            var10_14 = false;
                            if (!var9_12.isMultiMethodBreakpoint()) continue;
                            v8 = true;
                            ** GOTO lbl70
                        }
                        v8 = false;
lbl70:
                        // 3 sources

                        var4_5 = v8;
                        v9 = (DotNetBreakpointVariant)CollectionsKt.firstOrNull((List)var3_27);
                        var3_27.add(this.this$0.new DotNetAllBreakpointsVariant(this.$position, CollectionsKt.toList((Iterable)var3_27), v9 != null ? v9.getContainingFunctionDescription() : null, var4_5 != false, this.$project));
lbl74:
                        // 2 sources

                        return var3_27;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super List<DotNetBreakpointVariant>> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, continuation);
    }

    @Nullable
    public TextRange getHighlightRange(@NotNull XLineBreakpoint<DotNetLineBreakpointProperties> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        TextRange textRange = ((DotNetLineBreakpointProperties)breakpoint.getProperties()).getTextRange();
        if (!Intrinsics.areEqual((Object)textRange, (Object)TextRange.EMPTY_RANGE)) {
            return textRange;
        }
        return null;
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<XLineBreakpoint<DotNetLineBreakpointProperties>> createCustomRightPropertiesPanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new DotNetBreakpointFiltersPanel();
    }

    public int getPriority() {
        return -1;
    }

    @NotNull
    public String getDisplayText(@Nullable XLineBreakpoint<DotNetLineBreakpointProperties> breakpoint) {
        if (breakpoint == null) {
            return "";
        }
        String string = ((DotNetLineBreakpointProperties)breakpoint.getProperties()).getContainingFunctionPresentation();
        Object[] objectArray = (Object[])string;
        if (objectArray == null || objectArray.length() == 0) {
            Object[] objectArray2 = new Object[]{breakpoint.getLine() + 1, breakpoint.getShortFilePath()};
            String string2 = XDebuggerBundle.message((String)"xbreakpoint.default.display.text", (Object[])objectArray2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            return string2;
        }
        objectArray = new Object[]{breakpoint.getLine() + 1, string};
        return RiderDebuggerBundle.Companion.message("DotNetLineBreakpointType.line.in.function", objectArray);
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<XLineBreakpoint<DotNetLineBreakpointProperties>> createCustomPropertiesPanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new RiderBreakpointCompoundPanel(project);
    }

    @NotNull
    public List<? extends AnAction> getAdditionalPopupMenuActions(@NotNull XLineBreakpoint<DotNetLineBreakpointProperties> breakpoint, @Nullable XDebugSession currentSession) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        Iterable iterable = new ArrayList();
        List list2 = iterable;
        boolean bl = false;
        List list3 = super.getAdditionalPopupMenuActions(breakpoint, currentSession);
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getAdditionalPopupMenuActions(...)");
        list2.addAll(list3);
        List list4 = iterable;
        iterable = IDotNetLineBreakpointPopupActionsProvider.Companion.getEP().getExtensionList();
        boolean bl2 = false;
        for (Object e : iterable) {
            IDotNetLineBreakpointPopupActionsProvider iDotNetLineBreakpointPopupActionsProvider = (IDotNetLineBreakpointPopupActionsProvider)e;
            boolean bl3 = false;
            list4.addAll((Collection)iDotNetLineBreakpointPopupActionsProvider.getCustomPopupMenuActions(breakpoint, currentSession));
        }
        return list4;
    }

    @NotNull
    public String getGeneralDescription(@Nullable XLineBreakpoint<DotNetLineBreakpointProperties> breakpoint) {
        return RiderDebuggerBundle.Companion.message("rider.debugger.line.breakpoint.text", new Object[0]);
    }

    private static final DotNetLineBreakpointProperties x(VirtualFile virtualFile, int n) {
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            return new DotNetLineBreakpointProperties(false, 0, null, true, 7, null);
        }
        Document document2 = document;
        int n2 = document2.getLineStartOffset(n);
        String string = virtualFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return DotNetLineBreakpointProperties.Companion.create$default(DotNetLineBreakpointProperties.Companion, string, null, n2, n2, false, 0, null, true, 112, null);
    }

    private static final boolean x(Deferred deferred2) {
        return deferred2.isCompleted();
    }

    public static final /* synthetic */ Object access$computeVariantsInternal(DotNetLineBreakpointType $this, Project project, XSourcePosition position, Continuation $completion) {
        return $this.x(project, position, (Continuation<? super List<? extends DotNetBreakpointVariant>>)$completion);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger = Logger.getInstance(DotNetLineBreakpointType.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        DotNetLineBreakpointType.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType$Companion;", "", "DotNetLineBreakpointType$Companion", "()V", "ID", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002BG\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u001a\u0010\u0005\u001a\u0016\u0012\u0012\u0012\u00100\u0007R\b\u0012\u0004\u0012\u00020\t0\bj\u0002`\n0\u0006\u0012\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\b\u0010\u0013\u001a\u00020\tH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0005\u001a\u0016\u0012\u0012\u0012\u00100\u0007R\b\u0012\u0004\u0012\u00020\t0\bj\u0002`\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType$DotNetAllBreakpointsVariant;", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType$DotNetBreakpointVariant;", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "variantsList", "", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType$XLineBreakpointVariant;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType;", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointProperties;", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetBreakpointVariant;", "containingFunctionDescription", "", "isMultiMethodBreakpoint", "", "project", "Lcom/intellij/openapi/project/Project;", "DotNetLineBreakpointType$DotNetAllBreakpointsVariant", "(Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType;Lcom/intellij/xdebugger/XSourcePosition;Ljava/util/List;Ljava/lang/String;ZLcom/intellij/openapi/project/Project;)V", "createProperties", "getIcon", "Ljavax/swing/Icon;", "getHighlightRange", "Lcom/intellij/openapi/util/TextRange;", "isMultiVariant", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nDotNetLineBreakpointType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotNetLineBreakpointType.kt\ncom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType$DotNetAllBreakpointsVariant\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,321:1\n1563#2:322\n1634#2,3:323\n1563#2:326\n1634#2,3:327\n*S KotlinDebug\n*F\n+ 1 DotNetLineBreakpointType.kt\ncom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType$DotNetAllBreakpointsVariant\n*L\n309#1:322\n309#1:323,3\n310#1:326\n310#1:327,3\n*E\n"})
    public final class DotNetAllBreakpointsVariant
    extends DotNetBreakpointVariant {
        @NotNull
        private final XSourcePosition position;
        @NotNull
        private final List<XLineBreakpointType.XLineBreakpointVariant> variantsList;

        public DotNetAllBreakpointsVariant(@NotNull XSourcePosition position, @Nls @Nullable List<? extends XLineBreakpointType.XLineBreakpointVariant> variantsList, String containingFunctionDescription, @NotNull boolean isMultiMethodBreakpoint, Project project) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter(variantsList, (String)"variantsList");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String string = RiderDebuggerBundle.Companion.message("DotNetLineBreakpointType.all.breakpoints.message", new Object[0]);
            VirtualFile virtualFile = position.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            super(string, containingFunctionDescription, null, virtualFile, position.getLine(), null, isMultiMethodBreakpoint, project);
            this.position = position;
            this.variantsList = variantsList;
        }

        @Override
        @NotNull
        public DotNetLineBreakpointProperties createProperties() {
            Collection<Integer> collection;
            boolean bl;
            Collection<Integer> collection2;
            XLineBreakpointType.XLineBreakpointVariant xLineBreakpointVariant;
            VirtualFile virtualFile = this.position.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            VirtualFile virtualFile2 = virtualFile;
            String string = virtualFile2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            Iterable iterable = this.variantsList;
            String string2 = this.getContainingFunctionDescription();
            String string3 = string;
            boolean bl2 = false;
            Iterable iterable2 = iterable;
            Collection collection3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean bl3 = false;
            for (Object t : iterable2) {
                xLineBreakpointVariant = (XLineBreakpointType.XLineBreakpointVariant)t;
                collection2 = collection3;
                bl = false;
                TextRange textRange = xLineBreakpointVariant.getHighlightRange();
                collection2.add(textRange != null ? textRange.getStartOffset() : -1);
            }
            collection2 = (List)collection3;
            iterable = this.variantsList;
            bl2 = false;
            iterable2 = iterable;
            collection3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            bl3 = false;
            for (Object t : iterable2) {
                xLineBreakpointVariant = (XLineBreakpointType.XLineBreakpointVariant)t;
                collection = collection3;
                bl = false;
                TextRange textRange = xLineBreakpointVariant.getHighlightRange();
                collection.add(textRange != null ? textRange.getEndOffset() : -1);
            }
            collection = (List)collection3;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 112;
            BreakpointHitCountMode breakpointHitCountMode = null;
            int n2 = 0;
            boolean bl4 = false;
            Collection<Integer> collection4 = collection;
            Collection<Integer> collection5 = collection2;
            String string4 = string2;
            String string5 = string3;
            return new DotNetLineBreakpointProperties(string5, string4, (List)collection5, (List)collection4, bl4, n2, breakpointHitCountMode, n, defaultConstructorMarker);
        }

        @Override
        @NotNull
        public Icon getIcon() {
            Icon icon = AllIcons.Debugger.MultipleBreakpoints;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"MultipleBreakpoints");
            return icon;
        }

        @Override
        @Nullable
        public TextRange getHighlightRange() {
            return null;
        }

        public boolean isMultiVariant() {
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0096\u0004\u0018\u00002\f0\u0001R\b\u0012\u0004\u0012\u00020\u00030\u0002BQ\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\n\u0010 \u001a\u0004\u0018\u00010\bH\u0016J\b\u0010!\u001a\u00020\u0003H\u0016J\b\u0010\"\u001a\u00020\u0005H\u0016J\u0010\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u001dR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType$DotNetBreakpointVariant;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType$XLineBreakpointVariant;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType;", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointProperties;", "breakpointText", "", "containingFunctionDescription", "initialTextRange", "Lcom/intellij/openapi/util/TextRange;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "version", "Lcom/jetbrains/rd/ide/model/AbstractDocumentVersion;", "isMultiMethodBreakpoint", "", "project", "Lcom/intellij/openapi/project/Project;", "DotNetLineBreakpointType$DotNetBreakpointVariant", "(Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/util/TextRange;Lcom/intellij/openapi/vfs/VirtualFile;ILcom/jetbrains/rd/ide/model/AbstractDocumentVersion;ZLcom/intellij/openapi/project/Project;)V", "getContainingFunctionDescription", "()Ljava/lang/String;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getLine", "()I", "getVersion", "()Lcom/jetbrains/rd/ide/model/AbstractDocumentVersion;", "()Z", "getIcon", "Ljavax/swing/Icon;", "getHighlightRange", "createProperties", "getText", "x", "textRange", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nDotNetLineBreakpointType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotNetLineBreakpointType.kt\ncom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType$DotNetBreakpointVariant\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,321:1\n1#2:322\n*E\n"})
    public class DotNetBreakpointVariant
    extends XLineBreakpointType.XLineBreakpointVariant {
        @NotNull
        private final String breakpointText;
        @Nullable
        private final String containingFunctionDescription;
        @Nullable
        private final TextRange initialTextRange;
        @NotNull
        private final VirtualFile file;
        private final int line;
        @Nullable
        private final AbstractDocumentVersion version;
        private final boolean isMultiMethodBreakpoint;
        @NotNull
        private final Project project;

        public DotNetBreakpointVariant(@Nls @Nullable String breakpointText, @Nullable String containingFunctionDescription, @NotNull TextRange initialTextRange, VirtualFile file2, @Nullable int line, AbstractDocumentVersion version, @NotNull boolean isMultiMethodBreakpoint, Project project) {
            Intrinsics.checkNotNullParameter((Object)breakpointText, (String)"breakpointText");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super((XLineBreakpointType)DotNetLineBreakpointType.this);
            this.breakpointText = breakpointText;
            this.containingFunctionDescription = containingFunctionDescription;
            this.initialTextRange = initialTextRange;
            this.file = file2;
            this.line = line;
            this.version = version;
            this.isMultiMethodBreakpoint = isMultiMethodBreakpoint;
            this.project = project;
        }

        @Nullable
        public final String getContainingFunctionDescription() {
            return this.containingFunctionDescription;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        public final int getLine() {
            return this.line;
        }

        @Nullable
        public final AbstractDocumentVersion getVersion() {
            return this.version;
        }

        public final boolean isMultiMethodBreakpoint() {
            return this.isMultiMethodBreakpoint;
        }

        @Nullable
        public Icon getIcon() {
            return AllIcons.Debugger.Db_set_breakpoint;
        }

        @Nullable
        public TextRange getHighlightRange() {
            TextRange textRange;
            TextRange textRange2 = this.initialTextRange;
            if (textRange2 != null) {
                TextRange textRange3 = textRange2;
                boolean bl = false;
                textRange = this.x(textRange3);
            } else {
                textRange = null;
            }
            return textRange;
        }

        @NotNull
        public DotNetLineBreakpointProperties createProperties() {
            if (this.initialTextRange == null) {
                return new DotNetLineBreakpointProperties(false, 0, null, false, 15, null);
            }
            TextRange textRange = this.x(this.initialTextRange);
            String string = this.file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            return DotNetLineBreakpointProperties.Companion.create$default(DotNetLineBreakpointProperties.Companion, string, this.containingFunctionDescription, textRange.getStartOffset(), textRange.getEndOffset(), false, 0, null, this.isMultiMethodBreakpoint, 112, null);
        }

        @NotNull
        public String getText() {
            return this.breakpointText;
        }

        private final TextRange x(TextRange textRange) {
            AbstractDocumentVersion abstractDocumentVersion = this.version;
            if (abstractDocumentVersion == null) {
                return textRange;
            }
            AbstractDocumentVersion abstractDocumentVersion2 = abstractDocumentVersion;
            IDocumentRangeShifter iDocumentRangeShifter = RiderBreakpointDocumentRangeShifters.Companion.getInstance(this.project).getShifter(this.file);
            if (iDocumentRangeShifter == null || (iDocumentRangeShifter = iDocumentRangeShifter.shiftRange(abstractDocumentVersion2, textRange, false, false, false)) == null) {
                iDocumentRangeShifter = textRange;
            }
            return iDocumentRangeShifter;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType$Util;", "", "DotNetLineBreakpointType$Util", "()V", "Title", "", "getTitle", "()Ljava/lang/String;", "WAIT_FOR_VARIANTS_DURATION", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getWAIT_FOR_VARIANTS_DURATION$intellij_rider", "()Ljava/time/Duration;", "intellij.rider"})
    public static final class Util {
        @NotNull
        public static final Util INSTANCE = new Util();
        @Nls
        @NotNull
        private static final String Title = RiderDebuggerBundle.Companion.message("DotNetLineBreakpointType.net.line.breakpoints", new Object[0]);
        private static final Duration WAIT_FOR_VARIANTS_DURATION = Duration.ofSeconds(5L);

        private Util() {
        }

        @NotNull
        public final String getTitle() {
            return Title;
        }

        public final Duration getWAIT_FOR_VARIANTS_DURATION$intellij_rider() {
            return WAIT_FOR_VARIANTS_DURATION;
        }
    }
}

