/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.attach.remoting.unarchiver;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.rider.CPUKind;
import com.jetbrains.rider.RiderEnvironment;
import java.io.File;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/debugger/attach/remoting/unarchiver/LocalJetBrainsUnarchiver;", "", "cpu", "Lcom/jetbrains/rider/CPUKind;", "location", "Ljava/io/File;", "LocalJetBrainsUnarchiver", "(Lcom/jetbrains/rider/CPUKind;Ljava/io/File;)V", "getCpu", "()Lcom/jetbrains/rider/CPUKind;", "getLocation", "()Ljava/io/File;", "unarchive", "", "zipFile", "targetFolder", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nLocalJetBrainsUnarchiver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalJetBrainsUnarchiver.kt\ncom/jetbrains/rider/debugger/attach/remoting/unarchiver/LocalJetBrainsUnarchiver\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,67:1\n13#2:68\n13#3:69\n*S KotlinDebug\n*F\n+ 1 LocalJetBrainsUnarchiver.kt\ncom/jetbrains/rider/debugger/attach/remoting/unarchiver/LocalJetBrainsUnarchiver\n*L\n20#1:68\n20#1:69\n*E\n"})
public final class LocalJetBrainsUnarchiver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CPUKind cpu;
    @NotNull
    private final File location;
    @NotNull
    private static final Logger logger;
    @NotNull
    public static final String UNARCHIVER_NAME = "jb_zip_unarchiver";

    private LocalJetBrainsUnarchiver(CPUKind cpu, File location) {
        this.cpu = cpu;
        this.location = location;
    }

    @NotNull
    public final CPUKind getCpu() {
        return this.cpu;
    }

    @NotNull
    public final File getLocation() {
        return this.location;
    }

    public final boolean unarchive(@NotNull File zipFile, @NotNull File targetFolder) {
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        Intrinsics.checkNotNullParameter((Object)targetFolder, (String)"targetFolder");
        String[] stringArray = new String[]{this.location.getAbsolutePath(), "-src", zipFile.getAbsolutePath(), "-dst", targetFolder.getAbsolutePath()};
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(stringArray);
        String[] stringArray2 = new CapturingProcessHandler(generalCommandLine).runProcess();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"runProcess(...)");
        stringArray = stringArray2;
        return stringArray.checkSuccess(logger);
    }

    public /* synthetic */ LocalJetBrainsUnarchiver(CPUKind cpu, File location, DefaultConstructorMarker $constructor_marker) {
        this(cpu, location);
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger = Logger.getInstance(LocalJetBrainsUnarchiver.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LocalJetBrainsUnarchiver.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/debugger/attach/remoting/unarchiver/LocalJetBrainsUnarchiver$Companion;", "", "LocalJetBrainsUnarchiver$Companion", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "UNARCHIVER_NAME", "", "create", "Lcom/jetbrains/rider/debugger/attach/remoting/unarchiver/LocalJetBrainsUnarchiver;", "cpu", "Lcom/jetbrains/rider/CPUKind;", "x", "Ljava/io/File;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final LocalJetBrainsUnarchiver create(@NotNull CPUKind cpu) {
            Intrinsics.checkNotNullParameter((Object)cpu, (String)"cpu");
            File file2 = this.x(cpu);
            if (file2 == null) {
                return null;
            }
            File file3 = file2;
            return new LocalJetBrainsUnarchiver(cpu, file3, null);
        }

        private final File x(CPUKind cPUKind) {
            File file2 = RiderEnvironment.INSTANCE.getBundledBinDir();
            if (!file2.isDirectory()) {
                logger.error("Bin directory " + file2 + " does not exist, can't find unarchiver");
                return null;
            }
            File file3 = new File(file2, cPUKind.getDirectoryName());
            if (!file2.isDirectory()) {
                logger.error("Cpu-specific directory " + file3 + " does not exist, can't find unarchiver");
                return null;
            }
            Object[] objectArray = file3.listFiles(Companion::x);
            if (objectArray == null || objectArray.length == 0) {
                logger.error("There's no unarchiver available in the directory " + file3);
                return null;
            }
            if (objectArray.length > 1) {
                logger.warn("More than one unarchiver are available: [" + ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "]");
            }
            File file4 = (File)ArraysKt.first((Object[])objectArray);
            if (SystemInfo.isUnix && !file4.canExecute()) {
                file4.setExecutable(true);
            }
            return file4;
        }

        private static final boolean x(File file2, String string) {
            return StringsKt.equals((String)FilesKt.getNameWithoutExtension((File)new File(string)), (String)LocalJetBrainsUnarchiver.UNARCHIVER_NAME, (boolean)true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

