/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.attach.remoting.tools.url.providers;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rider.CPUKind;
import com.jetbrains.rider.debugger.attach.remoting.tools.url.DefaultRemoteDebuggerToolsUrlWithArguments;
import com.jetbrains.rider.debugger.attach.remoting.tools.url.RemoteDebuggerToolsUrl;
import com.jetbrains.rider.debugger.attach.remoting.tools.url.providers.DebuggerToolsUrlProvider;
import com.jetbrains.rider.debugger.modulesView.AssemblyVersion;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\b\u0010\u0012\u001a\u00020\u0007H\u0002J\b\u0010\u0013\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/debugger/attach/remoting/tools/url/providers/FallbackDebuggerToolsUrlProvider;", "Lcom/jetbrains/rider/debugger/attach/remoting/tools/url/providers/DebuggerToolsUrlProvider;", "FallbackDebuggerToolsUrlProvider", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "LATEST_RELEASE_VERSION", "", "FALLBACK_RELEASE_VERSION", "defaultRemoteToolsLink", "Lcom/jetbrains/rider/debugger/attach/remoting/tools/url/DefaultRemoteDebuggerToolsUrlWithArguments;", "get", "Lcom/jetbrains/rider/debugger/attach/remoting/tools/url/RemoteDebuggerToolsUrl;", "cpu", "Lcom/jetbrains/rider/CPUKind;", "x", "version", "currentRiderVersion", "G", "x", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nFallbackDebuggerToolsUrlProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FallbackDebuggerToolsUrlProvider.kt\ncom/jetbrains/rider/debugger/attach/remoting/tools/url/providers/FallbackDebuggerToolsUrlProvider\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,59:1\n13#2:60\n13#3:61\n*S KotlinDebug\n*F\n+ 1 FallbackDebuggerToolsUrlProvider.kt\ncom/jetbrains/rider/debugger/attach/remoting/tools/url/providers/FallbackDebuggerToolsUrlProvider\n*L\n10#1:60\n10#1:61\n*E\n"})
public final class FallbackDebuggerToolsUrlProvider
extends DebuggerToolsUrlProvider {
    @NotNull
    public static final FallbackDebuggerToolsUrlProvider INSTANCE = new FallbackDebuggerToolsUrlProvider();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final String LATEST_RELEASE_VERSION = "2022.3";
    @NotNull
    private static final String FALLBACK_RELEASE_VERSION = "2022.2.3";
    @NotNull
    private static final DefaultRemoteDebuggerToolsUrlWithArguments defaultRemoteToolsLink;

    private FallbackDebuggerToolsUrlProvider() {
    }

    @Override
    @Nullable
    public RemoteDebuggerToolsUrl get(@NotNull CPUKind cpu) {
        RemoteDebuggerToolsUrl remoteDebuggerToolsUrl;
        Intrinsics.checkNotNullParameter((Object)cpu, (String)"cpu");
        String string = this.getToolsCustomVersion();
        Object object = string;
        if (!(object == null || StringsKt.isBlank((CharSequence)object)) && (object = this.x(cpu, string)) != null) {
            return object;
        }
        Object object2 = object = this.x(cpu, this.G());
        if (object2 != null) {
            return object2;
        }
        RemoteDebuggerToolsUrl remoteDebuggerToolsUrl2 = remoteDebuggerToolsUrl = this.x(cpu, this.x());
        if (remoteDebuggerToolsUrl2 != null) {
            return remoteDebuggerToolsUrl2;
        }
        return null;
    }

    private final RemoteDebuggerToolsUrl x(CPUKind cPUKind, String string) {
        logger.info("Trying to find remote debugger tools of version " + string + " (CPU kind " + cPUKind + ")");
        AssemblyVersion assemblyVersion = AssemblyVersion.Companion.parse(string);
        String string2 = this.x(cPUKind, string);
        if (this.urlValid(string2)) {
            return new RemoteDebuggerToolsUrl(assemblyVersion, string2);
        }
        logger.warn("Download url for cpu " + cPUKind + " and version " + assemblyVersion + " is invalid (" + string2 + ")");
        return null;
    }

    private final String x(CPUKind cPUKind, String string) {
        logger.trace("Trying to get fallback debugger tools url, url = " + defaultRemoteToolsLink);
        return defaultRemoteToolsLink.substituteArguments(cPUKind, string);
    }

    private final String G() {
        return LATEST_RELEASE_VERSION;
    }

    private final String x() {
        return FALLBACK_RELEASE_VERSION;
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger = Logger.getInstance(FallbackDebuggerToolsUrlProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FallbackDebuggerToolsUrlProvider.logger = logger;
        defaultRemoteToolsLink = new DefaultRemoteDebuggerToolsUrlWithArguments();
    }
}

