/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.attach.remoting.tools.url.providers;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rider.CPUKind;
import com.jetbrains.rider.debugger.attach.remoting.RiderRemoteToolsDownload;
import com.jetbrains.rider.debugger.attach.remoting.RiderRemoteToolsRelease;
import com.jetbrains.rider.debugger.attach.remoting.RiderRemoteToolsVersions;
import com.jetbrains.rider.debugger.attach.remoting.RiderVersions;
import com.jetbrains.rider.debugger.attach.remoting.tools.url.RemoteDebuggerToolsUrl;
import com.jetbrains.rider.debugger.attach.remoting.tools.url.providers.DebuggerToolsUrlProvider;
import com.jetbrains.rider.debugger.modulesView.AssemblyVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/debugger/attach/remoting/tools/url/providers/DataServiceRemoteDebuggerToolsUrlProvider;", "Lcom/jetbrains/rider/debugger/attach/remoting/tools/url/providers/DebuggerToolsUrlProvider;", "DataServiceRemoteDebuggerToolsUrlProvider", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "get", "Lcom/jetbrains/rider/debugger/attach/remoting/tools/url/RemoteDebuggerToolsUrl;", "cpu", "Lcom/jetbrains/rider/CPUKind;", "x", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nDataServiceRemoteDebuggerToolsUrlProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataServiceRemoteDebuggerToolsUrlProvider.kt\ncom/jetbrains/rider/debugger/attach/remoting/tools/url/providers/DataServiceRemoteDebuggerToolsUrlProvider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,86:1\n3919#2:87\n4434#2,2:88\n1563#3:90\n1634#3,3:91\n1068#3:94\n774#3:95\n865#3,2:96\n774#3:98\n865#3,2:99\n13#4:101\n13#5:102\n*S KotlinDebug\n*F\n+ 1 DataServiceRemoteDebuggerToolsUrlProvider.kt\ncom/jetbrains/rider/debugger/attach/remoting/tools/url/providers/DataServiceRemoteDebuggerToolsUrlProvider\n*L\n30#1:87\n30#1:88,2\n39#1:90\n39#1:91,3\n39#1:94\n52#1:95\n52#1:96,2\n69#1:98\n69#1:99,2\n13#1:101\n13#1:102\n*E\n"})
public final class DataServiceRemoteDebuggerToolsUrlProvider
extends DebuggerToolsUrlProvider {
    @NotNull
    public static final DataServiceRemoteDebuggerToolsUrlProvider INSTANCE = new DataServiceRemoteDebuggerToolsUrlProvider();
    @NotNull
    private static final Logger logger;

    private DataServiceRemoteDebuggerToolsUrlProvider() {
    }

    @Override
    @Nullable
    public RemoteDebuggerToolsUrl get(@NotNull CPUKind cpu) {
        Intrinsics.checkNotNullParameter((Object)cpu, (String)"cpu");
        RemoteDebuggerToolsUrl remoteDebuggerToolsUrl = this.x(cpu);
        if (remoteDebuggerToolsUrl == null) {
            logger.error("Unable to get remote tools link for cpu " + cpu.getDirectoryName() + " using data services");
        }
        return remoteDebuggerToolsUrl;
    }

    private final RemoteDebuggerToolsUrl x(CPUKind cPUKind) {
        Object object;
        Object object2;
        boolean bl;
        RiderRemoteToolsRelease riderRemoteToolsRelease;
        int n;
        RiderRemoteToolsRelease[] riderRemoteToolsReleaseArray;
        logger.info("Trying to obtain remote tools url using data services");
        Object object3 = riderRemoteToolsReleaseArray = RiderRemoteToolsVersions.INSTANCE.getAllReleases();
        boolean bl2 = false;
        RiderRemoteToolsRelease[] riderRemoteToolsReleaseArray2 = object3;
        Iterable iterable2 = new ArrayList();
        boolean bl3 = false;
        int n2 = riderRemoteToolsReleaseArray2.length;
        for (n = 0; n < n2; ++n) {
            RiderRemoteToolsRelease iterable3;
            riderRemoteToolsRelease = iterable3 = riderRemoteToolsReleaseArray2[n];
            bl = false;
            if (!riderRemoteToolsRelease.getDownloads().containsKey(cPUKind.getDownloadKey())) continue;
            iterable2.add(iterable3);
        }
        List list2 = (List)iterable2;
        Iterable iterable = list2;
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator(...)");
        logger.trace("Applicable releases for cpu kind " + cPUKind + ": [" + CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null) + "]");
        if (list2.isEmpty()) {
            logger.warn("No applicable releases for CPU " + cPUKind.getDirectoryName() + " on data services");
            return null;
        }
        Iterable iterable5 = list2;
        boolean bl4 = false;
        iterable2 = iterable5;
        Iterable iterable6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable5, (int)10));
        n = 0;
        for (Object e : iterable2) {
            riderRemoteToolsRelease = (RiderRemoteToolsRelease)e;
            Collection collection = iterable6;
            bl = false;
            collection.add(new Pair((Object)riderRemoteToolsRelease, (Object)AssemblyVersion.Companion.parse(riderRemoteToolsRelease.getBuild())));
        }
        iterable5 = (List)iterable6;
        bl4 = false;
        object3 = CollectionsKt.sortedWith((Iterable)iterable5, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair pair = (Pair)b;
                boolean bl = false;
                Comparable comparable = (AssemblyVersion)pair.getSecond();
                pair = (Pair)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((AssemblyVersion)pair.getSecond()));
            }
        });
        iterable5 = ApplicationInfo.getInstance();
        logger.info("Application version: major = " + iterable5.getMajorVersion() + ", minor = " + iterable5.getMinorVersion() + ", micro = " + iterable5.getMicroVersion() + ", patch = " + iterable5.getPatchVersion());
        AssemblyVersion assemblyVersion = RiderVersions.INSTANCE.getBuildNumber();
        logger.info("Parsed build number: " + assemblyVersion);
        iterable6 = (Iterable)object3;
        n = 0;
        Iterable iterable7 = iterable6;
        Collection collection = new ArrayList();
        boolean bl5 = false;
        Iterator iterator2 = iterable7.iterator();
        while (iterator2.hasNext()) {
            object2 = iterator2.next();
            object = (Pair)object2;
            boolean bl6 = false;
            if (!(((AssemblyVersion)object.getSecond()).getMajor() == assemblyVersion.getMajor() && ((AssemblyVersion)object.getSecond()).getMinor() == assemblyVersion.getMinor())) continue;
            collection.add(object2);
        }
        iterable2 = (List)collection;
        String string2 = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lineSeparator(...)");
        logger.trace("Current wave releases: [" + CollectionsKt.joinToString$default(iterable2, (CharSequence)string2, null, null, (int)0, null, null, (int)62, null) + "]");
        if (iterable2.isEmpty()) {
            iterable6 = (Pair)CollectionsKt.first((List)object3);
            logger.warn("Can't find any releases for current wave (" + assemblyVersion.getMajor() + "." + assemblyVersion.getMinor() + "), trying to get the last one (" + iterable6.getFirst() + ")");
            return DataServiceRemoteDebuggerToolsUrlProvider.x(cPUKind, (Pair<RiderRemoteToolsRelease, AssemblyVersion>)iterable6);
        }
        Pair pair = iterable2;
        boolean bl7 = false;
        Iterable iterable3 = pair;
        Collection collection2 = new ArrayList();
        boolean bl8 = false;
        object2 = iterable3.iterator();
        while (object2.hasNext()) {
            Object object4 = object = object2.next();
            boolean bl9 = false;
            if (!(((AssemblyVersion)object4.getSecond()).getBuild() == assemblyVersion.getBuild())) continue;
            collection2.add(object);
        }
        iterable6 = (List)collection2;
        Iterable iterable4 = iterable6;
        String string3 = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"lineSeparator(...)");
        logger.trace("Current bugfix releases: [" + CollectionsKt.joinToString$default((Iterable)iterable4, (CharSequence)string3, null, null, (int)0, null, null, (int)62, null) + "]");
        if (iterable6.isEmpty()) {
            pair = (Pair)CollectionsKt.first(iterable2);
            logger.warn("Can't find any releases for current bugfix (" + assemblyVersion.getMajor() + "." + assemblyVersion.getMinor() + "." + assemblyVersion.getBuild() + "),trying to get the last one (" + pair.getFirst() + ")");
            return DataServiceRemoteDebuggerToolsUrlProvider.x(cPUKind, (Pair<RiderRemoteToolsRelease, AssemblyVersion>)pair);
        }
        pair = (Pair)CollectionsKt.first(iterable6);
        logger.info("Selected release: " + pair.getFirst());
        return DataServiceRemoteDebuggerToolsUrlProvider.x(cPUKind, (Pair<RiderRemoteToolsRelease, AssemblyVersion>)pair);
    }

    private static final RemoteDebuggerToolsUrl x(CPUKind cPUKind, Pair<RiderRemoteToolsRelease, AssemblyVersion> pair) {
        RiderRemoteToolsDownload riderRemoteToolsDownload = ((RiderRemoteToolsRelease)pair.getFirst()).getDownloads().get(cPUKind.getDownloadKey());
        if (riderRemoteToolsDownload == null) {
            throw new IllegalStateException("Artifacts for cpu " + cPUKind.getDirectoryName() + " should exist at this point");
        }
        RiderRemoteToolsDownload riderRemoteToolsDownload2 = riderRemoteToolsDownload;
        return new RemoteDebuggerToolsUrl((AssemblyVersion)pair.getSecond(), riderRemoteToolsDownload2.getLink());
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger = Logger.getInstance(DataServiceRemoteDebuggerToolsUrlProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        DataServiceRemoteDebuggerToolsUrlProvider.logger = logger;
    }
}

